<?php
header("Content-type: text/json");

require_once('config.php');

class UserTransaction extends System {
    
    private $userAccount;
    
    private $currency;
    private $from;
    private $to;
    private $page;
    
    public function __construct(){
        parent::__construct();
        $this -> init();
    }
    
    public function init(){
        $this -> setParameter();
        $this -> validation();
    }
    
    private function setParameter(){
        $this -> userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
        $this -> currency       = $this -> getDataPost("cur");
        $this -> from           = $this -> getDataPost("from");
        $this -> to             = $this -> getDataPost("to");
        $this -> page           = $this -> getDataPost("page");
    }
    
    private function validation(){
        if($_SERVER['REQUEST_METHOD'] != 'POST'){
            die(json_encode([
                "error_code" => 1,
                "message" => "Invalid Request Method [{$_SERVER['REQUEST_METHOD']}]"
            ]));
        }
        
        if(empty($this -> getUserData(PARAM_USER_ACCOUNT))){
            die(json_encode([
                "error_code" => 2,
                "message" => "No Site Session Found"
            ]));
        }
    }
    
    /*-------------------------------------------------------------------------
     * @function_name: 検索条件の取得
     * @parameter	: なし
     * @return		: 検索条件
     -------------------------------------------------------------------------*/
    private function getWhere() {
        
        // 変数宣言部
        $params	= array();
        $rtn	= NO_STRING;
        
        // 通貨指定
        if($this -> currency != NO_STRING) {
            $params[] = ' (trans.deposit_currency = (\')' . $this -> currency . '(\') OR trans.withdraw_currency = (\')' . $this -> currency . '(\') OR trans.transfer_currency = (\')' . $this -> currency . '(\'))';
        }
        
        // 日付指定(from)
        if($this -> from != NO_STRING) {
            $params[] = ' transaction_time >= (\')' . $this -> from . '(\')';
        }
        
        // 日付指定(to)
        if($this -> to != NO_STRING) {
            $params[] = ' transaction_time < DATE_ADD((\')' . $this -> to . '(\'), INTERVAL 1 DAY)';
        }
        
        // データが存在した場合
        if($this -> isLoopData($params)) {
            $rtn = DELIMIT_AND . implode(DELIMIT_AND, $params);
        }
        
        return $rtn;
    }
    
    private function getUserAccountData() {
        
        // 変数宣言部
        $rtn = array();
        
        $rtn[] = $this -> userAccount;	// ユーザアカウント
        $rtn[] = $this -> currency;
        $rtn[] = $this -> getWhere();						// 検索条件
        $rtn[] = NO_STRING;
        
        return $rtn;
    }
    
    public function result(){
        $params = $this -> getUserAccountData();
        
        $defaultPageCount = VAR_DEFAULT_PAGE_COUNT;
        
        $countTransactions = $this -> getRowData($this -> accessSelect('SELECT_USER_TRANSACTION_ADMIN_COUNT', $params));
        
        $totalPage = $this -> getTotalPageCommon($defaultPageCount, $countTransactions["overall_total"]);
        
        $currentPage = empty($this -> page) || !is_numeric($this -> page) ? 1 : $this -> page;
        
        if($currentPage > $totalPage)
            $currentPage = $totalPage;    
            
        $start  = ($currentPage - 1) * $defaultPageCount;
        
        $params[3] = "DESC LIMIT {$start}, {$defaultPageCount}";
        
        $list = $this -> accessSelect('LIST_USER_TRANSACTION', $params);
        
        $start		= 	 ($currentPage - VAL_INT_1) * $defaultPageCount;
        
        $result = [
            "row_count" => $countTransactions["overall_total"],
            "page_total" => $totalPage,
            "current_page" => $currentPage,
            "start_row" => $start + 1,
            "result" => []
        ];
        
        foreach($list as $transaction){            
            $result["result"][] = $transaction;
        }
        
        echo json_encode($result);
    }
}


$trans = new UserTransaction();
$trans -> result();