
<?php
require_once('config.php');

class APICheckUserInfoBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $account	= NO_STRING;
	private $state		= NO_STRING;
	private $city		= NO_STRING;
	private $address	= NO_STRING;
	private $zipCode	= NO_STRING;
	private $tel		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature	= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account	= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> state		= $this -> getDataPost(PARAM_STATE);
			$this -> city		= $this -> getDataPost(PARAM_CITY);
			$this -> address	= $this -> getDataPost(PARAM_ADDRESS);
			$this -> zipCode	= $this -> getDataPost(PARAM_ZIP_CODE);
			$this -> tel		= $this -> getDataPost(PARAM_TEL);

			// エラーチェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {

			// 口座の存在確認
			$this -> user = $this -> getAccountCommon($this -> account);

			if(count($this -> user) == NO_COUNT) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 必須項目
			// 都道府県のチェック
			if(!$this -> checkNull($this -> state)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 市区町村のチェック
			if(!$this -> checkNull($this -> city)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 住所のチェック
			if(!$this -> checkNull($this -> address)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 郵便番号のチェック
			if(!$this -> checkNull($this -> zipCode)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 電話番号のチェック
			if(!$this -> checkNull($this -> tel)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 正規表現
			// 都道府県のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> state)) {
				throw new Exception('E_ERROR_REGULAR_ASCII_STATE_CITY');
			}

			if(!$this -> checkLength($this -> state
									, VAL_INT_1
									, VAL_INT_64)) {
				throw new Exception('E_ERROR_STRING_LENGTH_ANY');
			}

			// 市区町村のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> city)) {
				throw new Exception('E_ERROR_REGULAR_ASCII_STATE_CITY');
			}

			if(!$this -> checkLength($this -> city
									, VAL_INT_1
									, VAL_INT_64)) {
				throw new Exception('E_ERROR_STRING_LENGTH_ANY');
			}

			// 住所のチェック
			if(!$this -> checkStringAddress($this -> address)) {
				throw new Exception('E_ERROR_REGULAR_ASCII_ADDRESS');
			}

			if(!$this -> checkLength($this -> address
									, VAL_INT_1
									, VAL_INT_128)) {
				throw new Exception('E_ERROR_STRING_LENGTH_ANY');
			}

			// 郵便番号のチェック
			if(!$this -> checkStringNumberZipCode($this -> zipCode)) {
				throw new Exception('E_ERROR_REGULAR_NUMBER_ZIP_CODE');
			}

			// 電話番号のチェック
			if(!$this -> checkStringNumberTel($this -> tel)) {
				throw new Exception('E_ERROR_REGULAR_NUMBER_TEL');
			}

			if(!$this -> checkLength($this -> tel
									, VAL_INT_7
									, VAL_INT_20)) {
				throw new Exception('E_ERROR_STRING_LENGTH_ANY');
			}

		} catch (Exception $e) {
			throw  $e;
		}
	}
}
?>