﻿<?php
use Firebase\JWT\JWT;

class DepositModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $account		          = null;
	private $method			          = NO_STRING;
	private $amount			          = NO_STRING;
	private $tAmount		          = NO_STRING;
	private $payment		          = NO_STRING;
	private $currency		          = NO_STRING;
	private $referenceNo	          = NO_STRING;	// リファレンス番号
	private $fee			          = NO_STRING;	// 手数料
	private $accountType              = NO_STRING; //account Type
	private $country				  = NO_STRING; //account Type
	private $file	                  = null; 	   //uploaded image

	// 別の入金Solutionの変数
	private $validCalculation      = NO_STRING;    // CCD
	private $token                 = NO_STRING;    // CCD
	private $formattedAmount       = NO_STRING;    // H2P
	private $ipAddress             = NO_STRING;    // H2P
	private $h2pTransferUrl        = NO_STRING;    // H2P
	private $h2pCallbackURL        = NO_STRING;    // H2P
	private $h2pSecurityCode       = NO_STRING;    // H2P
	private $h2pMerchantID         = NO_STRING;    // H2P
	private $userAccount           = NO_STRING;    // 一般的な
	private $bank                  = NO_STRING;    // 一般的な
	private $eplconf               = null;         // CCD
	private $ccdTransDetails       = null;         // CCD
	
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

			// 決済金額の計算
			$this -> calculate();

			return true;

		} catch (Exception $e) {
// 			throw new Exception(NO_STRING);
			return false;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> method			        = $this -> getDataPost(PARAM_METHOD);
		$this -> amount			        = $this -> getDataPost(PARAM_AMOUNT);
		$this -> currency 		        = $this -> getDataPost(PARAM_CURRENCY);
		$this -> message 		        = $this -> getDataPost(PARAM_MESSAGE);
		$this -> depoistmoney 	        = $this -> getDataPost('depositmoney');
        $this -> chineseName            = $this -> getDataPost(PARAM_CHINESE_NAME);
        $this -> bankName               = $this -> getDataPost(PARAM_BANK_NAME);
		$this -> email					= $this -> getUserData(PARAM_MAIL); //set email
		$this -> country				= $this -> getDataPost(PARAM_COUNTRY); //set Country
		$this -> bank 					= $this -> getDataPost('bank');
		
		// 別の入金Solutionの変数
		$this -> token                  = $this -> getDataPost("token");
		
		if($this -> method == VAL_STR_VSMS_METHOD){
			$this -> setType(CASHFLOW_DEPOSIT_INPUT);
		}else if($this -> method == CASHFLOW_DEPOSIT_CONFIRM){
			$this -> setType(CASHFLOW_DEPOSIT_CONFIRM);
		}else if($this -> method == CASHFLOW_DEPOSIT_SEND){
			$this -> setType(CASHFLOW_DEPOSIT_SEND);
		}else if($this -> method == TYPE_CUP){
			$this -> setType(TYPE_CUP_INPUT);
		}else if($this -> method == VAL_STR_JRF_METHOD){
			$this -> setType(VAL_STR_JRF_METHOD);
		}else if($this -> method == VAL_STR_FLAT3_METHOD){
			$this -> setType(VAL_STR_FLAT3_INPUT);
		}else if($this -> method == VAL_STR_FLAT3_INPUT){
			$this -> setType(VAL_STR_FLAT3_INPUT);
		}else if($this -> method == VAL_STR_FLAT3_SUCCESS){
			$this -> setType(VAL_STR_FLAT3_SUCCESS);
		}else if($this -> method == VAL_STR_LBTC_METHOD){//check if method is Local Bank Transfer (China)
            $this -> setType(TYPE_LBTC_INPUT);
        }else if($this -> method == VAL_STR_SEPA_METHOD){//check if method is SEPA
            $this -> setType(TYPE_SEPA_INPUT);
        }else if($this -> method == VAL_STR_BIT_METHOD){//check if method is Cubtis
            $this -> setType(TYPE_BIT_INPUT);
        }else if($this -> method == VAL_STR_LBTJ_METHOD){//check if method is LBTJ
            $this -> setType(TYPE_LBTJ_INPUT);
		}else if($this -> method == VAL_STR_IBT_METHOD){//check if method is LBTJ
				$this -> setType(TYPE_IBT_INPUT);
		}else if($this -> method == VAL_STR_LBTF3_METHOD){
			$this -> setType(VAL_STR_LBTF3_INPUT);
		}else if($this -> method == VAL_STR_LBTF3_INPUT){
			$this -> setType(VAL_STR_LBTF3_INPUT);
		}else if($this -> method == VAL_STR_LBTF3_SUCCESS){
			$this -> setType(VAL_STR_LBTF3_SUCCESS);
		}else if($this -> method == VAL_STR_JPV_METHOD){
			$this -> setType(VAL_STR_JPV_INPUT);
		}else if($this -> method == VAL_STR_JPV_INPUT){
			$this -> setType(VAL_STR_JPV_INPUT);
		}else if($this -> method == VAL_STR_JPV_SUCCESS){
			$this -> setType(VAL_STR_JPV_SUCCESS);
		}

        //FOR CLEARSETTLE ONLY
        $type = $this -> getType();
        if(strpos($type, 'clearsettle_complete') !== false){
            $clearSettleTrxNo = $this -> getDataGet('trxNo');

            if($clearSettleTrxNo != null && $clearSettleTrxNo != ''){
                //use php __set() magic function
                $this -> transaction_id = $clearSettleTrxNo;
            }
        }

        //For Local Bank Transfer China ONLY
        if(strpos($type,'lbtc_redirect') !== false) {
            sleep(2); // sleep because the redirection and callback are asynchronous
            $lbtcRedirectArray = array();
            $lbtcRedirectArray = explode('lbtc_redirect&', urldecode($type));
            parse_str($lbtcRedirectArray[1], $lbtcRedirectArray);

            //check if transaction number exists
            if($lbtcRedirectArray['trxNo'] != null && $lbtcRedirectArray["trxNo"] != ''){
                $transactionNumber  = $lbtcRedirectArray['trxNo'];
                $transactionDetails = $this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($transactionNumber)));

                //get language
                $lang = $this -> getLangage();

                //get account
                $account = $this -> getAccountCommon($lbtcRedirectArray["acctID"]);

                //check if account exists
                if(count($account) > 0){
                    //login the user
                    $this -> putSessionUserData($account);
                } else{
                    header('Location: https://secure.' . SITE_DOMAIN . DIRECTORY_SEPARATOR . $lang . DIRECTORY_SEPARATOR . 'login');
                    exit();
                }

                //check if there is a record in main deposit table
                if(count($transactionDetails) > 0){
                    $res = $this -> getRowData($this -> accessSelect('SELECT_TEMP_DEPOSIT_LBTC', array($transactionNumber)));

                    $this -> transationNumber   = $transactionNumber;
                    $this -> createTime         = $this -> getColumnData($res, COLUMN_CREATE_TIME);
                    $this -> currency           = $this -> getColumnData($res, COLUMN_CURRENCY);
                    $this -> amount             = $this -> intToCurrency($this -> getColumnData($res, COLUMN_AMOUNT), $this -> currency);
                    $this -> fee                = $this -> intToCurrency($this -> getColumnData($res, COLUMN_FEE), $this -> currency);

                    $this -> setType(TYPE_LBTC_SUCCESS);
                } else{
                     $this -> setType(TYPE_LBTC_FAIL);
                }
            }
        }

        //For CUP ONLY
        if(strpos($type,'cup_redirect') !== false) {
            $cupRedirectArray = array();
            $cupRedirectArray = explode('cup_redirect&', urldecode($type));
            parse_str($cupRedirectArray[1], $cupRedirectArray);

            //check if transaction number exists
            if($cupRedirectArray['trxNo'] != null && $cupRedirectArray["trxNo"] != ''){
                $transactionNumber  = $cupRedirectArray['trxNo'];
                $transactionDetails = $this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($transactionNumber)));

                //get language
                $lang = $this -> getLangage();

                //get account
                $account = $this -> getAccountCommon($cupRedirectArray["acctID"]);

                //check if account exists
                if(count($account) > 0){
                    //login the user
                    $this -> putSessionUserData($account);
                } else{
                    header('Location: https://secure.' . SITE_DOMAIN . DIRECTORY_SEPARATOR . $lang . DIRECTORY_SEPARATOR . 'login');
                    exit();
                }

                //check if there is a record in main deposit table
                if(count($transactionDetails) > 0){
                    $res = $this -> getRowData($this -> accessSelect('SELECT_TEMP_DEPOSIT_CUP', array($transactionNumber)));

                    $this -> transationNumber   = $transactionNumber;
                    $this -> createTime         = $this -> getColumnData($res, COLUMN_CREATE_TIME);
                    $this -> currency           = $this -> getColumnData($res, COLUMN_CURRENCY);
                    $this -> amount             = $this -> intToCurrency($this -> getColumnData($res, COLUMN_AMOUNT), $this -> currency);
                    $this -> fee                = $this -> intToCurrency($this -> getColumnData($res, COLUMN_FEE), $this -> currency);

                    $this -> setType(TYPE_CUP_PAYMENTSUCCESS);
                } else{
					$res = $this -> getRowData($this -> accessSelect('SELECT_TEMP_DEPOSIT_CUP', array($transactionNumber)));

					$failFlag = $this -> getColumnData($res, COLUMN_FAIL_EMAIL_FLG);

					if($failFlag == 0){
						//put user_account value inside variables
	                    $userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
	                    $userFullName   = $this -> getUserData(PARAM_NAME);
	                    $userEmail      = $this -> getUserEMailCommon($userAccount);
						$language		= $this -> getLangage();

	                    //email parameters
	                    $params = array();
	                    $params[] = $userAccount;
	                    $params[] = $userFullName;
						//send fail email
						$this -> sendMailByTmp('cup_fail.xml'
								, $params
								, $this -> getUserEMailCommon($userAccount)
								, VAR_CS_MAIL_ADDRESS);
						//update flag
						$this -> accessModifyCommon('UPDATE_TEMP_DEPOSIT_CUP_FAIL_MAIL',array($transactionNumber));
					}

                     $this -> setType(TYPE_CUP_PAYMENTFAILURE);
                }
            }
        }

		// ユーザ情報の取得
		$this -> account        = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));
		$this -> userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
        $this -> accountType    = $this -> getColumnData($this -> account,'account_type');
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
	    session_regenerate_id();
		// 変数宣言部
		$rtn		= true;
		$fee		= NO_COUNT;
		$commission	= NO_COUNT;
		$errType 	= NO_COUNT;
		if($this -> getType()		== TYPE_SUCCESS
			|| $this -> getType()	== TYPE_PENDING
			|| $this -> getType()	== TYPE_FAIL) {
			return true;
		}

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		if($this -> getType()	== TYPE_COMPLETE
			&& $this -> method	!= NO_STRING) {

			// リミットチェック
			if(!$this -> checkGPSLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> method, $errType)) {

				$this -> setType();

				if($errType == VAL_INT_1) {
					$this -> popUpSessionMessage(ERROR, 'E_DEPOSIT_PERMISSION', array());
				} else {
					$this -> popUpSessionMessage(ERROR, 'E_DEPOSIT_GPS_LIMIT', array());
				}

				$this -> setType(NO_STRING);
				return false;
			}
		} else if($this -> getType() == TYPE_CUP_INPUT ||
            $this -> getType() == TYPE_CUP_BACK     ||
			$this -> getType() == TYPE_CUP_CONFIRM){
                //generate transaction number
                $txnNo = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);

                //set message & currency with static value to avoid decoding
                    switch($this -> getLangage()){
                        case 'sc':
                            $this -> message = '中国银联';
                            break;
                        case 'tc':
                            $this -> message = '中國銀聯 ';
                            break;
                        default:
                            $this -> message = 'China UnionPay';
                    }

                    $this -> currency = 'CNY';

                    //put user_account value inside variables
                    $userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
                    $userFullName   = $this -> getUserData(PARAM_NAME);
                    $userEmail      = $this -> getUserEMailCommon($userAccount);

                    //email parameters
                    $params = array();
                    $params[] = $userAccount;
                    $params[] = $userFullName;

                    //check if user is not in bypass list. if not proceed with normal checking
                    if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_CUP_METHOD,$userAccount)){
                        //check if corporate
                        if($this -> getAccountType() == VAL_INT_1){
                            $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_CORPORATE', array());
                            $rtn = false;
                            $this -> setType('');
                            return;
                        }

						//为了统一，这里normal代码kYC非认证用户，vip代表KYC认证用户
						if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
							$this -> setType(TYPE_CUP_NOTICE_KYC);
							return;
						}
                    }




                    //checkMaxHourly
                    // 不正防止のため、成功失敗関係なく1時間に5回まで、決済することができる。
                    if(!$this -> checkCUPDeposit1Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
                        $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_1_HOUR', array());
                        $rtn = false;
                    }

                    //checkMaxTransactionsDaily
                    if(!$this -> checkDepositByCUP24Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
    						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_VIP', array());
                            $rtn = false;
    				}
                    //checkMaxAmountDaily
                    if(!$this -> checkDepositByCUP1Days($this -> getUserData(PARAM_USER_ACCOUNT))) {
    						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
                            $rtn = false;
    				}



                    if(!$rtn) {
                        $this -> setType('');
                        return;
                    }

			// $list = $this -> CheckPaymentKind();
			// if($list[VAL_INT_3] == NO_COUNT){
			// 	$this -> setType(NO_STRING);
			// 	$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_CUPKINDCHECK_VERTIFY', array());
			// 	return;
			// }

            if($this -> getType() == TYPE_CUP_BACK){
                $this -> setType(TYPE_CUP_INPUT);
                return;
            }
            
			if($this -> getType() == TYPE_CUP_CONFIRM){

                //validate currency
                    if(!$this -> checkNull($this -> currency)){
                        $this -> popUpSessionMessage(ERROR, 'E_INVALID_CURRENCY_VALUE', array());
                        $rtn = false;
                    } elseif($this -> currency != 'CNY'){
                        $this -> popUpSessionMessage(ERROR, 'E_INVALID_CURRENCY_VALUE', array());
                        $rtn = false;
                    }

                    //if amount is empty
                    if(!$this -> checkNull($this -> amount)){
                        $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
                        $rtn = false;
                    } else{
                        if($this -> checkNull($this -> depoistmoney)){
        					if(!$this -> checkCurrencyNumber($this -> amount)){
                                if(!ctype_digit($this -> amount)){
                                    $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array(200, "4,900"));
            						$rtn = false;
                                }else{
                                    $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
                                    $rtn = false;
                                }
        					} elseif(($this -> amount < 200) || ($this -> amount >4900)){
        						$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array(200, "4,900"));
        						$rtn = false;
        					}
        				} else {
    						if($this -> amount != 200 && $this -> amount != 500 && $this -> amount != 1000 && $this -> amount != 3000 && $this -> amount != 4900){
    							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array(200, "4,900"));
    							$rtn = false;
    						}
        				}
                    }

                    if(!$rtn) {
                        $this -> setType(TYPE_CUP_INPUT);
                        return;
                    }

                //send request to api
	            include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'sdDeposit.php';

                //set language to be sent
                    $language = $this -> getLangage();
                    $lang     = NO_STRING;
                    switch($language){
                        case 'sc':
                            $lang = 'zh-cn';
                            break;
                        case 'tc':
                            $lang = 'zh-hk';
                            break;
                        default:
                            $lang = 'en-us';
                    }

                    //compute fee
                    $this -> fee     = $this -> intToCurrency(round(bcmul($this -> amount, VAL_STR_CUP_FEE, 4)),PERCENT);

                    //total payment amount
                    $totalDepositAmount = number_format($this -> amount + $this -> fee, 2, ".", "");

                    //get $user_agent
                    $a = $_SERVER['HTTP_USER_AGENT'];
                    if ((strpos($a, 'Mobi') !== false) || (strpos($a, 'Android') !== false)) {
                                            $cmd = 6010;
                                            $this -> formURL = VAL_SDPAY_DEPOSIT_CUP_MOBILE_URL; // change later
                    }else{
                                            $cmd = 6006;
                                            $this -> formURL = VAL_SDPAY_DEPOSIT_URL; // change later
                    }

                    //redirect url
                    $getParamstring = urlencode("cup_redirect&trxNo=".$txnNo."&acctID=".$userAccount);
                    $redirectURL = "https://secure.". SITE_DOMAIN . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . "deposit?type=" . $getParamstring;

                    //request parameters
                        $xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
                                <message>
                                    <cmd>".$cmd."</cmd>
                                    <merchantid>".VAL_SDPAY_DEPOSIT_CUP_MERCHANT_CODE."</merchantid>
                                    <language>".$lang."</language>
                                    <userinfo>
                                        <order>".$txnNo."</order>
                                        <username>".$userEmail."</username>
                                        <money>".$totalDepositAmount."</money>
                                        <unit>1</unit>
                                        <time></time>
                                        <remark></remark>
                                        <backurl>".VAL_STR_CUP_CALLBACK_URL."</backurl>
                                        <backurlbrowser>".$redirectURL."</backurlbrowser>
                                    </userinfo>
                                </message>";


                    $mencrypt = new MyEncrypt(VAL_SDPAY_DEPOSIT_CUP_KEY1,VAL_SDPAY_DEPOSIT_CUP_KEY2);
                    $md5Str   = md5($xml.VAL_SDPAY_DEPOSIT_CUP_KEY_MD5);
                    $tempStr  = $xml.$md5Str;
                    $des      = $mencrypt->encryptData($tempStr);

                    $this -> sdPayEncrypted = $des;

                    $apiPath     = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
                    $requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'SDPay'.DIRECTORY_SEPARATOR.'cup_deposit_request';

                    //check if directory exists if not, create directory
                    if(!file_exists($requestUrl)) {
                        mkdir($requestUrl, 0777, true);
                    }

                    //log the transaction details
                    error_log(date("[Y-m-d H:i:s]")."\r\n XML request[".$txnNo."]:" ."\r\n". $xml ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                    chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                    error_log(date("[Y-m-d H:i:s]")."\r\n Encrypted request[".$txnNo."]:" ."\r\n". $des ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                    chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                    //put to temporary cup table
                    //cup array model
                    $CUP['Model'] = array();
    				$CUP['Model']['transaction_number'] = $txnNo;
    				$CUP['Model']['user_account'] = $userAccount;
    				$CUP['Model']['amount'] = number_format($this -> amount, 2, '', '');
    				$CUP['Model']['currency'] = 'CNY';
    				$CUP['Model']['method'] = 'CUP';
    				$CUP['Model']['deposit_bank'] = 'SD System (CUP)';
    				$CUP['Model']['fee'] = number_format($this -> fee, 2, '', '');
    				$CUP['Model']['message'] = $this -> message;
    				$CUP['Model']['comment'] = '';
    				$CUP['Model']['create_time'] = date("Y-m-d H:i:s");
    				$CUP['Model']['process_user'] = '9999';
    				$CUP['Model']['type'] = '0';
    				$CUP['Model']['err_flg'] = '0';
    				$CUP['Model']['language'] = $this -> getLangage();

                    //unset session variables
                    $this -> unsetTemporaryDepositSessionData();
                    $this -> setCUPSessionData($CUP['Model']);
			}
		
        }else if($this -> getType() == TYPE_ZANETA_INPUT ||
            $this -> getType() == TYPE_ZANETAPAY_DEPOSIT_SEND ||
            $this -> getType() == TYPE_ZANETAPAY_DEPOSIT_CONFIRM ||
            $this -> getType() == TYPE_ZANETAPAY_DEPOSIT_SUCCESS ||
            $this -> getType() == TYPE_ZANETAPAY_DEPOSIT_FAILURE ){
            
            if($this -> getType() == TYPE_ZANETA_INPUT){
                
                $account_Category = '';
                $accountType    = $this -> getColumnData($this -> account,'account_type');
                
                if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_ZANETAPAY_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){

                    //check if corporate
                        if($accountType == "1") {
                            $this -> popUpSessionMessage(ERROR, 'E_ERROR_OPTION_NOT_AVAILABLE', array());
                            $this -> setType();
                            return;
                        }

                    if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
                        $this -> setType(TYPE_ZANETAPAY_NOTICE_KYC);
                        return;
                    }

                    // $list = $this -> CheckPaymentKind();
                    // if($list[VAL_INT_4] == NO_COUNT){
                    //     $this -> setType(NO_STRING);
                    //     $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VISAKINDCHECK_VERTIFY', array());
                    //     return;
                    // }
                }

                // 不正防止のため、成功失敗関係なく1時間に5回まで、決済することができる。
                if(!$this -> checkZanetapayDeposit1Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
                    $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_1_HOUR', array());
                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(NO_STRING);
                        return;
                    }
                }

                //如果为认证会员，获取会员的type,vip还是normal
                if($this -> checkVIPStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
                    $account_Category = 'vip';
                }else{
                    $account_Category = 'normal';
                }

                //将账户类别保存到SESSION中
                $_SESSION['account_Category'] = $account_Category;


                // 24時間以内決済成功は限制回まで。過去24時間にVIP 10回決済，Normal 3回したユーザーは、4回目エラーメッセージを表示
                if(!$this -> checkDepositByCard24Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
                    if($account_Category == 'vip'){
                        $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_VIP', array());
                    }else if($account_Category == 'normal'){
                        $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_NORMAL', array());
                    }

                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(NO_STRING);
                        return;
                    }
                }

                // 30日間の決済成功累積額上限は、Normal USD20,000まで,Vip USD20,000まで
                if(!$this -> checkDepositByCard30Days($this -> getUserData(PARAM_USER_ACCOUNT))) {
                    $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(NO_STRING);
                        return;
                    }
                }


            }

            if($this -> getType() == TYPE_ZANETAPAY_DEPOSIT_CONFIRM){
                //判断是个人还是法人账户
                $accounttype = $this -> getColumnData($this -> account,'account_type');

                //查看必要用户信息是否已填写，没有通知先完善用户信息
                if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_ZANETAPAY_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
                    if($accounttype == 1){
                        $firstName = $this -> CallUserData(PARAM_CEO_FIRST_NAME);
                        $lastName = $this -> CallUserData(PARAM_CEO_LAST_NAME);
                        if(empty($firstName) || empty($lastName)){
                            $this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
                            $this -> setType(NO_STRING);
                            return;
                        }
                    }
                }

                //查看必要用户信息是否已填写，没有通知先完善用户信息
                $ZipCode    = $this -> CallUserData(PARAM_ZIP_CODE);
                $Address    = $this -> CallUserData(PARAM_ADDRESS);
                $City       = $this -> CallUserData(PARAM_CITY);
                $Phone      = $this -> CallUserData(PARAM_TEL);

                if(empty($ZipCode) ||
                    empty($Address) ||
                    empty($City ) ||
                    empty($Phone)
                ){
                    $this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
                    $this -> setType(NO_STRING);
                    return;
                }

                //查看金额是否为空
                if(!$this -> checkNull($this -> amount)){
                    $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(TYPE_ZANETA_INPUT);
                        return;
                    }
                }
                //判断自定义金额是否为空，不为空对金额做出判断,以及有效入金限制
                if($this -> checkNull($this -> depoistmoney)){
                    if($this -> currency == 'JPY'){
                        if(($this -> amount < 50000) || ($this -> amount >100000)){
                            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_JP', array(VAL_STR_AMOUNT));
                            $rtn = false;
                        }
                        if(!$this -> checkStringIntOnly($this -> amount)){
                            $this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
                            $rtn = false;
                        }
                        if(!$rtn) {
                            $this -> setType(TYPE_ZANETA_INPUT);
                            return;
                        }
                    }else{
                        if(($this -> amount < 500) || ($this -> amount >1000)){
                            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_OTHER', array(VAL_INT_500,VAL_INT_1000));
                            $rtn = false;
                        }
                        if(!$this -> checkCurrencyNumber($this -> amount)){
                            $this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
                            $rtn = false;
                        }
                        if(!$rtn) {
                            $this -> setType(TYPE_ZANETA_INPUT);
                            return;
                        }
                    }
                    if(!$rtn) {
                        $this -> setType(TYPE_ZANETA_INPUT);
                        return;
                    }
                } else {
                    if($this -> currency == 'JPY'){
                        if($this -> amount != 1000 && $this -> amount != 3000 && $this -> amount != 5000 && $this -> amount != 10000 && $this -> amount != 30000){
                            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_VM', array($this -> currency, '1,000', '100,000'));
                            $rtn = false;
                        }
                    }else{
                        if($this -> amount != 10 && $this -> amount != 30 && $this -> amount != 50 && $this -> amount != 100 && $this -> amount != 300){
                            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_VM', array($this -> currency, '10', '1,000'));
                            $rtn = false;
                        }
                    }
                    if(!$rtn) {
                        $this -> setType(TYPE_ZANETA_INPUT);
                        return;
                    }
                }

                // メッセージの正規表現チェック
                if(!$this -> checkStringMessage($this -> message)) {
                    $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_MESSAGE', array());
                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(TYPE_ZANETA_INPUT);
                        return;
                    }
                }

                if(!$this -> checkLength($this -> message , 0 , 128)){
                    $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_MESSAGE', array());
                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(TYPE_ZANETA_INPUT);
                        return;
                    }
                }


                if(!$this -> checkMoneyInExceed($this -> amount , $this -> currency)){
                    $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
                    $rtn = false;
                    if(!$rtn) {
                        $this -> setType(TYPE_ZANETA_INPUT);
                        return;
                    }
                }


                // 手数料の取得
                $fee = $this -> getFeeCommon(VAR_DEPOSIT
                                        , $this -> amount
                                        , $this -> currency
                                        , $this -> getUserData(PARAM_USER_ACCOUNT));

                $this -> fee = $this -> getColumnData($fee, $this -> currency . VAL_INT_1);
                // 上乗せ分対応
                if($this -> currency == USD){
                    $markup = ZANETAPAY_RISK_FEE_USD;
                }else if($this -> currency == EUR){
                    $markup     = ZANETAPAY_RISK_FEE_EUR;
                }else if($this -> currency == GBP){
                    $markup     = ZANETAPAY_RISK_FEE_GBP;
                }

                $commission     = $this -> intToCurrency(($this -> amount * VAL_STR_ZANETAPAY_FEE),PERCENT);
                $this -> fee    += $commission;
                $this -> fee    += $markup;

                if($this -> currency == 'JPY'){
                    $this -> fee    = ceil($this -> fee);
                }

                $this -> setFeeEx($this -> formatCurrency($this -> fee,$this -> currency));

                $_SESSION['zanetapay']['Country']    = $this -> getColumnData($this -> account,PARAM_COUNTRY);
                $_SESSION['zanetapay']['firstName']  = $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_FIRST_NAME) : $this -> getColumnData($this -> account,PARAM_LAST_NAME);
                $_SESSION['zanetapay']['lastName']   = $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_LAST_NAME) : $this -> getColumnData($this -> account,PARAM_FIRST_NAME);
                $_SESSION['zanetapay']['mail']       = $this -> getColumnData($this -> account,PARAM_MAIL);
                $_SESSION['zanetapay']['state']      = $this -> getColumnData($this -> account,PARAM_STATE);
                $_SESSION['zanetapay']['city']       = $this -> getColumnData($this -> account,PARAM_CITY);
                $_SESSION['zanetapay']['address']    = $this -> getColumnData($this -> account,PARAM_ADDRESS);
                $_SESSION['zanetapay']['zip']        = $this -> getColumnData($this -> account,PARAM_ZIP_CODE);
                $_SESSION['zanetapay']['tel']        = $this -> getColumnData($this -> account,PARAM_TEL);
                $_SESSION['zanetapay']['amount']     = $this -> amount;
                $_SESSION['zanetapay']['currency']   = $this -> currency;
                $_SESSION['zanetapay']['Actual']     = $this -> amount + $this -> fee;
                $_SESSION['zanetapay']['message']    = $this -> message;
                $_SESSION['zanetapay']['lang']       = $this -> getLangage();
                if($this -> currency != 'JPY'){
                    $this -> fee = sprintf("%.2f",$this -> fee);
                    $this -> amount = sprintf("%.2f",$this -> amount);
                }
                $_SESSION['zanetapay']['fee']        = $this -> fee;


            }

            if($this -> getType() == TYPE_ZANETAPAY_DEPOSIT_SEND){

                $apiPath         = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
                $requestUrl      = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Zanetapay'.DIRECTORY_SEPARATOR.'request';
                $requestDbUrl    = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Zanetapay'.DIRECTORY_SEPARATOR.'request_db';
                include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'core'.DIRECTORY_SEPARATOR.'zanetapay.php';

                //check if directory exists if not, create directory
                if(!file_exists($requestUrl)) {
                    mkdir($requestUrl, 0777, true);
                }

                //check if directory exists if not, create directory
                if(!file_exists($requestDbUrl)) {
                    mkdir($requestDbUrl, 0777, true);
                }

                $this -> transaction_number = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);

                $Amount             = $this -> getColumnData($_SESSION['zanetapay'],'Actual');
                $Currency           = $this -> getColumnData($_SESSION['zanetapay'],'currency');
                $Street             = $this -> getColumnData($_SESSION['zanetapay'],'address');
                $City               = $this -> getColumnData($_SESSION['zanetapay'],'city');
                $ZIP                = $this -> getColumnData($_SESSION['zanetapay'],'zip');
                $Country            = $this -> getColumnData($_SESSION['zanetapay'],'Country');
                $this -> language   = $this -> getColumnData($_SESSION['zanetapay'],'lang');
                $this -> lang       = isset($arrLan[$this -> language]) ? $arrLan[$this -> language] : 'en';
                $first_name         = $this -> getColumnData($_SESSION['zanetapay'],'firstName');
                $last_name          = $this -> getColumnData($_SESSION['zanetapay'],'lastName');
                $mail               = $this -> getColumnData($_SESSION['zanetapay'],'mail');
                $IP                 = $_SERVER['REMOTE_ADDR'];

                $data = "authentication.entityId=".ZANETAPAY_ENTITY_ID .
                   "&authentication.userId=".ZANETAPAY_USER_ID .
                   "&authentication.password=".ZANETAPAY_PASSWORD .
                   "&paymentType=".CASHFLOW_TRANS_TYPE .
                   "&merchantTransactionId=" .$this -> transaction_number.
                   "&amount=" .sprintf("%.2f",$Amount).
                   "&currency=".$Currency.
                   "&customer.givenName=".$first_name.
                   "&customer.surname=".$last_name.
                   "&billing.street1=".$Street.
                   "&billing.city=".$City.
                   "&billing.postcode=".$ZIP.
                   "&billing.country=".$Country.
                   "&customer.email=".$mail.
                   "&customer.ip=".$IP;

                error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number .' zanetapay request:' ."\r\n". $data ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, ZANETAPAY_TOKEN_URL);
                // curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                //    'Authorization:Bearer OGE4Mjk0MTg0YTk2Nzc3OTAxNGFjMzlmYWNlYzFhYTV8NmVSSnF0eHM='));
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $responseData = curl_exec($ch);
                if($errno = curl_errno($ch)) {
                    $error_message = curl_strerror($errno);
                    echo "cURL error ({$errno}):\n {$error_message}";
                    return false;
                }
                curl_close($ch);
                 $arr_token = json_decode($responseData);
                 // var_dump($arr_token);
                $this -> token = $arr_token->id;

                //创建zanetapay数据表的数据Model
                $ZANETAPAY['Model']['transaction_number'] = $this -> transaction_number;
                $ZANETAPAY['Model']['user_account'] = $this -> getColumnData($_SESSION['site_user_data'],'user_account');
                $ZANETAPAY['Model']['amount'] = $Currency != 'JPY' ? $this -> getColumnData($_SESSION['zanetapay'],'amount')*100 : $this -> getColumnData($_SESSION['zanetapay'],'amount');
                $ZANETAPAY['Model']['currency'] = $Currency;
                $ZANETAPAY['Model']['method'] = 'ZANETAPAY';
                $ZANETAPAY['Model']['deposit_bank'] = 'ZP_UPI';
                $ZANETAPAY['Model']['deposit_date'] = date("Y-m-d H:i:s");
                $ZANETAPAY['Model']['fee'] = '0';
                $ZANETAPAY['Model']['message'] = $this -> getColumnData($_SESSION['zanetapay'],'message');
                $ZANETAPAY['Model']['comment'] = '';
                $ZANETAPAY['Model']['create_time'] = date("Y-m-d H:i:s");
                $ZANETAPAY['Model']['process_user'] = '9999';
                $ZANETAPAY['Model']['type'] = '0';
                $ZANETAPAY['Model']['err_flg'] = '0';

                $sqlObject = new mysql($this->getConfigValue(SECTION_DB,HOST_NAME),$this->getConfigValue(SECTION_DB,USER_NAME),$this->getConfigValue(SECTION_DB,LOGIN_PASS),$this->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');
                $sql = "insert into t_deposit_zanetapay_temporary ";
                //进deposit表的sql方法
                $strsql = $sqlObject->Insertsql($ZANETAPAY['Model']);
                $sql .= $strsql;
                $sqlObject->query($sql);
                error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number.' zanetapay db request:' ."\r\n". $sql ."\r\n", 3, $requestDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                chmod($requestDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
            }

            if($this -> getType() == TYPE_ZANETAPAY_DEPOSIT_SUCCESS ||
                $this -> getType()  == TYPE_ZANETAPAY_DEPOSIT_FAILURE
            ){  
                //返回结果，对结果判断
                $this -> transationNumber = $this -> getColumnData($_SESSION,'transaction_number');
                $this -> setDeposit($this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($this -> transationNumber))));
                if($this -> isSendMail != VAL_INT_1){
                    if($this -> getType() == TYPE_ZANETAPAY_DEPOSIT_SUCCESS){
                       $this -> sendZanetapaySuccessMail();
                        $this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
                    }else if($this -> getType() == TYPE_ZANETAPAY_DEPOSIT_FAILURE){
                        $this -> sendZanetapayFailMail();
                        $this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
                    }
                }
            }

        }else if($this -> getType() == CASHFLOW_DEPOSIT_INPUT ||
			$this -> getType() == CASHFLOW_DEPOSIT_CONFIRM ||
			$this -> getType() == CASHFLOW_DEPOSIT_SUCCESS ||
			$this -> getType() == CASHFLOW_DEPOSIT_FAILURE ||
			$this -> getType() == CASHFLOW_DEPOSIT_SEND
		){

			//确认为CashFlow支付分支，进行提交检索
			if($this -> getType() == CASHFLOW_DEPOSIT_INPUT){
				//进入cashflow并进行输入时
				$account_Category = '';		//设定账号默认类别
				//判断是否是KYC认证用户
				// 通常会員不可！無制限会員のみOK
				if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_VSMS_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){

					//if($this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY)) != 'Japan'){
					//	$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_JAPAN', array());
					//	$this -> setType('');
					//	return;
					//}

					if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
						$this -> setType(TYPE_NOTICE_KYC);
						return;
					}else {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
					}

					$list = $this -> CheckPaymentKind();
					if($list[VAL_INT_4] == NO_COUNT){
						$this -> setType(NO_STRING);
						$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VISAKINDCHECK_VERTIFY', array());
						return;
					}
				}


				// 不正防止のため、成功失敗関係なく1時間に5回まで、決済することができる。
				if(!$this -> checkCashFlowDeposit1Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_1_HOUR', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}



				//如果为认证会员，获取会员的type,vip还是normal
				if($this -> checkVIPStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$account_Category = 'vip';
				}else{
					$account_Category = 'normal';
				}

				//将账户类别保存到SESSION中
				$_SESSION['account_Category'] = $account_Category;


				// 24時間以内決済成功は限制回まで。過去24時間にVIP 10回決済，Normal 3回したユーザーは、4回目エラーメッセージを表示
				if(!$this -> checkDepositByCard24Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
					if($account_Category == 'vip'){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_VIP', array());
					}else if($account_Category == 'normal'){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_NORMAL', array());
					}

					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}

				// 30日間の決済成功累積額上限は、Normal USD20,000まで,Vip USD20,000まで
				if(!$this -> checkDepositByCard30Days($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}



			}

			if($this -> getType() == CASHFLOW_DEPOSIT_CONFIRM){
				//确认页对输入的信息进行校验,并计算fee等信息

				//判断是个人还是法人账户
				$accounttype = $this -> getColumnData($this -> account,'account_type');

				//查看必要用户信息是否已填写，没有通知先完善用户信息
				if($accounttype == 1){
					$firstName = $this -> CallUserData(PARAM_CEO_FIRST_NAME);
					$lastName = $this -> CallUserData(PARAM_CEO_LAST_NAME);
					if(empty($firstName) || empty($lastName)){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
						$this -> setType(NO_STRING);
						return;
					}
				}

				//查看必要用户信息是否已填写，没有通知先完善用户信息
				$ZipCode 	= $this -> CallUserData(PARAM_ZIP_CODE);
				$Address 	= $this -> CallUserData(PARAM_ADDRESS);
				$City 		= $this -> CallUserData(PARAM_CITY);
				$Phone 		= $this -> CallUserData(PARAM_TEL);

				if(empty($ZipCode) ||
					empty($Address) ||
					empty($City ) ||
					empty($Phone)
				){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
					$this -> setType(NO_STRING);
					return;
				}

				//查看金额是否为空
				if(!$this -> checkNull($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}

				//判断自定义金额是否为空，不为空对金额做出判断,以及有效入金限制
				if($this -> checkNull($this -> depoistmoney)){
					if($this -> currency == 'JPY'){
						if(($this -> amount < 50000) || ($this -> amount >100000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_JP', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$this -> checkStringIntOnly($this -> amount)){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$rtn) {
							$this -> setType(CASHFLOW_DEPOSIT_INPUT);
							return;
						}
					}else{
						if(($this -> amount < 500) || ($this -> amount >1000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_OTHER', array(VAL_INT_500,VAL_INT_1000));
							$rtn = false;
						}
						if(!$this -> checkCurrencyNumber($this -> amount)){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$rtn) {
							$this -> setType(CASHFLOW_DEPOSIT_INPUT);
							return;
						}
					}
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				} else {
					if($this -> currency == 'JPY'){
						if($this -> amount != 1000 && $this -> amount != 3000 && $this -> amount != 5000 && $this -> amount != 10000 && $this -> amount != 30000){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_VM', array($this -> currency, '1,000', '100,000'));
							$rtn = false;
						}
					}else{
						if($this -> amount != 10 && $this -> amount != 30 && $this -> amount != 50 && $this -> amount != 100 && $this -> amount != 300){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_VM', array($this -> currency, '10', '1,000'));
							$rtn = false;
						}
					}
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}

				// メッセージの正規表現チェック
				if(!$this -> checkStringMessage($this -> message)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_MESSAGE', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}

				if(!$this -> checkLength($this -> message , 0 , 128)){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_MESSAGE', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}


				if(!$this -> checkMoneyInExceed($this -> amount , $this -> currency)){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}



				// 手数料の取得
				$fee = $this -> getFeeCommon(VAR_DEPOSIT
										, $this -> amount
										, $this -> currency
										, $this -> getUserData(PARAM_USER_ACCOUNT));

				$this -> fee = $this -> getColumnData($fee, $this -> currency . VAL_INT_1);
				// 上乗せ分対応
				if($this -> currency == USD){
					$markup = CASHFLOW_RISK_FEE_USD;
				}else if($this -> currency == EUR){
					$markup 	= CASHFLOW_RISK_FEE_EUR;
				}else if($this -> currency == GBP){
					$markup 	= CASHFLOW_RISK_FEE_GBP;
				}else if($this -> currency == JPY){
					$markup 	= CASHFLOW_RISK_FEE_JPY;
				}

				$commission		= $this -> intToCurrency(($this -> amount * VAL_STR_VSMS_FEE),PERCENT);
				$this -> fee	+= $commission;
				$this -> fee 	+= $markup;

				if($this -> currency == 'JPY'){
					$this -> fee    = ceil($this -> fee);
				}
				$this -> setFeeEx($this -> formatCurrency($this -> fee,$this -> currency));


				$_SESSION['cashflow']['Country'] 	= $this -> getColumnData($this -> account,PARAM_COUNTRY);
				$_SESSION['cashflow']['firstName'] 	= $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_FIRST_NAME) : $this -> getColumnData($this -> account,PARAM_LAST_NAME);
				$_SESSION['cashflow']['lastName'] 	= $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_LAST_NAME) : $this -> getColumnData($this -> account,PARAM_FIRST_NAME);
				$_SESSION['cashflow']['mail'] 		= $this -> getColumnData($this -> account,PARAM_MAIL);
				$_SESSION['cashflow']['state'] 		= $this -> getColumnData($this -> account,PARAM_STATE);
				$_SESSION['cashflow']['city'] 		= $this -> getColumnData($this -> account,PARAM_CITY);
				$_SESSION['cashflow']['address'] 	= $this -> getColumnData($this -> account,PARAM_ADDRESS);
				$_SESSION['cashflow']['zip'] 		= $this -> getColumnData($this -> account,PARAM_ZIP_CODE);
				$_SESSION['cashflow']['tel'] 		= $this -> getColumnData($this -> account,PARAM_TEL);
				$_SESSION['cashflow']['amount'] 	= $this -> amount;
				$_SESSION['cashflow']['currency'] 	= $this -> currency;
				$_SESSION['cashflow']['Actual'] 	= $this -> amount + $this -> fee;
				$_SESSION['cashflow']['fee'] 		= $this -> fee;
				$_SESSION['cashflow']['message'] 	= $this -> message;
				$_SESSION['cashflow']['lang']		= $this -> getLangage();
				if($this -> currency != 'JPY'){
					$this -> fee = sprintf("%.2f",$this -> fee);
					$this -> amount = sprintf("%.2f",$this -> amount);
				}

			}

			if($this -> getType() == CASHFLOW_DEPOSIT_SEND){
				$apiPath = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
				$requestUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'request';
				$requestDbUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'db_request';
				include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'core'.DIRECTORY_SEPARATOR.'cashflow.php';
				$this -> transaction_number = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);
				//$this -> transaction_number = trim(trim(date('YmdHis',time())).mt_rand(10000,99999));

				$Amount     		= $this -> getColumnData($_SESSION['cashflow'],'Actual');
				$Currency   		= $this -> getColumnData($_SESSION['cashflow'],'currency');
				$Street     		= $this -> getColumnData($_SESSION['cashflow'],'address');
				$City       		= $this -> getColumnData($_SESSION['cashflow'],'city');
				$ZIP        		= $this -> getColumnData($_SESSION['cashflow'],'zip');
				$Country    		= $this -> getColumnData($_SESSION['cashflow'],'Country');
				$this -> language   = $this -> getColumnData($_SESSION['cashflow'],'lang');
				$this -> lang      	= isset($arrLan[$this -> language]) ? $arrLan[$this -> language] : 'en';
				$first_name 		= $this -> getColumnData($_SESSION['cashflow'],'firstName');
				$last_name  		= $this -> getColumnData($_SESSION['cashflow'],'lastName');
				$mail       		= $this -> getColumnData($_SESSION['cashflow'],'mail');
				$IP 				= $_SERVER['REMOTE_ADDR'];
				//发送的Data
				$data = "authentication.entityId=".CASHFLOW_ENTITY_ID .
				   "&authentication.userId=".CASHFLOW_USER_ID .
				   "&authentication.password=".CASHFLOW_PASSWORD .
				   "&paymentType=".CASHFLOW_TRANS_TYPE .
				   "&merchantTransactionId=" .$this -> transaction_number.
				   "&amount=" .sprintf("%.2f",$Amount).
				   "&currency=".$Currency.
				   "&customer.givenName=".$first_name.
				   "&customer.surname=".$last_name.
				   "&billing.street1=".$Street.
				   "&billing.city=".$City.
				   "&billing.postcode=".$ZIP.
				   "&billing.country=".$Country.
				   "&customer.email=".$mail.
				   "&customer.ip=".$IP;
 				error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number .' cashflow request:' ."\r\n". $data ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
				chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
				//CURL 模拟POST
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, CASHFLOW_TOKEN_URL);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$responseData = curl_exec($ch);
				if(curl_errno($ch)) {
				  return curl_error($ch);
				}
				curl_close($ch);
				$arr_token = json_decode($responseData);

				$this -> token = $arr_token->id;
				//创建cashflow数据表的数据Model
				$CASHFLOW['Model']['transaction_number'] = $this -> transaction_number;
				$CASHFLOW['Model']['user_account'] = $this -> getColumnData($_SESSION['site_user_data'],'user_account');
				$CASHFLOW['Model']['amount'] = $Currency != 'JPY' ? $this -> getColumnData($_SESSION['cashflow'],'amount')*100 : $this -> getColumnData($_SESSION['cashflow'],'amount');
				$CASHFLOW['Model']['currency'] = $Currency;
				$CASHFLOW['Model']['method'] = 'CASHFLOWVM';
				$CASHFLOW['Model']['deposit_bank'] = 'ZP_VM';
				$CASHFLOW['Model']['deposit_date'] = date("Y-m-d H:i:s");
				$CASHFLOW['Model']['fee'] = '0';
				$CASHFLOW['Model']['message'] = $this -> getColumnData($_SESSION['cashflow'],'message');
				$CASHFLOW['Model']['comment'] = '';
				$CASHFLOW['Model']['create_time'] = date("Y-m-d H:i:s");
				$CASHFLOW['Model']['process_user'] = '9999';
				$CASHFLOW['Model']['type'] = '0';
				$CASHFLOW['Model']['err_flg'] = '0';
				$sqlObject = new mysql($this->getConfigValue(SECTION_DB,HOST_NAME),$this->getConfigValue(SECTION_DB,USER_NAME),$this->getConfigValue(SECTION_DB,LOGIN_PASS),$this->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');
				$sql = "insert into t_deposit_cashflow_temporary ";
				//进deposit表的sql方法
				$strsql = $sqlObject->Insertsql($CASHFLOW['Model']);
				$sql .= $strsql;
				$sqlObject->query($sql);
				error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number.' cashflow db request:' ."\r\n". $sql ."\r\n", 3, $requestDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
				chmod($requestDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
			}

			if($this -> getType() == CASHFLOW_DEPOSIT_SUCCESS ||
				$this -> getType()	== CASHFLOW_DEPOSIT_FAILURE
			){
				//返回结果，对结果判断
				$this -> transationNumber = $this -> getColumnData($_SESSION,'transaction_number');
				$this -> setDeposit($this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($this -> transationNumber))));
				if($this -> isSendMail != VAL_INT_1){
					if($this -> getType() == CASHFLOW_DEPOSIT_SUCCESS){
						$this -> sendCashFlowSuccessMail();
						$this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
					}else if($this -> getType() == CASHFLOW_DEPOSIT_FAILURE){
						$this -> sendCashFlowFailMail();
						$this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
					}
				}
			}

		} else if($this -> getType()	== TYPE_APPLY) {	// カード決済前

			$json = null;

			if($this -> method	== NO_STRING) {
				echo json_encode(array(PARAM_RESULT =>ERROR, PARAM_MESSAGE => 'パラメータが不足しています'));
			}

			// リミットチェック
			if(!$this -> checkGPSLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> method, $errType)) {

				if($errType == VAL_INT_1) {

					echo json_encode(array(PARAM_RESULT =>ERROR, PARAM_MESSAGE => $this -> getMessage(ERROR, 'E_DEPOSIT_PERMISSION', array())));
				} else {
					echo json_encode(array(PARAM_RESULT =>ERROR, PARAM_MESSAGE => $this -> getMessage(ERROR, 'E_DEPOSIT_GPS_LIMIT', array())));
				}

			} else {
				echo json_encode(array(PARAM_RESULT => INFO, PARAM_MESSAGE => ''));
			}
		} else if($this -> getType() == VAL_STR_FLAT3_INPUT
			|| $this -> getType() == VAL_STR_FLAT3_SUCCESS
			|| $this -> getType() == VAL_STR_FLAT3_PRINT){


			$userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
            //check if user is not in bypass list. if not proceed with normal checking
            if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_FLAT3_METHOD,$userAccount)){
    			if($this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY)) != 'Japan'){
    				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_JAPAN', array());
    				$this -> setType('');
    				return;
    			}


				if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> setType(VAL_STR_FLAT3_KYC);
					return;
				}
            }

			$this -> currency = JPY;
			if($this -> getType() == VAL_STR_FLAT3_SUCCESS){
				if(!$this -> checkNull($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_FLAT3', array());
					$this -> setType(VAL_STR_FLAT3_INPUT);
					return;
				}

				if(!$this -> checkStringIntOnly($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$this -> setType(VAL_STR_FLAT3_INPUT);
					return;
				}
				if(!$this -> checkCurrencyNumberJP($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$this -> setType(VAL_STR_FLAT3_INPUT);
					return;
				}

				if($this -> amount > 500000 || $this -> amount < 3000){
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_FLAT3', array());
					$this -> setType(VAL_STR_FLAT3_INPUT);
					return;
				}

				$this -> fee = $this -> intToCurrency(ceil(($this -> amount * VAL_STR_FLAT3_FEE)),PERCENT);
				$this -> fee = ceil($this -> fee);
				$this -> setFeeEx($this -> formatCurrency($this -> fee, $this -> currency));
				$_SESSION['BankInfo'] = $this -> getFloat3();
				$_SESSION['BankInfo']['Fee'] = $this -> fee;
				$_SESSION['BankInfo']['Purchase'] = $this -> returnDepositAmountNatural();
				$_SESSION['BankInfo']['Credit'] = $this -> getAmountString($this -> amount, $this -> currency);
			}
		}else if($this -> getType() == VAL_STR_LBTF3_INPUT
			|| $this -> getType() == VAL_STR_LBTF3_SUCCESS
			|| $this -> getType() == VAL_STR_LBTF3_PRINT){


			$userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
            //check if user is not in bypass list. if not proceed with normal checking
            if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_LBTF3_METHOD,$userAccount)){
				//check if corporate
				if($this -> getAccountType() == "1") {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_OPTION_NOT_AVAILABLE', array());
					$this -> setType();
					return;
				}
    			if($this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY)) != 'Japan'){
    				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_JAPAN', array());
    				$this -> setType('');
    				return;
    			}

				if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> setType(VAL_STR_LBTF3_KYC);
					return;
				}
            }

			$this -> currency = JPY;
			if($this -> getType() == VAL_STR_LBTF3_SUCCESS){
				if(!$this -> checkNull($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT_REQUIRED', array());
					$this -> setType(VAL_STR_LBTF3_INPUT);
					return;
				}

				if(!$this -> checkStringIntOnly($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$this -> setType(VAL_STR_LBTF3_INPUT);
					return;
				}
				if(!$this -> checkCurrencyNumberJP($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$this -> setType(VAL_STR_LBTF3_INPUT);
					return;
				}

				 if($this -> amount > 500000 || $this -> amount < 3000){
				 	$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_FLAT3', array());
				 	$this -> setType(VAL_STR_LBTF3_INPUT);
				 	return;
				 }

				$this -> fee = $this -> intToCurrency(ceil(($this -> amount * VAL_STR_LBTF3_FEE)),PERCENT);
				$this -> fee = ceil($this -> fee);
				$this -> setFeeEx($this -> formatCurrency($this -> fee, $this -> currency));
				$_SESSION['BankInfo'] = $this -> getLocalBankFlat3();
				$_SESSION['BankInfo']['Fee'] = $this -> fee;
				$_SESSION['BankInfo']['Purchase'] = $this -> returnDepositAmountNatural();
				$_SESSION['BankInfo']['Credit'] = $this -> getAmountString($this -> amount, $this -> currency);
			}
		}else if($this -> getType() == VAL_STR_JPV_INPUT
			|| $this -> getType() == VAL_STR_JPV_SUCCESS
			|| $this -> getType() == VAL_STR_JPV_PRINT){


			$userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
            //check if user is not in bypass list. if not proceed with normal checking
            if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_JPV_METHOD,$userAccount)){

				//check if corporate
				if($this -> getAccountType() == "1") {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_OPTION_NOT_AVAILABLE', array());
					$this -> setType();
					return;
				}

    			if($this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY)) != 'Japan'){
    				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_JAPAN', array());
    				$this -> setType('');
    				return;
    			}

				if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> setType(VAL_STR_JPV_KYC);
					return;
				}
            }

			$this -> currency = JPY;
			if($this -> getType() == VAL_STR_JPV_SUCCESS){
				if(!$this -> checkNull($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT_REQUIRED', array());
					$this -> setType(VAL_STR_JPV_INPUT);
					return;
				}

				if(!$this -> checkStringIntOnly($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$this -> setType(VAL_STR_JPV_INPUT);
					return;
				}
				if(!$this -> checkCurrencyNumberJP($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$this -> setType(VAL_STR_JPV_INPUT);
					return;
				}

				 if($this -> amount > 500000 || $this -> amount < 3000){
				 	$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_FLAT3', array());
				 	$this -> setType(VAL_STR_JPV_INPUT);
				 	return;
				 }

				$this -> fee = $this -> intToCurrency(ceil(($this -> amount * VAL_STR_JPV_FEE)),PERCENT);
				$this -> fee = ceil($this -> fee);
				$this -> setFeeEx($this -> formatCurrency($this -> fee, $this -> currency));
				$_SESSION['BankInfo'] = $this -> getJapanVoucherFlat3();
				$_SESSION['BankInfo']['Fee'] = $this -> fee;
				$_SESSION['BankInfo']['Purchase'] = $this -> returnDepositAmountNatural();
				$_SESSION['BankInfo']['Credit'] = $this -> getAmountString($this -> amount, $this -> currency);
			}
		} else if($this -> getType() == TYPE_LBTC_INPUT
            || $this -> getType() == TYPE_LBTC_BACK
			|| $this -> getType() == TYPE_LBTC_CONFIRM){
                //set message & currency with static value to avoid decoding
                switch($this -> getLangage()){
                    case 'sc':
                        $this -> message = '中国国内银行转帐';
                        break;
                    case 'tc':
                        $this -> message = '中國國內銀行轉帳';
                        break;
                    default:
                        $this -> message = 'China Local Bank Transfer';
                }

                $this -> currency = 'CNY';

                //put user_account value inside variables
                $userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
                $userFullName   = $this -> getUserData(PARAM_NAME);
                $userEmail      = $this -> getUserEMailCommon($userAccount);

                //email parameters
                $params = array();
                $params[] = $userAccount;
                $params[] = $userFullName;


                //check if user is not in bypass list. if not proceed with normal checking
                if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_LBTC_METHOD,$userAccount)){

                    //check if corporate
                    if($this -> getAccountType() == VAL_INT_1){
                        $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_CORPORATE', array());
                        $rtn = false;
                    }else if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))){ //check if not unli status
        				// $this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_CHINA', array());
                        $this -> setType(TYPE_LBTC_NOTICE_KYC);
        				return;
        			}else if($this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT)) && $this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY)) != 'China') { //check if unli and not from china
                        // $this -> setType(TYPE_LBTC_NOTICE_KYC);
                        $this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_CHINA', array());
                        $rtn = false;
                    }
                }

                if(!$rtn) {
                    $this -> setType('');
                    return;
                }

                if($this -> getType() == TYPE_LBTC_BACK){
                    $this -> setType(TYPE_LBTC_INPUT);
                    return;
                }

                if($this -> getType() == TYPE_LBTC_CONFIRM){
                    //validate currency
                    if(!$this -> checkNull($this -> currency)){
                        $this -> popUpSessionMessage(ERROR, 'E_INVALID_CURRENCY_VALUE', array());
                        $rtn = false;
                    } elseif($this -> currency != 'CNY'){
                        $this -> popUpSessionMessage(ERROR, 'E_INVALID_CURRENCY_VALUE', array());
                        $rtn = false;
                    }

                    //if amount is empty
                    if(!$this -> checkNull($this -> amount)){
                        $this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT_REQUIRED', array());
                        $rtn = false;
                    } else{
                        if($this -> checkNull($this -> depoistmoney)){
        					if(!$this -> checkCurrencyNumber($this -> amount)){
        						$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("500", "49,000"));
        						$rtn = false;
        					}
							//  elseif(($this -> amount < 500) || ($this -> amount >50000)){
        					// 	$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("500", "50,000"));
        					// 	$rtn = false;
        					// }
        				} else {
    						if($this -> amount != 500 && $this -> amount != 1000 && $this -> amount != 5000 && $this -> amount != 10000 && $this -> amount != 49000){
    							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("500", "49,000"));
    							$rtn = false;
    						}
        				}
                    }

                    if(!$rtn) {
                        $this -> setType(TYPE_LBTC_INPUT);
                        return;
                    }

                    //code for sending request to SDPay Deposit API
                    include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'sdDeposit.php';
                    include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'SdAPIDeposit.php';

                    //generate transaction number
                    $txnNo = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);

                    //set language to be sent
                    $language = $this -> getLangage();
                    $lang     = NO_STRING;
                    switch($language){
                        case 'sc':
                            $lang = 'zh-cn';
                            break;
                        case 'tc':
                            $lang = 'zh-hk';
                            break;
                        default:
                            $lang = 'en-us';
                    }

                    //compute fee
                    $this -> fee     = $this -> intToCurrency(round(bcmul($this -> amount, VAL_STR_LBTC_FEE, 4)),PERCENT);

                    //total payment amount
                    $totalDepositAmount = number_format($this -> amount + $this -> fee, 2, ".", "");

                    //redirect url
                    $getParamstring = urlencode("lbtc_redirect&trxNo=".$txnNo."&acctID=".$userAccount);
                    //$redirectURL = "https://". SITE_DOMAIN . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . "deposit?type=" . $getParamstring;

                    //request parameters
                    /* $xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
                            <message>
                                <cmd>6006</cmd>
                                <merchantid>".VAL_SDPAY_DEPOSIT_MERCHANT_CODE."</merchantid>
                                <language>".$lang."</language>
                                <userinfo>
                                    <order>".$txnNo."</order>
                                    <username>".$userEmail."</username>
                                    <money>".$totalDepositAmount."</money>
                                    <unit>1</unit>
                                    <time></time>
                                    <remark></remark>
                                    <backurl>".VAL_STR_LBTC_CALLBACK_URL."</backurl>
                                    <backurlbrowser>".$redirectURL."</backurlbrowser>
                                </userinfo>
                            </message>";
					*/
                    // $mencrypt = new MyEncrypt(VAL_SDPAY_DEPOSIT_KEY1,VAL_SDPAY_DEPOSIT_KEY2);
                    // $md5Str   = md5($xml.VAL_SDPAY_DEPOSIT_KEY_MD5);
                    // $tempStr  = $xml.$md5Str;
                    // $des      = $mencrypt->encryptData($tempStr);

                    // $this -> sdPayEncrypted = $des;

					$sdApi = new SdAPIDeposit();
					$depositDate = date('Ymdhis');

					$arr_param = array (
						'merchantCode' => SD_MERCHANT_CODE,
						'intoAmount' => $totalDepositAmount,
						'type' => 'offline',
						'paymentTypeCode' => 'BANK_CARD_PAY',
						'comparisonType' => 'MONEY_ADD_NOTE',
						'bankCode' => '',
						'asyncURL' => addslashes(SD_DEPOSIT_ASYNC_URL),
						'syncURL' => '',
						'requestTime' => $depositDate,
						'serialNumber' => $txnNo,
						'userCode' => $userAccount,
						'signature' => $sdApi->create_send_privatesign(SD_MERCHANT_CODE.$totalDepositAmount, SD_MERCHANT_PRIVATE_KEY),
					);

					$this -> sdPayEncrypted = $sdApi -> create_content($arr_param);
					$_SESSION['content'] = $this -> sdPayEncrypted;
					//var_dump($this -> sdPayEncrypted);

                    $apiPath     = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
                    $requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'SDPayDeposit'.DIRECTORY_SEPARATOR.'deposit_request';

                    //check if directory exists if not, create directory
                    if(!file_exists($requestUrl)) {
                        mkdir($requestUrl, 0777, true);
                    }

                    //log the transaction details
                    error_log(date("[Y-m-d H:i:s]")."\r\n Array request[".$txnNo."]:" ."\r\n". implode(",", $arr_param) ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                    chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                    error_log(date("[Y-m-d H:i:s]")."\r\n Encrypted request[".$txnNo."]:" ."\r\n".  $this -> sdPayEncrypted ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                    chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                    //put to temporary lbtc table
                    //lbtc array model
                    $LBTC['Model'] = array();
    				$LBTC['Model']['transaction_number'] = $txnNo;
    				$LBTC['Model']['user_account'] = $userAccount;
    				$LBTC['Model']['amount'] = number_format($this -> amount, 2, '', '');
    				$LBTC['Model']['currency'] = 'CNY';
    				$LBTC['Model']['method'] = 'LBTC';
    				$LBTC['Model']['deposit_bank'] = 'Local Bank Transfer (China)';
    				$LBTC['Model']['fee'] = number_format($this -> fee, 2, '', '');
    				$LBTC['Model']['message'] = $this -> message;
    				$LBTC['Model']['comment'] = '';
    				$LBTC['Model']['create_time'] = date("Y-m-d H:i:s");
    				$LBTC['Model']['process_user'] = '9999';
    				$LBTC['Model']['type'] = '0';
    				$LBTC['Model']['err_flg'] = '0';
    				$LBTC['Model']['language'] = $this -> getLangage();

                    //unset session variables
                    $this -> unsetTemporaryDepositSessionData();
                    $this -> setLBTCSessionData($LBTC['Model']);

                }
        } else if($this -> getType() == TYPE_BIT_INPUT
			|| $this -> getType() == TYPE_BIT_SEND
			|| $this -> getType() == TYPE_BIT_COMPLETE
			|| $this -> getType() == TYPE_BIT_SEND_EMAIL){

            //put user_account value inside variables
            $userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
            $userFullName   = $this -> getUserData(PARAM_NAME);
            $accountType    = $this -> getColumnData($this -> account,'account_type');

			if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_BIT_METHOD,$userAccount)){
				//check if corporate
	            if($accountType == "1") {
	                $this -> popUpSessionMessage(ERROR, 'E_ERROR_OPTION_NOT_AVAILABLE', array());
	                $this -> setType();
	                return;
	            }

	            //check if exceutive
	            if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
	                $this -> setType(TYPE_BIT_NOTICE_KYC);
	                return;
	            }

			}


            //if type is send
            if($this -> getType() == TYPE_BIT_SEND) {
                $language = $this -> getLangage();

                //require api file
                include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'bitAPI.php';

                //instantiate api class
                $bitAPI = new BitAPI();

                //start request
                $requestData = $bitAPI -> generateRequestData(); //generate request data
                $res         = $bitAPI -> createWalletAddress($requestData); //create channel
				$date		 = date('Y-m-d H:i:s'); //created date

                //check if create channel is successful
                if($res != false) {
                    //save transaction number to session
                    $_SESSION['BIT']['transaction_number'] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT); //transaction_number

                    //define insert array
                    $insertArray = array();
                    $insertArray[] = $_SESSION['BIT']['transaction_number'];
                    $insertArray[] = $userAccount; //user_account
                    $insertArray[] = $userFullName; //user full name
                    $insertArray[] = $res['data']['wallet_address']; //bitcoin address
                    $insertArray[] = json_encode($res); //comment save response
                    $insertArray[] = $date;
                    $insertArray[] = $language; //language

                    //call insert to db function
                    $bitAPI -> insertBitTemporary($insertArray);

                    $this -> setType(TYPE_BIT_COMPLETE);

                } else { //create channel failed
                    $this -> popUpSessionMessage(ERROR, 'E_ERROR_BIT_API_FAILED', array());
                     $this -> setType(TYPE_BIT_INPUT);
                }

            }

            //send email
            if($this -> getType() == TYPE_BIT_SEND_EMAIL) {


                //transaction number
                $transactionNumber     = $_SESSION['BIT']['transaction_number'];

                //get data from temporary bit table
                $res = $this -> getRowData($this -> accessSelect('SELECT_TEMP_DEPOSIT_BIT', array("transaction_number", $transactionNumber)));

                //email parameters
                $params   = array();
                $params[] = $userAccount;
                $params[] = $userFullName;
                $params[] = $this -> getColumnData($res, 'create_time');
                $params[] = $this -> getColumnData($res, 'currency');
                $params[] = $this -> getColumnData($res, 'bit_address');

                $this -> sendMailByTmp('bit_confirm.xml'
                        , $params
                        , $this -> getUserEMailCommon($userAccount)
                        , VAR_CS_MAIL_ADDRESS);

                $this -> setType(TYPE_BIT_SUCCESS);
            }
        } else if($this -> getType() == TYPE_CLEARSETTLE_INPUT
			|| $this -> getType() == TYPE_CLEARSETTLE_SEND
			|| $this -> getType() == TYPE_CLEARSETTLE_COMPLETE
			|| $this -> getType() == TYPE_CLEARSETTLE_BACK
			|| $this -> getType() == TYPE_CLEARSETTLE_CONFIRM){

                //check if type is back
                if($this -> getType() == TYPE_CLEARSETTLE_BACK){
                    $this -> setType(TYPE_CLEARSETTLE_INPUT);
                    return;
                }

                //if type is input
                if($this -> getType() == TYPE_CLEARSETTLE_INPUT){



                    //check if user is not in bypass list. if not proceed with normal checking
                    if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_CLEARSETTLE_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
                        //check if corporate - if yes return to method selection page
                        if($this -> getAccountType() == VAL_INT_1){
                            $this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_CORPORATE', array());
                            $rtn = false;

                            if(!$rtn) {
                                $this -> setType(NO_STRING);
                                return;
                            }
                        }

						//check if executive - if no return to method selection page
						if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
							$this -> setType(TYPE_CLEARSETTLE_NOTICE_KYC);
							return;
						}
                    }

    				// 不正防止のため、成功失敗関係なく1時間に5回まで、決済することができる。
    				if(!$this -> checkClearsettleDeposit1Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
    					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_1_HOUR', array());
    					$rtn = false;

    					if(!$rtn) {
    						$this -> setType(NO_STRING);
    						return;
    					}
    				}

                    //如果为认证会员，获取会员的type,vip还是normal
    				if($this -> checkVIPStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
    					$account_Category = 'vip';
    				}else{
    					$account_Category = 'normal';
    				}

    				//将账户类别保存到SESSION中
    				$_SESSION['account_Category'] = $account_Category;

                    // 24時間以内決済成功は限制回まで。過去24時間にVIP 10回決済，Normal 3回したユーザーは、4回目エラーメッセージを表示
    				if(!$this -> checkDepositSuccessLimit24Hour($this -> getUserData(PARAM_USER_ACCOUNT), 'CLEARSETTLE')) {
    					if($account_Category == 'vip'){
    						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_VIP', array());
    					}else if($account_Category == 'normal'){
    						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_NORMAL', array());
    					}

    					$rtn = false;
    					if(!$rtn) {
    						$this -> setType(NO_STRING);
    						return;
    					}
    				}

                    // 30日間の決済成功累積額上限は、Normal EUR2000まで,Vip EURまで
    				if(!$this -> checkDepositAmountLimit30Days('CLEARSETTLE', $this -> getUserData(PARAM_USER_ACCOUNT))) {
    					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT_MONTHLY', array());
    					$rtn = false;

    					if(!$rtn) {
    						$this -> setType(NO_STRING);
    						return;
    					}
    				}

                }

                //if type is confirm
                if($this -> getType() == TYPE_CLEARSETTLE_CONFIRM){
                    //set currency to EUR
                    $this -> currency = 'EUR';

                    //查看金额是否为空
    				if(!$this -> checkNull($this -> amount)){
    					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
    					$rtn = false;
    					if(!$rtn) {
    						$this -> setType(TYPE_CLEARSETTLE_INPUT);
    						return;
    					}
    				}

    				//判断自定义金额是否为空，不为空对金额做出判断,以及有效入金限制
    				if($this -> checkNull($this -> depoistmoney)){
						if(!$this -> checkCurrencyNumber($this -> amount)){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
							$rtn = false;
						} elseif(($this -> amount < 500) || ($this -> amount >750)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_CLEARSETTLE_VALUE_OTHER', array());
							$rtn = false;
						}

						if(!$rtn) {
							$this -> setType(TYPE_CLEARSETTLE_INPUT);
							return;
						}
    				} else {
						if($this -> amount != 10 && $this -> amount != 30 && $this -> amount != 50 && $this -> amount != 100 && $this -> amount != 300){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_VM', array($this -> currency, '10', '750'));
							$rtn = false;
						}

    					if(!$rtn) {
    						$this -> setType(TYPE_CLEARSETTLE_INPUT);
    						return;
    					}
    				}

                    // 手数料の取得
    				$fee = $this -> getFeeCommon(VAR_DEPOSIT
    										, $this -> amount
    										, $this -> currency
    										, $this -> getUserData(PARAM_USER_ACCOUNT));

    				$this -> fee = $this -> getColumnData($fee, $this -> currency . VAL_INT_1);
    				// 上乗せ分対応
					$markup = CLEARSETTLE_RISK_FEE_EUR;

    				$commission		= $this -> intToCurrency(($this -> amount * VAL_STR_CLEARSETTLE_FEE),PERCENT);

    				$this -> fee	+= $commission;
    				$this -> fee 	+= $markup;

                    //set session variables
                    $this -> setDepositInputSession('CLEARSETTLE');
                }

                //if type is send
                if($this -> getType() == TYPE_CLEARSETTLE_SEND){
                    //log files path
                    $apiPath 		= dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
                    $requestUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Clearsettle'.DIRECTORY_SEPARATOR.'request';
                    $requestDbUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Clearsettle'.DIRECTORY_SEPARATOR.'db_request';

                    //check if directory exists if not, create directory
                    if(!file_exists($requestUrl)) {
                        mkdir($requestUrl, 0777, true);
                    }

                    if(!file_exists($requestDbUrl)) {
                        mkdir($requestDbUrl, 0777, true);
                    }

                    //get session array variable for clearsettle input fields.
                    $Amount     		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'Actual');
                    $Amount     		= number_format($Amount, 2, '', '');
    				$Currency   		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'currency');
    				$Street     		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'address');
    				$City       		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'city');
    				$ZIP        		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'zip');
    				$Country    		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'Country');
    				$language   		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'lang');
    				$first_name 		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'firstName');
    				$last_name  		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'lastName');
    				$birthday   		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'birthday');
                    $birthday           = date_format(date_create($birthday), 'Y-m-d');
    				$mail       		= $this -> getColumnData($_SESSION['CLEARSETTLE'],'mail');
                    $transactionNumber  = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);
                    $userAccount        = $this -> getColumnData($this -> account, PARAM_USER_ACCOUNT);

                    //redirect url
                    $getParamstring = urlencode(TYPE_CLEARSETTLE_COMPLETE."&trxNo=".$transactionNumber);
                    $returnURL          = 'https://' . SITE_DOMAIN . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . 'deposit?type=' . $getParamstring;
                    // $returnURL          = 'http://iwl.localhost' . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . 'deposit?type=' . $getParamstring;

                    $language = ($language == 'sc' || $language == 'tc') ? 'cn' : $language;

                    //send request and save it to temporary clearsettle table
                    $data = "apiKey=". CLEARSETTLE_DEPOSIT_KEY .
                       "&email=" . $mail .
                       "&birthday=" . $birthday .
                       "&amount=". $Amount .
                       "&currency=EUR".
                       "&returnURL=" . $returnURL .
                       "&referenceNo=" . $transactionNumber .
                       "&language=" . $language .
                       "&billingFirstName=" . $first_name .
                       "&billingLastName=" . $last_name .
                       "&billingAddress1=" . $Street .
                       "&billingCity=" . $City .
                       "&billingCountry=" . $Country .
                       "&billingPostCode=" . $ZIP;

                    //log clearsettle request
                    error_log(date("[Y-m-d H:i:s]")."\r\n". $transactionNumber .' clearsettle request:' ."\r\n". $data ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
       				chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                    //CURL 模拟POST
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, CLEARSETTLE_DEPOSIT_API_URL);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $responseData = curl_exec($ch);
                    if(curl_errno($ch)) {
                      return curl_error($ch);
                    }
                    curl_close($ch);
                    //get response
                    $responseDataDecoded = json_decode($responseData);

                    //clearsettle array model
                    $CLEARSETTLE['Model'] = array();
    				$CLEARSETTLE['Model']['transaction_number'] = $transactionNumber;
    				$CLEARSETTLE['Model']['status'] = $responseDataDecoded -> status;
    				$CLEARSETTLE['Model']['user_account'] = $userAccount;
    				$CLEARSETTLE['Model']['amount'] = $this -> getColumnData($_SESSION['CLEARSETTLE'],'amount');
    				$CLEARSETTLE['Model']['currency'] = $Currency;
    				$CLEARSETTLE['Model']['method'] = 'CLEARSETTLE';
    				$CLEARSETTLE['Model']['deposit_bank'] = 'Clearsettle';
    				$CLEARSETTLE['Model']['fee'] = $this -> getColumnData($_SESSION['CLEARSETTLE'],'fee');
    				$CLEARSETTLE['Model']['message'] = $this -> getColumnData($_SESSION['CLEARSETTLE'],'message');
    				$CLEARSETTLE['Model']['comment'] = $responseData;
    				$CLEARSETTLE['Model']['create_time'] = date("Y-m-d H:i:s");
    				$CLEARSETTLE['Model']['process_user'] = '9999';
    				$CLEARSETTLE['Model']['type'] = '0';
    				$CLEARSETTLE['Model']['err_flg'] = '0';
    				$CLEARSETTLE['Model']['language'] = $this -> getLangage();
    				$sqlObject = new mysql($this->getConfigValue(SECTION_DB,HOST_NAME),$this->getConfigValue(SECTION_DB,USER_NAME),$this->getConfigValue(SECTION_DB,LOGIN_PASS),$this->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');
    				$sql = "insert into t_deposit_clearsettle_temporary ";
    				//进deposit表的sql方法
    				$strsql = $sqlObject->Insertsql($CLEARSETTLE['Model']);
    				$sql .= $strsql;
    				$sqlObject->query($sql);
    				error_log(date("[Y-m-d H:i:s]")."\r\n".$transactionNumber.' clearsettle db request:' ."\r\n". $sql ."\r\n", 3, $requestDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
    				chmod($requestDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                    //redirect to payment url
                    if(isset($responseDataDecoded -> purchaseUrl)) {
                        header('Location:'. $responseDataDecoded -> purchaseUrl);
                        exit();
                    } else{
                        $this -> popUpSessionMessage(ERROR, 'E_ERROR_DEPOSIT_UNKNOWN', array());
                        $this -> setType(TYPE_CLEARSETTLE_INPUT);
                        return;
                    }

                }

                //if type is complete
                if($this -> getType() == TYPE_CLEARSETTLE_COMPLETE){
                    //set transaction number
                    $transaction_number = $this -> transaction_id;

                    //search for it in t_deposit
                    $depositRecord = $this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($transaction_number)));

                    //if found, set type success else set type fail
                    if(count($depositRecord) > 0){
                        //set other email parameter
                        $this -> setClearsettleSuccessDetails($transaction_number);

                        //set type to success
                        $this -> setType(TYPE_CLEARSETTLE_SUCCESS);
                    } else{
                        //set type to fail
                        $this -> setType(TYPE_CLEARSETTLE_FAIL);
                    }
                    return;
                }
            } elseif ($this -> getType() == TYPE_LBTJ_INPUT) {

				$userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
                //check if user is not in bypass list. if not proceed with normal checking
                if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_LBTJ_METHOD,$userAccount)){
					if($this -> getAccountType() == VAL_INT_1){
							$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_CORPORATE', array());
							$rtn = false;

							if(!$rtn) {
									$this -> setType(NO_STRING);
									return;
							}
					}

                    if($this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY)) != 'Japan'){
    					$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_JAPAN', array());
    					$this -> setType('');
    					return;
    				}

					if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
						$this -> setType(TYPE_LBTJ_NOTICE_KYC);
						return;
					}
                }

    		} elseif($this -> getType() == TYPE_LBTJ_UPLOAD) {
				//check if upload file is empty
				if($_FILES['file_img']['size'] == 0 && $_FILES['file_img']['error'] == 4) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_ATTACHMENT', array());
					$this -> setType(TYPE_LBTJ_INPUT);
					return;
				} elseif($_FILES['file_img']['size'] > 5242880) { //check file size if exceeds 5MB
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_EXCEEDS_MAX_FILE_SIZE', array());
					$this -> setType(TYPE_LBTJ_INPUT);
					return;
				}

				//if there is no error, set the value of the file
				$this -> file = $_FILES['file_img'];

				//if there is no error, set type to LBTJ_COMPLETE
				$this -> setType(TYPE_LBTJ_COMPLETE);
			} elseif ($this -> getType() == TYPE_IBT_INPUT) {

                //check if user is not in bypass list. if not proceed with normal checking
                if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_IBT_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
    				if($this -> getAccountType() == VAL_INT_1){
    					$this -> setType(TYPE_IBT_CORP);
    					return;
    				}

					if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
						$this -> setType(TYPE_IBT_NOTICE_KYC);
						return;
					}
                }
    		}else if($this -> getType() == TYPE_H2P_INPUT) {
					$this -> isExecutive = $this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT));
					if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
						if($this -> getAccountType() == VAL_INT_1){
							$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_CORPORATE', array());
							$rtn = false;
							$this -> setType();
							return;
						}
						//check if exceutive
						if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
							$this -> setType(TYPE_H2P_NOTICE_KYC);
							return;
						}
						$countryName = $this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY));
						if($countryName != 'Indonesia' && $countryName != 'Vietnam' && $countryName != 'Thailand' && $countryName != 'Malaysia'){
							  $this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_IN_HELP2PAY', array());
							  $this -> setType('');
							  return;
						}
					}

					$sqlObject = new mysql($this->getConfigValue(SECTION_DB,HOST_NAME),$this->getConfigValue(SECTION_DB,USER_NAME),$this->getConfigValue(SECTION_DB,LOGIN_PASS),$this->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');
					$country = $this->dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));
					$countryList =  array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam');
					$bypassValue = ($this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT))));

					if((in_array($country,$countryList,TRUE)) && !$bypassValue){
						$this -> country = $country;
						// GET CURRENCY PER COUNTRY
						if($country == "Indonesia"){
							$this -> currency = "IDR";
						} else if($country == "Vietnam"){
							$this -> currency = "VND";
						} else if($country == "Thailand"){
							$this -> currency = "THB";
						} else if($country == "Malaysia"){
							$this -> currency = "MYR";
						}

					}else{
						if(isset($this -> country) || ($this -> country != NULL)){
							// GET CURRENCY PER COUNTRY
							if($this -> country == "Indonesia"){
								$this -> currency = "IDR";
							} else if($this -> country == "Vietnam"){
								$this -> currency = "VND";
							} else if($this -> country == "Thailand"){
								$this -> currency = "THB";
							} else if($this -> country == "Malaysia"){
								$this -> currency = "MYR";
							}
						}
					}

				} else if($this -> getType() == TYPE_H2P_CONFIRM) {

						// Check if executive
						$this -> isExecutive = $this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT));
						// REMOVE COMMA in amount
						$this -> amount = str_replace(",","",$this -> amount);
						// Validate amount if blank
						if(!$this -> checkNull($this -> amount)){
								$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
								$this -> setType(TYPE_H2P_INPUT);
								return;
						}

						$this -> bank = $this -> getDataPost('bank');

						// GET FEE
						$this -> fee  = $this -> intToCurrency(round(bcmul($this -> amount, VAL_STR_H2P_FEE, 4)),PERCENT);

						$country = $this->dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));
						$countryList =  array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam');
						$bypassValue = ($this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT))));

						if((in_array($country,$countryList,TRUE)) && !$bypassValue){
							$this -> country = $country;
							// GET CURRENCY PER COUNTRY
							if($this -> country == "Indonesia"){
								$this -> currency = "IDR";
							} else if($this -> country == "Vietnam"){
								$this -> currency = "VND";
							} else if($this -> country == "Thailand"){
								$this -> currency = "THB";
							} else if($this -> country == "Malaysia"){
								$this -> currency = "MYR";
							}
						}

						// Validation
						$customizedAmount = $this -> amount;
						if($this -> country == NULL || $this -> country == NO_STRING){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_COUNTRY));
							$rtn = false;
						}

						if($this -> currency == NULL || $this -> currency == NO_STRING){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CURRENCY));
							$rtn = false;
						}

						if(!$rtn){
							$this -> setType(TYPE_H2P_INPUT);
							return;
						}
						// CHECK IF BANK IS BLANK
						if($this -> bank == null) {
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_BANK_OTHER', array());
							$this -> setType(TYPE_H2P_INPUT);
						} else {

							// CHECK IF OTHERS IS GREATER OR EQUAL
							if($customizedAmount != null) {
								if($this -> currency == "VND"){
									if($this -> isExecutive == true) {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '300,000', '290,000,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 290000000 || $customizedAmount < 300000) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_VND_VALUE_EXECUTIVE_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_VND_VALUE_EXECUTIVE_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									} else {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '300,000', '100,000,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 100000000 || $customizedAmount < 300000 ) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_VND_VALUE_STANDARD_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_VND_VALUE_STANDARD_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									}
								}
								if($this -> currency == "IDR"){
									if($this -> isExecutive == true) {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '200,000', '190,000,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 190000000  ||  $customizedAmount < 200000) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_IDR_VALUE_EXECUTIVE_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_IDR_VALUE_EXECUTIVE_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									} else {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '200,000', '100,000,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 100000000  ||  $customizedAmount < 200000) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_IDR_VALUE_STANDARD_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_IDR_VALUE_STANDARD_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									}
								}
								if($this -> currency == "MYR"){
									if($this -> isExecutive == true) {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '50', '48,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 48000  ||  $customizedAmount < 50) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_MYR_VALUE_EXECUTIVE_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_MYR_VALUE_EXECUTIVE_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									} else {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '50', '30,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 30000  ||  $customizedAmount < 50) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_MYR_VALUE_STANDARD_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_MYR_VALUE_STANDARD_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									}
								}
								if($this -> currency == "THB"){
									if($this -> isExecutive == true) {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '500', '480,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 480000  ||  $customizedAmount < 500) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_THB_VALUE_EXECUTIVE_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_THB_VALUE_EXECUTIVE_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									} else {
										if (!is_numeric($this -> amount)) {
												$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_H2P_NONINTEGER', array($this -> currency, '500', '300,000'));
												$this -> setType(TYPE_H2P_INPUT);
												return;
										}
										if($customizedAmount > 300000  ||  $customizedAmount < 500) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_THB_VALUE_STANDARD_OTHER', array());
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
										if(!$this -> checkStringIntOnly($this -> amount)) {
											$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_THB_VALUE_STANDARD_OTHER', array(VAL_STR_AMOUNT));
											$this -> setType(TYPE_H2P_INPUT);
											return;
										}
									}
								}
							}
						}
				} else if($this -> getType() == TYPE_H2P_SEND) {
					// Check if executive
					$this -> isExecutive = $this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT));
					// GET AMOUNT
					$this -> amount = str_replace(",", NO_STRING, $this -> getDataPost('amount'));
					if(!$this -> checkNull($this -> amount)){
							$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
							$this -> setType('');
							return;
					}
					// Validate amount if its number
					if (!is_numeric($this -> amount)) {
							$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
							$this -> setType('');
							return;
					}
					// Get CustomerID Needed by the gateway
					$this -> userAccount = $this -> getColumnData($this -> account, PARAM_USER_ACCOUNT);
					// GET Bank
					$this -> bank = $this -> getDataPost('bank');
					// GET Currency
					$this -> fee = $this -> intToCurrency(round(bcmul($this -> amount, VAL_STR_H2P_FEE, 4)), PERCENT);

					$country = $this->dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));
					$countryList = array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam');
					$bypassValue = $this -> getUserBypassValue(
					                   PARAM_DEPOSIT, 
					                   VAL_STR_H2P_METHOD, 
					                   $this -> getUserData(PARAM_USER_ACCOUNT)
					    );

					if((in_array($country,$countryList,TRUE) && !$bypassValue) || isset($this -> country)){
						// GET CURRENCY PER COUNTRY
						if($country == "Indonesia"){
							$this -> currency = "IDR";
						} else if($country == "Vietnam"){
							$this -> currency = "VND";
						} else if($country == "Thailand"){
							$this -> currency = "THB";
						} else if($country == "Malaysia"){
							$this -> currency = "MYR";
						}
					}

					// CHECK IF AMOUNT IS CHANGE ON DEVELOPER TOOL
					$customizedAmount = $this -> amount;
					if($this -> currency == "VND"){
						if($this -> isExecutive == true) {
							if($customizedAmount > 290000000 || $customizedAmount < 300000) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						} else {
							if($customizedAmount > 100000000 || $customizedAmount < 300000 ) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						}
					}
					if($this -> currency == "IDR"){
						if($this -> isExecutive == true) {
							if($customizedAmount > 190000000  ||  $customizedAmount < 200000) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						} else {
							if($customizedAmount > 100000000  ||  $customizedAmount < 200000) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						}
					}
					if($this -> currency == "MYR"){
						if($this -> isExecutive == true) {
							if($customizedAmount > 48000  ||  $customizedAmount < 50) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						} else {
							if($customizedAmount > 30000  ||  $customizedAmount < 50) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						}
					}
					if($this -> currency == "THB"){
						if($this -> isExecutive == true) {
							if($customizedAmount > 480000  ||  $customizedAmount < 500) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						} else {
							if($customizedAmount > 300000  ||  $customizedAmount < 500) {
								$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
								$this -> setType('');
							}
						}
					}
					// Validate Bank with CURRENCY
					$IsBankLegit = $this -> ValidateBankCurrency();
					if($IsBankLegit == 0) {
						$this -> popUpSessionMessage(ERROR, 'E_VALIDATE_HELP2PAY_DEVELOPER_TOOLS', array());
						$this -> setType('');
					}
					// Check if chexkbox is check if not then redirect back.
					if($this -> getDataPost('checkaggree') != "on"){
						$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_HELP2PAY_NOTAGGREE_OTHER', array());
						$this -> setType(TYPE_H2P_CONFIRM);
					} else {
					    $h2pSettings = $this -> getSettingConfiguration("help2pay_conf");
					    
					    $this -> h2pTransferUrl    = $h2pSettings -> transfer_url;
					    $this -> h2pSecurityCode   = $h2pSettings -> security_code;
					    $this -> h2pMerchantID     = $h2pSettings -> merchant_code;
					    
						// Need to remove the comma in the amount
						$this -> formattedAmount = str_replace(
						    ",", 
						    NO_STRING,
						    $this -> formatCurrency(($this -> amount + $this -> fee), $this -> currency));
						
						// GET IP ADDRESS
						$this -> ipAddress = $this -> getColumnData($_SERVER, "HTTP_X_FORWARDED_FOR");
						
						if($this -> getColumnData($_SERVER, "REMOTE_ADDR") != NO_STRING) 
						    $this -> ipAddress = $this -> getColumnData($_SERVER, "REMOTE_ADDR");
						
						// Get Customer ReferenceID
						$this -> referenceNo = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);

						// Get Amount
						$this -> customer_amount = "{$this -> formattedAmount}.00";
					
						// Get Customer Note
						$this -> customer_note = "Note";
						
						// Get Customer language
						$this -> customer_language = "en-us";
						
						// Get Back URI
						$language = $this -> getLangage();
						$this -> h2pCallbackURL = HELP2PAY_CALLBACKURL."?lang=".$language;

						//SAVE TO DATABASE
						$transactionNumber = $this -> referenceNo;

						$this -> accessModify("INSERT_DEPOSIT_H2P_TEMP", [
						    $this -> referenceNo,
						    $this -> getUserData(PARAM_USER_ACCOUNT),
						    $this -> amount,
						    $this -> formattedAmount,
						    $this -> currency,
						    VAL_STR_H2P_METHOD,
						    date("Y-m-d H:i:s"),
						    $this -> getDataPost('bank'),
						    str_replace(",", NO_STRING, $this -> formatCurrency($this -> fee, $this -> currency)),
						    "Local Bank Transfer (Southeast Asia)",
						    "via Front Page",
						    date("Y-m-d H:i:s"),
						    '9999',
						    NO_COUNT,
						    NO_COUNT,
						    NO_COUNT
						]);
						
						// Need to set up the time as it error on third party
						date_default_timezone_set('Asia/Manila');

						// Get Date Today
						$customer_year = date('Y-m-d');
						$customer_Hour = date('g');
						$customer_Hour = ($customer_Hour < 10 ? '0'.$customer_Hour : $customer_Hour);
						$customer_minutes = date('i:s A');
						$this -> customer_date = $customer_year." ".$customer_Hour.":".$customer_minutes;

						$reqinfo = "[date:".$this -> customer_date."][amount:".$this -> customer_amount."][merchant:".$this -> h2pMerchantID."][customerName:".$this -> userAccount."][currency:".$this -> currency."][customerSecurityCode:".$this -> h2pSecurityCode."][customerBank:".$this -> bank."]";
						//SAVE LOGS
						$apiPath     = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
						$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P'.DIRECTORY_SEPARATOR.'deposit_request';

						//check if directory exists if not, create directory
						if(!file_exists($requestUrl)) {
							mkdir($requestUrl, 0777, true);
						}

						//log the transaction details
						error_log(date("[Y-m-d H:i:s]")."\r\nRequest[".$this -> referenceNo."]:" ."\r\n". $reqinfo ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
						chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

						// Get KEY
						$customer_data = $this -> h2pMerchantID
						                  .$this -> referenceNo
						                  .$this -> userAccount
						                  .$this -> customer_amount
						                  .$this -> currency
						                  .date('YmdHis')
						                  .$this -> h2pSecurityCode
						                  .$this -> ipAddress;

						$this -> customer_key = md5($customer_data);
						$this -> customer_data = $customer_data;
					}

				} else if($this -> getType() == TYPE_H2P_STATUS) {
					unset($_SESSION['H2PCurrency']);
					if($this -> getDataPost("Status") == NO_STRING) {
						$this -> setType('');
						return;
					}
						
					$this -> status = $this -> getDataPost("Status");
					$this -> transationNumber = $this -> getDataPost("Reference");
					
					switch($this -> status){
					    case "000":
					    case "006":{
					        $tempRow = $this -> accessSelect("SELECT_DEPOSIT_H2P_TEMP", [$this -> getDataPost("Reference")]);
					        
					        if($this -> isLoopData($tempRow)){
					            $tempRow = $this -> getRowData($tempRow);
					            
					            $processedTransaction = $this -> accessSelect("SELECT_DEPOSIT_BY_TRANSACTION_NUMBER", [$this -> getDataPost("Reference")]);
					            
					            if(!$this -> isLoopData($processedTransaction)){					                
					                $comment = "Bank:".$this -> getColumnData($tempRow, 'deposit_bank')
					                .",Merchant:{$this -> getDataPost('Merchant')}"
					                .",Status:{$this -> getDataPost('Status')}"
					                .",Currency:{$this -> getDataPost('Currency')}"
					                .",Amount:{$this -> getDataPost('Amount')}"
					                .",Datetime:{$this -> getDataPost('Datetime')}"
					                .",Customer:{$this -> getDataPost('Customer')}"
					                .",Language:{$this -> getDataPost('Language')}"
					                .",Reference:{$this -> getDataPost('Reference')}"
					                .",ID:{$this -> getDataPost('ID')}"
					                .",Key:{$this -> getDataPost('Key')}"
					                .",Note:{$this -> getDataPost('Note')}";
					                
					                $toInsert = [
					                    $this -> getColumnData($tempRow, COLUMN_TRANSACTION_NUMBER),
					                    $this -> getColumnData($tempRow, COLUMN_USER_ACCOUNT),
					                    $this -> getColumnData($tempRow, COLUMN_AMOUNT),
					                    $this -> getColumnData($tempRow, COLUMN_CURRENCY),
					                    $this -> getColumnData($tempRow, COLUMN_METHOD),
					                    "Local Bank Transfer(Southeast Asia)",
					                    $this -> getColumnData($tempRow, COLUMN_DEPOSIT_DATE),
					                    $this -> getColumnData($tempRow, COLUMN_FEE),
					                    $comment,
					                    $this -> getColumnData($tempRow, COLUMN_CREATE_TIME),
					                    NO_COUNT,
					                    NO_COUNT,
					                    "Local Bank Transfer(Southeast Asia)"
					                ];
					                					                
					                $this -> accessModify("INSERT_WB_DEPOSIT_TRANSACTION", $toInsert, false);
					                $processedTransaction = $this -> accessSelect("SELECT_DEPOSIT_BY_TRANSACTION_NUMBER", [$this -> getDataPost("Reference")]);
					            }
					            
					            $this -> setDeposit($this -> getRowData($processedTransaction));
					            
					            $this -> fee                 = $this -> intToCurrency(
					                                               round(bcmul($this -> getColumnData($tempRow, COLUMN_AMOUNT), 
					                                               VAL_STR_H2P_FEE, VAL_INT_4)), PERCENT);
					            $this -> createTime	         = $this -> getColumnData($tempRow, COLUMN_CREATE_TIME);
					            $this -> amount	             = $this -> getColumnData($tempRow, COLUMN_AMOUNT);
					            $this -> currency	         = $this -> getColumnData($tempRow, COLUMN_CURRENCY);
					            $this -> transationNumber    = $this -> getColumnData($tempRow, COLUMN_TRANSACTION_NUMBER);
					            
					            $this -> sendHelp2PaySuccessMail();
					        }
					        break;
					    }
					    case "009":
					        $this -> setType(TYPE_H2P_PENDING);
					        break;
					    default:
					        $this -> sendHelp2PayFailMail();
					        $this -> setType(TYPE_H2P_FAIL);
					        break;
					}
				}else if($this -> getType() == TYPE_CPS_INPUT
                    || $this -> getType() == TYPE_CPS_CONFIRM
                    || $this -> getType() == TYPE_CPS_COMPLETE
                    || $this -> getType() == TYPE_CPS_BACK
                    || $this -> getType() == TYPE_CPS_SEND){

                    //set currency to EUR
                    $this -> currency = 'EUR';
                    //put user_account value inside variables
                    $userAccount    = $this -> getUserData(PARAM_USER_ACCOUNT);
                    $userFullName   = $this -> getUserData(PARAM_NAME);
                    $accountType    = $this -> getColumnData($this -> account,'account_type');
                    $userCountry    = $this -> getColumnData($this -> account,'country');

                    //check if account is executive or corporate
                    if(!$this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_CPS_METHOD,$userAccount)){
                        //check if corporate
                        if($accountType == "1") {
                            $this -> popUpSessionMessage(ERROR, 'E_ERROR_OPTION_NOT_AVAILABLE', array());
                            $this -> setType();
                            return;
                        }

                        //check if exceutive
                        if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
							if(!$this -> checkUsuallyStatus($this -> getUserData(PARAM_USER_ACCOUNT))){
								$this -> setType(TYPE_CPS_NOTICE_KYC);
								return;
							}
                        }
                    }

                     if($this -> getType() == TYPE_CPS_BACK){
                        $this -> setType(TYPE_CPS_INPUT);
                        return;
                    }

                    if($this -> getType() == TYPE_CPS_CONFIRM){
                        // Validate amount if its a number
                        if (!is_numeric($this -> amount)) {
                                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array(50, '48,000'));
                                $this -> setType(TYPE_CPS_INPUT);
                                return;
                        }
                        //check if amount is empty
                        if(!$this -> checkNull($this -> amount)){
                        $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
                        $this -> setType(TYPE_CPS_INPUT);
                        }elseif($this -> checkNull($this -> depoistmoney)){

                            if(!$this -> checkCurrencyNumber($this -> amount)){
                                $this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
                                $this -> setType(TYPE_CPS_INPUT);
                            }
                             elseif(($this -> amount < 50 || $this -> amount > 48000)){
                                    $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array(50, '48,000'));
                                    $this -> setType(TYPE_CPS_INPUT);
                            }
                        }else{
                            if($this -> amount != 50 && $this -> amount != 100 && $this -> amount != 300 && $this -> amount != 500 && $this -> amount != 1000){
                                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array(50, "48,000"));
                                $this -> setType(TYPE_CPS_INPUT);
                            }
                        }
                        //compute fee
                        $this -> fee     = $this -> intToCurrency(round(bcmul($this -> amount, VAL_STR_CPS_FEE, 4)),PERCENT);
                        //total payment amount
                        $totalDepositAmount = number_format($this -> amount + $this -> fee, 2, ".", "");

                        //set session variables
                        $_SESSION['CPS']            = array();
                        $_SESSION['CPS']['amount']  = $this -> amount;
                        $_SESSION['CPS']['fee']     = $this -> fee;
                        $_SESSION['CPS']['Actual']  = $totalDepositAmount;
                    }

                    //if type is send
                    if($this -> getType() == TYPE_CPS_SEND) {
                        $apiPath        = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
                        $requestUrl     = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Cryptocoin'.DIRECTORY_SEPARATOR.'request';
                        $responseUrl    = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Cryptocoin'.DIRECTORY_SEPARATOR.'response';

                        //check if directory exists if not, create directory
                        if(!file_exists($requestUrl)) {
                            mkdir($requestUrl, 0777, true);
                        }

                        //check if directory exists if not, create directory
                        if(!file_exists($responseUrl)) {
                            mkdir($responseUrl, 0777, true);
                        }

                        $language = $this -> getLangage();

                        $this -> transaction_number = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);

                        //redirect url
                        $getParamstring = urlencode("cps_input");
                        //$redirectURL = "http://". SITE_DOMAIN . "/" . $language . "/" . "deposit?type=" . $getParamstring; // for CPS test
                        $redirectURL = "https://secure.". SITE_DOMAIN . "/" . $language . "/" . "deposit?type=" . $getParamstring; // for CPS live

                        $data = "amount=". $this -> getColumnData($_SESSION['CPS'],'Actual') .
                                "&fiat_currency=". $this -> currency .
                                //"&notification_url=https://test.iwl.world/api/andexPayCallback.php" . //for CPS test
                                "&notification_url=https://secure.iwl.world/api/andexPayCallback.php" . //for CPS live
                                "&merchant_transaction_id=". $this -> transaction_number .
                                "&customer_first_name=". $this -> getColumnData($this -> account, PARAM_FIRST_NAME) .
                                "&customer_last_name=". $this -> getColumnData($this -> account, PARAM_LAST_NAME) .
                                "&contact_email=". $this -> getColumnData($this -> account, PARAM_MAIL) .
                                "&customer_ip_address=". $_SERVER['REMOTE_ADDR'] .
                                "&customer_country_code=". $userCountry .
                                "&channel=iwl_cc-cps".
                                "&redirect_url=". $redirectURL;

                         error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number .' Cryptocoin request:' ."\r\n". $data ."\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
                         chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

                        //require api file
                        include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'cpsAPI.php';

                        //instantiate api class
                        $cpsAPI = new CpsAPI();

                        //start request
                        $res         = $cpsAPI->createWalletAddress($data); //create channel
                        $date        = date('Y-m-d H:i:s'); //created date

                        if($res != false){

							if($res['success'] == TRUE){

		                            error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number .' Cryptocoin response:' ."\r\n". json_encode($res) ."\r\n", 3, $responseUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
		                            chmod($responseUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

		                            $this -> formURL = $res['data']['url'];

		                            //define insert array
		                            $insertArray = array();
		                            $insertArray[] = $this -> transaction_number;
		                            $insertArray[] = $userAccount;
		                            $insertArray[] = $userFullName;
		                            $insertArray[] = $this -> currency;
		                            $insertArray[] = 0;//conversion rate
		                            $insertArray[] = $_SESSION['CPS']['amount'];//converted amount
		                            $insertArray[] = $_SESSION['CPS']['fee'];//converted amount
		                            $insertArray[] = 0;//crypto value
		                            $insertArray[] = '';//crypto currency
		                            $insertArray[] = json_encode($res); //comment
		                            $insertArray[] = $date; //create time
		                            $insertArray[] = $date; //update time
		                            $insertArray[] = $this -> getLangage(); //language
		                            $insertArray[] = '0'; //is reflected

		                            $cpsAPI->insertCPSTemporary($insertArray);

							}else{
								error_log(date("[Y-m-d H:i:s]")."\r\n".$this -> transaction_number .' Cryptocoin response:' ."\r\n". json_encode($res) ."\r\n", 3, $responseUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
								chmod($responseUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

								$this -> popUpSessionMessage(ERROR, 'E_ERROR_CPS_API_FAILED', array());
								$this -> setType(TYPE_CPS_INPUT);
							}

                        }else{
                            $this -> popUpSessionMessage(ERROR, 'E_ERROR_CPS_API_FAILED', array());
                            $this -> setType(TYPE_CPS_INPUT);
                        }
                    }

				}if($this -> getType() == TYPE_CCD_INPUT || 
				    $this -> getType() == TYPE_CCD_CONFIRM || 
				    $this -> getType() == TYPE_CCD_COMPLETE || 
				    $this -> getType() == TYPE_CCD_SEND ||
				    $this -> getType() == TYPE_CCD_SUCCESS ||
				    $this -> getType() == TYPE_CCD_FAIL){
				    
				    $this -> eplconf = $this -> getSettingConfiguration("easy_payment_link");
				    $midconf = $this -> getSettingConfiguration("middleware_conf");
				    				        
				    if(!$this -> getUserBypassValue(PARAM_DEPOSIT, VAL_STR_CCDEPOSIT_METHOD, $this -> getUserData(PARAM_USER_ACCOUNT))){
				        $this -> popUpSessionMessage(ERROR, 'E_ERROR_OPTION_NOT_AVAILABLE', array());
				        $this -> setType();
				        return false;
				    }
				    				
				    // validation
				    switch($this -> getType()){
				        case TYPE_CCD_FAIL:
				        case TYPE_CCD_SUCCESS:
				            $callbackData = $this -> getDataGet("ccback");
				            
				            $terminate = function(){
				                header("Location: /{$this -> getLangage()}");
				                exit();
				            };
				            
				            if($callbackData != NO_STRING){
				                try{
				                    $callbackData = JWT::decode($callbackData,
				                        $this -> eplconf -> link_key,
				                        [$midconf -> algorithm]);

				                    if(!is_object($callbackData))
				                        $terminate();
				                    
				                    if($this -> getType() == TYPE_CCD_SUCCESS) 
				                        $this -> ccdTransDetails = (array) $callbackData;
				                    
				                    if(isset($callbackData -> expiration)){
				                        $now = strtotime(date("Y-m-d H:i:s"));
				                        $exp = strtotime($callbackData -> expiration);
				                        
				                        if($now > $exp)
				                            $terminate();
				                    }
				                }catch(Exception $ex){
				                    $terminate();
				                }
				            }else
				                $terminate();
				            
				            break;
				        case TYPE_CCD_SEND:
				        case TYPE_CCD_CONFIRM:
				            if(!$this -> checkNull($this -> currency)){
				                $this -> popUpSessionMessage(ERROR, 'E_INVALID_CURRENCY_VALUE', array());
				                $rtn = false;
				            }else{
				                $currencies = explode(",", $this -> eplconf -> currencies);
				                
				                if(!in_array($this -> currency, $currencies)){
				                    $this -> popUpSessionMessage(ERROR, 'E_INVALID_CURRENCY_VALUE', array());
				                    $rtn = false;
				                }
				            }
				            
				            if(!$this -> checkNull($this -> amount)){
				                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				                $rtn = false;
				            }
				            
				            if(!$rtn){
				                $this -> setType(TYPE_CCD_INPUT);
				                return false;
				            }
				            break;
				    }
				    				    
				    if($this -> getType() == TYPE_CCD_CONFIRM){
				        $this -> fee = round($this -> amount * (VAL_STR_CCDEPOSIT_FEE / 100.00), 3);
				    }
				    
				    if($this -> getType() == TYPE_CCD_SEND) {
				        $this -> fee = round($this -> amount * (VAL_STR_CCDEPOSIT_FEE / 100.00), 3);
				        
				        $eplAPI = EasyPaymentLinkAPI::getInstance()
				                    -> setUserAccount($this -> getUserData(PARAM_USER_ACCOUNT))
            				        -> setLanguage($this -> getLangage())
            				        -> setAmount($this -> amount + $this -> fee)
            				        -> setFee($this -> fee)
            				        -> setCurrency($this -> currency)
            				        -> generatePayload();
				        
				        $eplAPI -> process();
				        
				        // verdict
				        if($eplAPI -> getHttpCode() == "200"){
				            $eplAPI -> redirectToForm();
				        }
				    }
				}


		return true;
	}
	
	/**
	 * 
	 * @param unknown $paramName
	 */
	public function echoCCDTransactionData($paramName){
	    $displayedValue = $this -> getColumnData($this -> ccdTransDetails, $paramName);
	    
	    switch($paramName){
	        case "amount":
	        case "credit_amount":
	        case "fee":
	            $currency = $this -> getColumnData($this -> ccdTransDetails, PARAM_CURRENCY);
	            $curvalue = $this -> intToCurrency($displayedValue, $currency);
	            echo "{$currency} {$curvalue}";
	            break;
	        default:
	            echo $displayedValue;
	            break;
	    }
	}
	
	/**
	 * 
	 * exclusive currency dropdown options
	 * 
	 */
	public function echoEPLCurrencyDropdownOptions(){
	    $currencies = explode(",", $this -> eplconf -> currencies);
	    
	    foreach($currencies as $currency){
	        echo "<option value=\"{$currency}\">{$currency}</option>";
	    }
	}
	
    /*-------------------------------------------------------------------------
     * @function_name:  getBitAdress
     * @parameter    :
     * @return       : string - bitcoin address
    --------------------------------------------------------------------------*/
    public function getBitAdress() {
        //get data from temporary bit table
        $res = $this -> getRowData($this -> accessSelect('SELECT_TEMP_DEPOSIT_BIT', array("transaction_number", $_SESSION['BIT']['transaction_number'])));

        //bit address
        $bitAddress = $this -> getColumnData($res, 'bit_address');

        return $bitAddress;
    }

    /*-------------------------------------------------------------------------
     * @function_name:  displayLocalBankList
     * @parameter    :
     * @return       : string - option tags with each local bank
    --------------------------------------------------------------------------*/
    public function displayLocalBankList() {
        $rtn  = NO_STRING;
        $bank = getLocalBankAllowList();
        $lang = $this->getLanguage();
        foreach ($bank as $key => $value) {
            $rtn .= '<option value=' . $value[2] . '>' . $value[$lang] . '</option>';
        }
        echo $rtn;
    }

    /*-------------------------------------------------------------------------
     * @function_name:  getLanguage
     * @parameter    :
     * @return       : integer based on language
    --------------------------------------------------------------------------*/
    public function getLanguage()
    {

        // 変数宣言部
        $rtn  = array();
        $lang = NO_COUNT;

        // 言語判定
        if (isset($_SERVER["REQUEST_URI"])) {
            $uri        = $_SERVER["REQUEST_URI"];
            $langStrArr = explode(DELIMIT_SLASH, $uri);
            $langStr    = $langStrArr[VAL_INT_1];

            if ($langStr == "ja") {
                $lang = VAL_INT_1;
            } else if ($langStr == "id") {
                $lang = VAL_INT_1;
            } else if ($langStr == "en") {
                $lang = VAL_INT_1;
            } else if ($langStr == "sc") {
                $lang = NO_COUNT;
            } else if ($langStr == "tc") {
                $lang = NO_COUNT;
            }
        }

        return $lang;
    }

    /*-------------------------------------------------------------------------
	* @function_name: setLBTCSessionData
	* @parameter	: array model for lbtc input data
	* @return		:
	-------------------------------------------------------------------------*/
    public function setLBTCSessionData($lbtcArray){
        $_SESSION['transaction_number']       = $lbtcArray['transaction_number'];
        $_SESSION['user_account']             = $lbtcArray['user_account'];
        $_SESSION['amount']                   = $lbtcArray['amount'];
        $_SESSION['currency']                 = $lbtcArray['currency'];
        $_SESSION['method']                   = $lbtcArray['method'];
        $_SESSION['deposit_bank']             = $lbtcArray['deposit_bank'];
        $_SESSION['fee']                      = $lbtcArray['fee'];
        $_SESSION['message']                  = $lbtcArray['message'];
        $_SESSION['comment']                  = $lbtcArray['comment'];
        $_SESSION['create_time']              = $lbtcArray['create_time'];
        $_SESSION['process_user']             = $lbtcArray['process_user'];
        $_SESSION['type']                     = $lbtcArray['type'];
        $_SESSION['err_flg']                  = $lbtcArray['err_flg'];
        $_SESSION['language']                 = $lbtcArray['language'];
    }

    public function setCUPSessionData($cupArray){
        $_SESSION['transaction_number']       = $cupArray['transaction_number'];
        $_SESSION['user_account']             = $cupArray['user_account'];
        $_SESSION['amount']                   = $cupArray['amount'];
        $_SESSION['currency']                 = $cupArray['currency'];
        $_SESSION['method']                   = $cupArray['method'];
        $_SESSION['deposit_bank']             = $cupArray['deposit_bank'];
        $_SESSION['fee']                      = $cupArray['fee'];
        $_SESSION['message']                  = $cupArray['message'];
        $_SESSION['comment']                  = $cupArray['comment'];
        $_SESSION['create_time']              = $cupArray['create_time'];
        $_SESSION['process_user']             = $cupArray['process_user'];
        $_SESSION['type']                     = $cupArray['type'];
        $_SESSION['err_flg']                  = $cupArray['err_flg'];
        $_SESSION['language']                 = $cupArray['language'];
    }

    /*-------------------------------------------------------------------------
    * @function_name: unsetTemporaryDepositSessionData
    * @para
    * @return		:
    -------------------------------------------------------------------------*/
    public function unsetTemporaryDepositSessionData(){
        unset($_SESSION['transaction_number']);
        unset($_SESSION['user_account']);
        unset($_SESSION['amount']);
        unset($_SESSION['currency']);
        unset($_SESSION['method']);
        unset($_SESSION['deposit_bank']);
        unset($_SESSION['fee']);
        unset($_SESSION['message']);
        unset($_SESSION['comment']);
        unset($_SESSION['create_time']);
        unset($_SESSION['process_user']);
        unset($_SESSION['type']);
        unset($_SESSION['err_flg']);
        unset($_SESSION['language']);
    }

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の計算
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function calculate() {

		// 変数宣言部
		$parcent	= NO_COUNT;
		$fix		= NO_COUNT;

		if($this -> method		== 'VISA'
			|| $this -> method	== 'GIFTCARD') {				// VISA、MASTERの場合

			$parcent	= 1.055;
			$fix		= 50;

			$this -> payment = intval(($this -> amount * $parcent) + $fix);

		} else if($this -> method == ''){

		} else if($this -> method == 'INSTANTBANKTRANSFER') {	// 銀行送金の場合

			$parcent	= 1.06;
			$fix		= 600;

			$this -> payment = ($this -> amount * $parcent) + $fix;

			// この場合はオリジナルレートで計算する
			$oRate = $this -> getRowData($this -> accessSelect('SELECT_ORIGINAL_RATE', array(EUR, JPY)));

			// オリジナルレート * 2%（最後に桁落とし）
			$this -> payment = $this -> intToCurrency(($this -> payment * $this -> getColumnData($oRate, COLUMN_ORIGINAL_RATE)) * 1.02, VAR_GPAYSAFE_CARD_CURRENCY);

			// 桁丸め
			$this -> payment = floor($this -> payment) + VAL_INT_1;
		} else {
			$this -> payment = $this -> amount;
		}
	}

    function newTag($methods){
		$newMethods = array('BIT','H2P','CPS','JPV', 'UNIONPAY');
        if(in_array($methods,$newMethods)){
           $class = "class='newtag'";
        }else{
            $class = NO_STRING;
        }
        return $class;
    }

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザデータの取得
	 * @parameter	: 取得パラメータ
	 * @return		: ユーザデータ
	 -------------------------------------------------------------------------*/
	public function getFloat3() {
		$accountNumber = $this -> getUserData(PARAM_USER_ACCOUNT);
		$GateWay = str_replace('{uid}', $accountNumber, VAL_STR_FLAT3_GATEWAY);
		$JsonResult = file_get_contents($GateWay);
		$JsonResult = str_replace('(', '', $JsonResult);
		$JsonResult = str_replace(')', '', $JsonResult);
		$result = json_decode($JsonResult,true);
		return $result;
	}

	public function getLocalBankFlat3() {
		$accountNumber = $this -> getUserData(PARAM_USER_ACCOUNT);
		$GateWay = str_replace('{uid}', $accountNumber, VAL_STR_LBTF3_GATEWAY);
		$JsonResult = file_get_contents($GateWay);
		$JsonResult = str_replace('(', '', $JsonResult);
		$JsonResult = str_replace(')', '', $JsonResult);
		$result = json_decode($JsonResult,true);
		return $result;
	}

	public function getJapanVoucherFlat3() {
		$accountNumber = $this -> getUserData(PARAM_USER_ACCOUNT);
		$GateWay = str_replace('{uid}', $accountNumber, VAL_STR_JPV_GATEWAY);
		$JsonResult = file_get_contents($GateWay);
		$JsonResult = str_replace('(', '', $JsonResult);
		$JsonResult = str_replace(')', '', $JsonResult);
		$result = json_decode($JsonResult,true);
		return $result;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: なし
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	public function echoFee() {
		echo $this -> formatCurrency($this -> fee, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 入金メソッド
	-------------------------------------------------------------------------*/
	public function getMethod() {
		return $this -> method;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 入金メソッド
	-------------------------------------------------------------------------*/
	public function echoMethod() {
		echo $this -> method;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザデータの取得
	 * @parameter	: 取得パラメータ
	 * @return		: ユーザデータ
	 -------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	public function echoCurrency() {
		echo $this -> currency;
	}
	/*-------------------------------------------------------------------------
	 * @function_name: 取引時間の取得
	 * @parameter	: なし
	 * @return		: 取引時間
	 -------------------------------------------------------------------------*/
	public function echoDepositAmountNatural() {
		echo $this -> formatCurrency(($this -> amount + $this -> fee), $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理時間の取得
	* @parameter	: なし
	* @return		: 処理時間
	-------------------------------------------------------------------------*/
	public function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引時間の取得
	 * @parameter	: なし
	 * @return		: 取引時間
	 -------------------------------------------------------------------------*/
	public function echoAmountString() {
		echo $this -> getAmountString($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: echoAmountPure
	 * @parameter	: なし
	 * @return		:
	 -------------------------------------------------------------------------*/
	public function echoAmountPure() {
	    echo $this -> amount;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 取引時間の取得
	 * @parameter	: なし
	 * @return		: 取引時間
	 -------------------------------------------------------------------------*/
	public function returnDepositAmountNatural() {
		$DepositAmount = $this -> amount + $this -> fee;
		return $this -> getAmountString($DepositAmount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引番号の取得
	 * @parameter	: なし
	 * @return		: 取引番号
	 -------------------------------------------------------------------------*/
	public function echoTransactionNumber() {
		echo $this -> transationNumber;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金データの設定
	 * @parameter	: 入金データ
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setDeposit($deposit) {
		$this -> deposit 	= $deposit;
		$CommentResult = array();
		$Comment = $this -> getColumnData($this -> deposit, COLUMN_COMMENT);

		if(!empty($Comment)){
			$CommentResult = json_decode($Comment,true);
		}
		if($this -> getType() == CASHFLOW_DEPOSIT_SUCCESS ||
			$this -> getType() == TYPE_ZANETAPAY_DEPOSIT_SUCCESS
		){

			if(isset($CommentResult['payload'])){
				@$this -> currency   = $CommentResult['payload']['currency'];
				if($this -> currency == 'JPY'){
					@$this -> payamount  = $CommentResult['payload']['amount'];
				}else{
					@$this -> payamount  = $CommentResult['payload']['amount']*100;
				}
			}else{
				@$this -> currency   = $CommentResult['currency'];
				if($this -> currency == 'JPY'){
					@$this -> payamount  = $CommentResult['amount'];
				}else{
					@$this -> payamount  = $CommentResult['amount']*100;
				}
			}
			$this -> amount		= $this -> getColumnData($this -> deposit, COLUMN_AMOUNT);
			$this -> fee		= $this -> payamount - $this -> amount;
		}else{
			$this -> amount		= $this -> getColumnData($this -> deposit, COLUMN_AMOUNT);
			$this -> fee		= $this -> getColumnData($this -> deposit, COLUMN_FEE);
		}

		$this -> createTime	= $this -> getColumnData($this -> deposit, COLUMN_CREATE_TIME_STRING);
		$this -> currency 	= $this -> getColumnData($this -> deposit, COLUMN_CURRENCY);
		$this -> isSendMail	= $this -> getColumnData($this -> deposit, 'isSendMail');
		$this -> setFeeEx($this -> fee);
	}

	// public function setCupFailDeposit($deposit) {
    //
	// }

	/*-------------------------------------------------------------------------
	 * @function_name: 入金成功時のメール送信パラメータ
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	private function getSendCashFlowSuccessData() {
		// 変数宣言部
		$rtn		= array();
		$account	= $this -> getColumnData($this -> deposit, COLUMN_USER_ACCOUNT);

		// パラメータの設定
		$rtn[]	= $account;															// 口座番号（1）
		$rtn[]	= $this -> getNameCommon($account);									// 氏名（2）
		$rtn[]	= $this -> transationNumber;										// 取引番号（3）
		$rtn[]	= $this -> createTime;												// 取引時刻（4）
		$rtn[]	= $this -> currency;																// 決済通貨（5）
		$rtn[]	= $this -> getAmountString($this -> amount, $this -> currency);					// 決済金額（6）
		$rtn[]	= $this -> currency;																// 反映通貨（7）
		$rtn[]	= $this -> getAmountString(($this -> amount + $this -> fee), $this -> currency);	// 反映金額（8）


		return $rtn;
	}


	/*-------------------------------------------------------------------------
	 * @function_name: 入金失败時のメール送信パラメータ
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	function getSendCashFlowFailData() {
		// 変数宣言部
		$rtn		= array();
		$rtn[]	= $this -> getUserData(PARAM_USER_ACCOUNT);							// 口座番号
		$rtn[]	= $this -> getNameCommon($this -> getUserData(PARAM_USER_ACCOUNT));	// 氏名
		return $rtn;
	}


	private function sendCashFlowSuccessMail(){
		$params = '';
		// 変数宣言部
		$params = $this -> getSendCashFlowSuccessData();
		// メールを送信（ユーザ）
		$this -> sendMailByTmp('cashflow_deposit_info.xml'
								, $params
								, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	private function sendCashFlowFailMail(){
		$params = '';
		// 変数宣言部
		$params = $this -> getSendCashFlowFailData();
		// メールを送信（ユーザ）
		$this -> sendMailByTmp('cashflow_deposit_failure.xml'
								, $params
								, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 入金メソッド
	-------------------------------------------------------------------------*/
	public function echoMethodString() {
		if($this -> method == 'GIFTCARD') {
			echo 'MASTERCARD';
		} else {
			echo $this -> method;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispMethod() {
		$result = '';
		$result = $this -> getDepositMethodListCommon();
		return $result;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function echoAccount() {
		echo $this -> getUserData(PARAM_USER_ACCOUNT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function dispAmount() {
		echo $this -> getAmountString($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 決済金額
	-------------------------------------------------------------------------*/
	public function dispPayment() {
		echo $this -> getAmountString($this -> payment, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> formatCurrency($this -> amount, $this -> currency);
		//echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 決済金額
	-------------------------------------------------------------------------*/
	public function echoPayment() {
		echo $this -> payment;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispAmountList() {

		// 変数宣言部
		$list = array();

// 		$list[] = array(PARAM_DATA_KEY		=> '100'
// 						, PARAM_DATA_VALUE	=> '€1');
		$list[] = array(PARAM_DATA_KEY		=> '500'
						, PARAM_DATA_VALUE	=> '€5');
		$list[] = array(PARAM_DATA_KEY		=> '2000'
						, PARAM_DATA_VALUE	=> '€20');
		$list[] = array(PARAM_DATA_KEY		=> '5000'
						, PARAM_DATA_VALUE	=> '€50');
		$list[] = array(PARAM_DATA_KEY		=> '10000'
						, PARAM_DATA_VALUE	=> '€100');
		$list[] = array(PARAM_DATA_KEY		=> '30000'
						, PARAM_DATA_VALUE	=> '€300');

		echo $this -> dispListOption($list, $this -> amount);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispTransferAmountList() {

		// 変数宣言部
		$list = array();

// 		$list[] = array(PARAM_DATA_KEY		=> '100'
// 						, PARAM_DATA_VALUE	=> '€1');
		$list[] = array(PARAM_DATA_KEY		=> '500'
						, PARAM_DATA_VALUE	=> '€5');
		$list[] = array(PARAM_DATA_KEY		=> '5000'
						, PARAM_DATA_VALUE	=> '€50');
		$list[] = array(PARAM_DATA_KEY		=> '10000'
						, PARAM_DATA_VALUE	=> '€100');
		$list[] = array(PARAM_DATA_KEY		=> '30000'
						, PARAM_DATA_VALUE	=> '€300');

		echo $this -> dispListOption($list, $this -> tAmount);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: なし
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	public function echoName() {
		echo $this -> getUserData(PARAM_NAME);
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	public function getAccountType() {
		return $this -> accountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function getLastName() {
		return $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function getFirstName() {
		return $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function getEMail() {
		return $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function getPassword() {
		return $this -> password;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワード（再入力）の取得
	* @parameter	: なし
	* @return		: パスワード（再入力）
	-------------------------------------------------------------------------*/
	public function getPasswordConfirm() {
		return $this -> passwordConfirm;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）の取得
	* @parameter	: なし
	* @return		: 生年月日（年）
	-------------------------------------------------------------------------*/
	public function getBirthYear() {
		return $this -> birthYear;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）の取得
	* @parameter	: なし
	* @return		: 生年月日（月）
	-------------------------------------------------------------------------*/
	public function getBirthMonth() {
		return $this -> birthMonth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）の取得
	* @parameter	: なし
	* @return		: 生年月日（日）
	-------------------------------------------------------------------------*/
	public function getBirthDay() {
		return $this -> birthDay;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function getCountry() {
		return $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の取得
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	public function getState() {
		return $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市の取得
	* @parameter	: なし
	* @return		: 市
	-------------------------------------------------------------------------*/
	public function getCity() {
		return $this -> city;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function getZipCode() {
		return $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地の取得
	* @parameter	: なし
	* @return		: 番地
	-------------------------------------------------------------------------*/
	public function getAddress() {
		return $this -> address;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function getTel() {
		return $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
 	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoEMail() {
		echo $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 確認用口座種別の取得
	* @parameter	: なし
	* @return		: 確認用口座種別
	-------------------------------------------------------------------------*/
	public function dispAccountType() {

		if($this -> getAccountType() == VAL_INT_1) {
			return VAL_STR_PERSONAL;
		} else if($this -> getAccountType() == VAL_INT_2) {
			return VAL_STR_CORPORATE;
		} else {
			return VAL_STR_PERSONAL;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示用口座種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoAccountType() {
		echo $this -> dispAccountTypeList($this -> getAccountType());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function echoUserData($param) {
		echo $this -> getColumnData($this -> account, $param);
	}

	public function CallUserData($param) {
		return $this -> getColumnData($this -> account, $param);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function echoCountryName() {
		echo $this -> dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));
	}
	public function echoCountryNameH2P() {
		//echo $this -> dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));

		$countryName = $this -> dispCountryCommon($this -> CallUserData(PARAM_COUNTRY));

		$bypassValue = ($this -> getUserBypassValue(PARAM_DEPOSIT,VAL_STR_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT))));

		if(($countryName != 'Indonesia' && $countryName != 'Vietnam' && $countryName != 'Thailand' && $countryName != 'Malaysia') || $bypassValue){
			$countryList =  array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam');
			$selected = NO_STRING;
			$rtn = NO_STRING;

			if(in_array($this -> country,$countryList,TRUE)){
				foreach ($countryList as $value) {
					if($this -> country === $value){
						$selected = 'selected';
					}else{
						$selected = NO_STRING;
					}
					$currencyCountry = ($value=='Indonesia'? 'IDR':($value=='Malaysia'? 'MYR' : ( $value=='Thailand'? 'THB' : ( $value=='Vietnam'? 'VND' : (NO_STRING)))));
					$rtn .= '<option value='.$value.' currency='.$currencyCountry.' '.$selected.'>'.$value.'</option>';
				}

			}else{
				if($this ->  getLangage() == 'en'){
					$rtn .= '<option name="select" id="select" value="select" class="px100" disabled selected="selected">Select</option>';
				}elseif($this ->  getLangage() == 'id'){
					$rtn .= '<option name="select" id="select" value="select" class="px100" disabled selected="selected">Pilih</option>';
				}
				foreach ($countryList as $value) {

					$currencyCountry = ($value=='Indonesia'? 'IDR':($value=='Malaysia'? 'MYR' : ( $value=='Thailand'? 'THB' : ( $value=='Vietnam'? 'VND' : (NO_STRING)))));
					$rtn .= '<option value='.$value.' currency='.$currencyCountry.' '.$selected.'>'.$value.'</option>';
				}
			}


			echo "<select name='country' id='country' class='px100'>".$rtn."</select>";
		}else{
			echo $this -> dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));
		}
	}
	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function dispCurrency() {
		echo $this -> currency;
	}
	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function dispH2PCurrency() {
		$countryList =  array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam');
		$currencyList =  array('IDR', 'MYR', 'THB', 'VND');

		if(in_array($this -> currency,$currencyList,TRUE)){
			echo "<p id='currency' name='currency'>".$this -> currency."</p><input type='hidden' id='currencyval' value=".$this -> currency." name='currency'>";
		}else if(in_array($this -> country,$countryList,TRUE)){
			$currencyCountry = ($this -> country==='Indonesia'? 'IDR':($this -> country==='Malaysia'? 'MYR' : ( $this -> country==='Thailand'? 'THB' : ( $this -> country==='Vietnam'? 'VND' : (NO_STRING)))));
			echo "<p id='currency' name='currency'>".$currencyCountry."</p><input type='hidden' id='currencyval' value=".$currencyCountry." name='currency'>";
		}else{
			if($this ->  getLangage() == 'en'){
				echo "<p id='currency' name='currency'><i>Please select a country</i></p><input type='hidden' id='currencyval' value='' name='currency'>";
			}elseif($this ->  getLangage() == 'id'){
				echo "<p id='currency' name='currency'><i>Silakan pilih negara </i></p><input type='hidden' id='currencyval' value='' name='currency'>";
			}
		}

	}

	public function getH2PCurrency() {
		$countryList =  array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam');
		$currencyList =  array('IDR', 'MYR', 'THB', 'VND');

		if(in_array($this -> currency,$currencyList,TRUE)){
			echo $this -> currency;
		}else if(in_array($this -> country,$countryList,TRUE)){
			$currencyCountry = ($this -> country==='Indonesia'? 'IDR':($this -> country==='Malaysia'? 'MYR' : ( $this -> country==='Thailand'? 'THB' : ( $this -> country==='Vietnam'? 'VND' : (NO_STRING)))));
			echo $currencyCountry;
		}

	}

	public function dispH2PAmount() {
		if(isset($this -> country)||($this -> country!=NO_STRING)){
			$currencyCountry = ($this -> country=='Indonesia'? 'IDR':($this -> country=='Malaysia'? 'MYR' : ( $this -> country=='Thailand'? 'THB' : ( $this -> country=='Vietnam'? 'VND' : (NO_STRING)))));
			//if-else echo based on currency
				if($currencyCountry == "VND") {
					 echo " <li onClick='clicknum(li01)' id='li01'>300,000</li>
					 		<li onClick='clicknum(li02)' id='li02'>1,000,000</li>
							<li onClick='clicknum(li03)' id='li03'>10,000,000</li>";
					  if($this-> getExecutiveStatus() == true) {
						  echo" <li onClick='clicknum(li04)' id='li04'>100,000,000</li>
						  		<li onClick='clicknum(li05)' class='selected' id='li05'>290,000,000</li>";
					  } else {
						  echo "<li onClick='clicknum(li05)' class='selected' id='li05'>100,000,000</li>";
					  }

				} else if($currencyCountry == "THB") {
					echo "<li onClick='clicknum(li01)' id='li01'>500</li>
						  <li onClick='clicknum(li02)' id='li02'>1,000</li>
						  <li onClick='clicknum(li03)' id='li03'>10,000</li>";

					if($this-> getExecutiveStatus() == true) {
						  echo "<li onClick='clicknum(li04)' id='li04'>300,000</li>
						  		<li onClick='clicknum(li05)' class='selected' id='li05'>480,000</li>";
					} else {
						  echo "<li onClick='clicknum(li05)' class='selected' id='li05'>300,000</li>";
					}

				 } else if($currencyCountry == "MYR") {
					 echo "<li onClick='clicknum(li01)' id='li01'>50</li>
					 	   <li onClick='clicknum(li02)' id='li02'>1,000</li>
					 	   <li onClick='clicknum(li03)' id='li03'>10,000</li>";

					 if($this-> getExecutiveStatus() == true) {
						 echo "<li onClick='clicknum(li04)' id='li04'>30,000</li>
						 	   <li onClick='clicknum(li05)' class='selected' id='li05'>48,000</li>";

					 } else {
						echo "<li onClick='clicknum(li05)' class='selected' id='li05'>30,000</li>";
					 }

				 } else if($currencyCountry == "IDR") {
					 echo "<li onClick='clicknum(li01)' id='li01'>200,000</li>
						   <li onClick='clicknum(li02)' id='li02'>1,000,000</li>
						   <li onClick='clicknum(li03)' id='li03'>10,000,000</li>";

					 if($this-> getExecutiveStatus() == true) {
						echo"<li onClick='clicknum(li04)' id='li04'>100,000,000</li>
						  	 <li onClick='clicknum(li05)' class='selected' id='li05'>190,000,000</li>";
					 } else {
						echo"<li onClick='clicknum(li05)' class='selected' id='li05'>100,000,000</li>";
					 }

				 } else {
					 echo "<li onClick='clicknum(li01)' id='li01'>200,000</li>
						   <li onClick='clicknum(li02)' id='li02'>1,000,000</li>
						   <li onClick='clicknum(li03)' id='li03'>10,000,000</li>";

					 if($this-> getExecutiveStatus() == true) {
						echo"<li onClick='clicknum(li04)' id='li04'>100,000,000</li>
							 <li onClick='clicknum(li05)' class='selected' id='li05'>190,000,000</li>";
					 } else {
						echo"<li onClick='clicknum(li05)' class='selected' id='li05'>100,000,000</li>";
					 }

				 }

				 if($this -> getLangage() == 'id'){
					 echo "<li onClick='clickothers()'>Lainnya</li>";
				 }else{
					 echo "<li onClick='clickothers()'>others</li>";
				 }

		}else{
			//echo "<div id='amount_option'>";
			echo "<li onClick='clicknum(li01)' id='li01'>200,000</li>
				  <li onClick='clicknum(li02)' id='li02'>1,000,000</li>
				  <li onClick='clicknum(li03)' id='li03'>10,000,000</li>";

			if($this-> getExecutiveStatus() == true) {
			   echo"<li onClick='clicknum(li04)' id='li04'>100,000,000</li>
					<li onClick='clicknum(li05)' class='selected' id='li05'>190,000,000</li>";
			} else {
			   echo"<li onClick='clicknum(li05)' class='selected' id='li05'>100,000,000</li>";
			}

			echo "<li onClick='clickothers()'>others</li>";
		}

	}
	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function echoResultMessage() {

		if($this -> getType() == TYPE_SUCCESS) {	// 成功
			echo $this -> getMessage(INFO, 'I_DEPOSIT_COMPLETE_GPS', array());
		} else {									// 失敗
			echo $this -> getMessage(ERROR, 'E_DEPOSIT_ERROR_GPS', array());
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: 請求名称の取得
	* @parameter	: なし
	* @return		: 請求名称
	-------------------------------------------------------------------------*/
	public function echoInvoiceName() {
		echo $this -> getValueByList($this -> getDepositInvoiceNameListCommon(), $this -> method);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 回数制限の取得
	* @parameter	: なし
	* @return		: 回数制限
	-------------------------------------------------------------------------*/
	public function echoDailyCountLimit() {
		echo $this -> getGPSCountLimit($this -> method, $this -> getColumnData($this -> account, COLUMN_GPS_ACCOUNT_FLG));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額制限の取得
	* @parameter	: なし
	* @return		: 金額制限
	-------------------------------------------------------------------------*/
	public function echoAmountLimit() {
		echo number_format($this -> getGPSAmountLimit($this -> method, $this -> getColumnData($this -> account, COLUMN_GPS_ACCOUNT_FLG)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額制限の期間の取得
	* @parameter	: なし
	* @return		: 金額制限の期間
	-------------------------------------------------------------------------*/
	public function echoBetweenDate() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> method == PARAM_GPS_VISA) {								// VISAの場合
			$rtn = VAL_INT_30;

		} else if($this -> method == PARAM_GPS_GIFTCARD) {					// MASTERCARDの場合
			$rtn = VAL_INT_30;

		} else if($this -> method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金の場合
			$rtn = VAL_INT_15;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果再確認のURL
	* @parameter	: なし
	* @return		: 結果再確認のURL
	-------------------------------------------------------------------------*/
	public function echoReconfirmUrl() {
		echo 'https://test.api.iwl.world/Complete_Gpaysafe?rn=' . $this -> referenceNo;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 結果再確認のURL
	 * @parameter	: なし
	 * @return		: 結果再確認のURL
	 -------------------------------------------------------------------------*/
	public function getRefarenceNo() {
		return $this -> referenceNo;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: getFile
	 * @parameter	:
	 * @return		: get uploaded file
	 -------------------------------------------------------------------------*/
	public function getFile() {
		return $this -> file;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: getLBTJEmailParams
	 * @parameter	:
	 * @return		: array containing email parameters
	 -------------------------------------------------------------------------*/
	public function getLBTJEmailParams() {
		$file = $this -> file;

		$params = array();

		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);
		$params[] = $this -> getUserData(PARAM_MAIL);
		$params[] = $this -> getUserData(PARAM_NAME);
		$params[] = ($file != null) ? $file['name'] : '';

		return $params;
	}

	//检查必要信息是否已经填写
	private function checkUserProfile(){
		$rtn = True;
		//查看必要用户信息是否已填写，没有通知先完善用户信息
		$ZipCode 	= $this -> CallUserData(PARAM_ZIP_CODE);
		$Address 	= $this -> CallUserData(PARAM_ADDRESS);
		$City 		= $this -> CallUserData(PARAM_CITY);
		$Phone 		= $this -> CallUserData(PARAM_TEL);

		if(empty($ZipCode) ||
			empty($Address) ||
			empty($City ) ||
			empty($Phone)
		){
			$rtn = False;
			return $rtn;
		}
		return $rtn;
	}

    /*-------------------------------------------------------------------------
	* @function_name: echoTransactionTime
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoTransactionTime() {
		echo $this -> transaction_time;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: echoValidCalculation
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
	public function echoValidCalculation(){
	    echo $this -> validCalculation;   
	}
	
	private function CheckPaymentKind(){
		$gpsPayments = $this -> getColumnData($this -> account, COLUMN_GPS_KIND_OF_PAYMENT);	// GPS決済種別
		$list	= $this -> makeArrayByPowerCommon($gpsPayments);
		return $list;
	}

    /*-------------------------------------------------------------------------
	 * @function_name: setDepositInputSession
	 * @parameter	: $depositMethod - deposit method used
	 * @return		: array session
	 -------------------------------------------------------------------------*/
    private function setDepositInputSession($depositMethod){
        $_SESSION[$depositMethod] = array();

        $_SESSION[$depositMethod]['Country'] 	= $this -> getColumnData($this -> account,PARAM_COUNTRY);
        $_SESSION[$depositMethod]['firstName'] 	= $this -> getColumnData($this -> account,PARAM_LAST_NAME);
        $_SESSION[$depositMethod]['lastName'] 	= $this -> getColumnData($this -> account,PARAM_FIRST_NAME);
        $_SESSION[$depositMethod]['birthday'] 	= $this -> getColumnData($this -> account,PARAM_BIRTH);
        $_SESSION[$depositMethod]['mail'] 		= $this -> getColumnData($this -> account,PARAM_MAIL);
        $_SESSION[$depositMethod]['state'] 		= $this -> getColumnData($this -> account,PARAM_STATE);
        $_SESSION[$depositMethod]['city'] 		= $this -> getColumnData($this -> account,PARAM_CITY);
        $_SESSION[$depositMethod]['address'] 	= $this -> getColumnData($this -> account,PARAM_ADDRESS);
        $_SESSION[$depositMethod]['zip'] 		= $this -> getColumnData($this -> account,PARAM_ZIP_CODE);
        $_SESSION[$depositMethod]['tel'] 		= $this -> getColumnData($this -> account,PARAM_TEL);
        $_SESSION[$depositMethod]['amount'] 	= number_format($this -> amount, 2, '', '');
        $_SESSION[$depositMethod]['currency'] 	= $this -> currency;
        $_SESSION[$depositMethod]['Actual'] 	= $this -> amount + $this -> fee;
        $_SESSION[$depositMethod]['fee'] 		= number_format($this -> fee, 2, '', '');
        $_SESSION[$depositMethod]['message'] 	= $this -> message;
        $_SESSION[$depositMethod]['lang']		= $this -> getLangage();

        return $_SESSION[$depositMethod];
    }

    /*-------------------------------------------------------------------------
	 * @function_name: setClearsettleSuccessDetails
	 * @parameter	: $transaction_number - transaction number of the deposit
	 * @return		:
	 -------------------------------------------------------------------------*/
    private function setClearsettleSuccessDetails($transaction_number){
        $row = $this -> getRowData($this -> accessSelect('SELECT_TEMP_DEPOSIT_CLEARSETTLE', array("transaction_number", $transaction_number)));
        $this -> transationNumber = $transaction_number;
        $this -> transaction_time = '';
        $this -> amount = '';
        $this -> fee = '';
        if(count($row) > 0){
            $currency                 = $this -> getColumnData($row, 'currency');
            $this -> transaction_time = $this -> getColumnData($row, 'deposit_date');
            $this -> amount           = $this -> getAmountString($this -> getColumnData($row, 'amount'), $currency);
            $this -> fee              = $this -> getAmountString($this -> getColumnData($row, 'fee'), $currency);
        }
    }

    /// HELP2PAY
    public function GetRedirectURLHelp2Pay() {
    	 $language		= $this -> getLangage();
    	 $redirectURL = SITE_PROTOCOL."://". SITE_DOMAIN_FULL . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . "deposit?type=h2p_status";
    	 //echo this-> $redirectURL;
    	 // $redirectURL = "http://localhost/en/deposit?type=h2p_status";
    	 echo $redirectURL;
    }
    
    public function GetSendInformationH2P($Type) {
    	if($Type == "Merchant") {
    	    echo $this -> h2pMerchantID;
    	} else if($Type == "Currency") {
    		echo $this-> currency;
    	} else if($Type == "Customer") {
    		echo $this-> userAccount;
    	} else if($Type == "Reference") {
    		echo $this-> referenceNo;
    	} else if($Type == "Key") {
    		echo $this-> customer_key;
    	} else if($Type == "Amount") {
    		echo $this-> customer_amount;
    	} else if($Type == "Note") {
    		echo $this-> customer_note;
    	} else if($Type == "DateTime") {
    		echo $this-> customer_date;
    	} else if($Type == "BackURI") {
    		echo $this-> h2pCallbackURL;
    	} else if($Type == "language") {
    		echo $this-> customer_language;
    	} else if($Type == "bank") {
    		echo $this-> bank;
    	} else if($Type == "ClientIP") {
    		echo $this-> ipAddress;
    	} else if($Type == "CustomerData") {
    		echo $this-> customer_data;
    	} else if($Type == "H2PURL") {
    	    echo $this -> h2pTransferUrl;
    	}
    }
		
	public function displayLocalBankListPerCurrency() {
		$currency = $this -> currency;
		$selected = NO_STRING;

		if(isset($this -> country) || $this -> country!= NO_STRING){
			$currency = ($this -> country==='Indonesia'? 'IDR':($this -> country==='Malaysia'? 'MYR' : ( $this -> country==='Thailand'? 'THB' : ( $this -> country==='Vietnam'? 'VND' : (NO_STRING)))));
		}
        $rtn  = NO_STRING;
        $bank = getLocalBankPerCurrency();
        $lang = $this->getLanguage();
        foreach ($bank as $key => $value) {
				if(isset($this -> bank)){
					if($this -> bank === $value[2]){
						$selected = 'selected';
					}else{
						$selected = NO_STRING;
					}
				}
					  if($currency == $value[3]) {
							$rtn .= '<option value="' . $value[2] .'"'. $selected.'>' . $value[1] . '</option>';
						}
        }
        echo $rtn;
    }

	public function getBank() {
		return $this -> bank;
	}

	public function getFee() {
		return $this -> fee;
	}
	public function getExecutiveStatus() {
		return $this -> isExecutive;
	}

	public function getBankName() {
		$bankID = $this -> bank;
		$bank = getLocalBankPerCurrency();
		foreach ($bank as $key => $value) {
				if($bankID == $value[2]) {
					return $value[1];
				}
		}
	}

	public function ValidateBankCurrency() {
		$bankID = $this -> bank;
		$currencyID = $this -> currency;
		$bank = getLocalBankPerCurrency();
		foreach ($bank as $key => $value) {
				if($bankID == $value[2] && $currencyID == $value[3]) {
						return 1;
				}
		}
		return 0;
	}

    private function getSendHelp2PaySuccessData() {
    	// 変数宣言部
    	$rtn		= array();
    	$account	= $this -> getColumnData($this -> deposit, COLUMN_USER_ACCOUNT);
    
    	// パラメータの設定
    	$rtn[]	= $account;															// 口座番号（1）
    	$rtn[]	= $this -> getNameCommon($account);									// 氏名（2）
    	$rtn[]	= $this -> transationNumber;										// 取引番号（3）
    	$rtn[]	= $this -> createTime;												// 取引時刻（4）
    	$rtn[]	= $this -> currency;																// 決済通貨（5）
    	$rtn[]	= $this -> getAmountString($this -> amount, $this -> currency);					// 決済金額（6）
    	$rtn[]	= $this -> currency;																// 反映通貨（7）
    	$rtn[]	= $this -> getAmountString(($this -> amount + $this -> fee), $this -> currency);	// 反映金額（8）
    	$rtn[]  = $this -> CallUserData(PARAM_COUNTRY);
    
    	return $rtn;
    }

    private function sendHelp2PaySuccessMail(){
    	$params = '';
    	// 変数宣言部
    	$params = $this -> getSendHelp2PaySuccessData();
    	// メールを送信（ユーザ）
    	$this -> sendMailByTmp('help2pay_deposit_info.xml'
    							, $params
    							, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
    							, VAR_CS_MAIL_ADDRESS
    							, $this -> getLangage());
    }
    
    private function getSendHelp2PayFailData() {
    		// 変数宣言部
    	$rtn		= array();
    	$rtn[]	= $this -> getUserData(PARAM_USER_ACCOUNT);							// 口座番号
    	$rtn[]	= $this -> getNameCommon($this -> getUserData(PARAM_USER_ACCOUNT));	// 氏名
    	return $rtn;
    }
    
    private function sendHelp2PayFailMail(){
    	$params = '';
    	// 変数宣言部
    	$params = $this -> getSendHelp2PayFailData();
    	// メールを送信（ユーザ）
    	$this -> sendMailByTmp('help2pay_deposit_info_fail.xml'
    							, $params
    							, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
    							, VAR_CS_MAIL_ADDRESS
    							, $this -> getLangage());
    }

    private function sendZanetapaySuccessMail(){
        $params = '';
        // 変数宣言部
        $params = $this -> getSendZanetapaySuccessData();
        // メールを送信（ユーザ）
        $this -> sendMailByTmp('zanetapay_success_mail.xml'
                                , $params
                                , $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
                                , VAR_CS_MAIL_ADDRESS
                                , $this -> getLangage());
    }

    private function getSendZanetapaySuccessData() {
        // 変数宣言部
        $rtn        = array();
        $account    = $this -> getColumnData($this -> deposit, COLUMN_USER_ACCOUNT);

        // パラメータの設定
        $rtn[]  = $account;                                                         // 口座番号（1）
        $rtn[]  = $this -> getNameCommon($account);                                 // 氏名（2）
        $rtn[]  = $this -> transationNumber;                                        // 取引番号（3）
        $rtn[]  = $this -> createTime;                                              // 取引時刻（4）
        $rtn[]  = $this -> currency;                                                                // 決済通貨（5）
        $rtn[]  = $this -> getAmountString($this -> amount, $this -> currency);                 // 決済金額（6）
        $rtn[]  = $this -> currency;                                                                // 反映通貨（7）
        $rtn[]  = $this -> getAmountString(($this -> amount + $this -> fee), $this -> currency);    // 反映金額（8）


        return $rtn;
    }

    private function sendZanetapayFailMail(){
        $params = '';
        // 変数宣言部
        $params = $this -> getSendZanetapayFailData();
        // メールを送信（ユーザ）
        $this -> sendMailByTmp('zanetapay_fail_mail.xml'
                                , $params
                                , $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
                                , VAR_CS_MAIL_ADDRESS
                                , $this -> getLangage());
    }

    function getSendZanetapayFailData() {
        // 変数宣言部
        $rtn        = array();
        $rtn[]  = $this -> getUserData(PARAM_USER_ACCOUNT);                         // 口座番号
        $rtn[]  = $this -> getNameCommon($this -> getUserData(PARAM_USER_ACCOUNT)); // 氏名
        return $rtn;
    }

	//class End

}
?>
