<?php
include_once $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'config.php';

class BitAPI {
    private $key            = BIT_KEY;



    /*-------------------------------------------------------------------------
     * @function_name: generateRequestData
     * "@description : generates the request data
     * @parameter    : $currency
     * @return       : JSON string - data
    -------------------------------------------------------------------------*/
    public function generateRequestData(){
        $data = 'currency_code=BTC';

        return $data;
    }

    /*-------------------------------------------------------------------------
     * @function_name: createChannel
     * "@description : creates channel and generates bitcoin address
     * @parameter    : $nonce, $signature, $data
     * @return       : array response data ; bool - false (if creation is successful, returns response data else returns false)
    -------------------------------------------------------------------------*/
    public function createWalletAddress($data){

		$http_header = array(
            'Content-Type: application/x-www-form-urlencoded',
            'X-Api-Key: '.$this -> key,
            'Content-Length: '.strlen($data)
        );

        //set curl parameters
        $ch = curl_init('https://api.atmoszero.com/crypto/create-wallet-address'); //请求的URL地址
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);//$data JSON类型字符串
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        //execute curl command
        $responseData = curl_exec($ch);

        //check if curl failed
        if(curl_errno($ch)) {
            return false;
	    }
        curl_close($ch);

        $responseData = json_decode($responseData,true);

        if(count($responseData) > 0) {
            return $responseData;
        } else {
            return false;
        }
    }

    /*-------------------------------------------------------------------------
     * @function_name: insertCubitsTemporary
     * "@description : inserts data into cubits database
     * @parameter    : $array - array containing the values to be inserted
     * @return       :
    -------------------------------------------------------------------------*/
    public function insertBitTemporary($array){
        //instantiate system class to be able to call functions from library
        $system = new System();

        //insert to database
        $system -> accessModifyCommon('INSERT_TEMP_DEPOSIT_BIT', $array);
    }

    /*-------------------------------------------------------------------------
     * @function_name: verifyCallbackSignature
     * "@description : verifies signature recieved in callback
     * @parameter    : $signature - signature from post request to callback
     * @return       : bool (true if verified else false)
    -------------------------------------------------------------------------*/
	public function verifyCallbackToken($walletAddress, $callbackToken){
        $tokenString = BIT_KEY.BIT_SECRET.$walletAddress;
        $token = md5($tokenString);

        if($token != $callbackToken) {
            return false;
        }

        return true;
    }
}
