<?php
class RiskAccountListModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs 			= null;
	private $accountNumber	= NO_STRING;	// 口座番号
	private $lastName		= NO_STRING;	// 姓
	private $firstName		= NO_STRING;	// 名
	private $status			= NO_STRING;	// 状態
	private $riskLevel		= NO_STRING;	// risk level (string)
	private $risk 			= NO_STRING;	// risk note (string)
	private $dateTagged		= NO_STRING;

	//search paramaeters
	private $sAccountNumber	= NO_STRING;
	private $sName 			= NO_STRING;
	private $sRiskLevel 	= NO_STRING;
	private $sDateTagged 	= NO_STRING;
	private $sTagFrom 		= NO_STRING;
	private $sTagTo		 	= NO_STRING;
	private $sStatus 		= NO_STRING;
	
	/**
	 *
	 * anton
	 *
	 */
	private $lang			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		//search parameters
		$this -> sAccountNumber				=	$this -> getDataPost(PARAM_USER_ACCOUNT);
		$this -> sName 						= 	$this -> getDataPost(PARAM_NAME);
		$this -> sRiskLevel 				= 	$this -> getDataPost(PARAM_RISK_LEVELS);
		$this -> sDateTagged 				= 	$this -> getDataPost(PARAM_DATE_TAGGED);
		$this -> sStatus 					= 	$this -> getDataPost(PARAM_STATUSES);
		$this -> sTagFrom 					= 	$this -> getDataPost(PARAM_TAG_FROM);
		$this -> sTagTo 					= 	$this -> getDataPost(PARAM_TAG_TO);
		
		$this -> lang						=   $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}
		
		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		 if(!$this -> checkAdminUserAccess('RLVL', array(''))){
		 	$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
		 	header('Location: /'.$redirect.'menu');
		 	exit();
		 }

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
				, count($this -> rs)
				, NO_STRING
				, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ一覧の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$row	= null;

		if($this -> isLoopData($this -> rs)) {

			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

				$row = $this -> getRowData($this -> rs, $cnt);

				$rtn .= '<tr>'
						. '<td> <a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'</a></td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_LAST_NAME) . '&nbsp;' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
						. '<td>' . $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '</td>'
						. '<td>' . $this -> dispRiskLevelCommon($this -> getColumnData($row, COLUMN_RISK_LEVEL)) . '</td>'
						. '<td style="word-break:break-all; width:50px;">' . $this -> getColumnData($row, COLUMN_RISK) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_DATE_TAGGED) . '</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}
/*-------------------------------------------------------------------------
	* @function_name: 口座状態の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispStatuses() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$sStatus	= array();
		$checked	= array();

		// 口座状態リストの取得
		$sStatus = $this -> getStatusList();

		// チェックリストの作成（デフォルト全取得）
		if(!is_array($this -> sStatus)) {

			if($this -> getType() == NO_STRING) {
				if($this -> isLoopData($sStatus)) {

					foreach($sStatus as $row) {
						$checked[$this -> getColumnData($row, PARAM_DATA_KEY)] = $this -> getColumnData($row, PARAM_DATA_KEY);
					}
				}
			}
		} else {

			foreach($this -> sStatus as $row) {
				$checked[$row] = $row;
			}
		}

		if($this -> isLoopData($sStatus)) {

			foreach($sStatus as $row) {
				$rtn .= '<label>' . $this -> makeCheckOne(PARAM_STATUSES . $row[PARAM_DATA_KEY], PARAM_STATUSES . '[]', $row[PARAM_DATA_KEY], $row[PARAM_DATA_VALUE] , $this -> getColumnData($checked, $row[PARAM_DATA_KEY])) . '</label>&emsp;';
			}
		}

		echo $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: 結果セット
	* @return		: 検索条件配列
	-------------------------------------------------------------------------*/
	function getWhere() {

		// 変数宣言部
		$where		= NO_STRING;
		$rtn		= array();
		$statuses	= array();

		//search via useraccount
		if($this -> sAccountNumber != NO_STRING) {
			$where .= ' AND user_account = (\')' . $this -> sAccountNumber . '(\')';
		}

		//search via name
		if($this -> sName != NO_STRING) {
			$where .= ' AND (first_name LIKE (\')%' . $this -> sName . '%(\') OR last_name LIKE (\')%' . $this -> sName . '%(\'))';
		}

		//search via status
		if($this -> getType() != NO_STRING) {		// 検索ボタンを押している場合

			if(is_array($this -> sStatus)) {

				$where .= ' AND (';

				foreach($this -> sStatus as $row) {
					$statuses[] = ' status = (\')' . $row . '(\')';
				}

				$where .= implode(DELIMIT_OR, $statuses) . ')';
			} else {
				$where .= ' AND status = (\')0(\')';
			}
		}

		
		if($this -> sDateTagged != NO_STRING){
			//search via date (FROM)
			if($this -> sTagFrom != '2014/01/01'
					&& $this -> sTagFrom != NO_STRING) {
				$where .= ' AND date_tagged >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sTagFrom) . '(\')';
			}

			//search via date (TO)
			if($this -> sTagTo != NO_STRING) {
				$where .= ' AND date_tagged < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sTagTo) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

		//chck if search is not search all
		// if($this -> getType() == TYPE_ADMIN_USER_SEARCH_ALL) {
		// 	$where = NO_STRING;
		// }

		$rtn[] = $where;
		$rtn[] = $page;

		return $rtn;
	}

	

	/*-------------------------------------------------------------------------
	* @function_name: 開設日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispOpenFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_DATE_TAGGED
											, PARAM_DATE_TAGGED
											, VAL_INT_1
											, NO_STRING, $this -> sDateTagged)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoTagFrom() {
		echo $this -> sTagFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoTagTo() {
		echo $this -> sTagTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> sName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の表示
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoAccountNumber() {
		echo $this -> sAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: makeExportData()
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function makeExportData(){

		
		
		$data = ($this -> lang == "en" ?  "Account Number,Name,Review Status,Risk Level,Reason,Date Tagged\n" 
				: '口座番号,名前,審査状況,リスクレベル,理由,タグした日付' . "\n"); 

		if($this -> isLoopData($this -> rs)){

			foreach($this -> rs as $row){
				$riskmes = $this -> getColumnData($row, COLUMN_RISK);
				$riskmes = str_replace("\"", "\"\"", $riskmes);

				$arr = array();

				$arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);					// ACCOUNT NUMBBR
				$arr[] = $this -> getColumnData($row, COLUMN_LAST_NAME) .' '.  $this -> getColumnData($row, COLUMN_FIRST_NAME);					// NAME
				$arr[] = $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_STATUS));				// STATUS
				$arr[] = $this -> dispRiskLevelCommon($this -> getColumnData($row, COLUMN_RISK_LEVEL));					// RISK LEVEL
				$arr[] = $riskmes;						// RISK NOTE
				$arr[] = $this -> getColumnData($row, COLUMN_DATE_TAGGED);					// RISK NOTE

                $data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";

			}

		}

		$this -> setExportDataCommon($data);
	}

}
?>