<?php
$page_title = "お問い合わせ";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
    <!-- メインエリア -->
    <link rel="stylesheet" type="text/css" href="../../files/css/newstyle.css">
<wrapper>
	<section class="container page-container">
		<div class="row page-title">
			<div class="col-sm-12">
				<h1 class="blue-line-ctr"><?php echo $page_title; ?></h1>
			</div>
		</div>
	
        <div id="main" class="container">
    		<div class="row no-border">
    			<div class="col-sm-12">
    				<h5 style="color: #f00f00; line-height: 1.75; font-size:20px;">
        				＊サーバーの不具合により、以下のお問い合わせフォームから送信されたお客様のメールが受信ができない状態が続いております。お手数ですが、当該機能を修正できるまで、お問い合わせの際は 
        				<span style="color:#648CEF;font-weight:bold;">cs@iwl.world</span> まで直接メールにてご連絡ください。
        				<br><br>
    				</h5>
    			</div>
    			<div class="col-sm-12" style="display:none;">				
    				<h5>お問い合わせの前にFAQをご覧ください。</h5>
    				<p>
    					下記フォームにお問い合わせ内容をご記入ください。<br>
         				 お返事は、原則として翌営業日までにEメールにてお答えさせて頂きます。但し、土日祝・夏季・冬季休業日のお問合せは、お待たせする場合がございます。<br>
         				 弊社からのお返事は、お客様個人宛てにお送りするものです。お返事文面の一部または全部を転載、二次利用することはご遠慮ください。<br>
         				 英語、日本語、中国語、韓国語のお問い合わせに対応いたします。
          			</p>
    			</div>
    		</div>
    		<div class="tab-content" style="display:none;">
    			<div class="tab-pane fade in active">
    			
    				<div class="row">
    					<div class="col-sm-8">
                          <form id="acForm" action="" method="post">
                              	<?php $this -> dispMessagesCommon(); ?>
                        		<div class="row">
                        			<div class="col-sm-12">
                        				<ul class="nav nav-pills">
                                	<?php $this -> dispAccountType(); ?>
                                				</ul>
                        			</div>
                        		</div>
                        		<?php $this -> dispInput(); ?>
                        		<div class="form-group row info-section" id="corp_block_01">
                        			<label class="col-sm-3 info-label" for="email">会社名:
                        				<span id="required" class="required">*</span>
                        			</label>
                        			<div class="col-sm-9 input-box">
                        				<input type="text" name="name_corp" value="<?php $this -> echoName(); ?>" class="form-control">
                        			</div>	
                        		</div>
                        		<div class="form-group row info-section" id="corp_block_02">
                        			<label class="col-sm-3 info-label" for="email">ご担当者名:
                        				<span id="required" class="required">*</span>
                        			</label>
                        			<div class="col-sm-9 input-box">
                        				<input type="text" name="manager_name" value="<?php $this -> echoManager(); ?>" class="form-control w50p">
                        			</div>	
                        		</div>
                        		<div class="form-group row info-section" id="personal_block">
                        			<label class="col-sm-3 info-label" for="email">お名前:
                        				<span id="required" class="required">*</span>
                        			</label>
                        			<div class="col-sm-9 input-box">
                        				<input type="text" name="name_per" value="<?php $this -> echoName(); ?>" class="form-control w50p">
                        			</div>	
                        		</div>
                        		<div class="form-group row info-section">
                        			<label class="col-sm-3 info-label" for="email">お問い合わせ件名:
                        				<span id="required" class="required">*</span>
                        			</label>
                        			<div class="col-sm-9 input-box">
                        			<input type="text" name="title" min="10" max="128" value="<?php $this -> echoTitle(); ?>" class="form-control">
                        			<span>(128文字以内で入力してください。)</span>
                        			</div>	
                        		</div>
                        		<div class="form-group row info-section" id="personal_block">
                        			<label class="col-sm-3 info-label" for="email">お問い合わせ内容:
                        				<span id="required" class="required">*</span>
                        			</label>
                        			<div class="col-sm-9 input-box">
                                        <textarea name="body" id="" rows="4" min="10" max="500" class="form-control"><?php $this -> echoBody(); ?></textarea>
                                        <span>(500文字以内で入力してください。)</span>
                        			</div>	
                        		</div>
                        
                        		<div class="col-sm-12 btn-box">
                        			<button class="btn-left" id="btnConfirm" type="submit" value="submit">確認ページへ進む</button>
                        			
                        		</div>
                                
                        
                                <input type="hidden" id="type" name="type" value="" />
                          </form>
    					</div>
    				</div>
    			</div>
             </div>
        </div>
    	<script src="../js/support.js"></script>
			
	</section>
</wrapper>
<?php
include_once('template/base_site_foot.php');
?>
</body>
</html>