<?php

/**
 * 
 * @author antonio
 *
 */
class TransactionManager extends RequestUtil {
    
    use ValidationExpression;
    use UserBalances, ProcessingHistory, Withdrawal;
    
    private $paramHolder;
    
    public function __construct(){
        parent::__construct();
        $this -> initComponents();
    }
    
    public function fetchResults(){
        $this -> displayResults();
    }
    
    private function initComponents(){
        $this -> initParams();
        $this -> checkValidities();
    }
    
    private function initParams(){    
        $this -> defaultValueParams();
        $this -> userListParams();
        $this -> primaryParams();
        $this -> processingHistoryParams();
        $this -> withdrawalListParams();
        
        $this -> catchDateParams();
    }
    
    private function defaultValueParams(){
        $this -> paramHolder = new ParamHolder($this);
        $this -> paramHolder -> ipAddress = $_SERVER["REMOTE_ADDR"];
        
        $this -> paramHolder -> contentType = isset($_SERVER["CONTENT_TYPE"])
            ? $_SERVER["CONTENT_TYPE"] : NO_STRING;
        
        $this -> paramHolder -> requestMethod = isset($_SERVER["REQUEST_METHOD"])
            ? $_SERVER["REQUEST_METHOD"] : NO_STRING;
    }
    
    private function primaryParams(){
        $this -> paramHolder -> open        = $this -> getDataGet("open", true);
        
        $this -> paramHolder -> dateFrom    = $this -> requestParam("dateFrom", true);
        $this -> paramHolder -> dateTo      = $this -> requestParam("dateTo", true);
        $this -> paramHolder -> page        = $this -> requestParam("page", true);
        $this -> paramHolder -> userAccount = $this -> requestParam("userAccount", true);
        $this -> paramHolder -> view        = $this -> requestParam("view", true);
        $this -> paramHolder -> currency    = $this -> requestParam("currency", true);
        
        $this -> paramHolder -> orderByAlgorithm    = $this -> requestParam("orderByAlgo");
        
        if(empty($this -> paramHolder -> orderByAlgorithm))
            $this -> paramHolder -> orderByAlgorithm = 1;
    }
    
    private function userListParams(){
        $this -> paramHolder -> wlId                                = $this -> requestParam("wlId", true);
        $this -> paramHolder -> emailAddress                        = $this -> requestParam("email", true);
        $this -> paramHolder -> name                                = $this -> requestParam("name", true);
        $this -> paramHolder -> accountType                         = $this -> requestParam("accountType", true);
        $this -> paramHolder -> country                             = $this -> requestParam("country", true);
        $this -> paramHolder -> state                               = $this -> requestParam("state", true);
        $this -> paramHolder -> address                             = $this -> requestParam("address", true);
        $this -> paramHolder -> agentCode                           = $this -> requestParam("agentCode", true);
        $this -> paramHolder -> crmId                               = $this -> requestParam("crmId", true);
        $this -> paramHolder -> kycFlg                              = $this -> requestParam("kycFlg", true);
                                                                    
        $this -> paramHolder -> statusDisable                       = $this -> requestParam("statusDisable", true);
        $this -> paramHolder -> statusTempoRegist                   = $this -> requestParam("statusTempoRegist", true);
        $this -> paramHolder -> statusStandard                      = $this -> requestParam("statusStandard", true);
        $this -> paramHolder -> statusExecutive                     = $this -> requestParam("statusExecutive", true);
        $this -> paramHolder -> statusSuspended                     = $this -> requestParam("statusSuspended", true);
        $this -> paramHolder -> statusClosed                        = $this -> requestParam("statusClosed", true);
        $this -> paramHolder -> statusSusStandardDormant            = $this -> requestParam("statusSusStandardDormant", true);
        $this -> paramHolder -> statusSusExecutiveDormant           = $this -> requestParam("statusSusExecutiveDormant", true);
        
        $this -> paramHolder -> dateOfAccountOpening                = $this -> requestParam("dateOfAccOpening", true);
        $this -> paramHolder -> dateOfAccountOpeningFrom            = $this -> requestParam("dateOfAccOpeningFrom", true);
        $this -> paramHolder -> dateOfAccountOpeningTo              = $this -> requestParam("dateOfAccOpeningTo", true);
                                                                    
        $this -> paramHolder -> dateOfLastLogin                     = $this -> requestParam("dateOfLastLogin", true);
        $this -> paramHolder -> dateOfLastLoginFrom                 = $this -> requestParam("dateOfLastLogFrom", true);
        $this -> paramHolder -> dateOfLastLoginTo                   = $this -> requestParam("dateOfLastLogTo", true);
                                                                    
        $this -> paramHolder -> dateOfAccountClosing                = $this -> requestParam("dateOfAccClosing", true);
        $this -> paramHolder -> dateOfAccountClosingFrom            = $this -> requestParam("dateOfAccClosingFrom", true);
        $this -> paramHolder -> dateOfAccountClosingTo              = $this -> requestParam("dateOfAccClosingTo", true);
        
        $this -> paramHolder -> dateOfAccountSuspension             = $this -> requestParam("dateOfAccSuspension", true);
        $this -> paramHolder -> dateOfAccountSuspensionFrom         = $this -> requestParam("dateOfAccSuspensionFrom", true);
        $this -> paramHolder -> dateOfAccountSuspensionTo           = $this -> requestParam("dateOfAccSuspensionTo", true);
    }
    
    private function processingHistoryParams(){
        $this -> paramHolder -> withdrawalAccountNum    = $this -> requestParam("withdrawalAccountNum", true);
        $this -> paramHolder -> withdrawalAccountName   = $this -> requestParam("withdrawalAccountName", true);
        $this -> paramHolder -> depositAccountNum       = $this -> requestParam("depositAccountNum", true);
        $this -> paramHolder -> depositAccountName      = $this -> requestParam("depositAccountName", true);
        $this -> paramHolder -> transactionNum          = $this -> requestParam("transactionNum", true);
        $this -> paramHolder -> transactionType         = $this -> requestParam("transactionType", true);
        $this -> paramHolder -> testAccountFlag         = $this -> requestParam("testAccountFlag", true);
        $this -> paramHolder -> minAmount               = $this -> requestParam("minAmount", true);
        $this -> paramHolder -> maxAmount               = $this -> requestParam("maxAmount", true);
        $this -> paramHolder -> searchByDate            = $this -> requestParam("searchByDate", true);
        
        
        $this -> paramHolder -> statusUser      = $this -> requestParam("statusUser", true);
        $this -> paramHolder -> statusAdmin     = $this -> requestParam("statusAdmin", true);
        $this -> paramHolder -> statusAPI       = $this -> requestParam("statusAPI", true);
        $this -> paramHolder -> statusBatch     = $this -> requestParam("statusBatch", true);
        $this -> paramHolder -> statusBank      = $this -> requestParam("statusBank", true);
        $this -> paramHolder -> statusCard      = $this -> requestParam("statusCard", true);
        $this -> paramHolder -> statusCredit    = $this -> requestParam("statusCredit", true);
    }
    
    private function withdrawalListParams(){
        $this -> paramHolder -> bankName            = $this -> requestParam("bankName", true);
        $this -> paramHolder -> remittanceAccount   = $this -> requestParam("remittanceAccount", true);
        $this -> paramHolder -> bankSlipNumber      = $this -> requestParam("bankSlipNumber", true);
        $this -> paramHolder -> withdrawalType      = $this -> requestParam("withdrawalType", true);
        $this -> paramHolder -> withdrawalSolution  = $this -> requestParam("withdrawalSolution", true);
        $this -> paramHolder -> withdrawalFee       = $this -> requestParam("withdrawalFee", true);
        $this -> paramHolder -> withdrawalStatus    = $this -> requestParam("withdrawalStatus", true);
        $this -> paramHolder -> tier                = $this -> requestParam("tier", true);
        $this -> paramHolder -> searchByAppDate     = $this -> requestParam("searchByAppDate", true);
        $this -> paramHolder -> applicationDateFrom = $this -> requestParam("applicationDateFrom", true);
        $this -> paramHolder -> applicationDateTo   = $this -> requestParam("applicationDateTo", true);
        $this -> paramHolder -> searchByProcessDate = $this -> requestParam("searchByProcessDate", true);
        $this -> paramHolder -> processDateFrom     = $this -> requestParam("processDateFrom", true);
        $this -> paramHolder -> processDateTo       = $this -> requestParam("processDateTo", true);
    }
    
    private function catchDateParams(){
        $this -> setToCurrentDate($this -> paramHolder -> dateFrom);
        $this -> setToCurrentDate($this -> paramHolder -> dateTo);
        $this -> setToCurrentDate($this -> paramHolder -> applicationDateFrom);
        $this -> setToCurrentDate($this -> paramHolder -> applicationDateTo);
        $this -> setToCurrentDate($this -> paramHolder -> processDateFrom);
        $this -> setToCurrentDate($this -> paramHolder -> processDateTo);
        
        $this -> setToCurrentDate($this -> paramHolder -> dateOfAccountOpeningFrom);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfAccountOpeningTo);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfLastLoginFrom);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfLastLoginTo);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfAccountClosingFrom);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfAccountClosingTo);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfAccountSuspensionFrom);
        $this -> setToCurrentDate($this -> paramHolder -> dateOfAccountSuspensionTo);
    }
    
    /**
     * 
     * will set the date-instance param to current date only if containing empty string.
     * 
     * @param $dateInstanceParam
     * 
     */
    private function setToCurrentDate(&$dateInstanceParam){
        if($dateInstanceParam == NO_STRING)
            $dateInstanceParam = date("Y-m-d");   
    }

    /**
     * 
     * iterates the condition list.
     * 
     */
    private function checkValidities() {
        foreach($this -> getCheckerValues($this -> paramHolder) as $validation){
            if($validation["notvalid"])
                die(json_encode($validation));
        }
    }
    
    
    private function displayResults(){
        if(!$this -> paramHolder -> open){
            switch($this -> paramHolder -> view){
                case "userBalance":
                    $this -> generateBalances($this -> paramHolder);
                    break;
                case "processingHistory":
                    $this -> getTransactions($this -> paramHolder);
                    break;
                case "withdrawalTotal":
                    $this -> getWithdrawalTotalPerCurrency($this -> paramHolder);
                    break;
                case "withdrawalTransList":
                    $this -> getWithdrawalList($this -> paramHolder);
                    break;
            }
        }else{
            $openApi = null;
            switch($this -> paramHolder -> view){
                case "userList":
                    $openApi = new UserList();
                    break;
                case "userTransactions":
                    $openApi = new UserTransactions();
                    $openApi -> setView("transactions");
                    break;
                case "userBalancesOpen":
                    $openApi = new UserTransactions();
                    $openApi -> setView("balances");
                    break;
                case "userAllBalanceApi":
                    $openApi = new BalanceAllUserAPI();
                    break;
                case "overallTransactions":
                    $openApi = new OverallTransactions();
                    break;
                case "withdrawalListOpen":
                    $openApi = new MoneyOutTransactions();
                    $openApi -> setView("withdrawalList");
                    break;
                case "withdrawalTotalOpen":
                    $openApi = new MoneyOutTransactions();
                    $openApi -> setView("totalPerCurrency");
                    break;
            }
            
            $openApi -> setHolder($this -> paramHolder);
            $openApi -> showResults();
        }
    }
}