/**
 * ボタンイベント
 */

 /**
  * anton
  * 
  * 
  **/

var applicableSetting = (lang == "en" ?  
    "You're about to modify the default setting. \nAre you really going to proceed with it?" 
    : "全適用設定を実行しようとしています。\n本当に実行しますか？");

$(function() {
	$('#btnRegist').click(function() {
		if($('#p_id').val() =='0') {
			if(confirm(applicableSetting)) {
				$('#type').val('complete');
				submitForm();
			}
		} else {
			var patternName = $('#pattern_name').val().trim()
			
			// validation message thrower
			if(patternName.length == 0){
				$('#type').val('complete');
				submitForm();
				return;
			}
			
            var createOrUpdatePattern = (lang == "en" ? 
                    "You are about to create/update a pattern [" + patternName + "]. \nProceed?" 
                    : "パターン名[" + patternName + "]を作成します。\n実行しますか？");
			if(confirm(createOrUpdatePattern)) {
				$('#type').val('complete');
				submitForm();
			}
		}
	});

	$('#new_pattern').click(function(e) {
        e.preventDefault()
		$('#p_id').val('');
		$('#new_pattern_name').toggle()
	});

	$('#btnInput').click(function() {
		allReset();
	});

    //　Updated
	$('#default_pattern').click(function(e) {
        e.preventDefault()
		$('#pattern_name').val('');
		$('#p_id').val('0');

        // Original: api/getExchangeFee -- anton
		// ポストアクション
		postAction('../api/getExchangeFee', {'p_id':'0'})
		.done(function(data) {
			allReset();
			$.each(data, function(key, value) {
                $('#' + key).val(value);
			});
		})
		.fail(function(data) {
			console.log(data);
		});
	});

    //　Updated　
	$('[id*=pattern_id_]').click(function(e) {
        e.preventDefault()
		var id	= $(this).attr('id');
		var arr	= id.split('_');
		var pId	= arr[2];

		$('#pattern_name').val($('#' + id).text());
		$('#p_id').val(pId);

        // ポストアクション
		postAction('../api/getExchangeFee', {'p_id':pId})
		.done(function(data) {
			allReset();

			$.each(data, function(key, value) {
                $('#' + key).val(value);
			});
		})
		.fail(function(data) {
			console.log(data);
        });
	});

	$('#btnCreate').click(function() {
		$('#type').val('create');
		submitForm();
	});

	$('#btnDelete').click(function() {
		var deletePattern = (lang == "en" ? 
            "You are about to delete the pattern [" + $('#pattern_name').val() + "]. \nProceed?" 
            : "パターン名[" + $('#pattern_name').val() + "]を作成します。\n実行しますか？");
		if(confirm(deletePattern)) {
			$('#type').val('delete');
			submitForm();
		}

	});

	$('#btnSearch').click(function() {
		$('#type').val('search');
		submitForm('searchForm');
	});

	$('#btnSearchAll').click(function() {
		$('#pattern_name').val('');
		$('#type').val('search');
		submitForm('searchForm');
	});
});

// データをリセットする
function allReset() {

	// データをリセット
	$.each($('[id*=whole_]'), function() {
		$(this).val('');
	});

	$.each($('[id*=markup_]'), function() {
		$(this).val('');
	});
}

/**
 * 詳細表示
 */
function actionDetail(pId, target) {
	$('#acForm').attr('action','');
	$('#type').val('detail');
	$('#p_id').val(pId);

	// ターゲットがない場合
	if(target != undefined) {
		getForm().attr('target', target);
	} else {
		getForm().attr('target', '');
	}

	submitForm();
}