<?php
require_once('config.php');
require_once('CheckExchangeBase.php');

class APICheckExchange extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'E' . $this -> account);
			}


		} catch (Exception $e) {
			throw $e;
		}
	}
}

try {


	$api = new APICheckExchange();
	$api -> action();

	// チェックロジック
	$api = new APICheckExchangeBase();
	$api -> action();

	echo json_encode(array('result'			=> 'OK'
						, 'messages'		=> 'I_COMPLETE_PROCESS'
						, 'rate'			=> $api -> getRate()
						, 'from_amount'		=> $api -> currencyToInt($api -> getFromAmount(), $api -> getFromCurrency())
						, 'to_amount'		=> $api -> currencyToInt($api -> getToAmount(), $api -> getToCurrency())
						, 'from_balance'	=> $api -> currencyToInt($api -> getBalanceCommon($api -> getAccount(), $api -> getFromCurrency()), $api -> getFromCurrency())
						, 'to_balance'		=> $api -> currencyToInt($api -> getBalanceCommon($api -> getAccount(), $api -> getToCurrency()), $api -> getToCurrency())
					));

} catch (Exception $e) {	// チェックエラー

	$rtn = array('result'		=> 'NG'
				, 'messages'	=> $e -> getMessage());

	echo json_encode($rtn);
}
?>