<?php
require_once(SYSTEM_LOGICS . 'agent/logic.php');

class ControlAgent extends LogicAgent {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		try {
		    $this -> checkAvailability("system", function(){
		        require_once($this -> getSystemHTML('TEMPLATE_MAINTENANCE_MODE_SYSTEM_PATH'));
		        exit();
		    });
		    
			// アクション実行
			$this -> logic();

			if($this -> getType() == CONTROL_ACTION) {			// 今は必要なし？
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_ACTION_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_INPUT) {		// エージェントの入力
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {		// エージェントの確認
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {	// エージェントの完了
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_LIST_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_DETAIL) {		// エージェントの詳細
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_SAVE) {		// エージェントの更新
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMMISSION) {	// エージェント報酬
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_REWARD_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_UPDATE) {		// エージェント報酬更新
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_REWARD_DETAIL_PATH', $this -> dispHTML()));

			} else {											// 画面の表示（一覧）
				require_once($this -> getSystemHTML('TEMPLATE_AGENT_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>