<?php
class TransactionLogsModelClass extends ModelClassEx {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $from                       = NO_STRING;						
	private $to                       	= NO_STRING; 						
	private $lang						= NO_STRING;
	private $method						= NO_STRING;
	private $rs 						= null;
	private $post 						= NO_STRING;
	private $url 						= NO_STRING;
	private $ip 						= NO_STRING;
	private $programCode                = NO_STRING;

	private $count                      = NO_COUNT;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {
			// パラメータの設定
			$this -> setParameter();
			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}
	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// ------------------ 検索系 ------------------//
		$this -> sFrom					= $this -> getDataPost(PARAM_S_FROM);						// 登録時刻（開始日）（検索項目）
		$this -> sTo					= $this -> getDataPost(PARAM_S_TO);							// 登録時刻（終了）（検索項目）
		$this -> method 				= $this -> getDataPost(PARAM_METHOD);
		$this -> ip 					= $this -> getDataPost(PARAM_IP_ADDRESS);
		$this -> url 					= $this -> getDataPost('url');
		$this -> post 					= $this -> getDataPost('post');
		$this -> programCode            = $this -> getDataPost(PARAM_P_NUM);
		// ------------------ 検索系 ------------------//

		$this -> lang					= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('TRLO', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoList
	* @parameter	: none
	* @return		: logfiles
	-------------------------------------------------------------------------*/
	public function echoList() {

		$solution = $this -> method;
		$apiUrl = SITE_PROTOCOL."://".SITE_DOMAIN_FULL."/api/Logs/";
		//for deposit logs
		$logFolder = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR;

		$merged = $this-> getLogs();
		$start				= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end				= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
		$listCountLogs	    = count($merged['merged']);

		for($cnt = $start;$cnt < $end && $cnt < $listCountLogs; $cnt++) {
			$request = str_replace('*.log', $merged['merged'][$cnt], $merged['reqFolder']);
			$request = str_replace($logFolder, $apiUrl, $request);
			$response = str_replace('*.log', $merged['merged'][$cnt], $merged['resFolder']);
			$response = str_replace($logFolder, $apiUrl, $response);

			if(in_array($merged['merged'][$cnt], $merged['sameValue'])){
				echo '<tr>'.
					 '<td>'.
					 $solution.
					 '</td>'.
					 '<td>'.
					 '<a href="'.$request.'" target="_blank">'.$merged['merged'][$cnt].'</a>'.
					 '</td>'.
					 '<td>'.
					 '<a href="'.$response.'" target="_blank">'.$merged['merged'][$cnt].'</a>'.
					 '</td>'.
					 '</tr>';
			}elseif(in_array($merged['merged'][$cnt], $merged['diffValue'])){
				echo '<tr>'.
					 '<td>'.
					 $solution.
					 '</td>'.
					 '<td>'.
					 '<a href="'.$request.'" target="_blank">'.$merged['merged'][$cnt].'</a>'.
					 '</td>'.
					 '<td>'.
					 '</td>'.
					 '</tr>';
			}elseif(in_array($merged['merged'][$cnt], $merged['diffValue2'])){
					echo '<tr>'.
						 '<td>'.
						 $solution.
						 '</td>'.
						 '<td>'.
						 '</td>'.
						 '<td>'.
						 '<a href="'.$response.'" target="_blank">'.$merged['merged'][$cnt].'</a>'.
						 '</td>'.
						 '</tr>';
			}
		}

	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		if($this -> method != 'From_DB'){
			$merged = $this-> getLogs();

			$total = count($merged['merged']);
		}else{
			$total = $this -> count;
		}
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $total)
										, $total
										, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispSolutions
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispSolutions() {
		// 変数宣言部
		$rtn		= NO_STRING;
		$method   = [];

		$methodNames = [
		    "CASHFLOWVM",
		    "LBTC",
		    "Overseas",
		    "CUP",
		    "BIT",
		    "H2P",
		    "H2PW",
		    "SDPay_Withdraw",
		    "settlement",
		    "CPS",
		    "From_DB",
		    "LBT(Japan)",
		    "Japan Remittance Voucher",
		    "ZP_UPI",
		    "Credit Card Deposit"
		];
		
		foreach($methodNames as $key => $value){
		    $method[] = [
		          PARAM_DATA_KEY => $key,
		          PARAM_DATA_VALUE => $value
		    ];
		}

		foreach($method as $row) {
			$rtn .= '<label>' . $this -> makeCheckOne(PARAM_METHOD . '" class="method', PARAM_METHOD, $row[PARAM_DATA_VALUE], $row[PARAM_DATA_VALUE] , $this -> method) . '</label>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: setCount
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
	function setCount($count){
	    $this -> count = $count;
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: getMethod
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function getMethod() {
		return $this -> method;
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoListDB
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoListDB() {
		$rtn	= NO_STRING;
		$row	= null;

		if($this -> isLoopData($this -> rs)) {
			foreach($this -> rs as $row) {
				$rtn .= '<tr>'
						. '<td> '. $this -> getColumnData($row, COLUMN_IP_ADDRESS) .'</td>'
						. '<td> '. $this -> getColumnData($row, 'p_num') .'</td>'
						. '<td style="word-break:break-all;">' . $this -> getColumnData($row, 'url')  . '</td>'
						. '<td style="word-break:break-all;">' . $this -> getColumnData($row, 'post') . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="5">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: setResult
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: getWhere
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function getWhere() {
		$where		= NO_STRING;
		$rtn		= array();

		if($this -> sFrom != '2014/01/01'
				&& $this -> sFrom != NO_STRING) {
			$where .= ' AND create_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sFrom) . '(\')';
		}else{
			// english-comment
			$this -> sFrom = date("Y/m/01");
			$where .= ' AND create_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sFrom) .'(\') ';
		}

		//search via date (TO)
		if($this -> sTo != NO_STRING) {
			$where .= ' AND create_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sTo) . '(\'), INTERVAL 1 DAY)';
		}else{
			// english-comment
			$this -> sTo = date("Y/m/d");
			$where .= ' AND create_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sTo) . '(\'), INTERVAL 1 DAY) ';
		}

		if($this -> ip != NO_STRING) {
			$where .= ' AND (ip_address LIKE (\')%'. $this -> ip .'%(\'))';
		}

		if($this -> url != NO_STRING) {
			$where .= ' AND (url LIKE (\')%'. $this -> url .'%(\'))';
		}

		if($this -> post != NO_STRING) {
			$where .= ' AND (post LIKE (\')%'. $this -> post .'%(\'))';
		}
		
		if($this -> programCode != NO_STRING){
		    $where .= ' AND (p_num = (\')'. $this -> programCode . '(\'))';
		}

		$rtn[] = $where;

		return $rtn;
	}

	function getLogs(){
		$requestTrim = array();
		$responseTrim = array();
		$logFolder = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'Logs';
		$solution = $this -> method;
		$reqFolder = NO_STRING;
		$resFolder = NO_STRING;
		$solution = $this -> method;

		switch($solution){
			/* deposit soultions start*/
			case 'CPS':
				//set log folders
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'Cryptocoin'.DIRECTORY_SEPARATOR.'request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'Cryptocoin'.DIRECTORY_SEPARATOR.'response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'CASHFLOWVM':
				//set log folders
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'LBTC'://SDPay Deposit
				//set log folders
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'SDPayDeposit'.DIRECTORY_SEPARATOR.'deposit_request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'SDPayDeposit'.DIRECTORY_SEPARATOR.'async_callback'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'Overseas':
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'Flat3'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'CUP':
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'SDPay'.DIRECTORY_SEPARATOR.'cup_deposit_request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'SDPay'.DIRECTORY_SEPARATOR.'deposit_cup_response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'BIT':	//bitcoin
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'Bitcoin'.DIRECTORY_SEPARATOR.'db_response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'H2P':	//help2pay
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'H2P'.DIRECTORY_SEPARATOR.'deposit_request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'H2P'.DIRECTORY_SEPARATOR.'deposit_response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'ZP_UPI':	//ZANETAPAY
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'Zanetapay'.DIRECTORY_SEPARATOR.'request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'Zanetapay'.DIRECTORY_SEPARATOR.'response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			/* deposit solutions end*/

			/* withdrawal solutions start*/
			case 'H2PW':
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'sending_request'.DIRECTORY_SEPARATOR.'request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'callback'.DIRECTORY_SEPARATOR.'success'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'SDPay_Withdraw':
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'SDPayWithdraw'.DIRECTORY_SEPARATOR.'request'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'SDPayWithdraw'.DIRECTORY_SEPARATOR.'response'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'settlement':
				$reqFolder = $logFolder.DIRECTORY_SEPARATOR.'settlement'.DIRECTORY_SEPARATOR.'access'.DIRECTORY_SEPARATOR.'*.log';
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'settlement'.DIRECTORY_SEPARATOR.'settlement_response_data'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'LBT(Japan)':
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'LBTF3'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'Japan Remittance Voucher':
				$resFolder = $logFolder.DIRECTORY_SEPARATOR.'SAPAY'.DIRECTORY_SEPARATOR.'*.log';
				break;
			case 'Credit Card Deposit':
			    $resFolder = $logFolder.DIRECTORY_SEPARATOR.'APN'.DIRECTORY_SEPARATOR.'*.log';
			    break;
		}

		//descend log files
		$reqLogFiles = array_reverse(glob($reqFolder));
		$resLogFiles = array_reverse(glob($resFolder));

		//get number of log files
		$listCountRequest	= count($reqLogFiles);
		$listCountResponse	= count($resLogFiles);

		//get file names
		if(!($listCountRequest>=VAL_INT_1 && $reqLogFiles[0]==NO_STRING)){
			for($cnt = 0; $cnt < $listCountRequest; $cnt++) {
			    $requestTrim[] = basename($reqLogFiles[$cnt]);
			}
		}
		if(!($listCountResponse>=VAL_INT_1 && $resLogFiles[0]==NO_STRING)){
			for($cnt = 0;$cnt < $listCountResponse; $cnt++) {
			    $responseTrim[] = basename($resLogFiles[$cnt]);
			}
		}

		//get same file name
		$sameValue = array_intersect($requestTrim, $responseTrim);
		//get request log file name that does not have same name with response log files
		$diffValue = array_diff($requestTrim, $responseTrim);
		//get response log file name that does not have same name with  request log files
		$diffValue2 = array_diff($responseTrim, $requestTrim);

		//merge request and response
		$merged = array_merge($diffValue, $sameValue, $diffValue2);
		rsort($merged);

		return array(
			'merged' => $merged
			,'sameValue' => $sameValue
			,'diffValue' => $diffValue
			,'diffValue2' => $diffValue2
			,'reqFolder' => $reqFolder
			,'resFolder' => $resFolder);
	}

	function echoTagFrom(){
		echo $this -> sFrom;
	}

	function echoTagTo(){
		echo $this -> sTo;
	}

	function echoURL(){
		echo $this -> url;
	}

	function echoPost(){
		echo $this -> post;
	}

	function echoIP(){
		echo $this -> ip;
	}
	
	function echoProgramCode(){
	    echo $this -> programCode;
	}
}
?>