<?php
header("Content-type: text/json");

include_once 'config.php';

class TransactionHistory extends System{

    private $detailAccount;
    private $transactionNumber;
    private $emailAddress;
    private $userAccount;
    private $currency;
    private $transactionType;
    private $dateFrom;
    private $dateTo;
    
    private $page;
    
    public function __construct(){
        parent::__construct();
        $this -> init();
    }
    
    public function init(){
        $this -> setParameter();
        $this -> validation();
    }
    
    private function setParameter(){
        $this -> detailAccount      = $this -> getDataPost("detailAccount");
        $this -> transactionNumber  = $this -> getDataPost("txnNum");
        $this -> emailAddress       = $this -> getDataPost("email");
        $this -> userAccount        = $this -> getDataPost("userAccount");
        $this -> currency           = $this -> getDataPost("cur");
        $this -> transactionType    = $this -> getDataPost("txnType");
        $this -> dateFrom           = $this -> getDataPost("from");
        $this -> dateTo             = $this -> getDataPost("to");
        $this -> page               = !empty($this -> getDataPost("page")) ? $this -> getDataPost("page") : 1;
    }
    
    private function validation(){
        if($_SERVER['REQUEST_METHOD'] != 'POST'){
            die(json_encode([
                "error_code" => 1,
                "message" => "Invalid Request Method [{$_SERVER['REQUEST_METHOD']}]"
            ]));   
        }
    }
    
    private function getWhere() {
        $rtn = [];
        
        $rtn[] = $this -> detailAccount;
        $rtn[] = $this -> currency;
        $whereStr = NO_STRING;
        // 取引番号
        if($this -> transactionNumber != NO_STRING) {
            $whereStr .= ' AND transaction_number = (\')' . $this -> transactionNumber . '(\')';
        }
        // メールアドレス
        if($this -> emailAddress != NO_STRING) {
            $whereStr .= ' AND (withdraw_user.mail LIKE (\')%' . $this -> emailAddress . '%(\') OR deposit_user.mail LIKE (\')%' . $this -> emailAddress . '%(\'))';
        }
        // 口座番号
        if($this -> userAccount != NO_STRING) {
            $whereStr .= ' AND (deposit_account_number = (\')' . $this -> userAccount . '(\') OR withdraw_account_number = (\')' . $this -> userAccount . '(\'))';
        }
        
        // 開始日
        if($this -> dateFrom != NO_STRING) {
            $whereStr .= ' AND transaction_time >= (\')' . $this -> dateFrom . '(\')';
        } else {
            $whereStr .= ' AND transaction_time >= (\')' . date('Y/m/01', strtotime('-2 month')) . '(\')';
        }
        // 終了日
        if($this -> dateTo != NO_STRING) {
            $whereStr .= ' AND transaction_time < DATE_ADD((\')' . $this -> dateTo . '(\'), INTERVAL 1 DAY)';
        } else {
            $whereStr .= ' AND transaction_time < DATE_ADD((\')' . date('Y/m/d') . '(\'), INTERVAL 1 DAY)';
        }
        
        // anton
        if($this -> transactionType != NO_STRING) {
            switch($this -> transactionType){
                case VAL_INT_1:
                    $whereStr .= ' AND transaction_type = (\')1(\')';					// 入金
                    break;
                case VAL_INT_2:
                    $whereStr .= ' AND (transaction_type IN ((\')9(\'), (\')10(\'), (\')12(\')) OR (transaction_type = (\')2(\') AND type = (\')0(\')))';	// 出金
                    break;
                case VAL_INT_3:
                    $whereStr .= ' AND transaction_type IN ((\')3(\'), (\')4(\'))';					// 通貨両替
                    break;
                case VAL_INT_4:
                    $whereStr .= ' AND (transaction_type IN ((\')5(\'), (\')6(\')) OR (transaction_type = (\')2(\') AND type = (\')3(\')))';				// 口座振替
                    break;
                case VAL_INT_5:
                    $whereStr .= ' AND transaction_type IN ((\')7(\'), (\')8(\'))';					// 引き落し
                    break;
                case VAL_INT_6:
                    $whereStr .= ' AND (transaction_type = (\')11(\') OR trans.type = (\')1(\'))';					// 引き落し
                    break;
            }
            
        }
        
        $rtn[] = $whereStr;
        
        return $rtn;
    }
    
    public function result(){
        $startTime = microtime(true);
        
        $where = $this -> getWhere();
        
        $defaultPageCount = VAR_DEFAULT_PAGE_COUNT;
        
        $rowCount = $this -> getColumnData(
            $this -> getRowData($this -> accessSelect('SELECT_USER_TRANSACTION_ADMIN_COUNT', $where), 0), "overall_total");
        
        $start	= ($this -> page - VAL_INT_1) * $defaultPageCount;
        
        $where[] = " LIMIT {$start}, {$defaultPageCount}";
        $totalPage = $this -> getTotalPageCommon($defaultPageCount, $rowCount);
        
        
        $fetched = $this -> accessSelect('LIST_USER_TRANSACTION_ADMIN', $where);
        
        if($this -> isLoopData($fetched)){
            foreach($fetched as &$data){
                if($this -> getColumnData($data, COLUMN_DEPOSIT_AMOUNT) != NO_STRING) {
                    $data[COLUMN_DEPOSIT_AMOUNT] = $this -> formatCurrency(
                        floatval($this -> getColumnData($data, COLUMN_DEPOSIT_AMOUNT)), $this -> currency);
                }
                
                if((strlen($this -> getColumnData($data, COLUMN_ACCOUNT_NUMBER) > 0))){
                    $data[COLUMN_ACCOUNT_NUMBER] = '<a href="account_edit?detail_account=' . $this -> getColumnData($data, COLUMN_ACCOUNT_NUMBER) . '">'
                        . $this -> getColumnData($data, COLUMN_ACCOUNT_NUMBER) .'</a>';
                }
                
                if($this -> getColumnData($data, COLUMN_WITHDRAW_AMOUNT) != NO_STRING) {
                    $data[COLUMN_WITHDRAW_AMOUNT] = $this -> formatCurrency(
                        floatval($this -> getColumnData($data, COLUMN_WITHDRAW_AMOUNT)), $this -> currency);
                }
                
                $data[COLUMN_FEE] = $this -> formatCurrency($this -> getColumnData($data, COLUMN_FEE), $this -> currency);
                
                $data[COLUMN_MESSAGE] = ($this -> getColumnData($data, COLUMN_MESSAGE) != NULL) ? 
                    $this -> getColumnData($data, COLUMN_MESSAGE) : $this -> getColumnData($data, COLUMN_METHOD);
                
                $data[COLUMN_BALANCE] = $this -> formatCurrency($this -> getColumnData($data, COLUMN_BALANCE), $this -> currency);
            }
        }
        
        $result = [
            "row_count" => $rowCount,
            "total_page" => $totalPage,
            "current_page" => $this -> page,
            "start_row" => $start + 1,
            "elapsed_time" => (microtime(true) - $startTime),
            "result" => $fetched,
        ];
        
        echo json_encode($result);    
    }
}


$txn = new TransactionHistory();
$txn -> result();
