<?php
require_once(SITE_LOGICS . 'request/logic.php');

class ControlRequest extends LogicRequest {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		// 変数宣言部
		$result = NO_STRING;

		try {
		    $this -> checkAvailability("site", function(){
		        require_once $this -> getUserHTML('TEMPLATE_MAINTENANCE_MODE_SITE_PATH');
		        exit();
		    });
		    
			// アクション実行
			$result = $this -> logic();

			// 画面の表示
			if($this -> getType() == CONTROL_ACTION) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_ACTION_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_APPLY) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_APPLY_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_SAVE) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_APPLY_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_LIST) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_LIST_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_INPUT) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getAction() == TYPE_LIST
						&& $this -> getType()			== TYPE_DETAIL) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getAction()	== TYPE_LIST
				&& $this -> getType()		== TYPE_REMOVE) {
					require_once($this -> getUserHTML('TEMPLATE_REQUEST_LIST_PATH', $this -> dispHTML()));
			} else if($this -> getAction() == TYPE_APPLY
					&& ($this -> getType() == TYPE_DETAIL
								|| $this -> getType()	== TYPE_BACK)) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_REQUEST_APPLY_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType()	== TYPE_DELETE) {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_LIST_PATH', $this -> dispHTML()));

			} else if($this -> getType()	== TYPE_2FA_DISABLE_ONE) {
				require_once($this -> getUserHTML('TEMPLATE_2FA_DISABLE_RECEIVED', $this -> dispHTML()));

			} else {
				require_once($this -> getUserHTML('TEMPLATE_REQUEST_ACTION_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {

			if($e -> getMessage() != NO_STRING) {
				require_once($this -> getUserHTML('TEMPLATE_TMP_PROCESS_INVALID_PATH', $this -> dispHTML()));
			} else {
				header('Location: /' . $this ->  getLangage() . '/login');
			}
		}
	}
}
?>