<?php
class NewsModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs			= null;			// 結果セット
	private $nId		= NO_COUNT;			// newsId

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		
		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: リストの設定
	 * @parameter	: リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	public function echoList() {
	
		// 変数宣言部
		$rtn			= NO_STRING;

		if($this -> isLoopData($this -> rs)) {
	
			// データの数だけループを回す
			$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
				
			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
	
				$row = $this -> getRowData($this -> rs, $cnt);
	
				$rtn	.= '<dt class="dateN">'
							. '<span>' . $this -> getColumnData($row, COLUMN_NEWS_TITLE) . '</span>'
							. '<time datetime="' . $this -> getColumnData($row, COLUMN_EXPOSE_TIME_TAG) . '">' . $this -> getColumnData($row, COLUMN_EXPOSE_TIME_STR) . '</time>　'
							. '</dt>'
							. '<dd class="bodyN">'
							. $this -> getColumnData($row, COLUMN_NEWS_BODY)
							. '</dd>';
			}
	
		} else {
			$rtn = '<dt>' . $this -> getMessage(INFO, 'I_NO_NEW_NEWS', array()) . '</dt>';
		}
	
		echo $rtn;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 検索条件を取得
	 * @parameter	: なし
	 * @return		: 検索条件
	 -------------------------------------------------------------------------*/
	public function getWhere() {
	
		// 変数宣言部
		$rtn = array();
		$lang = NO_COUNT;
		
		// 言語判定
		if(isset($_SERVER["REQUEST_URI"])) {
			$uri = $_SERVER["REQUEST_URI"];
			$langStrArr = explode(DELIMIT_SLASH, $uri);
			$langStr = $langStrArr[VAL_INT_1];
			
			if($langStr == "ja") {
				$lang = NO_COUNT;
			} else if($langStr == "en") {
				$lang = VAL_INT_1;
			} else if($langStr == "sc"){
				$lang = VAL_INT_2;
			} else if($langStr == "tc"){
				$lang = VAL_INT_3;
			} else if($langStr == "id"){
				$lang = VAL_INT_4;
			}
		}

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// ユーザアカウント
		$rtn[] = $lang;										// 言語
	
		return $rtn;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: ユーザアカウントを取得
	 * @parameter	: なし
	 * @return		: ユーザアカウント
	 -------------------------------------------------------------------------*/
	public function getUserAccount() {
	
		return $this -> getUserData(PARAM_USER_ACCOUNT);	// ユーザアカウント
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {
		
		// 変数宣言部
		$rtn = array();
		
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// ユーザアカウント
		
		return $rtn;
	}

}
?>