<?php
class LoginModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $userId		= NO_STRING;
	private $password	= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> type		= $this -> getDataPost(PARAM_TYPE);
		$this -> userId		= $this -> getDataPost(PARAM_USER_ID);
		$this -> password	= $this -> getDataPost(PARAM_PASSWORD);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

        //check if there is a logged in session
        if($this -> checkSiteUserLogin()) {
			header('Location: /' . $this ->  getLangage() . '/menu');
            exit();
		}

		// 変数宣言部
		$rtn	= true;
		$rs		= null;

		// アクションの確認
		if($this -> getAction() == NO_STRING) {
			return false;
		}

		// ユーザ名のチェックを行う
		$rtn = $this -> vailedateUserId($this -> userId);

		// パスワードのチェックを行う
		$rtn = $this -> vailedatePassword($this -> password);

		// この時点でエラーの場合はスロー
		if(!$rtn) {
			return false;
		}

		// 複合チェックを行う

		// 失敗リストチェック
		if(!$this -> checkLoginFail($this -> userId)) {
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_LOGIN_FAIL_COUNT', array());
			return false;
		}

		// ユーザの存在確認
		$rs = $this -> checkUser($this -> userId, $this -> password);

		if(count($rs) == VAL_INT_1) {

			//二次认证判断
			$accountd_list = $this -> accessSelect('SELECT_2FA_USER_ACCOUNT',array($this -> userId));
			$useraccount = $this -> getColumnData($accountd_list[0],'user_account');

			if (!$this -> get2FaValue(array($useraccount,'login_status','login_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24LOGIN_LOCK', array());
				$this -> setType(TYPE_VERI_ERROR);
				return false;
			}

			// セッションへデータを詰める
			$this -> putSessionUserData($rs);

			// ログイン成功で回数をリセット
			$this -> clearFailCounter($this -> userId);


			$row = $this -> getRowData($rs);

		} else {


			// 認証しているか否か
			if(!$this -> existVerification($this -> userId, $this -> password)) {	// メール未認証
				$this -> setType(TYPE_VERI_ERROR);
				return true;
			}

			$this -> popUpSessionMessage(ERROR, 'E_CAN_NOT_LOGIN', array());

			// 失敗リストの加算
			$this -> incrementFailCounter($this -> userId);

			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザ名のチェックを行う
	* @parameter	: なし
	* @return		: true:成功、false:失敗
	-------------------------------------------------------------------------*/
	private function vailedateUserId($userId) {

		// 変数宣言部
		$rtn = true;

		// ユーザ名のチェック
		if(!$this -> checkNull($userId)) {
			$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_NAME));
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザ名のチェックを行う
	* @parameter	: なし
	* @return		: true:成功、false:失敗
	-------------------------------------------------------------------------*/
	private function vailedatePassword($password) {

		// 変数宣言部
		$rtn = true;

		// ユーザパスワードのチェック
		if(!$this -> checkNull($password)) {
			$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PASSWORD));
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	public function getUserId() {
		return $this -> userId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function getPassword() {
		return $this -> password;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 获取语言
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
    public function getLang()
    {

        // 変数宣言部
        $rtn  = array();
        $lang = NO_COUNT;

        // 言語判定
        if (isset($_SERVER["REQUEST_URI"])) {
            $uri        = $_SERVER['REQUEST_URI'];
            $langStrArr = explode(DELIMIT_SLASH, $uri);
            $lang    = $langStrArr[VAL_INT_1];
        }

        return $lang;
    }
}
?>