<?php
$page_title = "ユーザー取引履歴";
include_once('template/base_head.php');
?>

<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href="account_list"><img src="../img/logo.png" alt="iWallet"></a></h1>
				<form id="searchForm" action="" method="post">
					<input type="hidden" id="detail_account" name="detail_account" value="<?php $this -> echoDetailAccount(); ?>">
					<div class="aside-heading">
						<div class="btns">
							<input type="button" id="btnSearchToday" value="本日" class="btn bg-default px50 hi22">&nbsp;
							<input type="button" id="btnSearch" value="検索" class="btn bg-default px50 hi22">
						</div>
					</div>
					
					<table class="conditions fontS w100p">
						<colgroup>
							<col class="w50p">
							<col class="w50p">
						</colgroup>
						<tr>
							<td>氏名:</td>
							<td><strong><?php $this -> echoAccountInfo("account_name") ?></strong></td>
						</tr>
						<tr>
							<td>ユーザー名:</td>
							<td><strong><?php $this -> echoAccountInfo("user_name") ?></strong></td>
						</tr>
						<tr>
							<td>生年月日:</td>
							<td><strong><?php $this -> echoAccountInfo("birth_string") ?></strong></td>
						</tr>
						<tr>
							<td>口座種別:</td>
							<td><strong><?php $this -> echoAccountInfo("account_type") ?></strong></td>
						</tr>
						<tr>
							<td>ステータス:</td>
							<td><strong><?php $this -> echoAccountInfo("status") ?></strong></td>
						</tr>
						<tr>
							<td>KYC認証:</td>
							<td><strong><?php $this -> echoAccountInfo("kyc_validate_status") ?></strong></td>
						</tr>
						<tr>
							<td>Riskレベル:</td>
							<td><strong><?php $this -> echoAccountInfo("risk_level") ?></strong></td>
						</tr>
						<tr>
							<td>ティアレベル:</td>
							<td><strong><?php $this -> echoAccountInfo("tier_level") ?></strong></td>
						</tr>
						<tr>
							<td>備考欄</td>
							<td><i><?php $this -> echoAccountInfo("note") ?></i></td>
						</tr>
						<tr>
							<td>Risk備考欄</td>
							<td><i><?php $this -> echoAccountInfo("risk") ?></i></td>
						</tr>
					</table>
					
					<hr/>
					
					<table class="conditions fontS w100p">
						<colgroup>
							<col class="w50p">
							<col class="w50p">
						</colgroup>
						<tr>
							<th>取引番号</th>
							<td><input type="text" id="transaction_number" name="transaction_number" value="<?php $this -> echoTransactionNumber(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>メールアドレス</th>
							<td><input type="text" id="s_email" name="s_email" value="<?php $this -> echoSEmail(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>口座番号</th>
							<td><input type="text" id="s_account" name="s_account" value="<?php $this -> echoSUserAccount(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>通貨種別</th>
							<td>
								<select id="s_currency" name="s_currency" class="w100p">
									<option value="">--- すべて ---</option>
									<?php $this -> echoCurrencyList(); ?>
								</select>
							</td>
						</tr>
						<tr>
							<th>取引科目</th>
							<td>
								<select name="transaction_type" id="transaction_type" class="w100p">
									<option value="">--- すべて ---</option>
									<?php $this -> dispTransactionTypeList(); ?>
								</select>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<span class="th">処理日時指定</span>
								<p>
									<input type="text" id="s_from" name="s_from" value="<?php $this -> echoFrom(); ?>" class="px110" placeholder="日付">  -
									  <input type="text" id="s_to" name="s_to" value="<?php $this -> echoTo(); ?>" class="px110" placeholder="日付">
								</p>
							</td>
						</tr>
					</table>
					<p class="calign">
						<input type="button" id="btnExport" value="エクスポート" class="btn bg-grad hi25 px100">
						<input type="button" id="btnBack" value="戻る" class="btn bg-grad hi25 px100">
					</p>
					<input type="hidden" value="" id="s_type" name="type" />
					
					<span style="display:none;" id="file_exporter_prog">
						ファイルをエクスポート中。。。
					</span>
				</form>
			</aside>
			
			<div id="colMain">
				<div class="mainIn">
					<?php include_once('template/base_nav.php'); ?>
					<article>
						<div class="article-heading">
							<h2><?php echo $page_title; ?> 「<?php $this -> echoDetailAccount(); ?>」</h2>	
						</div>
						
						<?php echo $this -> echoTransactionTables() ?>
						
						<?php echo $this -> echoJavascriptLabels() ?>
					</article>
				</div>
			</div>
			
		</div>
		<?php include_once('template/base_foot.php'); ?>
		</div>
		<script src="../js/account_transactions.js"></script>
    	<script src="../js/bootstrap.min.js"></script>
	</body>
</html>