<?php
class DepartmentModelClass extends ModelClassEx {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// 結果セット
	private $adId				= NO_COUNT;		// admin Department ID
	private $name				= NO_STRING;	// タイトル
	private $functionList		= NO_STRING;	// 本文
	private $searchName			= NO_STRING;	// 公開日
	private $searchKey			= NO_STRING;	// 公開日
	
	/**
	 *
	 * anton
	 *
	 */
	private $lang				= NO_STRING;
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> adId		= $this -> getDataPost(PARAM_AD_ID, true);				// newsId
		$this -> name		= $this -> getDataPost(PARAM_NAME, true);		// タイトル
		$this -> functionList = $this -> getDataPost(PARAM_FUNCTIONS, true);
		$this -> searchName = $this -> getDataPost(PARAM_NAME, true);
		$this -> searchKey = ($this -> getDataPost(PARAM_FUNCTION) != NULL)? $this -> getDataPost(PARAM_FUNCTION, true) : array('');
		
		$this -> lang		= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}
		
		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('DLST', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_REGITS) {
			//check access
			if(!$this -> checkAdminUserAccess('DLST', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('DDTL', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_EDIT) {
			//check access
			if(!$this -> checkAdminUserAccess('DDTL', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}


		// 登録時・更新時
		if($this -> getType() == TYPE_COMPLETE || $this -> getType() == TYPE_UPDATE) {

			if(!$this -> checkNull($this -> name)){
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_FIRST_NAME));
				$rtn = false;
			}
			if(!$this -> checkNull($this -> functionList)){
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ACCESS));
				$rtn = false;
			}
			// リストに変更
			if(!$rtn) {
				if($this -> getType() == TYPE_UPDATE){
					$this -> setType(TYPE_EDIT);
					return $rtn;
				}else{
					$this -> setType(TYPE_REGITS);
					return $rtn;
				}
			}

		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		if($this -> getType() == TYPE_SEARCH) {
			$this -> echoSearchList();
		} else {
			if($this -> isLoopData($this -> rs)) {

				// データの数だけループを回す
				$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
				$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
				$listCount	= count($this -> rs);

				for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

					$row = $this -> getRowData($this -> rs, $cnt);

					$rtn	.= '<tr>'
								. '<td>' . $this -> getColumnData($row, COLUMN_NAME) . '</td>'
								. '<td class="blocka"><a href="javascript:actionDetail(' . $this -> getColumnData($row, COLUMN_AD_ID) . ');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
								. '</tr>';
				}

			} else {
				$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
			}

			echo $rtn;
		}

	}

	public function echoSearchList() {
		// 変数宣言部
		$rtn			= NO_STRING;
		$functionIdArray = array_map('intval', $this -> searchKey);
		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);

			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($this -> rs, $cnt);
				$deptFunctionArray = unserialize($this -> getColumnData($row, COLUMN_FUNC_LIST)); // get functions allowed in the department
				$res = array_intersect($functionIdArray, $deptFunctionArray);
				if($res != NULL || $this -> searchName == $this -> getColumnData($row, COLUMN_NAME)){
									$rtn	.= '<tr>'
												. '<td>' . $this -> getColumnData($row, COLUMN_NAME) . '</td>'
												. '<td class="blocka"><a href="javascript:actionDetail(' . $this -> getColumnData($row, COLUMN_AD_ID) . ');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
												. '</tr>';
				}
			}
			if($rtn == NO_STRING){
				$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> name;		// 公開日
		$rtn[] = serialize(array_map('intval', $this -> functionList));

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 更新用のデータを取得
	 * @parameter	: なし
	 * @return		: 更新用データ
	 -------------------------------------------------------------------------*/
	public function getUpdateData() {

		// 変数宣言部
		$rtn = array();

		 $rtn[] = $this -> adId;
		 $rtn[] = $this -> name;		// 公開日
		 $rtn[] = serialize(array_map('intval', $this -> functionList));

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: newsIDの取得
	* @parameter	: なし
	* @return		: newsID
	-------------------------------------------------------------------------*/
	public function getAdId() {
		return $this -> adId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: newsIDの取得
	 * @parameter	: なし
	 * @return		: newsID
	 -------------------------------------------------------------------------*/
	public function echoAdId() {
		echo $this -> adId;
	}



	/*-------------------------------------------------------------------------
	 * @function_name: 登録ボタンの取得
	 * @parameter	: なし
	 * @return		: 登録ボタンタグ
	 -------------------------------------------------------------------------*/
	public function echoButton() {

		$px100 = ($this -> lang != "en" ? "px100" : "");

		if($this -> adId == NO_STRING) {
			echo '<input type="button" id="btnComplete" value="'.VAL_STR_ADMIN_SAVE.'" class="btn bg-grad px100 hi25">';
		} else {
			if($this -> getType() == TYPE_DETAIL){
				echo '<input type="button" id="btnEdit" value="'.VAL_STR_ADMIN_EDEPARTMENT.'" class="btn bg-grad '.$px100.' hi25">&emsp;';
			}else{
				echo '<input type="button" id="btnUpdate" value="'.VAL_STR_ADMIN_SAVE.'" class="btn bg-grad px100 hi25">&emsp;';
			}

		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パラメータの取得
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	public function echoParam() {
		if($this -> adId == NO_STRING) {
			echo '<a id="btnRegist" class="btn bg-default">&laquo; 戻る</a>';
		} else {
			echo '<a id="btnDetail" class="btn bg-default">&laquo; 戻る</a>';
		}
	}

	public function echoDeptName() {
			echo $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_NAME);

	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoFunctionList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$functionList = $this -> accessSelect('LIST_FUNCTION', array());

		$row='';
			$listCount	= count($functionList);
			$checked = '';

			for($cnt = 0; $cnt < $listCount; $cnt++) {
				$category = $this -> getColumnData($row, COLUMN_CATEGORY_NAME);
				$row = $this -> getRowData($functionList, $cnt);

				if($this -> adId == NO_STRING){
					$checked = '';
				} else if (isset($this -> adId)){
					$deptFunctionArray = $this -> getDeptAccess();
					if(in_array($this -> getColumnData($row, COLUMN_FUNC_ID), $deptFunctionArray)){
							$checked = 'checked';
					}else{
						$checked = '';
					}
				}
				if($this -> getColumnData($row, COLUMN_CATEGORY_NAME) == $category){
					$rtn	.= '<tr>'
								. '<td><input type="checkbox" name="functions[]" id="functions" value="'.$this -> getColumnData($row, COLUMN_FUNC_ID).'" '.$checked.'>&emsp;' . $this -> getColumnData($row, COLUMN_FUNC_NAME) . '</td>'
								. '</tr>';

				}else{
					$rtn	.= '<tr>'
								. '<th>' . $this -> getColumnData($row, COLUMN_CATEGORY_NAME) . '</th>'
								. '</tr>';
					$rtn	.= '<tr>'
								. '<td><input type="checkbox" name="functions[]" id="functions" value="'.$this -> getColumnData($row, COLUMN_FUNC_ID).'" '.$checked.'>&emsp;' . $this -> getColumnData($row, COLUMN_FUNC_NAME) . '</td>'
								. '</tr>';
				}

			}


		echo $rtn;
	}
	public function echoDeptFunctionList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$deptFunctionArray = $this -> getDeptAccess(); // get functions allowed in the department

		$param = implode(",",$deptFunctionArray);
		$functionList = $this -> accessSelect('LIST_DEPT_FUNCTION', array($param));
		$disabled = "";
		if($this -> getType() == TYPE_DETAIL){
			$disabled = "disabled";
		}
		if($this -> isLoopData($this -> rs)) {
		$row='';
			$listCount	= count($functionList);

			for($cnt = 0; $cnt < $listCount; $cnt++) {
				$category = $this -> getColumnData($row, COLUMN_CATEGORY_NAME);
				$row = $this -> getRowData($functionList, $cnt);
				if($this -> getColumnData($row, COLUMN_CATEGORY_NAME) == $category){
					$rtn	.= '<tr>'
								. '<td><input type="checkbox" checked = checked name="functions[]" id="functions" value='.$this -> getColumnData($row, COLUMN_FUNC_ID).' '.$disabled.'>&emsp;' . $this -> getColumnData($row, COLUMN_FUNC_NAME) . '</td>'
								. '</tr>';

				}else{
					$rtn	.= '<tr>'
								. '<th>' . $this -> getColumnData($row, COLUMN_CATEGORY_NAME) . '</th>'
								. '</tr>';
					$rtn	.= '<tr>'
								. '<td><input type="checkbox" checked = checked name="functions[]" id="functions" value='.$this -> getColumnData($row, COLUMN_FUNC_ID).' '.$disabled.'>&emsp;' . $this -> getColumnData($row, COLUMN_FUNC_NAME) . '</td>'
								. '</tr>';
				}

			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	public function getDeptAccess(){
		$rtn = unserialize($this -> getColumnData($this -> rs[NO_COUNT], COLUMN_FUNC_LIST));

		return $rtn;
	}

	public function echoDeptMemberList() {

		// 変数宣言部
		$rtn			= NO_STRING;

		$memberList = $this -> accessSelect('LIST_DEPT_USERS', array($this -> adId));

		if($this -> isLoopData($this -> rs)) {
		$row='';
			$listCount	= count($memberList);

			for($cnt = 0; $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($memberList, $cnt);

					$rtn	.= '<tr>'
								. '<td>' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '</td>'
								. '<td>' . $this -> getColumnData($row, COLUMN_LAST_NAME) .' '. $this -> getColumnData($row, COLUMN_FIRST_NAME).'</td>'
								. '<td>' . $this -> getColumnData($row, COLUMN_USER_NAME) . '</td>'
								. '</tr>';


			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}
	public function echoFunctionOptions() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$functionList = $this -> accessSelect('LIST_FUNCTION', array());

		$row='';
			$listCount	= count($functionList);
			$checked = '';

			for($cnt = 0; $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($functionList, $cnt);
					$rtn	.= '<option value='.$this -> getColumnData($row, COLUMN_FUNC_ID).'>'.$this -> getColumnData($row, COLUMN_FUNC_NAME).'</option>';
			}
		echo $rtn;
	}

	function getActivity(){
		$type = $this -> getType();

		//echo serialize(array_map('intval', $this -> functionList));
		// print_r($this -> functionList);
		//die();


		if($type == TYPE_UPDATE){

			$rs 				= $this -> accessSelect('DETAIL_DEPT', array($this -> getAdId()));
			$oldDeptName 		= $this -> getColumnData($rs[0], COLUMN_NAME);
			$newDeptName 		= $this -> name;
			$detail 			= array();

			$oldList = unserialize($this -> getColumnData($rs[NO_COUNT], COLUMN_FUNC_LIST));
			$newList =  $this -> functionList;
			
			if($oldDeptName != $newDeptName){
				$detail[] = 'department name from ['.$oldDeptName.'] to ['.$newDeptName.']';
			}

			if($oldList != $newList){

				$getFunctionName 	= array();
				
				$sameValue	= array_intersect($oldList, $newList);
				$removed	= array_diff($oldList, $sameValue);
				$added		= array_diff($newList, $sameValue);
				$detail[]   = 'Function List';
				
				if((count($removed)) != NO_COUNT){

					foreach ($removed as $value) {
						$fl_id2[] = "fl_id = ".$value;
					}
					$ids2 = implode(' OR ', $fl_id2);
					$rs2 = $this -> accessSelect('SELECT_ADMIN_FUNCTION_VIA_ID', array($ids2));
					$getFunctionNameRemoved = array();
					foreach ($rs2 as $row) {
						$getFunctionNameRemoved[] = $this -> getColumnData($row, COLUMN_NAME);
					}

					$removedFunctions 		= implode(", ", $getFunctionNameRemoved);
					$detail[] 				.= ' removed ['. $removedFunctions.']';

				}

				if((count($added)) != NO_COUNT){

					foreach ($added as $value) {
						$fl_id[] = "fl_id = ".$value;
					}
					$ids = implode(' OR ', $fl_id);
					$rs = $this -> accessSelect('SELECT_ADMIN_FUNCTION_VIA_ID', array($ids));

					$getFunctionNameAdded = array();
					foreach ($rs as $row) {
						$getFunctionNameAdded[] = $this -> getColumnData($row, COLUMN_NAME);
					}

					$addedFunctions 	= implode(", ", $getFunctionNameAdded);
					$detail[] 			.= ' added ['. $addedFunctions.']';

				}

				
			}

			if($detail != NULL){
   				$message = '[Department List] <br> Edited '. $newDeptName .'\'s '. implode(', <br/>', $detail);
   			}else{
   				$message = 'Saved without any changes';
   			}

		}elseif($type == TYPE_COMPLETE){
			$message = 'Created new department '.$this -> name;
		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 23;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}
}
?>
