<?php
require_once(SITE_LOGICS . 'batch/model.php');

class LogicBatch extends BatchModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr	= NO_STRING;	// 表示用HTML文字列
	private $msg		= NO_STRING;	// 表示用HTMLメッセージ
	private $result		= true;			// 実行結果

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		// 変数宣言部

		try {

			// 初期データ処理
			if(!$this -> init()) {
				return false;
			}

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		// データの削除
		$this -> accessModify('DELETE_TOTAL', $this -> getParams(), false);

		// バッチ入金
		$this -> totalDeposit();

		// バッチ出金（申請中）
		$this -> totalWithdrawApply();

		// バッチ出金（その他）
		$this -> totalWithdraw();

		// バッチ口座送金
		$this -> totalTransfer();

		// バッチ手数料
		$this -> totalFee();

		// バッチ両替
		$this -> totalExchange();

		// バッチコミッション
		$this -> totalCommision();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金集計
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalDeposit() {
		$this -> accessModify('INSERT_TOTAL_DEPOSIT', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金集計（申請中）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalWithdrawApply() {
		$this -> accessModify('INSERT_TOTAL_WITHDRAW_APPLY', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金集計（その他）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalWithdraw() {
		$this -> accessModify('INSERT_TOTAL_WITHDRAW', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座間送金集計
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalTransfer() {
		$this -> accessModify('INSERT_TOTAL_TRANSFER', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料集計
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalFee() {
		$this -> accessModify('INSERT_TOTAL_FEE', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨両替集計
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalExchange() {
		$this -> accessModify('INSERT_TOTAL_EXCHANGE', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッション集計
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function totalCommision() {
		$this -> accessModify('INSERT_TOTAL_COMMISION', $this -> getParams(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替バッチの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function transfer() {

		// 変数宣言部
		$batch			= null;
		$rowBatch		= null;
		$detail			= null;
		$rowDetail		= null;
		$errorList		= array();
		$resultCounter	= array();
		$error			= array();
		$params			= null;

		// バッチデータの取得
		$batch = $this -> accessSelect('LIST_TRANSFER_BATCH_PROCESS', array());

		if($this -> isLoopData($batch)) {

			foreach($batch as $rowBatch) {

				// 詳細データの取得
				$detail		= $this -> accessSelect('LIST_TRANSFER_BATCH_DETAIL', array($this -> getColumnData($rowBatch, COLUMN_TRANSACTION_ID)));

				if($this -> isLoopData($detail)) {

					// データがある場合はメール送信用の配列を取得
					$account = $this -> getRowData($detail);

					$this -> getCurrencies($this -> getColumnData($account, COLUMN_FROM_ACCOUNT), $resultCounter);

					foreach($detail as $rowDetail) {

						$account	= $this -> getColumnData($rowDetail, COLUMN_FROM_ACCOUNT);
						$currency	= $this -> getColumnData($rowDetail, COLUMN_TRANSFER_CURRENCY);

						// 口座間送金前のチェックｋ
						$result = $this -> checkTransfer($account
															, $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)
															, $currency
															, $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($rowDetail, COLUMN_DEBIT_CURRENCY))
															, $this -> getColumnData($rowDetail, COLUMN_DEBIT_CURRENCY));


						if($result[PARAM_RESULT] == NO_COUNT) {	// チェックOKだった場合は送金

							// データの挿入
							$this -> accessModify('INSERT_FROM_BATCH_TO_TRANSFER', array($this -> getColumnData($rowDetail, COLUMN_T_ID)), false);

							// 送金元口座情報の取得
							$from = $this -> getRowData($this -> getAccountCommon($this -> getColumnData($rowDetail, COLUMN_FROM_ACCOUNT)));

							// コミッションの集計（送金元）
							$this -> registCommision(VAR_TRANSFER
													, null
													, $account
													, $currency
													, $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_FROM_FEE), $currency));

							// 送金先口座情報の取得
							$from = $this -> getRowData($this -> getAccountCommon($this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)));

							// コミッションの集計（送金先）
							$this -> registCommision(VAR_TRANSFER
													, null
													, $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)
													, $currency
													, $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_TO_FEE), $currency)
													, PARAM_TO);



							// データの削除
							$this -> accessModify('DELETE_TRANSFER_BATCH_DETAIL', array($this -> getColumnData($rowDetail, COLUMN_T_ID)), false);

							// 送金完了メールの送信
							$params = array();
							$params[] = $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT);											// 送金先
							$params[] = $this -> getColumnData($rowDetail, COLUMN_TO_FIRST_NAME)
										. DELIMIT_SPACE . $this -> getColumnData($rowDetail, COLUMN_TO_LAST_NAME);						// 送金先名義
							$params[] = $account;																						// 送金元
							$params[] = $this -> getColumnData($rowDetail, COLUMN_FROM_FIRST_NAME)
										. DELIMIT_SPACE . $this -> getColumnData($rowDetail, COLUMN_FROM_LAST_NAME);					// 送金元名義
							$params[] = $this -> getCurrentTimeCommon();																// 処理日時
							$params[] = $currency;																						// 通貨
							$params[] = $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT), $currency);		// 送金金額
							$params[] = $currency;																						// 手数料通貨
							$params[] = $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_TO_FEE), $currency);			// 手数料金額
							$params[] = $this -> getColumnData($rowDetail, COLUMN_MESSAGE);												// メッセージ
							$params[] = $this -> getColumnData($rowDetail, COLUMN_TRANSACTION_NUMBER);									// 取引番号

// echo $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT) . ' => transfer_receive_user.xml<br/>';
							// 送金先へ通知
							$this -> sendMailByTmpAndWL($this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)
														, 'transfer_receive_user.xml'
														, $params
														, NO_STRING
														, 'cs@');

							// 成功件数のインクリメント
							$resultCounter[$account][PARAM_SUCCESS][$currency][PARAM_COUNTER]	+= VAL_INT_1;
							$resultCounter[$account][PARAM_SUCCESS][$currency][PARAM_AMOUNT]	+= $this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT);

						} else {								// エラーだった場合はエラーファイルの削除

							// データの削除
							$this -> accessModify('DELETE_TRANSFER_BATCH_DETAIL', array($this -> getColumnData($rowDetail, COLUMN_T_ID)), false);

							$errorList[] = implode(DELIMIT_COMMA, $rowDetail);

							// 失敗件数のインクリメント
							$resultCounter[$account][PARAM_NG][$currency][PARAM_COUNTER]	+= VAL_INT_1;
							$resultCounter[$account][PARAM_NG][$currency][PARAM_AMOUNT]		+= $this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT);
						}
					}

					// エラーがあった場合はエラーファイルの作成
					if($this -> isLoopData($errorList)) {

						$fileName	= $this -> getColumnData($rowBatch, COLUMN_TRANSACTION_ID) . '_err.csv';
						$path		= SYSTEM_DOCUMENT_TRANSFER . $fileName;

						// ファイルのロード
						$file = fopen($path, 'w+');

						$csv = implode("\n", $errorList);
						fwrite($file, $csv . "\n");

						fclose($file);

						// エラーファイルの更新
						$this -> accessModify('UPDATE_TRANSFER_BATCH_ERROR_FILE', array($this -> getColumnData($rowBatch, COLUMN_TRANSACTION_ID), $fileName), false);
					}

					// エラーリストの初期化
					$errorList = array();
				}
			}

			// メールを送信する（送金者、管理者）
			if($this -> isLoopData($resultCounter)) {

				foreach($resultCounter as $key => $val) {

					// 変数宣言部
					$suc = NO_STRING;
					$err = NO_STRING;

					// ユーザデータを取得する
					$account = $this -> getAccountCommon($key);
					$account = $this -> getRowData($account);

					$params = array();
					$params[] = $account[PARAM_USER_ACCOUNT];					// 口座名義
					$params[] = $account[PARAM_FIRST_NAME]
								. DELIMIT_SPACE . $account[PARAM_LAST_NAME];	// 氏名
					$params[] = $this -> getCurrentTimeCommon();				// 処理日時


					// 成功の一覧
					foreach($val[PARAM_SUCCESS] as $cur => $success) {
						$suc .=	'出金通貨計：' . $cur
								. DELIMIT_SPACE . $this -> intToCurrency($success[PARAM_AMOUNT], $cur)
								. DELIMIT_SPACE . number_format($success[PARAM_COUNTER]) . '件' . "\n";
					}

					// 失敗の一覧
					foreach($val[PARAM_NG] as $cur => $error) {
						$err .=	'出金通貨計：' . $cur
								. DELIMIT_SPACE . $this -> intToCurrency($error[PARAM_AMOUNT], $cur)
								. DELIMIT_SPACE . number_format($error[PARAM_COUNTER]) . '件' . "\n";

					}

					$params[] = $suc;								// 成功データ
					$params[] = $err;								// 失敗データ

					// 管理者へ通知
					$this -> sendMailByTmp('batchtransfer_admin.xml'
											, $params
											, VAR_NOTICE_MAIL_ADDRESS
											, VAR_NOTICE_MAIL_ADDRESS);
// echo $account[PARAM_USER_ACCOUNT] . ' => batchtransfer_corporate.xml<br/> ';
					// 送金者へ通知
					$this -> sendMailByTmpAndWL($account[PARAM_USER_ACCOUNT]
												, 'batchtransfer_corporate.xml'
												, $params
												, $this -> getColumnData($account, COLUMN_MAIL)
												, 'merchant@');
				}
			}
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: メール送信用の通貨リストの取得
	* @parameter	: なし
	* @return		: デフォルト通貨データ
	-------------------------------------------------------------------------*/
	function getCurrencies($account, &$resultCounter) {

		// 変数宣言部
		$currenies	= $this -> getCurrencyList();
		$suc		= array();
		$err		= array();

		if($this -> isLoopData($currenies)) {

			foreach($currenies as $cur) {
				$suc[$cur[PARAM_DATA_KEY]]	= array(PARAM_COUNTER => NO_COUNT, PARAM_AMOUNT => NO_COUNT);
				$err[$cur[PARAM_DATA_KEY]]	= array(PARAM_COUNTER => NO_COUNT, PARAM_AMOUNT => NO_COUNT);
			}

			$resultCounter[$account][PARAM_SUCCESS]	= $suc;
			$resultCounter[$account][PARAM_NG]		= $err;
		}
	}
	/*-------------------------------------------------------------------------
	 * @function_name	: 月額維持費バッチの実行
	 * @parameter		: なし
	 * @return			: なし
	 -------------------------------------------------------------------------*/
	function monthlyFee() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$rs			= null;
		$balances	= null;
		$fee		= null;
		$account	= NO_STRING;
		$balance	= NO_STRING;
		$remaining	= NO_STRING;
		$feeInt		= NO_COUNT;

		// 対象者の取得
		$rs = $this -> accessSelect('LIST_ACCOUNTS', array(' AND data.status > (\')1(\') AND data.account_type = (\')1(\')', NO_STRING, NO_STRING));
		
		
		// データの存在確認
		if($this -> isLoopData($rs)) {

			// 月額維持費の徴収
			foreach($rs as $row) {

				// 口座番号の取得
				$account = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);

				// 維持費を取得する
				$fee = $this -> getFeeCommon(VAR_MONTHLY, NO_COUNT, USD, $account);

				// USD手数料
				$feeInt = $this -> currencyToInt($this -> getColumnData($fee, USD . VAL_INT_1), USD);

				// 手数料が無い人は、飛ばす
				if($feeInt == NO_COUNT) {
					continue;
				}


				// ユーザの残高を取得する
				$balances = $this -> getBalanceListCommon($account);
				
				if($this -> isLoopData($balances)) {

					// まずは、USD優先
					if(isset($balances[USD])) {

						// USD口座で賄えた場合
						if($feeInt <= $balances[USD]) {

							// 出金処理
							$this -> monthlyWithdraw($account, USD, $feeInt);

							continue;

						} else {

							// 出金処理
							$this -> monthlyWithdraw($account, USD, $balances[USD]);
							$feeInt -= $balances[USD];
						}

						unset($balances[USD]);
					}


					$zeroDecimalCurrencies = $this -> getZeroDecimalCurrenciesCommon();
					// Loop until maintenance costs are gone
					foreach($balances as $currency => $balance) {

						// Money exchange
						$exchange	= $this -> getExchangeCommon($balance, $currency, USD, true, false);

						if(in_array($currency,$zeroDecimalCurrencies)){
							$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT)*100);
						}else{
							$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT));
						}

						// 相殺できてるか
						if($feeInt <= $remaining) {

							$exchange	= $this -> getExchangeCommon($feeInt, USD, $currency,true, true);
							if(in_array($currency,$zeroDecimalCurrencies)){

								$feeval		= floor($this -> getColumnData($exchange, PARAM_AMOUNT)/100);
							}else{

								$feeval		= floor($this -> getColumnData($exchange, PARAM_AMOUNT));
							}

							// 出金処理
							$this -> monthlyWithdraw($account, $currency, $feeval);
							break;

						} else {

							// 出金処理
							$this -> monthlyWithdraw($account, $currency, $balance);
							$feeInt -= $remaining;
						}

						// 手数料が無くなったら終了
						if($feeInt <= NO_COUNT) {
							break;
						}
					}
				}
			}
		}

		echo "run end！";
	}
	
   /*-------------------------------------------------------------------------
	* @function_name: メール送信用の通貨リストの取得
	* @parameter	: 口座番号、通貨、金額
	* @return		: デフォルト通貨データ
	 -------------------------------------------------------------------------*/
	function monthlyWithdraw($account, $currency, $amount) {
		
		$this -> registFeeCommon($account
										, $currency
										, $this -> intToCurrency($amount, $currency)
										, 'Monthly Maintenance'
										, VAL_INT_2
										);
	}


	function autostop() {
		// 変数宣言部
		$rtn			= NO_STRING;
		$rs				= null;
		$rsExchange 	= null;
		$rsDeposit 		= null;
		$rsWithDraw		= null;
		$rsTransfer 	= null;
		$rsRequest 		= null;
		$rsSep 			= null;
		$balances		= null;
		$fee			= null;
		$balanceAll 	= null;
		$account		= NO_STRING;
		$balance		= NO_STRING;
		$remaining		= NO_STRING;
		$feeInt			= NO_COUNT;
		$date 			= date("Y-m-d");
		$dateLimit 		= date("Y-m-d",strtotime("-180 day"));
		$date90Limit	= date("Y-m-d",strtotime("-90 day"));
		$dateYear 		= date("Y-m-d",strtotime("-1 year"));
		$arrRtn 		= array();
		$date2 			= date("m/d/Y");

		// 対象者の取得
		$rs = $this -> accessSelect('LIST_ACCOUNTS', array(' AND ((data.status = (\')1(\') And data.create_time <=(\')'.$date90Limit.'(\')) Or (data.status = (\')2(\') AND data.create_time <=(\')'.$dateLimit.'(\') ) Or (data.status = (\')3(\') And data.create_time <=(\')'.$dateLimit.'(\'))) AND data.account_type = (\')0(\')', NO_STRING, NO_STRING));
		

		// データの存在確認

		if($this -> isLoopData($rs)) {
			$arrRtn = array();
			foreach($rs as $row){
				// 口座番号の取得
				$account 		= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
				$accountStatus 	= $this -> getColumnData($row, COLUMN_STATUS);
				$accountMail 	= $this -> getColumnData($row, COLUMN_MAIL);
				$message 		= $this -> getColumnData($row, COLUMN_NOTE);

				if($accountStatus == 1){
					$rsDeposit		= $this -> accessSelect('LIST_DEPOSIT',array(' And deposit.create_time >= "'.$date90Limit.'" And deposit.user_account="'.$account.'"'));
					$rsExchange		= $this -> accessSelect('LIST_EXCHANGE',array(' And exchange.create_time >= "'.$date90Limit.'" And exchange.user_account="'.$account.'"'));
					$rsWithDraw		= $this -> accessSelect('LIST_WITHDRAW',array(' And withdraw.create_time >= "'.$date90Limit.'" And withdraw.user_account="'.$account.'"'));
					$rsTransfer		= $this -> accessSelect('LIST_TRANSFER_SIMPLE',array(' And transfer.create_time >= "'.$date90Limit.'" And (transfer.from_account="'.$account.'" Ortransfer.to_account="'.$account.'") '));
					$rsRequest		= $this -> accessSelect('LIST_REQUEST',array(' And request.create_time >= "'.$date90Limit.'" And request.from_account="'.$account.'" And request.status="1"'));
				}else{
					$rsDeposit		= $this -> accessSelect('LIST_DEPOSIT',array(' And deposit.create_time >= "'.$dateLimit.'" And deposit.user_account="'.$account.'"'));
					$rsExchange		= $this -> accessSelect('LIST_EXCHANGE',array(' And exchange.create_time >= "'.$dateLimit.'" And exchange.user_account="'.$account.'"'));
					$rsWithDraw		= $this -> accessSelect('LIST_WITHDRAW',array(' And withdraw.create_time >= "'.$dateLimit.'" And withdraw.user_account="'.$account.'"'));
					$rsTransfer		= $this -> accessSelect('LIST_TRANSFER_SIMPLE',array(' And transfer.create_time >= "'.$dateLimit.'" And (transfer.from_account="'.$account.'" Ortransfer.to_account="'.$account.'") '));
					$rsRequest		= $this -> accessSelect('LIST_REQUEST',array(' And request.create_time >= "'.$dateLimit.'" And request.from_account="'.$account.'" And request.status="1"'));
				}
								
				//如果所有的结果都为空，说明180天内没有交易，则查询在1年前有没有扣费行为
				if(empty($rsDeposit) && empty($rsExchange)&& empty($rsWithDraw)&& empty($rsTransfer)&& empty($rsRequest)){
					
					$rsSep = $this -> accessSelect('SELECT_DOMANT_BY_USER', array($account,' And create_time > (\')'.$dateYear.'(\')'));
					
					//搜索结果，如果为空，说明1年内没有扣费行为，可以扣费
					if(empty($rsSep)){
						// 維持費を取得する
						$fee = $this -> getFeeCommon(VAR_DOMANT, NO_COUNT, USD, $account);
						// USD手数料
						$feeInt = $this -> currencyToInt($this -> getColumnData($fee, USD . VAL_INT_1), USD);
	
						// 手数料が無い人は、飛ばす
						if($feeInt == NO_COUNT) {
							continue;
						}
						
						// ユーザの残高を取得する
						$balances = $this -> getBalanceListCommon($account);
						
						if($this -> isLoopData($balances)) {
							$balanceAll	= null;
							$zeroDecimalCurrencies = $this -> getZeroDecimalCurrenciesCommon();
							// まずは、USD優先
							foreach($balances as $currency => $balance){
								$exchange	= $this -> getExchangeCommon($balance, $currency, USD, true, false);

								if(in_array($currency,$zeroDecimalCurrencies)){
									$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT)*100);
								}else{
									$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT));
								}
								$balanceAll += $remaining;
							}
							
							$balanceAll	= null;
							
							
							// まずは、USD優先
							foreach($balances as $currency => $balance){
								$exchange	= $this -> getExchangeCommon($balance, $currency, USD, true, false);

								if(in_array($currency,$zeroDecimalCurrencies)){
									$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT)*100);
								}else{
									$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT));
								}
								$balanceAll += $remaining;
							}
							

							if($balanceAll < $feeInt){
								
								$params = array();
								$this -> sendMailByTmpAndWL($account
													, 'suspension_for_user.xml'
													, $params
													, $this -> getColumnData($account, COLUMN_MAIL)
													, 'merchant@');

								$arrTmp   = array();
								$arrTmp[] = $account;
								$arrTmp[] = $accountStatus;
								$arrRtn[] = $arrTmp;
								$message  .= "\r\n".$date2.' Inactive - Bulk Suspended'; 
								$this -> accessModify('UPDATE_DOMANT_BY_USER',array($account,$message));
								
								
								continue;
							}

							if(isset($balances[USD])) {
								// USD口座で賄えた場合
								if($feeInt <= $balances[USD]) {
									// 出金処理
									$this -> DomantWithdraw($account, USD, $feeInt);
									continue;
								} else {
									// 出金処理
									$this -> DomantWithdraw($account, USD, $balances[USD]);
									$feeInt -= $balances[USD];
								}
								unset($balances[USD]);
							}
							
							// 維持費がなくなるまで、ループ
							foreach($balances as $currency => $balance) {
								// 両替
								$exchange	= $this -> getExchangeCommon($balance, $currency, USD, true, false);

								if(in_array($currency,$zeroDecimalCurrencies)){
									$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT)*100);
								}else{
									$remaining	= floor($this -> getColumnData($exchange, PARAM_AMOUNT));
								}

								// 相殺できてるか
								if($feeInt <= $remaining) {
									$exchange	= $this -> getExchangeCommon($feeInt, USD, $currency,true, true);
									if(in_array($currency,$zeroDecimalCurrencies)){
										$feeval		= floor($this -> getColumnData($exchange, PARAM_AMOUNT)/100);
									}else{
										$feeval		= floor($this -> getColumnData($exchange, PARAM_AMOUNT));
									}

									// 出金処理
									$this -> DomantWithdraw($account, $currency, $feeval);
									break;
								} else {
									// 出金処理
									$this -> DomantWithdraw($account, $currency, $balance);
									$feeInt -= $remaining;
								}

								// 手数料が無くなったら終了
								if($feeInt <= NO_COUNT) {
									break;
								}
							}
						}else{
							
							$params = array();
							$this -> sendMailByTmpAndWL($account
												, 'suspension_for_user.xml'
												, $params
												, $this -> getColumnData($account, COLUMN_MAIL)
												, 'merchant@');
							$arrTmp   = array();
							$arrTmp[] = $account;
							$arrTmp[] = $accountStatus;
							$arrRtn[] = $arrTmp;
							$message  .= "\r\n".$date2.' Inactive - Bulk Suspended';
							$this -> accessModify('UPDATE_DOMANT_BY_USER',array($account,$message));
							
							
						}
					}
				}
			}
		}
		
		echo "变更的账户：<br>";
		foreach($arrRtn as $val){
			echo $val[0].'----'.$val[1];
			echo "<br>";
		}
	}



	/*-------------------------------------------------------------------------
	* @function_name: メール送信用の通貨リストの取得
	* @parameter	: 口座番号、通貨、金額
	* @return		: デフォルト通貨データ
	 -------------------------------------------------------------------------*/
	function DomantWithdraw($account, $currency, $amount) {
		$date = date("m/d/Y");
		$this -> registDomantCommon($account
										, $currency
										, $this -> intToCurrency($amount, $currency)
										, VAL_INT_11
										, $date.' Inactive - Bulk Suspended'
										, VAL_INT_2
										);
	}
	//ClassEnd
}
?>