<?php
include "../../system/lib/config.php";

class FrameworkTest extends System {
    public function __construct(){
        parent::__construct();
    }
    
    public function checkRemoteAddress(){
        $devSetting = $this -> getRowData($this -> accessSelect("SELECT_DEV_SETTING", ["tester_tool_conf"]));
        
        if($this -> isLoopData($devSetting)){
            if(!$this -> getColumnData($devSetting, "dev_setting_enabled"))
                return true;
            
            if($this -> checkJSONString($this -> getColumnData($devSetting, "dev_setting_value"))){
                $devSetting = json_decode($this -> getColumnData($devSetting, "dev_setting_value"));
                
                $ipAddresses    = explode(",", $devSetting -> ip_address);
                $remoteAddress  = $this -> getColumnData($_SERVER, "REMOTE_ADDR");                

                if(in_array($remoteAddress, $ipAddresses))
                    return true;
            }
        }
        
        return false;
    }
}