<?php
class HtmlBuilder extends DBAccess {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $pagerFlg	= false;

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数群コンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {

		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: リストのオプション部HTML文字列を取得する
	* @parameter	: 表示配列、初期値
	* @return		: 表示用HTML文字列
	------------------------------------------------------------------------*/
	public function dispListOption($list, $selected) {

		// 変数宣言部
		$rtn 		= NO_STRING;
		$selectStr	= NO_STRING;

		foreach($list as $val) {

			// 選択データの場合選択する
			if($selected == NO_STRING) {					// 選択が空文字の場合
				$selectStr = NO_STRING;
			} else if($val[PARAM_DATA_KEY] == $selected) {	// 選択が一致した場合
				$selectStr = 'selected="selected"';
			} else {										// その他
				$selectStr = NO_STRING;
			}

			$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . '>' . $val[PARAM_DATA_VALUE] . '</option>';
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータスを取得する
	* @parameter	: 選択値、フラグ（true:未選択を挿入、false:未選択は挿入しない）
	* @return		: 表示用HTML文字列
	------------------------------------------------------------------------*/
	public function dispWithdrawStatusOptionList($selected, $flg = true) {

		// 変数宣言部
		$status	= null;
		$option		=  NO_STRING;

		// 国一覧の取得
		$status = $this -> getWithdrawStatusList();

		// データの取得
		$option = $this -> dispListOption($status, $selected);

		// フラグの確認
		if($flg) {

			// 空データの追加
			$option = '<option value=""></option>' . $option;
		}

		// 表示用のリストの作成
		return $option;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国一覧を取得する
	* @parameter	: 選択値、フラグ（true:未選択を挿入、false:未選択は挿入しない）
	* @return		: 表示用HTML文字列
	------------------------------------------------------------------------*/
	public function dispCountryOptionList($selected, $flg = true) {

		// 変数宣言部
		$countries	= null;
		$option		=  NO_STRING;

		// 国一覧の取得
		$countries = $this -> getCountyList();	
		$account_nums = [
		    "42156169"
		];
		
		if(in_array($this -> getUserData(PARAM_USER_ACCOUNT), $account_nums)){
		    $countries[] = [
		        PARAM_DATA_KEY => "US",
		        PARAM_DATA_VALUE => "United States of America"
		    ];
		    
		    uasort($countries, function($a, $b) {
		        return strcmp($a[PARAM_DATA_VALUE], $b[PARAM_DATA_VALUE]);
		    });
		}    
		    
		// データの取得
		$option = $this -> dispListOption($countries, $selected);

		// フラグの確認
		if($flg) {

			// 空データの追加
			$option = '<option value=""></option>' . $option;
		}

		// 表示用のリストの作成
		return $option;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨一覧を取得する
	* @parameter	: 選択値、フラグ（true:未選択を挿入、false:未選択は挿入しない）
	* @return		: 表示用HTML文字列
	------------------------------------------------------------------------*/
	public function dispCurrencyOptionList($selected, $flg = true) {

		// 変数宣言部
		$currencies	= null;
		$option		=  NO_STRING;

		// 国一覧の取得
		$currencies = $this -> getCurrencyList();

		// データの取得
		$option = $this -> dispListOption($currencies, $selected);

		// フラグの確認
		if($flg) {

			// 空データの追加
			$option = '<option value=""></option>' . $option;
		}

		// 表示用のリストの作成
		return $option;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別を取得する
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	------------------------------------------------------------------------*/
	public function dispAccountTypeList($selected) {

		// 表示用のリストの作成
		return $this -> dispListOption($this -> getAccountTypeList(), $selected);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）リストを取得する
	* @parameter	: 選択値
	* @return		: 生年月日（年）リスト
	------------------------------------------------------------------------*/
	public function dispBirthYearList($selected = NO_STRING) {

		// 変数宣言部
		$date = getdate();

		echo $this -> dispListOption($this -> makeNumberList($date[PARAM_YEAR] - VAR_BIRTH_YEAR_START, $date[PARAM_YEAR] - VAR_BIRTH_YEAR_END), $selected);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）リストを取得する
	* @parameter	: 選択値
	* @return		: 生年月日（月）リスト
	------------------------------------------------------------------------*/
	public function dispBirthMonthList($selected = NO_STRING) {
		echo $this -> dispListOption($this -> makeNumberList(VAR_BIRTH_MONTH_START, VAR_BIRTH_MONTH_END), $selected);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）リストを取得する
	* @parameter	: 選択値
	* @return		: 生年月日（日）リスト
	------------------------------------------------------------------------*/
	public function dispBirthDayList($selected = NO_STRING) {
		echo $this -> dispListOption($this -> makeNumberList(VAR_BIRTH_DAY_START, VAR_BIRTH_DAY_END), $selected);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 数字リストを作成する
	* @parameter	: 始まり、終わり
	* @return		: 数字リスト
	------------------------------------------------------------------------*/
	public function makeNumberList($start
									, $end
									, $digit = VAL_INT_2) {

		// 変数宣言部
		$rtn	= array();
		$cnt	= NO_COUNT;

		if($end == NO_COUNT
			|| $start > $end) {
			return $rtn;
		}

		for($cnt = $start; $cnt <= $end; $cnt++) {
			$rtn[] = array(PARAM_DATA_KEY		=> $cnt
							, PARAM_DATA_VALUE	=> sprintf('%0' . VAL_INT_2 . 'd', $cnt));
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ラジオボタンを作成する（グループ）
	* @parameter	: ID、ネーム、値、チェック確認
	* @return		: 数字リスト
	------------------------------------------------------------------------*/
	public function makeRadio($name
								, $list
								, $checked
								, $onChange = NO_STRING) {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> isLoopData($list)) {

			foreach($list as $row) {

				// IDの取得
				$id = $this -> getColumnData($row, PARAM_DATA_KEY);

				$rtn .= $this -> makeRadioOne($name .  $id
												, $name
												, $this -> getColumnData($row, PARAM_DATA_KEY)
												, $checked
												, $onChange) . $this -> getColumnData($row, PARAM_DATA_VALUE) . '&emsp;';
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ラジオボタンを作成する（1コマ）
	* @parameter	: ID、ネーム、値、チェック確認
	* @return		: 数字リスト
	------------------------------------------------------------------------*/
	public function makeRadioOne($id
								, $name
								, $value
								, $checked
								, $onChange = NO_STRING) {

		// 変数宣言部
		$rtn			= NO_STRING;
		$checkedStr		= NO_STRING;
		$changeEvent	= NO_STRING;

		if($value == $checked) {
			$checkedStr = 'checked="checked"';
		} else if($value 		=== NO_COUNT
					&& $checked	=== NO_STRING) {
			$checkedStr = 'checked="checked"';
		}

		if($onChange != NO_STRING) {
			$changeEvent = 'onchange="' . $onChange . '"';
		}

		$rtn = '<input type="radio" id="' . $id . '" name="' . $name . '"  value="' . $value . '" ' . $checkedStr . ' ' . $changeEvent . '/>';

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: チェックボックスを作成する（1コマ）
	* @parameter	: ID、ネーム、値、表示文字列、チェック確認
	* @return		: 数字リスト
	------------------------------------------------------------------------*/
	public function makeCheckOne($id
								, $name
								, $value
								, $disp
								, $checked
								, $script = NO_STRING) {

		// 変数宣言部
		$rtn			= NO_STRING;
		$checkedStr		= NO_STRING;
		$changeEvent	= NO_STRING;

		if($value == $checked) {
			$checkedStr = 'checked="checked"';
		} else if($value	=== NO_COUNT
				&& $checked	=== NO_STRING) {
			$checkedStr = 'checked="checked"';
		}

		if($script != NO_STRING) {
			$changeEvent = 'onchange="' . $script . '"';
		}

		$rtn = '<input type="checkbox" id="' . $id . '" name="' . $name . '"  value="' . $value . '" ' . $checkedStr . ' ' . $changeEvent . '/>' . $disp;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャを取得する
	* @parameter	: 現在ページ、合計ページ、合計件数、リンク先
	* @return		: 表示ようHTML文字列
	------------------------------------------------------------------------*/
	public function getPagerCommonCore($curPage
										, $totalPage
										, $num
										, $toLink = NO_STRING
										, $export = false) {

		// 変数宣言部
		$rtn		= NO_STRING;
		$id			= NO_STRING;
		$btn		= NO_STRING;
		$btnExport	= NO_STRING;
		$dispExport	= NO_STRING;

		// classの指定
		if(!$this -> pagerFlg) {
			$this -> pagerFlg = true;
			$btn		= 'btnMovePageHigh';
			$id			= 'move_page_high';
			$btnExport	= 'btnExportCommonHigh';
		} else {
			$btn		= 'btnMovePageLow';
			$id			= 'move_page_low';
			$btnExport	= 'btnExportCommonLow';
		}

		// 編集した -- anton
		$lang = $this -> getLangage();
		$prev = ($lang == "en" ? "Previous Page" : "前ページ");
		$next = ($lang == "en" ? "Next Page" : "次ページ");
		$show = ($lang == "en" ? "Display" : "表示"); // ひょうじ
		$page = ($lang == "en" ? "Page " : "ページ ");
		$searchResults = ($lang == "en" ? "Search Results" : "検索結果");
		$exportLabel = ($lang == "en" ? "Export" : "エクスポート");
		
		// 編集した -- anton
		// エクスポートボタンの表示・非表示の切り替え
		if($export) {
			$dispExport = '<input type="button" id="' . $btnExport . '" name="btnExportCommon" value="'.$exportLabel.'" class="btn bg-default '
					.($lang == "en" ? "px60" : "").' hi22">';
		}
		
		$rtn =	'<div class="pager">'
				. $searchResults.' ' . number_format($num) . '&emsp;'
				. $page . number_format($curPage) . ' / ' . number_format($totalPage) . '&emsp;'
				. '<input type="text" id="' . $id . '" name="move_page" value="' . $curPage . '" class="px30 ralign">&nbsp;'
				. '<input type="button" id="' . $btn . '" value="'.$show.'" class="btn bg-default px60 hi22" onclick="movePageEx();">&emsp;';

				if($curPage == VAL_INT_1) {		// 前ページが存在しない
					$rtn .= '<input type="button" value="'.$prev.'" class="btn bg-default px90 hi22">&nbsp;';
				} else {						// 前ページが存在する
					$rtn .= '<input type="button" onclick="movePage(\'' . ($curPage - VAL_INT_1) . '\');" value="'.$prev.'" class="btn bg-default px90 hi22">&nbsp;';
				}

				if($curPage == $totalPage) {	// 次ページが存在しない
					$rtn .= '<input type="button" name="" value="'.$next.'" class="btn bg-default px90 hi22">&emsp;';
				} else {						// 次ページが存在する
					$rtn .= '<input type="button" onclick="movePage(\'' . ($curPage + VAL_INT_1) . '\');" value="'.$next.'" class="btn bg-default px90 hi22">&emsp;';
				}

		$rtn .=	$dispExport
				. '<input type="hidden" id="total_page" value="' . $totalPage . '" />'
				. '</div>';

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 結果セットのデータを取得する
	* @parameter	: 1行データ、カラム名
	* @return		: データ
	-------------------------------------------------------------------------*/
	function getColumnData($row, $key) {

		// 変数宣言部
		$rtn = NO_STRING;

		if(is_array($row)
			&& isset($row[$key])) {
			$rtn = $row[$key];
		}

		return $rtn;
	}

	public function dispTierOptionList($selected, $flg = true) {

		// 変数宣言部
		$status	= null;
		$option		=  NO_STRING;

		// 国一覧の取得
		$status = $this -> getTierStatusList();

		// データの取得
		$option = $this -> dispListOption($status, $selected);

		// フラグの確認
		if($flg) {

			// 空データの追加
			$option = '<option value=""></option>' . $option;
		}

		// 表示用のリストの作成
		return $option;
	}
}
?>