
<?php
require_once('config.php');
require_once('CheckUserPasswordBase.php');

class APIUserPasswordChange extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $account	= NO_STRING;
	private $password	= NO_STRING;
	private $user		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature	= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account	= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> password	= $this -> getDataPost(PARAM_PASSWORD);

			// シグネチャの確認
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'L' . $this -> account);
			}

			// エラーチェック
			$base = new APICheckPasswordBase();
			$base -> action();

			// パスワードの更新
			if($this -> accessModify('UPDATE_USER_PASSWORD', array($this -> getColumnData($this -> user, COLUMN_USER_NAME), $this -> password), false)) {

				// メール送信用のパラメータ設定
				$params[] = $this -> account;							// 口座番号
				$params[] = $this -> getNameCommon($this -> account);	// お客様名

				// パスワード変更完了メール（ユーザ側）
				$this -> sendMailById('change_password_complete.xml'
										, $params
										, $this -> account
										, VAR_CS_MAIL_ADDRESS);
			}

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {}
}

$api = new APIUserPasswordChange();
$api -> action();
?>