<?php
require_once('config.php');

class APICheckExchangeBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $amount			= NO_STRING;
	private $amountType		= NO_STRING;
	private $fromCurrency	= NO_STRING;
	private $toCurrency		= NO_STRING;
	private $exAmount		= NO_STRING;
	private $fromAmount		= NO_STRING;
	private $toAmount		= NO_STRING;
	private $rate			= NO_STRING;
	private $originalAmount	= NO_STRING;
	private $fromBalance	= NO_STRING;
	private $toBalance		= NO_STRING;
	private $exAmoun		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> amount			= $this -> getDataPost(PARAM_AMOUNT);
			$this -> amountType		= $this -> getDataPost(PARAM_AMOUNT_TYPE);
			$this -> fromCurrency	= strtoupper($this -> getDataPost(PARAM_FROM));
			$this -> toCurrency		= strtoupper($this -> getDataPost(PARAM_TO));

			// エラーチェック
			$this -> validate();

			return true;

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs			= array();
		$fromCurrency	= NO_STRING;
		$toCurrency		= NO_STRING;
		$divFlg			= NO_STRING;
		$check			= NO_STRING;
		$digit			= NO_STRING;

		try {

			// 口座の存在確認
			$account = $this -> getAccountCommon($this -> account);

			if(count($account) == NO_COUNT) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 口座ステータスチェック
			if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_EXCHANGE)) {
				throw new Exception('E_INVALID_ACCOUNT_STATUS');
			}

			// 入力チェック
			if(!$this -> checkNull($this -> amount)) {
				throw new Exception('E_DO_NOT_INPUT');
			}

			// 通貨同一チェック
			if($this -> toCurrency == $this -> fromCurrency) {
				throw new Exception('E_ERROR_SAME_CURRENCY');
			}

			// 数値の正規表現
			if(!$this -> checkStringNumber($this -> amount)) {
				throw new Exception('E_ERROR_REGULAR_NUMBER');
			}

			// 数値のマイナスチェック
			if($this -> amount <= NO_COUNT) {
				throw new Exception('E_ERROR_VALUE');
			}

			// 変換通貨の取得
			if($this -> amountType == NO_COUNT) {

				$fromCurrency	= $this -> fromCurrency;
				$toCurrency		= $this -> toCurrency;

			} else {
				$fromCurrency	= $this -> toCurrency;
				$toCurrency		= $this -> fromCurrency;
				$divFlg			= true;
			}

			// 最低値と最高値の設定
			if(!$this -> checkRangeCurrency($this -> amount
											, $fromCurrency
											, NO_COUNT
											, 9999999)) {
				throw new Exception('E_ERROR_AMOUNT');
			}

			// レートの取得
			$exc = $this -> getExchangeCommon($this -> amount
											, $fromCurrency
											, $toCurrency
											, true
											, $divFlg);

			// 変換後の金額
			// チェック用のデータ
			if($this -> amountType == NO_COUNT) {	// 引き落とし口座
				$check				= $this -> amount;
				$this -> exAmount	= $exc[PARAM_AMOUNT];
				$this -> fromAmount	= $this -> amount;
				$this -> toAmount	= $exc[PARAM_AMOUNT];

			} else {								// 入金口座
				$check				= $exc[PARAM_AMOUNT];
				$this -> exAmount	= $this -> amount;
				$this -> fromAmount	= $exc[PARAM_AMOUNT];
				$this -> toAmount	= $this -> amount;
			}

			$this -> rate			= $exc[PARAM_RATE];
			$this -> originalAmount	= $exc[PARAM_ORIGINAL_AMOUNT];

			if($this -> amountType == NO_COUNT) {	// 引き落とし口座

				// IWalletが損しない為の処理
				if($this -> toAmount > ($this -> fromAmount * $this -> rate)) {
					$digit = $this -> getDigit($toCurrency);

					$this -> toAmount -= (VAL_INT_1 / $digit);
				}
			} else {								// 入金額指定の場合

				// IWalletが損しない為の処理
				if($this -> fromAmount < ($this -> toAmount / $this -> rate)) {
					$digit = $this -> getDigit($this -> fromCurrency);

					$this -> fromAmount += (VAL_INT_1 / $digit);
				}
			}

			// 残高の取得
			$this -> fromBalance	= $this -> getBalanceCommon($this -> account, $this -> fromCurrency);
			$this -> toBalance		= $this -> getBalanceCommon($this -> account, $this -> toCurrency);

			// 残高のチェック
			if($this -> fromBalance < $check) {
				throw new Exception('E_INSUFFICIENT_FUNDS');
			}

			if(count($msgs) > NO_COUNT) {
				throw new Exception(implode(DELIMIT_COMMA, $msgs));
			}
		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: From通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getAccount() {
		return $this -> account;
	}

	/*-------------------------------------------------------------------------
	* @function_name: From通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getFromCurrency() {
		return $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: From金額の取得
	* @parameter	: なし
	* @return		: From金額
	-------------------------------------------------------------------------*/
	public function getFromAmount() {
		return $this -> fromAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: To通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getToCurrency() {
		return $this -> toCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: To金額の取得
	* @parameter	: なし
	* @return		: To金額
	-------------------------------------------------------------------------*/
	public function getToAmount() {
		return $this -> toAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	public function getRate() {
		return $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function getOriginalAmount() {
		return $this -> originalAmount;
	}

}
?>