<?php
class TransferModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	// private $fromTotal				= array();		// 結果セット（集計）
	// private $toTotal				= array();		// 結果セット（集計）
	private $fromToTotal				= array();		// 結果セット（集計）
	private $rs					= null;			// 結果セット
	private $tId				= NO_COUNT;		// トランザクションID
	private $from				= NO_STRING;	// 送金元口座番号
	private $to					= NO_STRING;	// 送金先口座番号
	private $amount				= NO_STRING;	// 金額
	private $balances			= null;			// バランス
	private $currencies			= null;			// 通貨データ
	private $message			= NO_STRING;	// メッセージ
	private $fromCurrency		= NO_STRING;	// From通貨
	private $toCurrency			= NO_STRING;	// To通貨
	private $transferType		= NO_COUNT;		// 送金タイプ
	private $fromName			= NO_STRING;	// from名前
	private $toName				= NO_STRING;	// to名前
	private $rate 				= NO_STRING;	// レート
	private $debitAmount		= NO_COUNT;		// 出金金額
	private $debitCurrency		= NO_STRING;	// 出金通貨
	private $transferCurrency	= NO_STRING;	// 送金通貨
	private $transferAmount		= NO_STRING;	// 送金金額
	private $fromFee			= NO_COUNT;		// 送金元手数料
	private $toFee				= NO_COUNT;		// 送金先手数料
	private $summaryList		= null;			// 残高リスト
	private $afterSummaryList	= null;			// 処理後残高リスト
	private $transactionNumber	= NO_STRING;	// 取引番号
	private $totalCount			= NO_STRING;	// 総件数

	// ------------------ インポート系 ------------------//
	private $csv				= array();		// CSVデータ
	private $errCsv				= null;			// CSVエラーデータ
	private $errFlg				= NO_COUNT;		// エラーフラグ
	private $tmpPath			= NO_STRING;	// テンプレートパス
	private $oldFilename		= NO_STRING;	// 元ファイル名
	private $newFilename		= NO_STRING;	// 元ファイル名

	// ------------------ 検索系 ------------------//
	private $sTId				= NO_STRING;	// トランザクションID
	private $sTransactionNumber = NO_STRING; 	// 取引番号
	private $sFromAccount		= NO_STRING;	// From口座番号
	private $sToAccount			= NO_STRING;	// To口座番号
	private $sFromName			= NO_STRING;	// Fromユーザネーム
	private $sToName			= NO_STRING;	// Toユーザネーム
	private $sFrom				= NO_STRING;	// 開始日
	private $sTo				= NO_STRING;	// 終了日
	private $sProcessType		= array();		// 処理タイプ
	// ------------------ 検索系 ------------------//

	/**
	 *
	 * anton
	 *
	 */
	public $lang			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> tId				= $this -> getDataPost(PARAM_T_ID);							// 送金元口座番号
		$this -> from				= $this -> getDataPost(PARAM_FROM);							// 送金元口座番号
		$this -> to					= $this -> getDataPost(PARAM_TO);							// 送金先口座番号
		$this -> amount				= $this -> getDataPost(PARAM_AMOUNT);						// 金額
		$this -> message			= $this -> getDataPost(PARAM_MESSAGE);						// メッセージ
		$this -> fromCurrency		= $this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY);		// From通貨
		$this -> toCurrency			= $this -> getDataPost(PARAM_TRANSFER_TO_CURRENCY);			// To通貨
		$this -> transferType		= $this -> getDataPost(PARAM_TRANSFER_TYPE);				// 送金タイプ
		$this -> fromName			= $this -> getDataPost(PARAM_TRANSFER_FROM_NAME);			// from名前
		$this -> toName				= $this -> getDataPost(PARAM_TRANSFER_TO_NAME);				// to名前
		$this -> rate				= $this -> getDataPost(PARAM_RATE);							// レート
		$this -> debitAmount		= $this -> getDataPost(PARAM_DEBIT_AMOUNT);					// 出金金額
		$this -> debitCurrency		= $this -> getDataPost(PARAM_DEBIT_CURRENCY);				// 出金通貨
		$this -> transferCurrency	= $this -> getDataPost(PARAM_TRANSFER_CURRENCY);			// 送金通貨
		$this -> transferAmount		= $this -> getDataPost(PARAM_TRANSFER_AMOUNT);				// 送金金額
		$this -> fromFee			= $this -> getDataPost(PARAM_FROM_FEE);						// 送金元手数料
		$this -> toFee				= $this -> getDataPost(PARAM_TO_FEE);						// 送金先手数料
		// ------------------ インポート系 ------------------//
		$this -> tmpPath			= $this -> getDataPost(PARAM_TMP_PATH);				// テンプレートパス
		$this -> oldFilename		= $this -> getDataPost(PARAM_D_ID);					// 元ファイル名
		$this -> newFilename		= $this -> getDataPost(PARAM_NEW_FILENAME);			// 新ファイル名

		// ------------------ 検索系 ------------------//
		$this -> sTId				= $this -> getDataPost(PARAM_S_T_ID);				// トランザクションID
		$this -> sTransactionNumber = $this -> getDataPost(PARAM_TRANSACTION_NUMBER);	// 取引番号
		$this -> sFromName 			= $this -> getDataPost(PARAM_S_FROM_NAME);			// From名前
		$this -> sToName 			= $this -> getDataPost(PARAM_S_TO_NAME);			// To名前
		$this -> sFromAccount		= $this -> getDataPost(PARAM_S_FROM_ACCOUNT);		// From口座
		$this -> sToAccount			= $this -> getDataPost(PARAM_S_TO_ACCOUNT);			// To口座
		$this -> sFrom				= $this -> getDataPost(PARAM_S_FROM);				// From日付
		$this -> sTo				= $this -> getDataPost(PARAM_S_TO);					// To日付
		$this -> sProcessType		= $this -> getDataPost(PARAM_S_PROCESS_TYPE);		// To処理タイプ
		$this -> testAccountFlg		= $this -> getDataPost(PARAM_TEST_ACCOUNT_FLG);			// WLID
		// ------------------ 検索系 ------------------//

		// 開始日が指定されていない場合は、当月の01日に設定
		if($this -> sFrom == NO_STRING) {

			$today = getdate();
			$this -> sFrom = $today['year'] . DELIMIT_SLASH . $today['mon'] . DELIMIT_SLASH . '01';
		}

		$this -> lang				= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('ATRN', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('ATDT', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == CONTROL_ACTION) {
			//check access
			if(!$this -> checkAdminUserAccess('ATRN', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_UPDATE) {
			//check access
			if(!$this -> checkAdminUserAccess('ATDT', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('ATDT', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		// 口座番号入力
		if($this -> getType() == TYPE_INPUT) {

			// 送金元口座の入力チェック
			if(!$this -> checkNull($this -> from)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TRANSFER_FROM_ACCOUNT));
				$rtn = false;
			}

			// 送金先口座の入力チェック
			if(!$this -> checkNull($this -> to)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TRANSFER_TO_ACCOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 送金元口座の正規表現チェック
			if(!$this -> checkStringNumber($this -> from)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_TRANSFER_FROM_ACCOUNT));
				$rtn = false;
			}

			// 送金先口座の正規表現チェック
			if(!$this -> checkStringNumber($this -> to)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_TRANSFER_TO_ACCOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 同一口座チェック
			if($this -> to == $this -> from) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_ACCOUNT', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 送金元口座の存在チェック
			if(!$this -> checkExistAccount($this -> from)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_TRANSFER_FROM_ACCOUNT));
				$rtn = false;
			}

			// 送金元口座のステータスチェック
			if(!$this -> checkAccountStatus($this -> from, VAR_TRANSACTION_TRANSFER_WITHDRAW)) {
				$this -> popUpSessionMessage(ERROR, 'E_DONT_TRANSFER_DEPOSIT_ACCOUNT_ADMIN', array());
				$rtn = false;
			}

			// 送金先口座の存在チェック
			if(!$this -> checkExistAccount($this -> to)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_TRANSFER_TO_ACCOUNT));
				$rtn = false;
			}

			// 送金先口座のステータスチェック
			if(!$this -> checkAccountStatus($this -> to, VAR_TRANSACTION_TRANSFER_DEPOSIT)) {
				$this -> popUpSessionMessage(ERROR, 'E_DONT_TRANSFER_WITHDRAW_ACCOUNT_ADMIN', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

		}
		// 確認の場合
		else if($this -> getType() == TYPE_CONFIRM) {

			// 送金金額の入力チェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			// 正規表現チェック（半角数字）
			} else if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			// 小数点チェック
			$loc = explode(DELIMIT_DOT, $this -> amount);
			if(isset($loc[VAL_INT_1])) {
				$pointArr = explode(DELIMIT_DOT, $this -> amount);
				$point = $pointArr[VAL_INT_1];
			} else {
				$point = NO_COUNT;
			}

			if(strpos($this -> amount, DELIMIT_DOT)) {
				if($this -> fromCurrency == JPY && $this -> transferType == NO_COUNT) {
					$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, VAL_INT_1));
					$rtn = false;
				} else if($this -> toCurrency == JPY && $this -> transferType == VAL_INT_1) {
					$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, VAL_INT_1));
					$rtn = false;
				} else if(strlen($point) > VAL_INT_2) {
					$this -> popUpSessionMessage(ERROR, 'E_NOT_NUMBER_POINT', array());
					$rtn = false;
				}
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			// 金額の範囲チェック
			if($this -> amount < NO_COUNT) {
				$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, 0.01));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			// 送金、出金通貨設定
			$this -> debitCurrency 		= $this -> fromCurrency;	// 出金通貨
			$this -> transferCurrency	= $this -> toCurrency;		// 送金通貨

			// 送金、出金金額設定
			if($this -> transferType == NO_COUNT) {
				$exchange	= $this -> getExchangeCommon($this -> amount, $this -> debitCurrency, $this -> transferCurrency, true, false, NO_STRING, $this -> from);
				$this -> debitAmount 		= $this -> amount;												// 出金金額

				if($this -> debitCurrency == $this -> transferCurrency) {
					$this -> transferAmount 	= $this -> amount;											// 送金金額
				} else {
					$this -> transferAmount 	= $exchange[PARAM_AMOUNT];									// 送金金額
				}

				$debitlowLimit				= VAL_INT_1 / ($this -> getDigit($this -> debitCurrency));		// 出金最低金額
				$transferlowLimit			= VAL_INT_1 / ($this -> getDigit($this -> transferCurrency));	// 送金最低金額

				// 金額の最低金額チェック
				if($this -> debitAmount < $debitlowLimit) {
					$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, $debitlowLimit));
					$rtn = false;
				}

				// 出金額が最低金額以下になる場合は最低金額を設定
				if($this-> debitAmount < $debitlowLimit) {
					$this -> debitAmount = $debitlowLimit;
				}

				// 送金額調整
				if($this -> transferAmount > ($this -> debitAmount * $exchange[PARAM_RATE])) {
					$this -> transferAmount = NO_COUNT;
				}

			} else if($this -> transferType == VAL_INT_1){
				$exchange	= $this -> getExchangeCommon($this -> amount, $this -> transferCurrency, $this -> debitCurrency, true, true, NO_STRING, $this -> from);
				$this -> debitAmount 		= $exchange[PARAM_AMOUNT];										// 出金金額
				$this -> transferAmount 	= $this -> amount;												// 送金金額
				$debitlowLimit				= VAL_INT_1 / ($this -> getDigit($this -> debitCurrency));		// 出金最低金額
				$transferlowLimit			= VAL_INT_1 / ($this -> getDigit($this -> transferCurrency));	// 送金最低金額
				// 金額の最低金額チェック
				if($this -> transferAmount < $transferlowLimit) {
					$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, $transferlowLimit));
					$rtn = false;
				}
				// IWalletが損しない為の処理
				if($this -> transferAmount > ($this -> debitAmount / $exchange[PARAM_RATE])) {
					$this -> debitAmount += $debitlowLimit;
				}
			}


			// レートの取得

			$this -> rate	= $this -> getRateCommon($this -> debitCurrency, $this -> transferCurrency, $null , NO_STRING, $this -> from);

			// 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> from, $this -> debitCurrency, $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			// 手数料取得
			$fee		= $this -> getFeeCommon(VAR_TRANSFER
// 												, $this -> transferAmount
// 												, $this -> transferCurrency
												, $this -> debitAmount
												, $this -> debitCurrency
												, $this -> from
												, $this -> to
												, $this -> transferCurrency
												, $this -> transferAmount);

			// 送金元手数料設定
			if($fee[$this -> debitCurrency . VAL_INT_1] > NO_COUNT) {

				// 小数点を桁数で切り捨て
				$digit				= $this -> getDigit($this -> debitCurrency);
				$this -> fromFee 	= floor($fee[$this -> debitCurrency . VAL_INT_1] * $digit);
				$this -> fromFee	= $this -> fromFee / $digit;

				// 最小金額を算出
				$low				= VAL_INT_1 / $digit;

				// 0の場合は最低金額を設定
				if($this -> fromFee < $low) {
					$this -> fromFee = VAL_INT_1 / $digit;
				}

			} else {
				$this -> fromFee = NO_COUNT;
			}

			// 送金先手数料設定
			if($fee[$this -> transferCurrency . VAL_INT_2] > NO_COUNT) {

// 				// 送金元の手数料を出金通貨に両替
// 				$exchangeToFee = 	$this -> getExchangeCommon($fee[$this -> debitCurrency . VAL_INT_1]
// 																, $this -> debitCurrency
// 																, $this -> transferCurrency);
				// 小数点を桁数で切り捨て
				$digit			= $this -> getDigit($this -> transferCurrency);
				$this -> toFee 	= floor($fee[$this -> transferCurrency . VAL_INT_2] * $digit);
				$this -> toFee	= $this -> toFee / $digit;

				// 最小金額を算出
				$low				= VAL_INT_1 / $digit;

				// 0の場合は最低金額を設定
				if($this -> toFee < $low) {
					$this -> toFee = VAL_INT_1 / $digit;
				}
			} else {
				$this -> toFee = NO_COUNT;
			}

			// // 残高取得
			// $balance	= $this -> getBalanceCommon($this -> from, $this -> debitCurrency);

			// // 残高チェック
			// if($balance < ($this -> debitAmount + $this -> fromFee)) {
			// 	$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> debitCurrency, $this -> formatCurrency(($this -> debitAmount + $this -> fromFee), $this -> debitCurrency)));
			// 	$rtn = false;
			// }

			// メッセージの入力文字数チェック
			if(!$this -> checkLength($this -> message, NO_COUNT, VAL_INT_500)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_MESSAGE, '文字数オーバー', NO_COUNT, VAL_INT_500));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$detailLink		= NO_STRING;
		$fromUserName	= NO_STRING;
		$toUserName		= NO_STRING;
		$status			= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
// 			$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
// 			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
// 			$listCount	= count($this -> rs);
// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> rs, $cnt);

			foreach($this -> rs as $row) {
				// 詳細リンク
				if($this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) == NO_STRING) {
					$detailLink	= '&nbsp;';
				} else {
					$detailLink = '<a href="javascript:void(0);" onclick="goDetail(\'' . $this -> getColumnData($row, COLUMN_T_ID) . '\', \'_blank\')">' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</a>';
				}

				// ユーザ詳細
				if($this -> getColumnData($row, COLUMN_FROM_USER_NAME) == NO_STRING) {
					$fromUserName	= '&nbsp;';
				} else {
					$fromUserName	= $this -> getColumnData($row, COLUMN_FROM_USER_NAME);
				}

				// ユーザ詳細
				if($this -> getColumnData($row, COLUMN_TO_USER_NAME) == NO_STRING) {
					$toUserName	= '&nbsp;';
				} else {
					$toUserName	= $this -> getColumnData($row, COLUMN_TO_USER_NAME);
				}

				// 種別
				switch ($this -> getColumnData($row, COLUMN_PROCESS_STATUS)) {
					case 0: $status = 'User'; break;
					case 1: $status = 'Admin'; break;
					case 2: $status = 'API'; break;
					case 3: $status = 'Batch'; break;
					default: $status = '---';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td>' . $detailLink . '</td>'
							. '<td class="l">' . $fromUserName . '</td>'
							// . '<td><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '\', \'_blank\')">' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '</a></td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY) . '</td>'
							. '<td>' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
							. '<td>' . $this -> getAmountString($this -> getColumnData($row, COLUMN_FROM_FEE), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
							. '<td class="l">' . $toUserName . '</td>'
							// . '<td><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '\', \'_blank\')">' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '</a></td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_TO_ACCOUNT) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY) . '</td>'
							. '<td>' . $this -> getAmountString($this -> getColumnData($row, COLUMN_TRANSFER_AMOUNT), $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY)) . '</td>'
							. '<td>' . $this -> getAmountString($this -> getColumnData($row, COLUMN_TO_FEE), $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY)) . '</td>'
							. '<td>' . $status . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_RATE) . '</td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="14">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	public function echoTotalList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$lists		= array();
		$counter	= NO_STRING;
		$data		= NO_STRING;
		$cName		= NO_STRING;
		$amount		= NO_STRING;

		// データを入れ替える
		// if($this -> isLoopData($this -> fromTotal)) {
		// 	foreach($this -> fromTotal as $row) {
		// 		$listsFrom[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
		// 	}
		// }

		// if($this -> isLoopData($this -> toTotal)) {
		// 	foreach($this -> toTotal as $row) {
		// 		$listsTo[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
		// 	}
		// }

		if($this -> isLoopData($this -> fromToTotal)) {
			foreach($this -> fromToTotal as $row) {
				$listsFrom[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> fromToTotal)) {
			foreach($this -> fromToTotal as $row) {
				$listsTo[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		foreach($this -> currencies as $row) {

			if(isset($listsFrom[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)])) {

				$cName	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$fromAmount	= $this -> getColumnData($listsFrom[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)], COLUMN_FROM_AMOUNT);

				$counter1	= number_format($this -> getColumnData($listsFrom[$cName], COLUMN_FROM_ACCOUNT));

				$fromData	= number_format($this -> intToCurrency($fromAmount, $cName), $this -> getDigitCount($cName));
			} else {
				$counter1	= NO_COUNT;
				$fromData		= number_format(NO_COUNT, $this -> getColumnData($row, COLUMN_DIGIT));
			}

			if(isset($listsTo[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)])) {

				$cName	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$toAmount	= $this -> getColumnData($listsTo[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)], COLUMN_TO_AMOUNT);

				$counter2	= number_format($this -> getColumnData($listsTo[$cName], COLUMN_TO_ACCOUNT));

				$toData	= number_format($this -> intToCurrency($toAmount, $cName), $this -> getDigitCount($cName));
			} else {
				$counter2	= NO_COUNT;
				$toData		= number_format(NO_COUNT, $this -> getColumnData($row, COLUMN_DIGIT));
			}

			$rtn .=	'<tr>'
					. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY_NAME) . '</td>'
					. '<td>' . $counter1 . '</td>'
					. '<td class="r">' . $fromData . '</td>'
					. '<td>' . $counter2 . '</td>'
					. '<td class="r">' . $toData . '</td>'
					. '</tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	public function echoDetail() {

		// 変数宣言部
		$rtn 				= NO_STRING;
		$fromAccountType 	= NO_STRING;
		$toAccountType 		= NO_STRING;
		$processType		= NO_STRING;
		$processUser		= NO_STRING;

		$row = $this -> rs[NO_COUNT];

		// アカウントタイプ取得
		if($this -> getColumnData($row, COLUMN_FROM_ACCOUNT_TYPE) == NO_COUNT) {
			$fromAccountType = VAL_STR_PERSONAL;
		} else if($this -> getColumnData($row, COLUMN_FROM_ACCOUNT_TYPE) == VAL_INT_1) {
			$fromAccountType = VAL_STR_CORPORATE;
		}

		if($this -> getColumnData($row, COLUMN_TO_ACCOUNT_TYPE) == NO_COUNT) {
			$toAccountType = VAL_STR_PERSONAL;
		} else if($this -> getColumnData($row, COLUMN_TO_ACCOUNT_TYPE) == VAL_INT_1) {
			$toAccountType = VAL_STR_CORPORATE;
		}

		if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == NO_COUNT) {
			$processType = 'User';
		} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_1) {
			$processType = 'Admin';
		} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_2) {
			$processType = 'API';
		} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_3) {
			$processType = 'Batch';
		}

		if($this -> getColumnData($row, COLUMN_ADMIN_ID) == NO_STRING) {
			$processUser = '---';
		} else {
			$processUser = $this -> getColumnData($row, COLUMN_ADMIN_ID);
		}

		$rtn = '<tr>'
				. '<th>'.VAL_STR_TRANSFER_DATE.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
				. '</tr>'
				. '<th>'.VAL_STR_TRANSACTION_NUMBER.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_REMITAMMOUNT.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY) . ' ' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_REMITSOURCENAME.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_FROM_USER_NAME) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_REMITSOURCETYPE.'</th>'
				. '<td>' . $fromAccountType . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_REMITSOURCENUMBER.'</th>'
				. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '" target="_blank">' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '</a></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_AMOUNTRECEIVE.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY) . ' ' . $this -> getAmountString($this -> getColumnData($row, COLUMN_TRANSFER_AMOUNT), $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY)) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_RECIPIENTNAME.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_TO_USER_NAME) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_RECIPIETTYPE.'</th>'
				. '<td>' . $toAccountType . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_RECIPIETNUMBER.'</th>'
				. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '" target="_blank">' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '</a></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_EXCHANGERATE.'</th>'
				. '<td>' . $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY) . ' ' . $this -> getColumnData($row, COLUMN_RATE) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_MESSAGE.'</th>'
				. '<td>' . nl2br($this -> getColumnData($row, COLUMN_MESSAGE)) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_PTYPE.'</th>'
				. '<td>' . $processType . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_TRANSFER_PUSER.'</th>'
				. '<td>' . $processUser . '</td>'
				. '</tr>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	public function echoDetailMessage() {

		$row = $this -> rs[NO_COUNT];
		echo $this -> getColumnData($row, 'note');

	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索条件パラメータの取得
	 * @parameter	: なし
	 * @return		: 検索条件パラメータ
	 -------------------------------------------------------------------------*/
	public function getWhereTransfer() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sTId != NO_STRING) {			// トランザクションID
			$rtnParams[] = ' transfer.t_id = (\')' . $this -> sTId . '(\') ';
		}

		if($this -> sTransactionNumber != NO_STRING) {	// 取引番号
			$rtnParams[] = ' transfer.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}

		if($this -> sFromAccount != NO_STRING) {	// From口座
			$rtnParams[] = ' transfer.from_account = (\')' . $this -> sFromAccount . '(\') ';
		}

		if($this -> sToAccount != NO_STRING) {	// To口座
			$rtnParams[] = ' transfer.to_account = (\')' . $this -> sToAccount . '(\') ';
		}

		if($this -> sFrom != NO_STRING) {			//
			$rtnParams[] = ' transfer.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
		}

		if($this -> sTo != NO_STRING) {				// 終了日
			$rtnParams[] = ' transfer.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
		}

		if(!empty($this -> sProcessType)) {				// 処理タイプ
			$rtnParams[] = ' transfer.process_status IN (' . implode(DELIMIT_COMMA, $this -> sProcessType) . ') ';
		}

		$rtnParams[] = ' NOW() + INTERVAL 16 HOUR > transfer.create_time';
		
		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	public function getWhereTotal($rtn) {
		// 変数宣言部
		$rtnParams = array();

		if($this -> testAccountFlg != NO_STRING) {
			$rtnParams[] .= 'users.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}
		// 検索条件の結合

		if(count($rtnParams) > NO_COUNT) {
			return $rtn. DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return $rtn;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	 -------------------------------------------------------------------------*/
	public function getWhereUser() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> testAccountFlg != NO_STRING) {
			$rtnParams[] .= 'users.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}
		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 決済セットの設定（口座一覧）
	 * @parameter	: 結果セット
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function dispBalances() {

		// 変数宣言部
		$lists	= array();
		$rtn	= NO_STRING;

		// データを入れ替える
		if($this -> isLoopData($this -> balances)) {
			foreach($this -> balances as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> currencies)) {

			// データの数だけループを回す
			foreach($this -> currencies as $row) {

				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$data		= $this -> getColumnData($lists, $currency);
				$amount		= NO_COUNT;

				// データを生成
				if($data == NO_STRING) {	// データが無い
					$amount = number_format($this -> intToCurrency(NO_COUNT, $currency), $this -> getDigitCount($currency));
				} else {
					$amount = number_format($this -> intToCurrency($this -> getColumnData($data, COLUMN_BALANCE), $currency), $this -> getDigitCount($currency));
				}

				if($this -> fromCurrency != NO_STRING) {
					if($this -> fromCurrency == $currency) {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '" checked> ' . $currency . ' - ' . $amount . '</label>';
					} else {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '"> ' . $currency . ' - ' . $amount . '</label>';
					}
				} else {
					if($currency == USD) {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '" checked> ' . $currency . ' - ' . $amount . '</label>';
					} else {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '"> ' . $currency . ' - ' . $amount . '</label>';
					}
				}
			}

		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料の算出
	 * @parameter	: なし
	 * @return		: 手数料
	 -------------------------------------------------------------------------*/
	function getImportFee($amount, $currency, $from, $to) {

		$rtn = NO_COUNT;
		// 手数料取得
		$fee = $this -> getFeeCommon(VAR_TRANSFER
									, $amount
									, $currency
									, $from
									, $to);

		// 送金元の手数料を出金通貨に両替
		$exchangeFromFee = 	$this -> getExchangeCommon($fee[$currency . VAL_INT_1]
														, $currency
														, $currency);

		// 小数点を桁数で切り捨て
		$digit				= $this -> getDigit($currency);
		$rtn 	= floor($exchangeFromFee[PARAM_AMOUNT] * $digit);
		$rtn	= $rtn / $digit;

		// 最小金額を算出
		$low				= VAL_INT_1 / $digit;

		// 0の場合は最低金額を設定
		if($rtn < $low) {
			$rtn = VAL_INT_1 / $digit;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高リストの表示
	 * @parameter	: なし
	 * @return		: 残高リスト
	 -------------------------------------------------------------------------*/
	public function echoSummaryList() {

		$rtn = NO_STRING;
		$list = null;

		if($this -> isLoopData($this -> summaryList)) {
			foreach ($this -> summaryList as $key => $value) {
				if(isset($value[VAL_INT_1])) {
					$after = $value[VAL_INT_1];
				} else {
					$after = $value[NO_COUNT];
				}
				$rtn .= '<tr>'
						. '<td>' . $key . '</td>'
						. '<td>' . $value[NO_COUNT] . '</td>'
						. '<td>' . $after . '</td>'
						. '</tr>';
			}
		}
		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: テンプレートファイルのパス取得
	 * @parameter	: なし
	 * @return		: テンプレートファイルのパス
	 -------------------------------------------------------------------------*/
	public function getTmpPath() {
		return $this -> tmpPath;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エラーフラグ取得
	 * @parameter	: なし
	 * @return		: エラーフラグ
	 -------------------------------------------------------------------------*/
	public function getErrFlg() {
		return $this -> errFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金メッセージの取得
	* @parameter	: なし
	* @return		: 送金メッセージ
	-------------------------------------------------------------------------*/
	public function echoTransferMessage() {
		echo $this -> message;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金元口座番号の取得
	* @parameter	: なし
	* @return		: 送金元口座番号
	-------------------------------------------------------------------------*/
	public function echoFrom() {
		echo $this -> from;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先口座番号の取得
	* @parameter	: なし
	* @return		: 送金先口座番号
	-------------------------------------------------------------------------*/
	public function echoTo() {
		echo $this -> to;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先口名の取得
	 * @parameter	: なし
	 * @return		: 送金先口名
	 -------------------------------------------------------------------------*/
	public function echoToName() {
		if($this -> getType() == TYPE_INPUT) {
			echo $this -> rs[VAL_INT_1][COLUMN_USER_NAME];
		} else {
			echo $this -> toName;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金元口名の取得
	 * @parameter	: なし
	 * @return		: 送金先元名
	 -------------------------------------------------------------------------*/
	public function echoFromName() {
		if($this -> getType() == TYPE_INPUT) {
			echo $this -> rs[NO_COUNT][COLUMN_USER_NAME];
		} else {
			echo $this -> fromName;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨一覧の取得
	 * @parameter	: なし
	 * @return		: 通貨一覧
	 -------------------------------------------------------------------------*/
	public function echoCurrencyList() {
		echo $this -> dispCurrencyOptionList($this -> toCurrency, false);
	}

	function echoTestAccountFlg() {
		echo $this -> dispListOption($this -> getTestAccountList(), $this -> testAccountFlg);
	}
	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		// 取引番号設定
		$this -> transactionNumber = $this -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);

		$rtn[] = $this -> from;																	// 送金元口座番号
		$rtn[] = $this -> from;																	// 送金元口座番号
		$rtn[] = $this -> debitCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> fromFee, $this -> debitCurrency);				// 口座元手数料
		$rtn[] = $this -> to;																	// 送金先口座番号
		$rtn[] = $this -> transferCurrency;														// 送金元通貨
		$rtn[] = $this -> currencyToInt($this -> toFee, $this -> transferCurrency);				// 送金元手数料
		$rtn[] = $this -> amount;																// 入力金額
		$rtn[] = $this -> transferType;															// 送金方法
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> debitCurrency;														// 出金通貨
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);			// 出金金額
		$rtn[] = $this -> transferCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> transferAmount, $this -> transferCurrency);	// 送金金額
		$rtn[] = $this -> rate;																	// レート
		$rtn[] = VAL_INT_1;																		// 処理種別
		$rtn[] = $this -> getAdminUserData(PARAM_USER_ACCOUNT);									// 管理者ID
		$rtn[] = VAL_INT_1;																		// 処理ステータス
		$rtn[] = $this -> transactionNumber;													// トランザクションナンバー
		$rtn[] = date("Y-m-d H:i:s");

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: コミッションの登録
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function transferRegistCommision() {

		// 送金元口座情報の取得
		$from = $this -> getRowData($this -> getAccountCommon($this -> from));

		// コミッションの集計（送金元）
		$this -> registCommision(VAR_TRANSFER
				, $this -> getColumnData($from, COLUMN_PARENT_AGENT_CODE)
				, $this -> from
				, $this -> debitCurrency
				, $this -> fromFee);

		// 送金先口座情報の取得
		$to = $this -> getRowData($this -> getAccountCommon($this -> to));

		// コミッションの集計（送金先）
		$this -> registCommision(VAR_TRANSFER
				, $this -> getColumnData($to, COLUMN_PARENT_AGENT_CODE)
				, $this -> to
				, $this -> transferCurrency
				, $this -> toFee
				, PARAM_TO);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金元アカウント
	 * @parameter	: なし
	 * @return		: 送金元アカウント
	 -------------------------------------------------------------------------*/
	public function getFrom() {
		return $this -> from;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先アカウント
	 * @parameter	: なし
	 * @return		: 送金先アカウント
	 -------------------------------------------------------------------------*/
	public function getTo() {
		return $this -> to;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金通貨を取得
	 * @parameter	: なし
	 * @return		: 出金通貨
	 -------------------------------------------------------------------------*/
	public function getTransferType() {
		return $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金通貨を取得
	 * @parameter	: なし
	 * @return		: 出金通貨
	 -------------------------------------------------------------------------*/
	public function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金金額を取得
	 * @parameter	: なし
	 * @return		: 出金金額
	 -------------------------------------------------------------------------*/
	public function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨を取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	public function getTransferCurrency() {
		return $this -> transferCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額を取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	public function getTransferAmount() {
		return $this -> transferAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 登録用のデータを取得
	 * @parameter	: なし
	 * @return		: 登録用データ
	 -------------------------------------------------------------------------*/
	public function getUpdateDateData() {
		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> tId;
		$rtn[] = $this -> message;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得（送金元ユーザ）
	 * @parameter	: なし
	 * @return		: メール送信用データ
	 -------------------------------------------------------------------------*/
	public function getSendDataFrom() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> from);
		$row	= $this -> getRowData($data);
		$data2	= $this -> getAccountCommon($this -> to);
		$row2	= $this -> getRowData($data2);

		$rtn[] = $this -> from;																	// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);				// ユーザ名
		$rtn[] = $this -> to;																	// 送金先口座番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row2, COLUMN_LAST_NAME);				// ユーザ名（送金先）
		$rtn[] = $this -> getCurrentTimeCommon();												// 現在時刻
		$rtn[] = $this -> transferCurrency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> transferAmount, $this -> transferCurrency);	// 金額
		$rtn[] = $this -> debitCurrency;														// 手数料通貨
		$rtn[] = $this -> formatCurrency($this -> fromFee, $this -> debitCurrency);				// 手数料
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> transactionNumber;													// 取引番号
		$rtn[] = $this -> getColumnData($row, COLUMN_MAIL);										// メールアドレス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得（送金先ユーザ）
	 * @parameter	: なし
	 * @return		: メール送信用データ
	 -------------------------------------------------------------------------*/
	public function getSendDataTo() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> from);
		$row	= $this -> getRowData($data);
		$data2	= $this -> getAccountCommon($this -> to);
		$row2	= $this -> getRowData($data2);

		$rtn[] = $this -> from;																	// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row2, COLUMN_LAST_NAME);				// ユーザ名
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金先口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);				// ユーザ名（送金元）
		$rtn[] = $this -> getCurrentTimeCommon();												// 現在時刻
		$rtn[] = $this -> transferCurrency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> transferAmount, $this -> transferCurrency);	// 金額
		$rtn[] = $this -> debitCurrency;														// 手数料通貨
		$rtn[] = $this -> formatCurrency($this -> toFee, $this -> transferCurrency);			// 手数料
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> transactionNumber;													// 取引番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_MAIL);									// メールアドレス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 表示用のデータを取得
	 * @parameter	: なし
	 * @return		: 表示用データ
	 -------------------------------------------------------------------------*/
	public function getViewData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> from;				// 送金元口座番号
		$rtn[] = $this -> to;				// 送金先口座番号
		return $rtn;

	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {

		// 変数宣言部
		$temp = array();

		$this -> rs = $rs;

		// データを最小限にする
		$start				= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end				= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
		$listCount			= count($this -> rs);

        $this -> totalCount	= $listCount;
        if($this -> getType() != TYPE_EXPORT){

    		for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
    			$temp[] = $this -> rs[$cnt];
    		}
    // print_r($temp);
    		$this -> rs = $temp;
        }

	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setRs($rs) {
		$this -> rs = $rs;
		$listCount = count($this -> rs);
		$this -> totalCount	= $listCount;
	}

	// public function setTotalFrom($rs) {
	// 	$this -> fromTotal = $rs;
	// }

	// public function setTotalTo($rs) {
	// 	$this -> toTotal = $rs;
	// }

	public function setTotalFromTo($rs) {
		$this -> fromToTotal = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function getUIds() {

		// 変数宣言部
		$rtn	= VAL_INT_1;
		$list	= array();

		// データの数だけループを回す
		if($this -> isLoopData($this -> rs)) {

			foreach($this -> rs as $row) {
				$list[$row[COLUMN_FROM_ACCOUNT]]	= '(\')' . $row[COLUMN_FROM_ACCOUNT] . '(\')';
				$list[$row[COLUMN_TO_ACCOUNT]]		= '(\')' . $row[COLUMN_TO_ACCOUNT] . '(\')';
			}

			$rtn = implode(DELIMIT_COMMA, $list);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function mergeUser($users) {

		// 変数宣言部
		$arrUser	= array();
		$uId		= NO_STRING;
		$temp		= array();

		// データ入れなおす
		if($this -> isLoopData($users)) {

			foreach($users as $row) {

				$uId = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);

				$arrUser[$uId] = $this -> getColumnData($row, COLUMN_LAST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME);
			}
		}

		// ユーザデータの追加
		if($this -> isLoopData($this -> rs)) {

			foreach($this -> rs as $row) {


				$row[COLUMN_FROM_USER_NAME]	= ($this -> getLangage() == "en") ? 'Account not found!' : '口座が見つかりません！';
				$row[COLUMN_TO_USER_NAME]	= ($this -> getLangage() == "en") ? 'Account not found!' : '口座が見つかりません！';

				// 追加処理from_user_name to_user_name
				if(($this -> getColumnData($arrUser, $row[COLUMN_FROM_ACCOUNT])!= NO_STRING) || ($this -> getColumnData($arrUser, $row[COLUMN_TO_ACCOUNT]) != NO_STRING)){
					if(($this -> getColumnData($arrUser, $row[COLUMN_FROM_ACCOUNT])!= NO_STRING)){
						$row[COLUMN_FROM_USER_NAME]	= $this -> getColumnData($arrUser, $row[COLUMN_FROM_ACCOUNT]);

					}
					if(($this -> getColumnData($arrUser, $row[COLUMN_TO_ACCOUNT]) != NO_STRING)){

						$row[COLUMN_TO_USER_NAME]	= $this -> getColumnData($arrUser, $row[COLUMN_TO_ACCOUNT]);
					}

					$temp[]	= $row;
				}

			}

			$this -> setResult($temp);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨のバランスデータの設定
	 * @parameter	: 結果セット
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setBalances($rs) {
		$this -> balances = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨データの設定
	 * @parameter	: 通貨データ
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザアカウントの取得
	 * @parameter	: なし
	 * @return		: ユーザアカウント
	 -------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> rs[NO_COUNT][COLUMN_USER_ACCOUNT];
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> totalCount)
										, $this -> totalCount
										, NO_STRING
										, true);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: トランザクションIDの取得
	 * @parameter	: なし
	 * @return		: トランザクションID
	 -------------------------------------------------------------------------*/
	public function echoSTId() {
		echo $this -> sTId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From名前の取得
	 * @parameter	: なし
	 * @return		: From名前
	 -------------------------------------------------------------------------*/
	public function echoSFromName() {
		echo $this -> sFromName;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From口座の取得
	 * @parameter	: なし
	 * @return		: From口座
	 -------------------------------------------------------------------------*/
	public function echoSFromAccount() {
		echo $this -> sFromAccount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To名前の取得
	 * @parameter	: なし
	 * @return		: To名前
	 -------------------------------------------------------------------------*/
	public function echoSToName() {
		echo $this -> sToName;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To口座の取得
	 * @parameter	: なし
	 * @return		: To口座
	 -------------------------------------------------------------------------*/
	public function echoSToAccount() {
		echo $this -> sToAccount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From日付の取得
	 * @parameter	: なし
	 * @return		: From日付
	 -------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To日付の取得
	 * @parameter	: なし
	 * @return		: To日付
	 -------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: トランザクションIDの取得
	 * @parameter	: なし
	 * @return		: トランザクションID
	 -------------------------------------------------------------------------*/
	public function getTId() {
		return $this -> tId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	public function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	public function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	public function echoDebitAmountNumber() {
		$number = number_format($this -> debitAmount, 2);
		echo preg_replace("/\.?0+$/","",$number);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金元手数料の取得
	 * @parameter	: なし
	 * @return		: 送金元手数料
	 -------------------------------------------------------------------------*/
	public function echoFromFee() {
		echo $this -> fromFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取通貨の取得
	 * @parameter	: なし
	 * @return		: 受取通貨
	 -------------------------------------------------------------------------*/
	public function echoTransferCurrency() {
		echo $this -> transferCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取金額の取得
	 * @parameter	: なし
	 * @return		: 受取金額
	 -------------------------------------------------------------------------*/
	public function echoTransferAmount() {
		echo $this -> transferAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取金額の取得
	 * @parameter	: なし
	 * @return		: 受取金額
	 -------------------------------------------------------------------------*/
	public function echoTransferAmountNumber() {
		$number = number_format($this -> transferAmount, 2);
		echo preg_replace("/\.?0+$/","",$number);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先手数料の取得
	 * @parameter	: なし
	 * @return		: 送金先手数料
	 -------------------------------------------------------------------------*/
	public function echoToFee() {
		echo $this -> toFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金タイプの取得
	 * @parameter	: なし
	 * @return		: 送金タイプ
	 -------------------------------------------------------------------------*/
	public function echoDispTransferType($type) {
		if($this -> transferType == $type) {
			echo 'checked';
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	public function echoRate() {
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	public function echoTransferType() {
		echo $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: to通貨の取得
	 * @parameter	: なし
	 * @return		: to通貨
	 -------------------------------------------------------------------------*/
	public function echoToCurrency() {
		echo $this -> toCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: from通貨の取得
	 * @parameter	: なし
	 * @return		: from通貨
	 -------------------------------------------------------------------------*/
	public function echoFromCurrency() {
		echo $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 処理タイプの取得
	 * @parameter	: なし
	 * @return		: 処理タイプ
	 -------------------------------------------------------------------------*/
	public function echoSProcessType($value) {
		if(!empty($this -> sProcessType)) {
			foreach ($this -> sProcessType as $row) {
				if($row == $value) {
					echo 'checked';
				}
			}
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: TIDの取得
	 * @parameter	: なし
	 * @return		: メッセージ
	 -------------------------------------------------------------------------*/
	public function echoTId() {
		echo $this -> tId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メッセージの取得
	 * @parameter	: なし
	 * @return		: メッセージ
	 -------------------------------------------------------------------------*/
	public function echoIMessage() {
		echo $this -> message;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 表示用メッセージの取得
	 * @parameter	: なし
	 * @return		: 表示用メッセージ
	 -------------------------------------------------------------------------*/
	public function echoViewMessage() {
		echo nl2br($this -> message);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 新ファイル名の取得
	 * @parameter	: なし
	 * @return		: 新ファイル名
	 -------------------------------------------------------------------------*/
	public function getNewFilename() {
		return $this -> newFilename;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 元ファイル名の取得
	 * @parameter	: なし
	 * @return		: 元ファイル名
	 -------------------------------------------------------------------------*/
	public function getOldFilename() {
		return $this -> oldFilename;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 旧ファイル名の設定
	 * @parameter	: 旧ファイル名
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setOldFileName($name) {
		$this -> oldFilename = $name;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 新ファイル名の設定
	 * @parameter	: 新ファイル名
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setNewFileName($name) {
		$this -> newFilename = $name;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引番号の設定
	 * @parameter	: 取引番号
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

    /*-------------------------------------------------------------------------
	 * @function_name: makeExportData
	* @parameter	:
	* @return		: string - export data csv format
	-------------------------------------------------------------------------*/
    public function getExportDetails(){
        // 変数宣言部
		$rtn			= NO_STRING;
		$detailLink		= NO_STRING;
		$fromUserName	= NO_STRING;
		$toUserName		= NO_STRING;
		$status			= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			foreach($this -> rs as $row) {
				// 詳細リンク
				if($this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) == NO_STRING) {
					$detailLink	= '';
				} else {
					$detailLink = $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
				}

				// ユーザ詳細
				if($this -> getColumnData($row, COLUMN_FROM_USER_NAME) == NO_STRING) {
					$fromUserName	= '';
				} else {
					$fromUserName	= $this -> getColumnData($row, COLUMN_FROM_USER_NAME);
				}

				// ユーザ詳細
				if($this -> getColumnData($row, COLUMN_TO_USER_NAME) == NO_STRING) {
					$toUserName	= '';
				} else {
					$toUserName	= $this -> getColumnData($row, COLUMN_TO_USER_NAME);
				}

				// 種別
				switch ($this -> getColumnData($row, COLUMN_PROCESS_STATUS)) {
					case 0: $status = 'User'; break;
					case 1: $status = 'Admin'; break;
					case 2: $status = 'API'; break;
					case 3: $status = 'Batch'; break;
					default: $status = '---';
				}

				// remarks /* アントニオはデータ変更した  */
				$remarks = nl2br($this -> getColumnData($row, COLUMN_MESSAGE));
				$remarks = str_replace(["<br />", "<br>", "<br/>", ",", "\""], " ", $remarks);
				$remarks = "\"{$remarks}\"";

				$rtn	.=  $this -> getColumnData($row, COLUMN_CREATE_TIME) . ','
                            . $detailLink . ','
                            . $fromUserName . ','
                            . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . ','
                            . $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY) . ','
                            . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY))) . ','
                            . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_FROM_FEE), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY))) . ','
                            . $toUserName . ','
                            . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . ','
                            . $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY) . ','
                            . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_TRANSFER_AMOUNT), $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY))) . ','
                            . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_TO_FEE), $this -> getColumnData($row, COLUMN_TRANSFER_CURRENCY))) . ','
                            . $status . ','
                            . $this -> getColumnData($row, COLUMN_RATE) . ','
                            . $remarks
							. "\n";
			}

		} else {
			$rtn = '';
		}

		return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: insertActivity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
   function getActivity(){

		$id =  $this -> tId;
   		// var_dump($row 		= $this -> rs[NO_COUNT]);
   		$type 		= $this -> getType();
   		$message 	= ($type == TYPE_UPDATE) ? 'Edited transaction remarks ' : 'Deleted transaction ';
   		$row 	 	= $this -> accessSelect('SELECT_TRANSFER_NUMBER_BY_ID', array($id));
   		$tNumber 	= $this -> getColumnData($row[0], COLUMN_TRANSACTION_NUMBER);


		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 12;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message.'['.$tNumber.']';

		return $rtn;
	}





}
?>
