
<?php
require_once('config.php');

class APICheckCardLoadBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $cardHolderId	= NO_STRING;
	private $amount			= NO_STRING;
	private $debitCurrency	= NO_STRING;
	private $debitAmount	= NO_STRING;
	private $toAmount		= NO_STRING;
	private $cards			= NO_STRING;
	private $balance		= NO_STRING;
	private $transferType	= NO_STRING;


	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> cardHolderId	= $this -> getDataPost(PARAM_CARD_HOLDER_ID);
			$this -> amount			= $this -> getDataPost(PARAM_AMOUNT);
			$this -> debitCurrency	= strtoupper($this -> getDataPost(PARAM_DEBIT_CURRENCY));
			$this -> debitAmount	= $this -> getDataPost(PARAM_DEBIT_AMOUNT);
			$this -> transferType	= $this -> getDataPost(PARAM_TRANSFER_TYPE);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'C' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 口座の存在確認
		$this -> user = $this -> getAccountCommon($this -> account);

		if(count($this -> user) == NO_COUNT) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 口座ステータスチェック
		if(!$this -> checkAccountStatus($this -> account, VAR_TRANSACTION_WITHDRAW)) {
			throw new Exception(VAL_INT_99);
		}

		// カード所持確認
		$this -> cards = $this -> getCardsCommon($this -> account);
		if(!$this -> isLoopData($this -> cards)) {
			throw new Exception('E_DONT_HOLD_CARD');
		}

		// 制限口座のチェック(出金確認時)
		if(!$this -> checkWithdrawLimit($this -> account
										, $this -> debitCurrency
										, $this -> currencyToInt(floatval($this -> amount), $this -> debitCurrency))) {
			throw new Exception('E_LIMIT_WITHDRAW');
		}

		// 金額のチェック
		if(!$this -> checkNull($this -> amount)) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 必須項目
		// debit口座のチェック
		if(!$this -> checkNull($this -> debitCurrency)) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 金額の正規表現チェック
		if(!$this -> checkStringNumber($this -> amount)) {
			throw new Exception('E_ERROR_REGULAR_NUMBER');
		}

		// チェックが通ったら各種項目を設定する
		// バランスの取得
		$this -> balance = $this -> getBalanceCommon($this -> account, $this -> debitCurrency);

		// 手数料の取得
		$fee		= $this -> getFeeCommon(VAR_CARD_DEPOSIT
											, $this -> amount
											, USD
											, $this -> account);

		$this -> setFeeEx($this -> getColumnData($fee, USD . VAL_INT_1));

		// タイプによって変更パラメータ
		if($this -> debitCurrency == USD) {				// 通貨が一緒だった場合

			$this -> debitAmount	= $this -> amount;
			$this -> toAmount		= $this -> amount;
			$this -> setRateEx(VAL_INT_1);

		} else if($this -> transferType == NO_COUNT) {	// 出金額指定

			// 出金額の両替
			$exchange	= $this -> getExchangeCommon($this -> amount
													, $this -> debitCurrency
													, USD);

			// 手数料の両替
			$fee		= $this -> getExchangeCommon($this -> getFeeEx()
													, USD
													, $this -> debitCurrency);

			$this -> debitAmount	= $this -> amount;
			$this -> toAmount		= $this -> getColumnData($exchange, PARAM_AMOUNT);
			$this -> setRateEx($this -> getColumnData($exchange, PARAM_RATE));
			$this -> setFeeEx($this -> getColumnData($fee, PARAM_AMOUNT));

		} else {										// 送金通貨指定

			// 出金額の両替
			$exchange = $this -> getExchangeCommon($this -> amount
													, USD
													, $this -> debitCurrency
													, false
													, true);

			// 手数料の両替
			$fee		= $this -> getExchangeCommon($this -> getFeeEx()
													, USD
													, $this -> debitCurrency
													, false
													, true);


			$this -> debitAmount	= $this -> getColumnData($exchange, PARAM_AMOUNT);
			$this -> toAmount		= $this -> amount;
			$this -> setRateEx($this -> getColumnData($exchange, PARAM_RATE));
			$this -> setFeeEx($this -> getColumnData($fee, PARAM_AMOUNT));
		}

		// 金額リミットチェック
		if(!$this -> checkRange($this -> toAmount, VAL_INT_1, (VAL_INT_500 * 10))) {
			throw new Exception('E_ERROR_AMOUNT');
		}

		// 口座残高チェック
		if($this -> balance < ($this -> debitAmount + $this -> getFeeEx())) {
			throw new Exception('E_INSUFFICIENT_FUNDS');
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金通貨の取得
	* @parameter	: なし
	* @return		: 送金通貨
	-------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金金額の取得
	* @parameter	: なし
	* @return		: 送金金額
	-------------------------------------------------------------------------*/
	public function getAmount() {
		return $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金金額の取得
	* @parameter	: なし
	* @return		: 送金金額
	-------------------------------------------------------------------------*/
	public function getToAmount() {
		return $this -> toAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし通貨の取得
	* @parameter	: なし
	* @return		: 引き落とし通貨
	-------------------------------------------------------------------------*/
	public function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし金額の取得
	* @parameter	: なし
	* @return		: 引き落とし金額
	-------------------------------------------------------------------------*/
	public function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	public function getRate() {
		return $this -> rate;
	}

}
?>