<?php

class LoginHistoryModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// ログイン履歴
	private $total						= NO_COUNT;		// リスト総合計

	// ------------------ 検索系 ------------------//
	private $sUserAccout 				= NO_STRING;	// 口座番号
	private $sIPAddress 				= NO_STRING;	// IPアドレス
	private $sFrom						= NO_COUNT;		// 登録時刻（開始日）（検索項目）
	private $sTo						= NO_COUNT;		// 登録時刻（終了）（検索項目）
	private $loginFlg 					= NO_COUNT; 
	// ------------------ 検索系 ------------------//

	/**
	 *
	 * anton
	 *
	 */
	private $lang						= NO_STRING;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// ------------------ 検索系 ------------------//
		$this -> sUserAccout	= $this -> getDataPost(PARAM_S_USER_ACCOUNT); 	// 口座番号
		$this -> sIPAddress		= $this -> getDataPost(PARAM_S_IP_ADDRESS); 	// IPアドレス
		$this -> sFrom			= $this -> getDataPost(PARAM_S_FROM);			// 登録時刻（開始日）（検索項目）
		$this -> sTo			= $this -> getDataPost(PARAM_S_TO);				// 登録時刻（終了）（検索項目）
		$this -> loginFlg       = $this -> getDataPost(PARAM_LOGIN_FLG);
		// ------------------ 検索系 ------------------//
		
		$this -> lang			= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		
		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('LHTR', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: なし
	* @return		: 検索条件
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtn	= array();
		$page	= NO_STRING;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 口座番号（検索項目）
		if($this -> sUserAccout != NO_STRING) {
			$rtn[] = ' users.user_account = (\')' . $this -> sUserAccout . '(\') ';
		}

		// IPアドレス（検索項目）
		if($this -> sIPAddress != NO_STRING) {
			$rtn[] = ' login_history.ip_address = (\')' . $this -> sIPAddress . '(\') ';
		}

		if($this -> loginFlg  != NO_STRING){
			// 登録時刻（開始日）（検索項目）
			if($this -> sFrom != NO_STRING) {
				$rtn[] = ' login_history.create_time >= (\')' . $this -> sFrom . '(\')';
			}

			// 登録時刻（終了）（検索項目）
			if($this -> sTo != NO_STRING) {
				$rtn[] = ' login_history.create_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
			}
		}

		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

		// 検索条件の結合
		if(count($rtn) > NO_COUNT) {
			return array(DELIMIT_AND . implode(DELIMIT_AND, $rtn), $page);
		} else {
			return array(NO_STRING, $page);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	public function exportLoginHistory(){
		if($this -> isLoopData($this -> rs)){
			
			$data = ($this -> lang == "en" ? 
					"Login Time,Name,Account Number,IP Address,User Agent\n" : 
					'ログイン時間,名前,口座番号,IPアドレス,ユーザーエージェント' . "\n");
			
			foreach($this -> rs as $row){
				//print_r($row);
				
				$arr = [];
				
				$arr[] = $this -> getColumnData($row, COLUMN_CREATE_TIME);
				$arr[] = sprintf("%s %s", $this -> getColumnData($row, COLUMN_LAST_NAME), $this -> getColumnData($row, COLUMN_FIRST_NAME));
				$arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
				$arr[] = $this -> getColumnData($row, COLUMN_IP_ADDRESS);
				$arr[] = $this -> getColumnData($row, COLUMN_USER_AGENT);
				
				$data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
			}
			
			$this -> setExportDataCommon($data);
		}
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$tType			= NO_STRING;
		$deposit		= NO_STRING;
		$withdraw		= NO_STRING;
		$depositCur		= NO_STRING;
		$withdrawCur	= NO_STRING;
		$debitCur		= NO_STRING;
		$debitAmount	= NO_STRING;
		$pStatus		= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= $this -> total;

// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> rs, $cnt);

			foreach($this -> rs as $row) {

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_LAST_NAME) . '&nbsp;' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
							// . '<td><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '</a></td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_IP_ADDRESS) . '</td>'
							. '<td class="l">' . $this -> getColumnData($row, COLUMN_USER_AGENT) . '</td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="5">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setTotal($count) {
		$this -> total = $count;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		$pager = $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> total)
										, $this -> total
										, NO_STRING, true);
		echo $pager;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座番号の取得
	 * @parameter	: なし
	 * @return		: 口座番号
	 -------------------------------------------------------------------------*/
	function echoSUserAccount() {
		echo $this -> sUserAccout;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: IPアドレスの取得
	 * @parameter	: なし
	 * @return		: IPアドレス
	 -------------------------------------------------------------------------*/
	function echoSIPAddress() {
		echo $this -> sIPAddress;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispLoginFlg
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispLoginFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_LOGIN_FLG
											, PARAM_LOGIN_FLG
											, VAL_INT_1
											, NO_STRING, $this -> loginFlg)
				. '</label>';
	}
}
?>