<?php
require_once(SYSTEM_LOGICS . 'request/model.php');

class LogicRequest extends RequestModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType() == CONTROL_ACTION) {		// 一覧データ
					$this -> lists();
				} else if($this -> getType() == TYPE_DETAIL) {	// 詳細データ
					$this -> select();
				} else if($this -> getType() == TYPE_SAVE) {	// メッセージ保存
					$this -> update();
					$this -> select();
				} else if($this -> getType() == TYPE_EXPORT) {
					$this -> lists();
					$this -> exportWithdrawalList();	
				} else if($this -> getType() == TYPE_DELETE) {
					$this -> insertActivity();
					$this -> deleteTransaction();
					$this -> lists();
				} else {
					$this -> lists();
				}
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし一覧の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		if ( $this -> getType() == TYPE_EXPORT ) {			
			$this -> setResult($this -> accessSelect('LIST_REQUEST', array($this -> getWhere())));
		} else {
			/* $this -> setResult($this -> accessSelect('LIST_REQUEST', array($this -> getWhere()))); */
			
			$start = ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$this -> setCount($this -> getWhere());
			$this -> setResult($this -> accessSelect('LIST_REQUEST_LIMIT', array($this -> getWhere(), $start, VAR_DEFAULT_PAGE_COUNT)));
			
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし詳細の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
		$this -> setDetail($this -> accessSelect('SELECT_REQUEST', array($this -> getRId())));

		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし詳細の更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('UPDATE_REQUEST_COMMENT', $this -> getUpdateParameter(),false);
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	function deleteTransaction() {
		$this -> accessModify('COPY_REQUEST_TRANSACTION', array($this -> getRId(), $this -> getAdminUserData(PARAM_UID)));
		$this -> accessModify('DELETE_REQUEST_TRANSACTION', array($this -> getRId()));

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
	}

	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(),false);
	}
}
?>