<?php
require_once('config.php');

class APISendDepositMail extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'D' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			// 変数宣言部
			$params		= array();
			$rtn		= array();
			$history	= null;
			$ago		= null;

			// ユーザデータの取得
			$account	= $this -> getAccountCommon($this -> account);
			$row		= $this -> getRowData($account);

			// パラメータの作成
			$params[] = $this -> account;
			$params[] = $this -> getNameCommon($this -> account);

			if($this -> getColumnData($row, COLUMN_MAIL) != NO_STRING) {
				$this -> sendMailByTmp('deposit_info.xml'
										, $params
										, $this -> getColumnData($row, COLUMN_MAIL)
										, VAR_BS_MAIL_ADDRESS);
			} else {
				throw new Exception('E_CAN_NOT_SEND_MAIL');
			}

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 口座の存在確認
		$account = $this -> getAccountCommon($this -> account);

		if(count($account) == NO_COUNT) {
			throw new Exception('E_REQUIRED_VALUE');
		}
	}
}

$api = new APISendDepositMail();
$api -> action();
?>