
<?php
require_once('config.php');

class APIMakeRequestStatusAuth extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $account	= NO_STRING;
	private $fee		= NO_STRING;
	private $fee2		= NO_STRING;
	private $rId			= NO_STRING;	// 引落ID
	private $amount			= NO_STRING;	// 金額
	private $currency		= NO_STRING;	// 通貨
	private $message		= NO_STRING;	// メッセージ
	private $fromCurrency	= NO_STRING;	// From通貨
	private $status			= NO_STRING;	// ステータス
	private $sendMessage	= NO_STRING;	// メッセージ（返信メッセージ）



	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;
		$row		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> rId			= $this -> getDataPost(PARAM_R_ID);									// 引落ID
			$this -> amount			= $this -> getDataPost(PARAM_AMOUNT);								// 金額
			$this -> currency		= strtoupper($this -> getDataPost(PARAM_CURRENCY));					// 金額
			$this -> message		= $this -> getDataPost(PARAM_MESSAGE);								// 金額
			$this -> fromCurrency	= strtoupper($this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY));	// From通貨
			$this -> status			= $this -> getDataPost(PARAM_STATUS);								// ステータス
			$this -> sendMessage	= $this -> getDataPost(PARAM_SEND_MESSAGE);							// メッセージ（返信メッセージ）

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'R' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			// データの更新
			$params = array();
			$params[] = $this -> rId;
			$params[] = $this -> fromCurrency;
			$params[] = $this -> currencyToInt($this -> amount, $this -> fromCurrency);
			$params[] = $this -> status;
			$params[] = $this -> rate;
			$params[] = addslashes($this -> sendMessage);
			$params[] = $this -> currencyToInt($this -> fee, $this -> fromCurrency);
			$params[] = $this -> currencyToInt($this -> fee2, $this -> currency);

			$this -> accessModify('UPDATE_REQUEST', $params);

// 			$params = $this -> getSendCompleteParams();

			// メールの送信
			$row	= $this -> getRowData($this -> getRequestCommon($this -> rId));

			$params = array();
			$params[] = $this -> getColumnData($row, COLUMN_TO_ACCOUNT);
			$params[] = $this -> getNameCommon($this -> account);
			$params[] = $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
			$params[] = $this -> getColumnData($row, COLUMN_CREATE_TIME_STRING);
			$params[] = $this -> getColumnData($row, COLUMN_CURRENCY);
			$params[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
			$params[] = $this -> getColumnData($row, COLUMN_MESSAGE);
			$params[] = $this -> getCurrentTimeCommon();
			$params[] = $this -> fromCurrency;
			$params[] = $this -> formatCurrency($this -> amount, $this -> fromCurrency);
			$params[] = addslashes($this -> sendMessage);
			$params[] = $this -> getColumnData($row, COLUMN_TO_MAIL);

			$this -> sendMailByTmp('request_complete.xml'
									, $params
									, $params[VAL_INT_11]
									, VAR_CS_MAIL_ADDRESS);

			// コミッション関連
			$data = $this -> getRowData($this -> accessSelect('LIST_REQUEST_BY_R_ID', array($this -> rId)));

			// コミッションの登録（送金元）
			$this -> registCommision(VAR_TRANSFER
									, null
									, $this -> getColumnData($data, COLUMN_FROM_ACCOUNT)
									, $this -> getColumnData($data, COLUMN_DEBIT_CURRENCY)
									, $this -> intToCurrency($this -> getColumnData($data, COLUMN_FROM_FEE), $this -> getColumnData($data, COLUMN_DEBIT_CURRENCY)));

			// コミッションの登録（送金先）
			$this -> registCommision(VAR_TRANSFER
									, null
									, $this -> getColumnData($data, COLUMN_TO_ACCOUNT)
									, $this -> getColumnData($data, COLUMN_CURRENCY)
									, $this -> intToCurrency($this -> getColumnData($data, COLUMN_TO_FEE), $this -> getColumnData($data, COLUMN_CURRENCY))
									, PARAM_TO);


			// 異通貨の場合は為替コミッション発生
			$request	= $this -> getRowData($this -> getRequestCommon($this -> rId));
			$from		= $this -> getColumnData($request, COLUMN_DEBIT_CURRENCY);
			$to			= $this -> getColumnData($request, COLUMN_CURRENCY);

			if($from != $to) {
				$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
												, $to
												, $from
												, $this -> getColumnData($request, COLUMN_DEBIT_AMOUNT));
			}



			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 口座の存在確認
		$this -> user = $this -> getAccountCommon($this -> account);

		if(count($this -> user) == NO_COUNT) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 必須項目
		// debit口座のチェック
		if(!$this -> checkNull($this -> fromCurrency)) {
			throw new Exception('E_REQUIRED_VALUE');
		}

		// 残高のチェック
		$balance			= $this -> getBalanceCommon($this -> account, $this -> fromCurrency);
		$row				= $this -> getRowData($this -> getRequestCommon($this -> rId));

		$this -> currency	= $this -> getColumnData($row, COLUMN_CURRENCY);
		$amount				= $this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> currency);
		$fee				= $this -> getFeeCommon(VAR_TRANSFER
													, $amount
													, $this -> currency
													, $this -> getColumnData($row, COLUMN_FROM_ACCOUNT)
													, $this -> getColumnData($row, COLUMN_TO_ACCOUNT));

		// バランスと（送金額 + 手数料）のチェック

		// 引き落し額
		$exchange		= $this -> getExchangeCommon($amount, $this -> currency, $this -> fromCurrency, false, true);
		$this -> amount	= $exchange[PARAM_AMOUNT];

		// 引き落し手数料
		$exchange		= $this -> getExchangeCommon($fee[$this -> currency . VAL_INT_1], $this -> currency, $this -> fromCurrency);

		$this -> fee	= $exchange[PARAM_AMOUNT];

		// レート
		$this -> rate	= $exchange[PARAM_RATE];

		// 受け取り手数料
		$this -> fee2	= $fee[$this -> currency . VAL_INT_2];
		$total			= $this -> amount + $this -> fee;
		$this -> agent1	= $fee[PARAM_AGENT_CODE . VAL_INT_1];
		$this -> agent2	= $fee[PARAM_AGENT_CODE . VAL_INT_2];


		if($balance < $total) {
			throw new Exception('E_INSUFFICIENT_FUNDS');
		}

		// 制限口座のチェック
		if(!$this -> checkWithdrawLimit($this -> account, $this -> getColumnData($row, COLUMN_CURRENCY), $this -> getColumnData($row, COLUMN_AMOUNT))) {
			throw new Exception('E_LIMIT_WITHDRAW');
		}
	}
}

$api = new APIMakeRequestStatusAuth();
$api -> action();
?>