<?php
require_once(SITE_LOGICS . 'support/model.php');

class LogicSupport extends SupportModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType()		== NO_STRING
			|| $this -> getType()	== TYPE_INPUT) {		// 入力画面
			$this -> select();
		} else if($this -> getType() == TYPE_COMPLETE) {	// 完了画面
			$this -> send();
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function select() {

		// 変数宣言部
		$rs		= null;
		$row	= null;

		// データの取得
		$rs = $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));

		$this -> setUserData($this -> getRowData($rs));

		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function send() {

		// 変数宣言部
		$mail	= $this -> getEmail();
		$rs		= null;

		// データ用生成用のデータを取得する
		$rs = $this -> getAccountByEmailCommon($mail);

		// アドミン側へ送信
		$this -> sendMailByTmp('send_mail_for_admin.xml'
								, $this -> getSendParamsForAdmin($rs)
								, VAR_CS_MAIL_ADDRESS
								, $mail);

		// ユーザ側へ送信
		$this -> sendMailByTmp('send_mail_for_user.xml'
								, $this -> getSendParamsForUser($rs)
								, $mail
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>