<?php
require_once(SYSTEM_LOGICS . 'withdraw/logic.php');

class ControlWithdraw extends LogicWithdraw {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		try {

			// アクション実行
			$this -> logic();

			if($this -> getType() == TYPE_EXPORT) {					// エクスポート

				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=Withdraw_' . date('Ymd') . '.csv');
				header('Content-Transfer-Encoding: binary');

				readfile(SYSTEM_DOCUMENT_WITHDRAW . date('Ymd') . '.csv');



			} elseif($this -> getType() == TYPE_EXPORT_FLAT3) {					// エクスポート

                header('Content-Encoding: UTF-8');
				header("Content-type: text/csv; charset=UTF-8");
				header('Content-Disposition: attachment; filename=Withdraw_Flat3_' . date('Ymd') . '.csv');
				header('Content-Transfer-Encoding: binary');

                echo "\xEF\xBB\xBF";
				echo $this -> getExportDataCommon();

			} else if($this -> getType() == TYPE_EXPORT_COMMON) {	// 共通エクスポート

				// header('Content-Type: application/octet-stream');
				header('Content-Encoding: UTF-8');
				header("Content-type: text/csv; charset=UTF-8");
				header('Content-Disposition: attachment; filename=Withdraw_' . date('YmdHis') . '.csv');
				header('Content-Transfer-Encoding: binary');

				echo "\xEF\xBB\xBF";
				echo $this -> getExportDataCommon();

			} else if($this -> getType() == TYPE_INPUT) {			// 銀行口座の入力
				require_once($this -> getSystemHTML('TEMPLATE_WITHDRAW_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {			// 銀行口座の確認
				require_once($this -> getSystemHTML('TEMPLATE_WITHDRAW_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {		// 銀行口座の完了
				require_once($this -> getSystemHTML('TEMPLATE_WITHDRAW_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getType()		== TYPE_DETAIL
						|| $this -> getType()	== TYPE_SAVE) {		// データの詳細表示とステータスの更新
				require_once($this -> getSystemHTML('TEMPLATE_WITHDRAW_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_FLAT3_PREVIEW) {		// 銀行口座の完了
				require_once($this -> getSystemHTML('TEMPLATE_WITHDRAW_FLAT3_PREVIEW_PATH', $this -> dispHTML()));

			} else {												// 画面の表示（一覧）
				require_once($this -> getSystemHTML('TEMPLATE_WITHDRAW_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>