<?php
require_once(SYSTEM_LOGICS . 'transfer/logic.php');

class ControlTransfer extends LogicTransfer {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		try {

			// アクション実行
			$this -> logic();

			if($this -> getType() == CONTROL_ACTION) {			// 口座番号の入力
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_ACTION_PATH', $this -> dispHTML()));
			} else if($this -> getType() == TYPE_INPUT) {		// 口座振替情報の入力
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_INPUT_PATH', $this -> dispHTML()));
			
			} else if($this -> getType() == TYPE_CONFIRM) {		// 口座振替情報の確認
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {		// 口座振替情報の完了
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_COMPLETE_PATH', $this -> dispHTML()));
			
			} else if($this -> getType() == TYPE_DETAIL) {		// 詳細の表示
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_DETAIL_PATH', $this -> dispHTML()));
			} else if($this -> getType() == TYPE_UPDATE) {		// メッセージ更新
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_DETAIL_PATH', $this -> dispHTML()));
			} else if($this -> getType() == TYPE_EXPORT) {
                $this -> exportData();
            } else {											// 画面の表示（一覧）
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>