<?php
class MstExchangeFeeModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs 								= null;
	private $detail 							= null;
	private $fees								= null;			// 手数料リスト
	private $patterns							= null;			// パターンリスト

	private $pId								= NO_STRING;	// パターンID
	private $patternName						= NO_STRING;	// パターン名
	private $exModification						= NO_STRING;	// ex-modif-flag
	private $currentPattern						= NO_STRING;	// currentpattern
	
	private $sPatternName						= NO_STRING;	// パターン名

	private $lang 								= NO_STRING;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> pId			= $this -> getPosParameter(PARAM_P_ID);				// パターンID
		$this -> patternName	= $this -> getPosParameter(PARAM_PATTERN_NAME);		// パターン名
		$this -> exModification	= $this -> getPosParameter(PARAM_DATA_MODIFICATION);	// anton
		$this -> currentPattern	= $this -> getPosParameter(PARAM_CURRENT_PATTERN);			// mikko
		
		if($this -> getType()	== TYPE_COMPLETE
			&& $this -> pId		=== NO_STRING) {
			$this -> pId = $this -> getSequenceNo(SQ_EXCHANGE_FEE);
		}
				
		$this -> lang			= $this -> getLangage();
	}

	public function restore(){
		$this -> pId			= $this -> getColumnData($this -> detail, COLUMN_M_F_ID);		//$this -> getColumnData($row, COLUMN_M_F_ID);	// パターンID
		$this -> patternName	= $this -> getColumnData($this -> detail, COLUMN_PATTERN_NAME);      //$this -> getColumnData($row, COLUMN_PATTERN_NAME); // $this -> getDataPost(PARAM_PATTERN_NAME);		// パターン名
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('XSET', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_COMPLETE) {
			//check access
			if(!$this -> checkAdminUserAccess('XSET', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
			//check if name already exist
			if($this -> checkExistPattern($this -> patternName) && $this -> currentPattern != $this -> patternName ){
				$this -> popUpSessionMessage(ERROR, 'E_EXIST_DATA', array($this -> patternName));
				$this -> setType($this -> exModification != NO_STRING ? TYPE_DETAIL : TYPE_CREATE);
			}
		}

		if($this -> getType() == TYPE_CREATE) {
			//check access
			if(!$this -> checkAdminUserAccess('XSET', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('XSET', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			} elseif($this -> pId == NO_COUNT){//check if default pattern is being deleted
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				$this -> setType(TYPE_DETAIL);
			}
		}

		// will validate if the inputted pattern name is not empty
		if($this -> getType() == TYPE_COMPLETE) {
			if(trim($this -> patternName) == NO_STRING && $this -> pId != NO_COUNT) {
				$this -> setType($this -> exModification != NO_STRING ? TYPE_DETAIL : TYPE_CREATE);
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_EMPTY_PATTERN_NAME', array());
				$rtn = false;
			}
			
			// The default exchange setting shouldn't have other name. 
			if ($this -> pId == NO_COUNT) {
				$this -> patternName = NO_STRING;
			}
		}
		

		/* if(!$rtn){
			$this -> setType();
			
		} */
		
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: getwhere
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	public function getWhere() {
		$rtn		= NO_STRING;

		//search pattername
		if($this -> patternName != NO_STRING) {
			$rtn .= ' AND pattern_name = (\')' . $this -> patternName . '(\')';
		}

		return $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの取得
	* @parameter	: なし
	* @return		: 一覧データ
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$currencies	= null;
		$from		= NO_STRING;
		$to			= NO_STRING;
		$whole		= NO_COUNT;
		$markup		= NO_COUNT;
		$fees		= array();
		$pId		= NO_COUNT;

		if($this -> pId !== NO_STRING) {
			$pId = $this -> pId;
		}

		// 為替手数料データの取得
		$fees = $this -> getExchangeFeeCommon($pId);

		// 通貨データを取得
		$currencies = $this -> getCurrencyList();

		if($this -> isLoopData($currencies)) {	// データが存在する場合

			// 各通貨のレートを設定する
			foreach($currencies as $name => $val) {

				// From通貨
				$from = $this -> getColumnData($val, PARAM_DATA_KEY);

				foreach($currencies as $nameSub => $valSub){

					// From通貨
					$to = $this -> getColumnData($valSub, PARAM_DATA_KEY);

					// 手数料データが存在するか否か
					if(isset($fees[$from][$to])) {
						$whole	= $this -> intToCurrency($fees[$from][$to][COLUMN_WHOLE], PERCENT);
						$markup	= $this -> intToCurrency($fees[$from][$to][COLUMN_MARKUP], PERCENT);
					} else {
						$whole	= $this -> intToCurrency(NO_COUNT, PERCENT);
						$markup	= $this -> intToCurrency(NO_COUNT, PERCENT);
					}

					// 同一通貨以外の場合リスト表示
					if($from != $to) {
						//check if register page
						if($this -> getType() == TYPE_CREATE){
							$whole 	= '';
							$markup = '';
						}

						$rtn .= '<tr>'
								. '<td>' . $from . '</td>'
								. '<td>' . $to . '</td>'
								. '<td><input type="text" class="w80p ralign" id="whole_' . $from . DELIMIT_UNDER_BAR . $to . '" name="whole_' . $from . DELIMIT_UNDER_BAR . $to . '" value="' . $whole . '" />&nbsp;%</td>'
								. '<td><input type="text" class="w80p ralign" id="markup_' . $from . DELIMIT_UNDER_BAR . $to . '" name="markup_' . $from . DELIMIT_UNDER_BAR . $to . '" value="' . $markup . '" />&nbsp;%</td>'
								. '</tr>';
					}
				}
			}

		} else {								// データが存在しない場合
			$rtn = '<tr><td colspan="3">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パターンデータの取得
	* @parameter	: なし
	* @return		: パターンデータ
	-------------------------------------------------------------------------*/
	public function dispPatterns() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> isLoopData($this -> patterns)) {

			foreach($this -> patterns as $row) {
				$rtn .= '<tr>'
						. '<td><a href="javascript:actionDetail(\''. $this -> getColumnData($row, COLUMN_M_F_ID).'\',\'_blank\')">' . $this -> getColumnData($row, COLUMN_PATTERN_NAME) . '</a></td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATED_BY) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						. '</tr>';

			}
		}

		echo $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 手数料登録用データの取得
	* @parameter	: なし
	* @return		: 手数料登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {
		// var_dump($this -> pId);
		// die();
		// 変数宣言部
		$rtn		= array();
		$currencies	= null;
		$fee		= NO_STRING;
		$pId		= NO_STRING;

		// 通貨データを取得
		$currencies = $this -> getCurrencyList();

		if($this -> isLoopData($currencies)) {	// データが存在する場合

			if($this -> pId === NO_STRING) {

			} else {
				$pId = $this -> pId;
			}

			// 各通貨のレートを設定する
			foreach($currencies as $name => $val) {

				// From通貨
				$from = $this -> getColumnData($val, PARAM_DATA_KEY);

				foreach($currencies as $nameSub => $valSub){

					// From通貨
					$to = $this -> getColumnData($valSub, PARAM_DATA_KEY);

					// 同一通貨以外の場合リスト表示
					if($from != $to) {

						// POSTデータの取得
						$whole	= floatval($this -> getPosParameter('whole' . DELIMIT_UNDER_BAR . $from . DELIMIT_UNDER_BAR . $to));
						$markup	= floatval($this -> getPosParameter('markup' . DELIMIT_UNDER_BAR . $from . DELIMIT_UNDER_BAR . $to));

						$rtn[] = '((\')' . $pId . '(\'), (\')' . $this -> patternName . '(\'), (\')' . $from . '(\'), (\')' . $to . '(\'), (\')' . $this -> currencyToInt($whole, PERCENT) . '(\'), (\')' . $this -> currencyToInt($markup, PERCENT) . '(\'),  NOW() + INTERVAL 17 HOUR, (\')'. $this -> getAdminUserData(PARAM_FIRST_NAME) .'&nbsp;'. $this -> getAdminUserData(PARAM_LAST_NAME) .'(\'))';
						
					}
				}

			}

			return array(implode(DELIMIT_COMMA, $rtn));
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パターンIDの取得
	* @parameter	: なし
	* @return		: パターンID
	-------------------------------------------------------------------------*/
	public function getPId() {
		return $this -> pId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料データの設定
	* @parameter	: 手数料データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setFees($rs) {
		$this -> fees = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パターンリストデータの設定
	* @parameter	: パターンリストデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setPatterns($rs) {
		$this -> patterns = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoPattern
	* @parameter	: pattern name
	* @return		: 
	-------------------------------------------------------------------------*/
	public function echoPattern() {
		echo $this -> patternName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoPattern
	* @parameter	: pattern name
	* @return		: 
	-------------------------------------------------------------------------*/
	public function echoPid() {
		echo $this -> pId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: selectDetail
	* @parameter	: detailed data
	* @return		: 
	-------------------------------------------------------------------------*/
	public function setDetail($rs) {
		$this -> detail = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/

	public function getActivity(){
		$rtn 				= array();
		$details 			= array();
		$fees 				= array();
		$type 				= $this -> getType();
		$message 			= NO_STRING;
		$currencies			= null;
		$pId 				= $this -> pId;

		$fees 				= $this -> getExchangeFeeCommon($pId);

		if($type == TYPE_DELETE){
			$message = 'Deleted exchange fee setting ' . $this -> patternName;
		}elseif($type == TYPE_COMPLETE){
			if($fees != NULL){
				$currencies = $this -> getCurrencyList();

				$rs 		= $this -> accessSelect('LIST_MST_EXCHANGE_FEE', array($this -> pId));
				$origName 	= $this -> getColumnData($rs[0], COLUMN_PATTERN_NAME);

				//from submitted values
				foreach($currencies as $name => $val) {

					// From通貨
					$from = $this -> getColumnData($val, PARAM_DATA_KEY);

					foreach($currencies as $nameSub => $valSub){

						// From通貨
						$to = $this -> getColumnData($valSub, PARAM_DATA_KEY);

						if(isset($fees[$from][$to])) {
							$whole2		= $this -> intToCurrency($fees[$from][$to][COLUMN_WHOLE], PERCENT);
							$markup2	= $this -> intToCurrency($fees[$from][$to][COLUMN_MARKUP], PERCENT);
						} else {
							$whole2		= $this -> intToCurrency(NO_COUNT, PERCENT);
							$markup2	= $this -> intToCurrency(NO_COUNT, PERCENT);
						}

						// 同一通貨以外の場合リスト表示
						if($from != $to) {
							// echo $to.'<br>';
							// POSTデータの取得
							$whole	= floatval($this -> getPosParameter('whole' . DELIMIT_UNDER_BAR . $from . DELIMIT_UNDER_BAR . $to));
							$markup	= floatval($this -> getPosParameter('markup' . DELIMIT_UNDER_BAR . $from . DELIMIT_UNDER_BAR . $to));
							$w[] = $this -> currencyToInt($whole, PERCENT);
							$m[] = $this -> currencyToInt($markup, PERCENT);
							$currencyFrom[] = $from;
							$currencyTo[]	 = $to;

							$w2[] = $this -> currencyToInt($whole2, PERCENT);
							$m2[] = $this -> currencyToInt($markup2, PERCENT);
							$currencyFrom2[] = $from;
							$currencyTo2	 = $to;
							
						}


					}
				}

				if($origName != $this -> patternName){
					$details[] .= 'pattern name from ['. $origName .'] to ['. $this -> patternName .']';
				}
				for($i = 0; $i < (count($w)); $i++){
					if($w2[$i] != $w[$i]){
						$details[] .=  $currencyFrom[$i] . '->' . $currencyTo[$i] . ' wholesale price  from ['. ($w2[$i] == 0 ? '0.00' : substr_replace($w2[$i], '.', -2, 0)). '] to ['. ($w[$i] == 0 ? '0.00' : substr_replace($w[$i], '.', -2, 0)).']';
					}

					if($m2[$i] != $m[$i]){
						$details[] .=  $currencyFrom[$i] . '->' . $currencyTo[$i] . ' mark up from ['. ($m2[$i] == 0 ? '0.00' : substr_replace($m2[$i], '.', -2, 0)). '] to ['. ($m[$i] == 0 ? '0.00' : substr_replace($m[$i], '.', -2, 0)).']';
					}
				}

				if($details != NULL){
					$message = 'Edited '. $this -> patternName .'\'s '. implode(', <br/>', $details);
				}else{
	   				$message = 'Saved without any changes';
	   			}

			}else{
				$message = 'Created new Exchange Fee Setting ['. $this -> patternName .']';
			}

		}

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 19;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}




}
?>