<?php
require_once(SYSTEM_LOGICS . 'api_signature/logic.php');

class ControlApiSignature extends LogicApiSignature {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		try {

			// アクション実行
			$this -> logic();

			if($this -> getType() == CONTROL_ACTION) {			// 登録口座の入力
				require_once($this -> getSystemHTML('TEMPLATE_API_SIGNATURE_ACCOUNT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_INPUT) {		// データの登録
				require_once($this -> getSystemHTML('TEMPLATE_API_SIGNATURE_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {		// データの確認
				require_once($this -> getSystemHTML('TEMPLATE_API_SIGNATURE_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType()		== TYPE_EDIT
						|| $this -> getType()	== TYPE_BACK) {	// データの修正
				require_once($this -> getSystemHTML('TEMPLATE_API_SIGNATURE_EDIT_PATH', $this -> dispHTML()));

			} else {											// 一覧データ
				require_once($this -> getSystemHTML('TEMPLATE_API_SIGNATURE_LIST_PATH', $this -> dispHTML()));
			}
		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>