<?php
require_once(SYSTEM_LOGICS . 'advertisements/model.php');

class LogicAdvertisements extends AdvertisementModelClass {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			// 初期データ処理
			if($this -> init()){
				$this -> lists();
				
			}elseif($this -> getType() == TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE){
				if($this -> checkChiket()) {
					$this -> popUpSessionMessage(INFO, 'I_COMPLATE_SAVE', array());
				}
				$this -> insertActivity();
				$this -> loadImageAds();
				$this -> listsImages();
			}elseif($this -> getType() == TYPE_IMAGE_MANAGER || $this -> getType()	== TYPE_SEARCH){
				$this -> listsImages();
			}elseif($this -> getType() == TYPE_IMAGE_MANAGER_DETAIL){
				$this -> selectAdDetails();
			}elseif($this -> getType() == TYPE_UPDATE){
				$this -> insertActivity();
				$this -> update();
			}elseif($this -> getType() == TYPE_DELETE){
				$this -> insertActivity();
				$this -> deleteAd();
				$this -> listsImages();
			}else{
				$this -> lists();
			}
			
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		//set variables
		//$where = null;

		$where = $this -> getWhere();
		//$this -> getWhere();
		$this -> setResult($this -> accessSelect('LIST_CLICKED_ADS', $where));

	}


	function listsImages() {
		$this -> setImages($this -> accessSelect('LIST_IMAGES', $this -> getWhereAds()));
	}

	function selectAdDetails(){
		$this -> setAdDetails($this -> accessSelect('SELECT_AD_DETAILS', array($this -> getAdID())));
		$this -> restore();
	}

	function update(){
		$this -> accessModify('UPDATE_AD_DETAILS', $this -> getUpdateData());
	}

	function updateSequence(){
		$this -> getUpdateSequence();
	}

	function deleteAd(){
		$this -> accessModify('DELETE_AD_FILE', $this -> getDeleteData(), false);
	}

    function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}

}


?>