<?php
require_once(SITE_LOGICS . 'settlement/model.php');

class LogicSettlement extends SettlementModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// POSTのログを取る
			$this -> logPost();

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		//check if type is control action
		if($this -> getType() == CONTROL_ACTION) {
			//unset session variable for previous type
			unset($_SESSION['settlement_previous_type']);
		}

		if($this -> getType() == TYPE_COMPLETE) {

			//unset session variables before redirection
			unset($_SESSION['settlement_amount']);
			unset($_SESSION['settlement_previous_type']);
			unset($_SESSION['settlement_user_account']);
			unset($_SESSION['settlement_debit_currency']);
			unset($_SESSION['settlement_currency']);
			unset($_SESSION['to_fee']);
			unset($_SESSION['from_fee']);
			unset($_SESSION['request_token']);

			try {
				$registResult = $this -> regist();
				$this -> forward($registResult);
			} catch(Exception $e) {
				$this -> forward(VAL_INT_1);
			}

		} else if($this -> getType()		== TYPE_INPUT
					|| $this -> getType()	== TYPE_CONFIRM) {
			$this -> select();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function lists() {}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function select() {
		$this -> setAccount($this -> getAccountCommon($this -> getToAccount()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {

		if($this -> accessModify('INSERT_TRANSFER_API', $this -> getRegistData())) {

			// コミッションの登録（送金元）
			$this -> registCommision(VAR_TRANSFER
									, null
									, $this -> getUserData(PARAM_USER_ACCOUNT)
									, $this -> getDebitCurrency()
									, $this -> getFromFee());

			// コミッションの登録（送金先）
			$this -> registCommision(VAR_TRANSFER
									, null
									, $this -> getToAccount()
									, $this -> getCurrency()
									, $this -> getToFee());

			// 異通貨の場合は為替コミッション発生
			$from	= $this -> getDebitCurrency();
			$to		= $this -> getCurrency();

			if($from != $to) {

				// 着金額指定の場合
				$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
													, $to
													, $from
													, $this -> currencyToInt($this -> getDebitAmount(), $from));
			}

			// メールを送信（送金元ユーザ）
			$params = $this -> getSendDataFrom();
			$this -> sendMailByTmp('transfer_send_user.xml'
									, $params
									, $params[VAL_INT_11]
									, VAR_CS_MAIL_ADDRESS);

			// メールを送信（送金先ユーザ）
			$params = $this -> getSendDataTo();
			$this -> sendMailByTmp('transfer_receive_user.xml'
									, $params
									, $params[VAL_INT_11]
									, VAR_CS_MAIL_ADDRESS);
			return NO_COUNT;
		} else {
			return VAL_INT_1;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function forward($result) {

		// 変数宣言部
		$url = NO_STRING;
		$data		= null;

		// 転送先
		$url		= $this -> getUrl();
		$callBack	= $this -> getCallBackUrl();
		$failUrl	= $this -> getFailUrl();

		// コールバック
		$data = $this -> getForwardParams($result);
		$jsonData = json_encode($data);
		$data = http_build_query($data, '', '&');

		//log directory
		$apiPath 		= dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
		$requestUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'settlement'.DIRECTORY_SEPARATOR.'settlement_response_data';

		if(!file_exists($requestUrl))
		{
			mkdir($requestUrl, 0777, true);
		}

		//log data
		error_log(date("\r\n[Y-m-d H:i:s]") . "Return URL:\r\n" . $callBack . "\r\n context: " . $data . "\r\n", 3, $requestUrl.DIRECTORY_SEPARATOR.'Log_' . date("Y-m-d") . '.log');
		chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

		$header = array('Content-Type: application/x-www-form-urlencoded'
						, 'Content-Length: ' . strlen($data)
		);

		$opts = array('http' => array('method'			=> 'POST'
										, 'header'  	=> implode("\r\n", $header)
										, 'content'		=> $data)
		);

		$context = stream_context_create($opts);

		// コールバック送信！
		$file = file_get_contents($callBack, false, $context);

		if(isset($_SERVER['REMOTE_ADDR'])) {
			$ip = $_SERVER['REMOTE_ADDR'];
		}

		if(isset($_SERVER['HTTP_REFERER'])) {
		    $referer = $this -> sqlSanitation($_SERVER['HTTP_REFERER']);
		}
		// 転送をする
		if($url			!= NO_STRING
			&& $file	== NO_COUNT
			&& $result == NO_COUNT) {	// 正常終了
			$this -> accessModifyCommon('INSERT_LOG_POST', array($ip,$referer,'[CALLBACK_SUCCESSFUL]'.$jsonData));
			header('Location: ' . $url);

		} else {						// 異常
			$this -> accessModifyCommon('INSERT_LOG_POST', array($ip,$referer,'[CALLBACK_ERROR]'.$jsonData));
			if($failUrl != NO_STRING) {
				header('Location: ' . $failUrl);
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>