<?php
require_once(SITE_LOGICS . 'register/logic.php');

class ControlRegister extends LogicRegister {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$result = NO_STRING;

		try {

			// アクション実行
			$result = $this -> logic();

			// 画面の表示
			if($this -> getType()						== TYPE_INPUT
				&& $this -> getAccountType()			== VAR_PERSON) {	// 入力画面（個人口座）
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_STEP_2_PATH', $this -> dispHTML()));

			} else if($this -> getType()				== TYPE_INPUT
						&& $this -> getAccountType()	== VAR_CORP) {		// 入力画面（法人口座）
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_STEP_2_CORPORATE_PATH', $this -> dispHTML()));

			} else if($this -> getType()				== TYPE_CONFIRM
						&& $this -> getAccountType()	== VAR_PERSON) {	// 確認画面（個人口座）
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_STEP_3_PATH', $this -> dispHTML()));

			} else if($this -> getType()				== TYPE_CONFIRM
						&& $this -> getAccountType()	== VAR_CORP) {		// 確認画面（法人口座）
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_STEP_3_CORPORATE_PATH', $this -> dispHTML()));

			} else if($this -> getType()				== TYPE_COMPLETE) {	// メール送信画面
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_STEP_4_PATH', $this -> dispHTML()));

			} else if($this -> getType()				== TYPE_FAIL) {		// エージェントコード無効
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_FAIL_PATH', $this -> dispHTML()));

			} else {														// その他
				require_once($this -> getUserHTML('TEMPLATE_REGISTER_STEP_1_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /' . $this ->  getLangage() . '/login');
		}
	}
}
?>