<?php
require_once('config.php');
require_once('CheckTransferBase.php');

class APIMakeTransfer extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $fromAccount				= NO_STRING;	// 送金元口座
	private $toAccount					= NO_STRING;	// 送金先口座
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $debitCurrency				= NO_STRING;	// 引落通貨
	private $message					= NO_STRING;	// 送金メッセージ

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$params		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> fromAccount				= $this -> getDataPost(PARAM_FROM);							// 送金元口座
			$this -> toAccount					= $this -> getDataPost(PARAM_TO);							// 送金先口座
			$this -> currency					= strtoupper($this -> getDataPost(PARAM_CURRENCY));			// 通貨
			$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);						// 金額
			$this -> debitCurrency				= strtoupper($this -> getDataPost(PARAM_DEBIT_CURRENCY));	// 引落通貨
			$this -> message					= $this -> getDataPost(PARAM_MESSAGE);						// メッセージ

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'T' . $this -> fromAccount . $this -> toAccount);
			}

			// チェッククラスの生成
			$base = new APICheckTransferBase();
			$rs = $base -> action();

			$debitAmount = $this -> getColumnData($base, PARAM_AMOUNT);

			// 取引番号の生成
			$transactionNum = $this -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);

			// 送金実行
			$params[] = $this -> fromAccount;																			// 送金元口座番号
			$params[] = $this -> fromAccount;																			// 送金元口座番号
			$params[] = $this -> debitCurrency;																			// 送金通貨
			$params[] = $this -> currencyToInt($this -> getColumnData($rs, PARAM_FROM_FEE), $this -> debitCurrency);	// 口座元手数料
			$params[] = $this -> toAccount;																				// 送金先口座番号
			$params[] = $this -> currency;																				// 送金元通貨
			$params[] = $this -> currencyToInt($this -> getColumnData($rs, PARAM_TO_FEE), $this -> currency);			// 送金先手数料
			$params[] = $this -> amount;																				// 入力金額
			$params[] = NO_COUNT;																						// 送金方法
			$params[] = addslashes($this -> message);																	// メッセージ
			$params[] = $this -> debitCurrency;																			// 出金通貨
			$params[] = $this -> currencyToInt($this -> getColumnData($rs, PARAM_AMOUNT), $this -> debitCurrency);		// 出金金額
			$params[] = $this -> currency;																				// 送金通貨
			$params[] = $this -> currencyToInt($this -> amount, $this -> currency);										// 送金金額
			$params[] = $this -> getColumnData($base, PARAM_RATE);														// レート
			$params[] = NO_COUNT;																						// 処理種別
			$params[] = NO_STRING;																						// 管理者ID
			$params[] = VAL_INT_2;																						// 処理ステータス
			$params[] = $transactionNum;																				// 取引番号

			$this -> accessModify('INSERT_TRANSFER', $params, false);

			// 通貨が違う場合は、為替コミッションの発生
			if($this -> debitCurrency != $this -> currency) {

				// 着金額指定の場合
				$this -> registCommisionExchange($this -> fromAccount
												, $this -> currency
												, $this -> debitCurrency
												, $this -> currencyToInt($debitAmount, $this -> debitCurrency));
			}

			// コミッションの集計（送金元）
			$this -> registCommision(VAR_TRANSFER
									, null
									, $this -> fromAccount
									, $this -> debitCurrency
									, $this -> getColumnData($base, PARAM_FROM_FEE));

			// コミッションの集計（送金先）
			$this -> registCommision(VAR_TRANSFER
									, null
									, $this -> toAccount
									, $this -> currency
									, $this -> getColumnData($base, PARAM_TO_FEE)
									, PARAM_TO);

			// 返却値生成(成功時)
			$rtn[PARAM_RESULT]				= 'OK';
			$rtn[PARAM_MESSAGE]				= 'I_COMPLETE_PROCESS';
			$rtn[PARAM_TRANSACTION_NUMBER]	= $transactionNum;
			$rtn[PARAM_CURRENCY]			= $this -> currency;
			$rtn[PARAM_AMOUNT]				= $this -> amount;
			$rtn[PARAM_DEBIT_CURRENCY]		= $base -> getDebitCurrency();
			$rtn[PARAM_DEBIT_AMOUNT]		= $this -> getColumnData($rs, PARAM_AMOUNT);
			$rtn[PARAM_FEE]					= $this -> getColumnData($rs, PARAM_FROM_FEE);
			$rtn[PARAM_RATE]				= $this -> getColumnData($rs, PARAM_RATE);
			echo json_encode($rtn);

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {
	}
}

$api = new APIMakeTransfer();
$api -> action();
?>