<?php
require_once('../system/lib/config.php');

class GetBalanceAllUser extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$csv		= array();

		try {

			// ファイルを作成する
			$handle = fopen('balance.csv', 'w+');
			// データを取得
			$rs = $this -> accessSelect('SELECT_USER_BALANCES_API', array());
			$title = array();
			$title[] = "UserAccount";
			$title[] = "Currency";
			$title[] = "DepositAmount";
			$title[] = "WithdrawAmount";
			$title[] = "Balance";
			fputcsv($handle, $title);

			// ダウンロード
			if($this -> isLoopData($rs)) {
				// ファイルを作成する
				foreach($rs as $row) {

					$csv = array();
					$csv[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
					$csv[] = $this -> getColumnData($row, COLUMN_CURRENCY);
					$csv[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
					$csv[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
					$csv[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_BALANCE), $this -> getColumnData($row, COLUMN_CURRENCY));

					fputcsv($handle, $csv);
				}
			}

			header('Content-Type: application/force-download');
			header('Content-Length: '.filesize('balance.csv'));
			header('Content-disposition: attachment; filename="balance.csv"');

			readfile('balance.csv');

			// ファイルのクローズ
			fclose($handle);

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {}
}

$api = new GetBalanceAllUser();
$api -> action();
?>