<?php
require_once('config.php');
require_once('CheckWithdrawBase.php');

class APICheckWithdraw extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'W' . $this -> account);
			}
		} catch (Exception $e) {
			throw $e;
		}
	}
}

try {


	$api = new APICheckWithdraw();
	$api -> action();

	// チェックロジック
	$api = new APICheckWithdrawBase();
	$api -> action();

	echo json_encode(array('result'			=> 'OK'
						, 'messages'		=> 'I_COMPLETE_PROCESS'
						, 'currency'		=> $api -> getCurrency()
						, 'amount'			=> $api -> getAmount()
						, 'debit_currency'	=> $api -> getDebitCurrency()
						, 'debit_amount'	=> $api -> getDebitAmount()
						, 'fee'				=> $api -> getFeeEx()));

} catch (Exception $e) {	// チェックエラー

	$rtn = array('result'		=> 'NG'
				, 'messages'	=> $e -> getMessage());

	echo json_encode($rtn);
}
?>