<?php
require_once(SYSTEM_LOGICS . 'transfer_batch/logic.php');

class ControlTransferBatch extends LogicTransferBatch {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		try {
		    $this -> checkAvailability("system", function(){
		        require_once($this -> getSystemHTML('TEMPLATE_MAINTENANCE_MODE_SYSTEM_PATH'));
		        exit();
		    });
		    
			// アクション実行
			$this -> logic();

			if($this -> getType() == TYPE_IMPORT) {						// CSVインポート
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_IMPORT_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_IMPORT_CONFIRM) {		// CSVデータの確認
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_IMPORT_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_EXPORT) {				// ファイルダウンロード
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=' . $this -> getOldFilename());
				header('Content-Transfer-Encoding: binary');
				readfile(SYSTEM_DOCUMENT_TRANSFER . $this -> getNewFilename());

			} else if($this -> getType() == TYPE_EXPORT_ERROR) {		// ファイルダウンロード（エラー）
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=' . $this -> getTId() . '_err.csv');
				header('Content-Transfer-Encoding: binary');
				readfile(SYSTEM_DOCUMENT_TRANSFER . $this -> getTId() . '_err.csv');
			} else {											// 画面の表示（一覧）
				require_once($this -> getSystemHTML('TEMPLATE_TRANSFER_BATCH_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>