<?php
class SiteHeaderModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $accunt	= NO_STRING;
	private $name	= NO_STRING;
	private $rs		= null;
	private $mail   = NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

			return true;
		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> accunt	= $this -> getUserData(PARAM_USER_ACCOUNT);
		$this -> name	= $this -> getUserData(PARAM_NAME);
		$this -> mail   = $this->getUserData(PARAM_MAIL);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
        // ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}
    }

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function echoAccount() {
		echo $this -> accunt;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: なし
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	public function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 未読告知リンク取得
	 * @parameter	: なし
	 * @return		: 未読告知リンク
	 -------------------------------------------------------------------------*/
	public function echoUnreadNews() {

		if(count($this -> rs) != NO_COUNT) {
			echo '<p class="bolded"><a href="news.php" class="red"><span class="fa fa-envelope fa-lg"></span> ' . $this -> getMessage(INFO, 'I_NEW_NEWS', array()) . '</a></p>';
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザアカウントを取得
	 * @parameter	: なし
	 * @return		: ユーザアカウント
	 -------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtn = array();
		$lang = NO_COUNT;

		// 言語判定
		if(isset($_SERVER["REQUEST_URI"])) {
			$langStr = $_SERVER["REQUEST_URI"];
			$langStr = explode(DELIMIT_SLASH, $langStr);
			$langStr = $langStr[VAL_INT_1];
			if($langStr == "ja") {
				$lang = NO_COUNT;
			} else if($langStr == "en") {
				$lang = VAL_INT_1;
			} else if($langStr == "sc") {
				$lang = VAL_INT_2;
			} else if($langStr == "tc") {
				$lang = VAL_INT_3;
			} else if($langStr == "id") {
				$lang = VAL_INT_4;
			}
		}

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// ユーザアカウント
		$rtn[] = $lang;										// 言語

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: リストの設定
	 * @parameter	: リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 氏名の取得
	 * @parameter	: なし
	 * @return		: 氏名
	-------------------------------------------------------------------------*/
	public function echoMail()
	{
		echo $this->mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispTransferSetting
	* @parameter	: 
	* @return		: Internal Transfer Setting Submenu
	-------------------------------------------------------------------------*/
	public function dispTransferSetting() {
		$accountType = $this -> accessSelect('SELECT_ACCOUNT_TYPE', array($this -> mail));
		$lang 		= $this -> getLangage();

		switch ($lang) {

			case 'en':
				$content = 'Internal Transfer Settings';
				break;
			case 'sc':
				$content = '内部转账设定';
				break;
			case 'tc':
				$content = '內部轉帳設定';
				break;
			case 'ja':
				$content = '口座間送金セッティング';
				break;
			case 'id':
				$content = 'Pengaturan Transfer Internal';
				break;

		}
		
		if(count($accountType) > 0){
			echo '<li><a href="setting?type=TransferSettings">'.$content.'</a></li>';
		}
	}
}
?>