<?php
$page_title = "Create an account";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
    <!-- メインエリア -->
<wrapper class="mymain_container">
	<section class="container page-container">
		<div class="form_information">
			<div class="number-list">
	            <ul class="num_ul">
	                <li class="f_1 done"><div class="circle">1</div><div class="line"></div></li><!--
	                --><li class="active f_2"><div class="circle">2</div><div class="line"></div></li><!--
	                --><li class="f_3"><div class="circle">3</div><div class="line"></div></li><!--
	                --><li class="f_4"><div class="circle">4</div><div class="line"></div></li><!--
	                --><li class="f_5"><div class="circle">5</div></li>
	            </ul>
	        </div>

		<form id="acForm" action="" method="post" class="form_list active">
		<?php $this -> dispMessagesCommon(); ?>
	        	<div class="cont_steps s_step">
	        		<div class="field_list">
	        			<div class="limit_width">
	        				<label class="title_name"><?php echo $page_title; ?></label>
			        		<p>
			        			Please enter the required information below.
			        		</p>
			        		<div class="cus_form">
			        			<div class="table_form table_form_list">
				        			<div class="form_elem ">
				        				<label class="title_txt">First Name (& Middle Name)<span id="required" class="required">*</span><br><span>Exactly shown on your ID First Name</span></label>
				        				<input type="text" name="first_name" class="verify_input" value="<?php $this -> echoFirstName(); ?>" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Last Name<span id="required" class="required">*</span><br><span>Please enter your last name. English Alphabet only.  (E.G. Smith / Mario de Sanches)</span></label>
				        				<input type="text" name="last_name" class="verify_input" value="<?php $this -> echoLastName(); ?>" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Company Name<span id="required" class="required">*</span></label>
				        				<input type="text" name="name" value="<?php $this -> echoName(); ?>" class="verify_input"><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Telephone Number<span id="required" class="required">*</span></label>
				        				<input type="tel" name="tel" value="<?php $this -> echoTel(); ?>" class="verify_input"><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Representative Birth Date</label>
							<select name="birth_year" id="birth_year" class="select">
								<option>--YYYY--</option>
								<?php $this -> dispYear(); ?>
							</select>
							<select name="birth_month" id="birth_month" class="select">
								<option value="--MM--">--MM--</option>
								<?php $this -> dispMonth(); ?>
							</select>
							<select name="birth_day" id="birth_day" class="select">
								<option>--DD--</option>
								<?php $this -> dispDay(); ?>
							</select>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Email Address</label>
				        				<?php $this -> echoEmail(); ?><i class="fa"></i>
				        			</div>
				        			<div class="form_elem verify_password">
				        				<label class="title_txt">Password<span id="required" class="required">*</span><br><span>Password must be 8 to 35 characters long including numbers, upper and lower case letters (e.g. AtoZ^%-@0~9!).</span></label>
				        				<input type="password" name="password" class="verify_input" value="" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem verify_password2">
				        				<label class="title_txt">Re-enter Password<span id="required" class="required">*</span><br><span>Please re-enter password.</span></label>
				        				<input type="password" name="password_confirm" class="verify_input" value="" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Country</label>
								<select name="country" value="<?php $this -> echoEmail(); ?>" class="select">
									<option value=''>--Select--</option>
									<?php $this -> dispCountry(); ?>
								</select>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">State/Province<span id="required" class="required">*</span></label>
								<input type="text" name="state" value="<?php $this -> echoState(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">City<span id="required" class="required">*</span></label>
								<input type="text" name="city" value="<?php $this -> echoCity(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Address<span id="required" class="required">*</span></label>
								<input type="text" name="address" value="<?php $this -> echoAddress(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Post Code<span id="required" class="required">*</span></label>
								<input type="text" name="zip_code" value="<?php $this -> echoZipCode(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Service Site or Brand Name<br><span>Please enter your service site or brand name for pubilc viewing</span></label>
								<input type="text" name="site_name" value="<?php $this -> echoSiteName(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">Service Site URL (or Official Site URL)<span id="required" class="required">*</span></label>
								<input type="url" name="site_url" value="<?php $this -> echoSiteUrl(); ?>" class="verify_input">
				        			</div>

				        		</div>
			        		</div>
	        			</div>
	        			
	        		</div>
	        		<div class="event_next1 event_custom">
	        			<input type="button" id="btnConfirm" value="Confirm" class="custom nxt_form">
	        		</div>

			<input type="hidden" id="type" name="type" value="" />
			<input type="hidden" id="account_type" name="account_type" value="<?php $this -> echoAccountType(); ?>" />
			<input type="hidden" id="email" name="email" value="<?php $this -> echoEmail(); ?>" />
			<input type="hidden" id="agent_code" name="agent_code" value="<?php $this -> echoAgent(); ?>" />
			</div>
		</form>

	<script src="../js/register.js"></script>
		</div>
	</section>

</wrapper>
<?php
include_once('template/base_site_foot.php');
echo $endscripts;
?>
</body>
</html>