<?php
require_once('config.php');
// require_once('CheckUserInfoBase.php');

class APICreateUser extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $uId		= NO_STRING;
	private $account	= NO_STRING;
	private $reqid		= NO_STRING;
	private $email		= NO_STRING;
	private $country	= NO_STRING;
	private $firstName	= NO_STRING;
	private $lastName	= NO_STRING;
	private $birth		= NO_STRING;
	private $state		= NO_STRING;
	private $city		= NO_STRING;
	private $address	= NO_STRING;
	private $zipCode	= NO_STRING;
	private $tel		= NO_STRING;
	private $note		= NO_STRING;
	private $agent		= NO_STRING;
	private $year		= NO_STRING;
	private $month		= NO_STRING;
	private $day		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn	= array();
		$arr	= null;

		try {
print_r($_POST);
return;
			// パラメータの設定
			// 必須パラメータ
			$this -> signature	= $this -> getDataPost(PARAM_SIGNATURE);
// 			$this -> reqid		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> email		= $this -> getDataPost(PARAM_EMAIL);
			$this -> country	= $this -> getDataPost(PARAM_COUNTRY);
			$this -> firstName	= $this -> getDataPost(PARAM_FIRST_NAME);
			$this -> lastName	= $this -> getDataPost(PARAM_LAST_NAME);
			$this -> birth		= $this -> getDataPost(PARAM_BIRTH);

			// 生年月日の分割
			$arr = explode(DELIMIT_SLASH, $this -> birth);
			$this -> year		= intval($this -> getColumnData($arr, NO_COUNT));
			$this -> month		= intval($this -> getColumnData($arr, VAL_INT_1));
			$this -> day		= intval($this -> getColumnData($arr, VAL_INT_1));

			// 任意
			$this -> state		= $this -> getDataPost(PARAM_STATE);
			$this -> city		= $this -> getDataPost(PARAM_CITY);
			$this -> address	= $this -> getDataPost(PARAM_ADDRESS);
			$this -> zipCode	= $this -> getDataPost(PARAM_ZIP_CODE);
			$this -> tel		= $this -> getDataPost(PARAM_TEL);
			$this -> note		= $this -> getDataPost(PARAM_NOTE);
			$this -> agent		= $this -> getDataPost(PARAM_AGENT_CODE);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'U' . $this -> email);
				throw new Exception(VAL_INT_90);
			}

			if(!$this -> validate()) {
				new Exception('02');
			}

			// UIDの作成
			$this -> uId		= $this -> createUId();

			// 口座番号の作成
			$this -> account	= $this -> createAccount();

			// データの登録
			$this -> insert();

			// メールの送信
			$this -> send();

		} catch (Exception $e) {
			throw $e;
		}
	}

	//-------------------------------------------------------------------------
	// @function_name: データのチェック
	// @parameter	: なし
	// @return		: なし
	//-------------------------------------------------------------------------
	function validate() {

		// 変数宣言部
		$rtn = true;

		// 必須項目
		// 名
		if(!$this -> checkNull($this -> firstName)) {
			$rtn = false;
		}

		// 姓
		if(!$this -> checkNull($this -> lastName)) {
			$rtn = false;
		}

		// メールアドレスのチェック
		if(!$this -> checkNull($this -> email)) {
			$rtn = false;
		}

		// 国コードのチェック
		if(!$this -> checkNull($this -> country)) {
			$rtn = false;
		}

		// 生年月日のチェック
		if(!$this -> checkNull($this -> birth)) {
			$rtn = false;
		}

		if(!$rtn) {
			return false;
		}

		// 名の正規表現
		if(!$this -> checkStringAlphabetAndSpace($this -> firstName)) {
			$rtn = false;
		}

		// 名の文字数制限
		if(!$this -> checkLength($this -> firstName
								, VAL_INT_1
								, VAL_INT_64)) {
			$rtn = false;
		}

		// 姓の正規表現
		if(!$this -> checkStringAlphabetAndSpace($this -> lastName)) {
			$rtn = false;
		}

		// 姓の文字数制限
		if(!$this -> checkLength($this -> lastName
								, VAL_INT_1
								, VAL_INT_64)) {
			$rtn = false;
		}

		// メールアドレスの正規表現
		if(!$this -> checkStringMailAddress(addslashes($this -> email))) {
			$this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_EMAIL));
			$rtn = false;
		}

		if(!$rtn) {
			return false;
		}

		// メールアドレスの存在確認
		if(!$this -> checkMailAddress($this -> email)) {
			$rtn = false;
		}

		if(!$rtn) {
			return false;
		}

		// メールアドレスのドメインの存在チェック
		$mails = explode(DELIMIT_AT, $this -> email);

		if(!isset($mails[VAL_INT_1])) {	// @マークがない
			$rtn = false;
		} else {

			$ip = gethostbyname($mails[VAL_INT_1]);

			if($ip == $mails[VAL_INT_1]) {
				$rtn = false;
			}

			// ワンタイムドメインのチェック
			$list = $this -> getInvalidDomainList();
			if($this -> getColumnData($list, $mails[VAL_INT_1]) != NO_STRING) {
				$rtn = false;
			}
		}

		if(!$this -> checkLimitAge($this -> country
									, $this -> year
									, $this -> month
									, $this -> day)) {
			$rtn = false;
		}

		// 誕生日のチェック
		if(!$this -> checkDate($this -> year
								, $this -> month
								, $this -> day)) {
			$rtn = false;
		}

		// 誕生日のチェック
		if(!$this -> checkDate(intval($this -> year)
		, intval($this -> month)
		, intval($this -> day))) {
			$this -> popMessageCommon(ERROR, 'E_DATE_VALUE', array($this -> year
					, $this -> month
					, $this -> day));
			$rtn = false;
		}

		if(!$rtn) {
			return false;
		} else {
			return true;
		}
	}

	//-------------------------------------------------------------------------
	// @function_name: データの登録
	// @parameter	: なし
	// @return		: なし
	//-------------------------------------------------------------------------
	function insert() {

		// 変数宣言部
		$rtn	= true;
		$params = array();

		// パラメータの設定
		$params[]	= $this -> uId;				// UID
		$params[]	= $this -> email;			// ログインID
		$params[]	= $this -> getPassword();	// ログインパスワード

		// ログインデータの登録
		$rtn = $this -> accessModify('INSERT_LOGIN', $params);

		// パラメータの設定（ユーザテーブル）
		$params[]	= $uId;							// UID
		$params[] 	= $this -> email;				// メルアド
		$params[] 	= NO_COUNT;						// 口座種別
		$params[] 	= $account;						// 口座番号
		$params[] 	= NO_STRING;					// 電話番号
		$params[] 	= $this -> lastName;			// 姓
		$params[] 	= $this -> firstName;			// 名
		$params[] 	= $this -> year;				// 生年月日（年）
		$params[] 	= $this -> month;				// 生年月日（月）
		$params[] 	= $this -> day;					// 生年月日（日）
		$params[] 	= $this -> country;				// 国
		$params[] 	= $this -> state;				// 都道府県
		$params[] 	= $this -> city;				// 市
		$params[] 	= $this -> zipCode;				// 郵便番号
		$params[] 	= $this -> address;				// 番地
		$params[] 	= NO_STRING;					// 番地2
		$params[] 	= NO_STRING;					// エージェントコード
		$params[] 	= NO_COUNT;						// エージェントフラグ
		$params[] 	= NO_STRING;					// 親エージェントコード
		$params[] 	= $_SERVER[PARAM_REMOTE_ADDR];	// 登録IPアドレス
		$params[] 	= VAL_INT_1;					// ステータス（仮登録)
		$params[] 	= NO_STRING;					// CRM ID
		$params[] 	= WHITE_LABEL_ID;				// ホワイトレーベルID
		$params[] 	= VAR_DEFAULT_LANGAGE;			// 言語

		$this -> accessModify('INSERT_USER', $params);
		$this -> accessModify('INSERT_2FA_ENABLE', array($account), false);
		$this -> accessModify('INSERT_2FA_CODE', array($account), false);
		// ログインデータの登録
		return $rtn;
	}

	//-------------------------------------------------------------------------
	// @function_name: メールの送信
	// @parameter	: なし
	// @return		: なし
	//-------------------------------------------------------------------------
	function send() {

		// 申請メールを送信する
		$params		= array();
		$params[]	= $account;														// 口座番号
		$params[]	= $this -> getColumnData($row, VAL_INT_3)
						. DELIMIT_SPACE . $this -> getColumnData($row, VAL_INT_4);	// 名前
		$params[]	= $uid;															// UID
		$params[]	= $confCode;													// 確認コード

		$this -> sendMailByTmpAndWL($account
									, 'regist_password_apply.xml'
									, $params
									, $this -> getColumnData($row, VAL_INT_1)
									, 'cs@');
	}
}

try {

	$api = new APICreateUser();
	$api -> action();

	// チェックロジック
// 	$api = new APICheckUserInfoBase();
// 	$api -> action();
return;
	// 処理成功
	echo json_encode(array('result'			=> '00'
							, 'messages'	=> 'I_COMPLETE_PROCESS'));

} catch (Exception $e) {	// チェックエラー
	echo json_encode(array('result'			=> $e -> getMessage()
							, 'messages'	=> $e -> getMessage()));
}
?>
