<?php
class Cnnector extends CommonBase {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $con;	// DBコネクション

	/*-------------------------------------------------------------------------
	* @function_name: DBアクセスクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {

		// スーパークラスコンストラクタ呼び出し
		parent::__construct();

		// コネクションの取得
		try {

			$host = $this -> getConfigValue(SECTION_DB, HOST_NAME);
			$port = '3306';
			$username = $this -> getConfigValue(SECTION_DB, USER_NAME);
			$password = $this -> getConfigValue(SECTION_DB, LOGIN_PASS);
			$db = $this -> getConfigValue(SECTION_DB, TARGET_DB_NAME);
			
			$mysqli = mysqli_init();
			mysqli_options($mysqli, MYSQLI_OPT_SSL_VERIFY_SERVER_CERT, true);
			
			$mysqli->ssl_set(NULL,NULL,"/var/www/html/db/rds-combined-ca-bundle.pem",NULL,NULL);
			
			$mysqli->real_connect($host, $username, $password, $db, $port, NULL, MYSQLI_CLIENT_SSL);
			
			$this->con = $mysqli;
			
			if(mysqli_connect_error()) {
				throw new Exception('', -1);
			}
			
			mysqli_query($this -> con, "SET NAMES utf8");

		} catch(Exception $e) {
			die($this -> getMessage(ERROR, E_CAN_NOT_DB_CONNECTION, array()));
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: DBアクセスクラスデストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __destruct() {
		$this -> closeConnection();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コネクション取得関数
	* @detail		: メンバのコネクションを取得します
	* @parameter	: なし
	* @return		: DBコネクション
	-------------------------------------------------------------------------*/
	function getConnection() {
		return $this -> con;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コネクションの切断
	* @detail		: メンバのコネクションを切断します
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function closeConnection() {

		try {
			if(!mysqli_close($this -> con)) {
				throw new Exception($this -> getMessage(ERROR, E_CAN_NOT_CLOSE_DB_CONNECTION, array()), -1);
			}
		} catch(Exception $e) {
			die($e -> getMessage());
		}
	}
}
?>