<?php
require_once(SITE_LOGICS . 'setting/logic.php');

class ControlSetting extends LogicSetting {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		// 変数宣言部
		$result = NO_STRING;

		try {
		    $this -> checkAvailability("site", function(){
		        require_once $this -> getUserHTML('TEMPLATE_MAINTENANCE_MODE_SITE_PATH');
		        exit();
		    });
		    
			// アクション実行
			$result = $this -> logic();

			// 画面の表示
			if($this -> getType()						== TYPE_INPUT) {					// プロフィール修正・変更（入力）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_INPUT_PROFILE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_EXPORT) {									// KYC書類のダウンロード

					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename=' . $this -> getOldFileName() . '');
					header('Content-Transfer-Encoding: binary');

					readfile($this -> getPath());

			} else if($this -> getAction()				== CONTROL_SETTING_CHANGE_PASSWORD
						&& $this -> getType()			== TYPE_CONFIRM) {					// パスワード変更（確認）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_PW_CONFIRM', $this -> dispHTML()));
			} else if($this -> getAction()				== CONTROL_SETTING_CHANGE_PASSWORD
						&& $this -> getType()			== TYPE_COMPLETE) {					// パスワード変更（完了）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_PW_COMPLETE', $this -> dispHTML()));
			} else if($this -> getAction()				== CONTROL_SETTING_CHANGE_MAIL
						&& $this -> getType()			== TYPE_CONFIRM) {					// メールアドレス変更（メール送信）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_MAIL_COMPLETE', $this -> dispHTML()));
// 				header('Location: /' . $this ->  getLangage() . '/menu');

			} else if($this -> getAction()				== NO_STRING
						&& $this -> getType()			== TYPE_CONFIRM) {					// プロフィール修正・変更（確認）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_COMFIRM_PROFILE_PATH', $this -> dispHTML()));
			} else if($this -> getAction()				== NO_STRING
						&& $this -> getType()			== TYPE_BACK) {						// プロフィール修正・変更（再入力）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_INPUT_PROFILE_PATH', $this -> dispHTML()));
			} else if($this -> getAction()				== NO_STRING
						&& $this -> getType()			== TYPE_COMPLETE) {					// プロフィール修正・変更（完了）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_COMPLETE_PROFILE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == CONTROL_SETTING_CHANGE_PASSWORD) {				// パスワード変更
				require_once($this -> getUserHTML('TEMPLATE_SETTING_PW_INPUT', $this -> dispHTML()));

			} else if($this -> getType()				== CONTROL_SETTING_CHANGE_MAIL) {	// メールアドレス変更
				require_once($this -> getUserHTML('TEMPLATE_SETTING_MAIL_INPUT', $this -> dispHTML()));
// 				header('Location: /' . $this ->  getLangage() . '/menu');
			} else if($this -> getType()				== CONTROL_SETTING_KYC
						&& $this -> getAccountType()	== VAR_CORP) {						// KYC登録（法人）
					require_once($this -> getUserHTML('TEMPLATE_SETTING_KYC_UPLOAD_STEP2', $this -> dispHTML()));
			} else if($this -> getType()				== CONTROL_SETTING_KYC
						&& $this -> getAccountType()	== VAR_PERSON) {					// KYC登録（個人）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_KYC_UPLOAD', $this -> dispHTML()));
			} else if($this -> getAction()				== CONTROL_SETTING_KYC
						&& $this -> getType()			== TYPE_SAVE) {						// KYC登録（個人）
					require_once($this -> getUserHTML('TEMPLATE_SETTING_KYC_UPLOAD', $this -> dispHTML()));
			} else if($this -> getAction()				== CONTROL_SETTING_KYC
						&& $this -> getType()			== TYPE_COMPLETE) {					// KYC登録（法人）
						require_once($this -> getUserHTML('TEMPLATE_SETTING_KYC_UPLOAD_STEP2', $this -> dispHTML()));

			} else if( $this -> getType()			    == TYPE_SECURITY_SECTTING) {					// KYC登録（法人）
				require_once($this -> getUserHTML('TEMPLATE_SETTING_SECURITY_SETTINGS', $this -> dispHTML()));

			} else if( $this -> getType()			    == TYPE_TRANSFER_SETTING) {
				require_once($this -> getUserHTML('TEMPLATE_TRANSFER_SETTINGS_PATH', $this -> dispHTML()));

			} else if ($this -> getType()               == TYPE_2FA_DISABLE_ONE){
				require_once($this -> getUserHTML('TEMPLATE_2FA_DISABLE_MAIL', $this -> dispHTML()));
			} else if ($this -> getType()               == TYPE_2FA_DISABLE_TWE){
				require_once($this -> getUserHTML('TEMPLATE_2FA_DISABLE_PASSWORD', $this -> dispHTML()));
			}else {																		// デフォルト
				require_once($this -> getUserHTML('TEMPLATE_SETTING_PROFILE_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /' . $this ->  getLangage() . '/login');
		}
	}
}
?>