<?php
class AdvertisementModelClass extends ModelClassEx {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	private $lang			= NO_STRING;
	private $rs 			= null;
	private $mail 			= NO_STRING;
	private $IP 			= NO_STRING;
	private $adsID 			= NO_STRING;
	private $adID 			= NO_STRING;
	private $adDetails 		= NO_STRING;
	private $language 		= NO_STRING;
	private $slanguage 		= NO_STRING;
	private $from 			= NO_STRING;
	private $to 			= NO_STRING;
	private $img1Flg		= NO_STRING;
	private $rs2			= NO_STRING;	
	private $location		= NO_STRING;	
	private $slocation		= NO_STRING;	
	private $link 			= NO_STRING;	
	private $fileName 		= NO_STRING;	
	private $adName 		= NO_STRING;	
	private $sequence 		= NO_STRING;	

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}


	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> lang			= $this -> getLangage();
		$this -> mail 			= $this -> getDataPost('mail', true);
		$this -> IP 			= $this -> getDataPost('ip', true);
		$this -> adsID 			= $this -> getDataPost('adsId', true);
		$this -> adID 			= $this -> getDataPost('adID', true);
		$this -> language 		= $this -> getDataPost('language', true);
		$this -> slanguage 		= $this -> getDataPost('slanguage', true);
		$this -> from 			= $this -> getDataPost('from', true);
		$this -> to 			= $this -> getDataPost('to', true);
		$this -> img1Flg		= $this -> getDataPost(PARAM_IMG_1_FLG);
		$this -> location 		= $this -> getDataPost('location', true);
		$this -> slocation 		= $this -> getDataPost('slocation', true);
		$this -> link 			= $this -> getDataPost('link', true);
		$this -> adName 		= $this -> getDataPost('adName', true);
		$this -> fileName 		= $this -> getDataPost('fileName', true);
		$this -> sequence 		= $this -> getDataPost('sequence', true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> fileName 		= $this -> getColumnData($this -> adDetails, 'file_name');
		$this -> adName 		= $this -> getColumnData($this -> adDetails, 'ads_id');
		$this -> adID 			= $this -> getColumnData($this -> adDetails, 'id');
		$this -> link 			= $this -> getColumnData($this -> adDetails, 'redirect_link');
		$this -> location 		= $this -> getColumnData($this -> adDetails, 'ads_location');
		$this -> language 		= $this -> getColumnData($this -> adDetails, 'language');
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		if(!$this -> checkAdminUserAccess('ADVT', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_IMAGE_MANAGER_DETAIL){
			if(!$this -> checkAdIDExist($this -> adID)){
				$this -> setType(TYPE_IMAGE_MANAGER);
			}
		}elseif($this -> getType() == TYPE_UPDATE) {

			if(!in_array($this -> location, array('menu', 'login'))){
				$this -> setType(TYPE_IMAGE_MANAGER_DETAIL);
			}

			$lang = array('en', 'ja', 'sc', 'tc', 'id');
			if(!in_array($this -> language, $lang)){
				$this -> setType(TYPE_IMAGE_MANAGER_DETAIL);
			}
		}elseif($this -> getType() == TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE) {
			if(!$this -> checkExistImage($_FILES['img1']['name'])){
				$this -> popUpSessionMessage(ERROR, 'E_EXIST_DATA', array('Filename '));
				$this -> setType(TYPE_IMAGE_MANAGER);
			}
			
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ一覧の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoList() {
		// 変数宣言部
		$rtn	= NO_STRING;
		$row	= null;

		if($this -> isLoopData($this -> rs)) {
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);

			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
				
				$row = $this -> getRowData($this -> rs, $cnt);

				$rtn .= '<tr>'.
						'<td>'.$this -> getColumnData($row, 'mail').'</td>' .
						'<td>'.$this -> getColumnData($row, 'ip_address').'</td>' .
						'<td>'.$this -> getColumnData($row, 'device').'</td>' .
						'<td>'.$this -> getColumnData($row, 'ads_id').'</td>' .
						'<td>'.$this -> getColumnData($row, 'ads_location').'</td>' .
						'<td>'.$this -> getColumnData($row, 'redirect_link').'</td>' .
						'<td>'.$this -> getColumnData($row, 'language').'</td>' .
						'<td>'.$this -> getColumnData($row, 'details').'</td>'.
						'<td>'.$this -> getColumnData($row, 'create_time').'</td>'.
						'</tr>';

			}
		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}
		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function setImages($rs2) {
		$this -> rs2 = $rs2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function setAdDetails($rs) {
		$this -> adDetails = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function getAdID() {
		return $this -> adID;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
				, count($this -> rs)
				, NO_STRING
				, false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: 結果セット
	* @return		: 検索条件配列
	-------------------------------------------------------------------------*/
	function getWhere() {
		// 変数宣言部
		$where		= NO_STRING;
		$rtn		= array();

		if($this -> mail != NO_STRING){
			$where .= ' AND mail = (\')' . $this -> mail . '(\')';	
		}

		if($this -> IP != NO_STRING){
			$where .= ' AND ip_address = (\')' . $this -> IP . '(\')';	
		}

		if($this -> adsID != NO_STRING){
			$where .= ' AND ads_id LIKE (\')%' . $this -> adsID . '%(\')';	
		}

		if($this -> from != NO_STRING) {			
			$where .= ' AND create_time >= (\')' . $this -> from . ' 00:00:00(\') ';
		}

		if($this -> to != NO_STRING) {				// 終了日
			$where .= ' AND create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> to . ' +1 days')) . '(\') ';
		}

		if($this -> language != NO_STRING) {				// 終了日
			$where .= ' AND language = (\')' . $this -> language . '(\')';
		}

		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

		$rtn[] = $where;
		$rtn[] = $page;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoFrom() {
		echo $this -> from;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoTo() {
		echo $this -> to;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoMail() {
		echo $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoIP() {
		echo $this -> IP;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoAdsId() {
		echo $this -> adsID;
	}


	public function echoLanguageList() {

		// 変数宣言部
		$language[] = array(PARAM_DATA_KEY => 'en'
						, PARAM_DATA_VALUE => 'EN');
		$language[] = array(PARAM_DATA_KEY => 'ja'
						, PARAM_DATA_VALUE => 'JA');
		$language[] = array(PARAM_DATA_KEY => 'sc'
						, PARAM_DATA_VALUE => 'SC');
		$language[] = array(PARAM_DATA_KEY => 'tc'
						, PARAM_DATA_VALUE => 'TC');
		$language[] = array(PARAM_DATA_KEY => 'id'
						, PARAM_DATA_VALUE => 'ID');

		
			// foreach($language as $row) {
			// 	$lists[] = array(PARAM_DATA_KEY			=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME)
			// 						, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME));
			// }
	

		echo $this -> dispListOption($language, $this -> language);
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC画像のアップロード（個人用）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function loadImageAds() {
		// echo $this -> adsID;
		// echo $this -> location;
		// echo $this -> language;
		// echo $this -> link;
		// die();
		// 変数宣言部
		$path		= NO_STRING;
		$saveName	= NO_STRING;
		$flg		= false;
		$oldName	= NO_STRING;
		$imgFlg		= NO_STRING;
		$uploads	= array();

		// ルートディレクトリを取得する
		$path = SYSTEM_DOCUMENT_ADS;

		// 該当ディレクトリの確認
		if(!file_exists($path)) {
			mkdir($path, 0777);
		} else {
			chmod($path, 0777);
		}

		// 画像1の存在確認
		if($this -> isUpload(PARAM_IMG1)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG1][PARAM_NAME]);
			$saveName	= basename($_FILES[PARAM_IMG1][PARAM_NAME]);

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG1][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG1][PARAM_NAME]);
				$imgFlg		= $this -> getImg1Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_ADS', array(10, $saveName, $this -> adsID, $this -> location, $this -> link, $this -> language, $this -> getAdminUserData(PARAM_UID)));
			}
		}
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: アップロードファイルの存在確認
	* @parameter	: パラメータ
	* @return		: 存在する:true、存在しない:false
	-------------------------------------------------------------------------*/
	function isUpload($param) {

		// 変数宣言部
		$rtn = false;

		if(isset($_FILES[$param])) {

			if(is_uploaded_file($_FILES[$param][PARAM_TMP_NAME])) {
				$rtn = true;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像1フラグの取得
	* @parameter	: なし
	* @return		: 画像1フラグ
	-------------------------------------------------------------------------*/
	public function getImg1Flg() {
		return $this -> img1Flg;
	}

	function echoImageList(){
		// 変数宣言部
		$rtn	= NO_STRING;
		$row	= null;

		if($this -> isLoopData($this -> rs2)) {
			$listCount	= count($this -> rs2);

			for($cnt = 0; $cnt < count($this -> rs2); $cnt++) {
		
				$row = $this -> getRowData($this -> rs2, $cnt);
				// $rtn .= 
				// 		'<li class="list-group-item h5" id='.$this -> getColumnData($row, 'id').'>'.
				// 		'<img src="http://iwl.localhost/documents/ads/'.$this -> getColumnData($row, 'file_name').'" class="img-thumbnail" alt="Cinque Terre" width="70">'.
				// 		'<p class="ml-3 mt-3">'.$this -> getColumnData($row, 'ads_id').'</p>'.
				// 		'<span id="'.$this -> getColumnData($row, 'id').'" class="fa fa-info-circle fa-lg mr-5" style="color: #0275d8; position: absolute; right: 0;"></span>'.
				// 		'<span onclick="deleteAd(\''.$this -> getColumnData($row, 'id').'\')" class="fa fa-trash fa-lg mr-2" style="color: #0275d8; position: absolute; right: 0;"></span>'.
				// 		'</li>';
				$rtn .= '<tr id='.$this -> getColumnData($row, 'id').' >'.
						'<td>'.
						'<img src="https://'.SITE_DOMAIN.'/documents/ads/'.$this -> getColumnData($row, 'file_name').'" class="img-thumbnail" alt="Cinque Terre" width="70">'.
						'</td>'.
						'<td>'.
						'<p class="ml-3 mt-3">'.$this -> getColumnData($row, 'ads_id').'</p>'.
						'</td>'.
						'<td>'.
						'<p class="ml-3 mt-3">'. $this -> getAdminNameByUid($this -> getColumnData($row, 'created_by')).'</p>'.
						'</td>'.
						'<td>'.
						'<p class="ml-3 mt-3">'.$this -> getColumnData($row, 'create_time').'</p>'.
						'</td>'.
						'<td class="blocka">'.
						'<a href="#"><span id="'.$this -> getColumnData($row, 'id').'" class="fa fa-info-circle fa-lg ml-3 mt-3" style="color: #0275d8;"></span></a>'.
						'</td>'.
						'<td class="blocka">'.
						'<a href="#"><span onclick="deleteAd(\''.$this -> getColumnData($row, 'id').'\')" class="fa fa-trash fa-lg ml-3 mt-3" style="color: #0275d8;"></span></a>'.
						'</td>'.
					   '</tr>';

			}
		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}
		echo $rtn;
	}

	function echoFileName(){
		echo $this -> fileName;
	}

	function echoAdName(){
		echo $this -> adName;
	}

	function echoLink(){
		echo $this -> link;
	}

	function echoID(){
		echo $this -> adID;
	}

	function echoLocation(){
		$location 		= array('login', 'menu');
		$options 		= array();
		$rtn 			= NO_STRING;

		if($this -> getType() == TYPE_DELETE || $this -> getType() == TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE || $this -> getType() == TYPE_IMAGE_MANAGER_DETAIL){
			$loc = $this -> location;
		}else{
			$loc = $this -> slocation;
		}

		foreach ($location as $value) {
			if($loc == $value){
				$options[] = '<option value="'.$loc.'" selected="selected">'.$loc.'</option>';
			}else{
				$options[] = '<option value="'.$value.'">'.$value.'</option>';
			}
		}
		$rtn = implode(' ', $options);
		echo $rtn;
	}

	function echoLanguage(){
		$language 		= array('en', 'ja', 'sc', 'tc', 'id');
		$options 		= array();
		$rtn 			= NO_STRING;

		if($this -> getType() == TYPE_DELETE || $this -> getType() == TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE || $this -> getType() == TYPE_IMAGE_MANAGER_DETAIL){
			$lang = $this -> language;
		}else{
			$lang = $this -> slanguage;
		}

		foreach ($language as $value) {
			if($lang == $value){
				$options[] = '<option value="'.$lang.'" selected="selected">'.$lang.'</option>';
			}else{
				$options[] = '<option value="'.$value.'">'.$value.'</option>';
			}
		}
		$rtn = implode(' ', $options);
		echo $rtn;
	}

	function echoAdLanguage(){
		echo $this -> language;
	}

	function echoAdLocation(){
		echo $this -> language;
	}

	function getUpdateData(){
		$rtn = array();

		$rtn[] =  $this -> adName;
		$rtn[] =  $this -> link;
		$rtn[] =  $this -> location;
		$rtn[] =  $this -> language;
		$rtn[] =  $this -> adID;
		return $rtn;
	}

	function getUpdateSequence(){
		$rtn 		= array();
		$adID 		= array();
		$condition = array();
		$adID 		= $this -> sequence;
		$IDarray 	= explode(',', $adID);
		$cnt 		= 1;
		
		foreach ($IDarray as $value) {
			$condition[] = $value . ' THEN ' . $cnt;
			$cnt++;
		}

		$rtn[] = implode(' WHEN ', $condition);

		var_dump($rtn);



		//die();
		//return $rtn;
	}

	function getWhereAds(){

		$rtn = array();
		$whereStr = NO_STRING;
		if($this -> getType() == TYPE_IMAGE_MANAGER || $this -> getType() == TYPE_SEARCH){
			if($this -> slocation != NO_STRING){
				$whereStr .= ' AND ads_location = (\')'.$this -> slocation.'(\')';
			}else{
				$whereStr .= ' AND ads_location = (\')login(\')';
			}
			if($this -> slanguage != NO_STRING){
				$whereStr .= ' AND language = (\')'.$this -> slanguage.'(\')';
			}else{
				$whereStr .= ' AND language = (\')en(\')';
			}
		}elseif($this -> getType() == TYPE_DELETE || $this -> getType() == TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE){
			$whereStr .= ' AND ads_location = (\')'.$this -> location.'(\')';
			$whereStr .= ' AND language = (\')'.$this -> language.'(\')';
		}
		
		$rtn[] = $whereStr;

		return $rtn;

	}

	function getDeleteData(){

		$rtn 	= array();
		$rtn[] 	= $this -> adID;

		return $rtn;

	}

	function checkExistImage($fileName){
		$rtn = true;
		$file = $this -> accessSelect('CHECK_EXIST_AD', array($fileName));

		if((count($file)) > NO_COUNT){
			$rtn = false;
		}

		return $rtn;
	}

	function sessionLocation(){

		return $_SESSION['location'];

	}

	function sessionLanguage(){

		return $_SESSION['language'];

	}

	/*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getActivity(){

		 $type 			= $this -> getType();
		 $details 		= array();
		

   		if($type == TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE){
   			$message = 'Uploaded ['.basename($_FILES[PARAM_IMG1][PARAM_NAME]).']';
   		}elseif($type == TYPE_DELETE){
   			$message = 'Deleted ['.$this -> getFileDetailsByID($this -> adID, 'file_name').']';
   		}elseif($type == TYPE_UPDATE){
   			 $origID 		= $this -> getFileDetailsByID($this -> adID, 'ads_id');
			 $newID 		= $this -> adName;
			 $origLink 		= $this -> getFileDetailsByID($this -> adID, 'redirect_link');
			 $newLink 		= $this -> link;
			 $origLang 		= $this -> getFileDetailsByID($this -> adID, 'language');
			 $newLang 		= $this -> language;
			 $origLoc 		= $this -> getFileDetailsByID($this -> adID, 'ads_location');
			 $newLoc 		= $this -> location;
			 
   			if($origID != $newID){
   				$details[] = 'Edited ID of '.$this -> getFileDetailsByID($this -> adID, 'file_name').' from ['.$origID.'] to ['.$newID.']';
   			}

   			if($origLink != $newLink){
   				$details[] = 'Edited Link of '.$this -> getFileDetailsByID($this -> adID, 'file_name').' from ['.$origLink.'] to ['.$newLink.']';
   			}

   			if($origLang != $newLang){
   				$details[] = 'Edited Language of '.$this -> getFileDetailsByID($this -> adID, 'file_name').' from ['.$origLang.'] to ['.$newLang.']';
   			}

   			if($origLoc != $newLoc){
   				$details[] = 'Edited Location of '.$this -> getFileDetailsByID($this -> adID, 'file_name').' from ['.$origLoc.'] to ['.$newLoc.']';
   			}

   			if($details != NULL){
   				$message = implode(', <br/>', $details);
   			}else{
   				$message = 'Saved without any changes';
   			}
   		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 26;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}

	function getFileDetailsByID($id, $column){
		$row 		= $this -> accessSelect('SELECT_AD_DETAILS', array($id));
		$details 	= $this -> getColumnData($row[0], $column);

		return $details; 
	}
}

?>