<?php
require_once('config.php');
require_once('CheckWithdrawBase.php');

class APIMakeWithdraw extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $accountName				= NO_STRING;	// 口座名義
	private $receiptCountry				= NO_STRING;	// 受取人国
	private $receiptAddress1			= NO_STRING;	// 受取人住所1
	private $receiptAddress2			= NO_STRING;	// 受取人住所2
	private $tel						= NO_STRING;	// 電話番号
	private $receiptMessage				= NO_STRING;	// 受取人メッセージ
	private $receiptBankName			= NO_STRING;	// 受取銀行名
	private $receiptBankSwift			= NO_STRING;	// 受取銀行SWIFT
	private $receiptBankCountry			= NO_STRING;	// 受取銀行国
	private $receiptBranchCode			= NO_STRING;	// 受取銀行支店コード
	private $receiptBranchName			= NO_STRING;	// 受取銀行支店名
	private $receiptBankAddress1		= NO_STRING;	// 受取銀行住所1
	private $receiptBankAddress2		= NO_STRING;	// 受取銀行住所2
	private $accountNumber				= NO_STRING;	// 受取銀行口座番号
	private $intermediaryFlg			= NO_STRING;	// 中継銀行フラグ
	private $intermediaryBankName		= NO_STRING;	// 中継銀行名
	private $intermediaryBankSwift		= NO_STRING;	// 中継銀行SWIFT
	private $intermediaryBankCountry	= NO_STRING;	// 中継銀行国
	private $intermediaryBankAddress1	= NO_STRING;	// 中継銀行住所1
	private $intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2
	private $intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージ
	private $fromCurrency				= NO_STRING;	// From通貨
	private $debitCurrency				= NO_STRING;	// 引落通貨
	private $debitAmount				= NO_STRING;	// 引落金額

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$param		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account					= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> currency					= strtoupper($this -> getDataPost(PARAM_CURRENCY));					// 通貨
			$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);								// 金額
			$this -> accountName				= $this -> getDataPost(PARAM_ACCOUNT_NAME);							// 口座名義
			$this -> receiptCountry				= $this -> getDataPost(PARAM_RECEIPT_COUNTRY);						// 受取人国
			$this -> receiptAddress1			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_1);					// 受取人住所1
			$this -> receiptAddress2			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_2);					// 受取人住所2
			$this -> tel						= $this -> getDataPost(PARAM_TEL);									// 電話番号
			$this -> receiptMessage				= $this -> getDataPost(PARAM_RECEIPT_MESSAGE);						// 受取人メッセージ
			$this -> receiptBankName			= $this -> getDataPost(PARAM_RECEIPT_BANK_NAME);					// 受取銀行名
			$this -> receiptBankSwift			= $this -> getDataPost(PARAM_RECEIPT_BANK_SWIFT);					// 受取銀行SWIFT
			$this -> receiptBankCountry			= $this -> getDataPost(PARAM_RECEIPT_BANK_COUNTRY);					// 受取銀行国
			$this -> receiptBranchCode			= $this -> getDataPost(PARAM_RECEIPT_BRANCH_CODE);					// 受取銀行支店コード
			$this -> receiptBranchName			= $this -> getDataPost(PARAM_RECEIPT_BRANCH_NAME);					// 受取銀行支店名
			$this -> receiptBankAddress1		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_1);				// 受取銀行住所1
			$this -> receiptBankAddress2		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_2);				// 受取銀行住所2
			$this -> accountNumber				= $this -> getDataPost(PARAM_ACCOUNT_NUMBER);						// 受取銀行口座番号
			$this -> intermediaryFlg			= $this -> getDataPost(PARAM_INTERMEDIARY_FLG);						// 中継銀行フラグ
			$this -> intermediaryBankName		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_NAME);				// 中継銀行名
			$this -> intermediaryBankSwift		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_SWIFT);				// 中継銀行SWIFT
			$this -> intermediaryBankCountry	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_COUNTRY);			// 中継銀行国
			$this -> intermediaryBankAddress1	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_1);			// 中継銀行住所1
			$this -> intermediaryBankAddress2	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_2);			// 中継銀行住所2
			$this -> intermediaryBankMessage	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_MESSAGE);			// 中継銀行メッセージ
			$this -> fromCurrency				= strtoupper($this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY));	// From通貨
			$this -> debitCurrency				= strtoupper($this -> getDataPost(PARAM_DEBIT_CURRENCY));			// 引落通貨
			$this -> debitAmount				= $this -> getDataPost(PARAM_DEBIT_AMOUNT);							// 引落金額

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'W' . $this -> account);
			}

			// チェッククラスの生成
			$base = new APICheckWithdrawBase();
			$base -> action();

			// 変数宣言部
			$original	= NO_COUNT;
			$from		= NO_STRING;
			$to			= NO_STRING;
			$profit		= NO_COUNT;

			$param[] = $this -> account;															// 口座番号(1)
			$param[] = $this -> currency;															// 通貨(2)
			$param[] = $this -> currencyToInt($this -> amount, $this -> currency);					// 金額(3)
			$param[] = $this -> currency;															// 通貨(4)
			$param[] = $this -> accountName;														// 口座名義(5)
			$param[] = $this -> receiptCountry;														// 受取人国(6)
			$param[] = $this -> receiptAddress1;													// 受取人住所1(7)
			$param[] = $this -> receiptAddress2;													// 受取人住所2(8)
			$param[] = $this -> receiptMessage;														// 受取人メッセージ(9)
			$param[] = $this -> receiptBankName;													// 受取銀行名(10)
			$param[] = $this -> receiptBranchName;													// 受取銀行支店名(11)
			$param[] = $this -> receiptBankSwift;													// 受取銀行SWIFT(12)
			$param[] = $this -> receiptBankCountry;													// 受取銀行国(13)
			$param[] = $this -> receiptBankAddress1;												// 受取銀行住所1(14)
			$param[] = $this -> receiptBankAddress2;												// 受取銀行住所2(15)
			$param[] = $this -> accountNumber;														// 受取銀行口座番号(16)
			$param[] = intval($this -> intermediaryFlg);											// 中継銀行フラグ(17)
			$param[] = $this -> intermediaryBankName;												// 中継銀行名(18)
			$param[] = $this -> intermediaryBankSwift;												// 中継銀行SWIFT(19)
			$param[] = $this -> intermediaryBankCountry;											// 中継銀行国(20)
			$param[] = $this -> intermediaryBankAddress1;											// 中継銀行住所1(21)
			$param[] = $this -> intermediaryBankAddress2;											// 中継銀行住所2(22)
			$param[] = $this -> intermediaryBankMessage;											// 中継銀行メッセージ(23)
			$param[] = $this -> tel;																// 電話番号(24)
			$param[] = $this -> debitCurrency;														// 引落口座通貨(25)
			$param[] = $this -> currencyToInt($base -> getDebitAmount(), $this -> debitCurrency);	// 引落口座金額(26)
			$param[] = $this -> getRateEx();														// レート(27)
			$param[] = $this -> currencyToInt($base -> getFeeEx(), $this -> debitCurrency);			// 手数料(28)
			$param[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_WITHDRAW);				// 取引番号(29)
			$param[] = $this -> receiptBranchCode;													// 受取銀行支店コード(30)

			// 出金申請の登録
			if($this -> accessModify('INSERT_WITHDRAW', $param, false)) {

				// 異通貨の場合は為替コミッション発生
				if($base -> getCurrency() != $base -> getDebitCurrency()) {
					$this -> registCommisionExchange($this -> account
													, $this -> currency
													, $this -> debitCurrency
													, $this -> currencyToInt($base -> getDebitAmount(), $this -> debitCurrency));
				}

				$this -> accessModify('UPDATE_USER_BANK_INFO', $param, false);

				// 変数宣言部
				$params	= array();
				$data	= $this -> getRowData($this -> getAccountCommon($this -> account));

				$params[] = $this -> account;														// ユーザ口座番号
				$params[] = $this -> getNameCommon($this -> account);								// ユーザ名
				$params[] = $this -> getCurrentTimeCommon();										// 現在時刻
				$params[] = $this -> currency;														// 通貨
				$params[] = $this -> formatCurrency($this -> amount, $this -> currency);			// 金額
				$params[] = $this -> getColumnData($data, COLUMN_MAIL);								// メールアドレス

				// メールを送信（ユーザ）
				$this -> sendMailByTmp('withdraw_apply_for_user.xml'
										, $params
										, $params[VAL_INT_5]
										, VAR_BS_MAIL_ADDRESS);

				// メールを送信（管理者）
				$this -> sendMailByTmp('withdraw_apply_for_admin.xml'
										, $params
										, VAR_NOTICE_MAIL_ADDRESS
										, VAR_NOTICE_MAIL_ADDRESS);
			}

			// コミッションの登録
			$this -> registCommision(VAR_WITHDRAW_SUCCESS
										, null
										, $this -> account
										, $this -> debitCurrency
										, $this -> currencyToInt($base -> getFeeEx(), $this -> debitCurrency));


			echo json_encode(array('result'			=> 'OK'
								, 'messages'		=> 'I_COMPLETE_PROCESS'
								, 'debit_currency'	=> $this -> debitCurrency
								, 'debit_amount'	=> $base -> getDebitAmount()
								, 'rate'			=> $base -> getRateEx()
								, 'fee'				=> $base -> getFeeEx(), $this -> debitCurrency));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {
	}
}

$api = new APIMakeWithdraw();
$api -> action();
?>