<?php
require_once(SITE_LOGICS . 'transfer/model.php');

class LogicTransfer extends TransferModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {
		if($this -> getType() == TYPE_COMPLETE) {
			$this -> regist();

			//set session variable for 2fa validated to not validated
			$_SESSION['2fa_validated'] = 'not validated';
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {
		try {
			// 口座振替データ登録
			if($this -> accessModify('INSERT_TRANSFER', $this -> getRegistData())) {

				// コミッション登録
				$this -> transferRegistCommision();

				// 異通貨の場合は為替コミッション発生
				$from	= $this -> getDebitCurrency();
				$to		= $this -> getTransferCurrency();

				if($from != $to) {
					if($this -> getTransferType() == NO_COUNT) {	// 送金額指定の場合
						$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
								, $from
								, $to
								, $this -> currencyToInt($this -> getTransferAmount(), $to));
					} else {										// 着金額指定の場合
						$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
								, $to
								, $from
								, $this -> currencyToInt($this -> getDebitAmount(), $from));
					}
				}

				// メールを送信（送金元ユーザ）
				$params = $this -> getSendDataFrom();
				$this -> sendMailByTmp('transfer_send_user.xml'
						, $params
						, $params[VAL_INT_11]
						, VAR_CS_MAIL_ADDRESS);

				// メールを送信（送金先ユーザ）
				$params = $this -> getSendDataTo();
				$this -> sendMailByTmp('transfer_receive_user.xml'
						, $params
						, $params[VAL_INT_11]
						, VAR_CS_MAIL_ADDRESS);

			} else {
				throw new Exception(NO_STRING);
			}
		} catch(Excption $e) {
			$this -> popUpSessionMessage(ERROR, 'E_FATAL', array());
			$this -> setType(TYPE_CONFIRM);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>