<?php

/**
 * 
 * @author antonio
 *
 */
trait Withdrawal{
    
    public function getWithdrawalTotalPerCurrency(ParamHolder $holder){
        $sys = $holder -> getSource();
                
        if($sys instanceof System){
            $result = $sys -> accessSelect('LIST_WITHDRAW_TOTAL', [$this -> getWhereWithdrawal($holder)]);
                             
            if($sys -> isLoopData($result)) {
                foreach($result as &$row) {
                    $row["amount"] = $sys -> intToCurrency($row["amount"], $row["currency"]);
                }
            }
            
            echo json_encode($result); 
        }
    }
    
    public function getWithdrawalList(ParamHolder $holder){
        $sys = $holder -> getSource();
        
        if($sys instanceof System){

            switch($holder -> orderByAlgorithm){
                case 1:
                    $holder -> orderByAlgorithm = "ASC";
                    break;
                case 2:
                    $holder -> orderByAlgorithm = "DESC";
                    break;
            }
                
            $list = $sys -> accessSelect('LIST_WITHDRAW_REVISED', [$this -> getWhereWithdrawal($holder), 
                "withdraw.create_time {$holder -> orderByAlgorithm}"]);
            
            $rowCount = count($list);
            $totalPage = $sys -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $rowCount);
            
            $currentPage = !empty($holder -> page) ? $holder -> page : 1;
            
            if($currentPage > $totalPage)
                $currentPage = $totalPage;
            
            $start		= 	 ($currentPage - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
            $end		=     $currentPage * VAR_DEFAULT_PAGE_COUNT;
            
            $result = [
                "row_count" => $rowCount,
                "page_total" => $totalPage,
                "current_page" => $currentPage,
                "result" => []
            ];
            
            for($i = $start; $i < $end && $i < $rowCount; $i++) {
                $result["result"][] = $this -> getRowData($list, $i);
            }
            
            echo json_encode($result);
        }
    }
    
    private function getWhereWithdrawal(ParamHolder $holder) : String {
        $sys = $holder -> getSource();
        
        // 変数宣言部
        $rtn = NO_STRING;
        
        // 送金先口座番号（検索項目）
        if($holder -> transactionNum != NO_STRING) {
            $rtn .= ' AND withdraw.transaction_number = (\')' . $holder -> transactionNum . '(\')';
        }
        
        // メールアドレス（検索項目）
//         if($this -> sEmail != NO_STRING) {
//             $rtn .= ' AND (users.user_name = (\')' . $this -> sEmail . '(\')'
//                 . ' OR users.mail = (\')' . $this -> sEmail . '(\')' . ')';
//         }
        
        // 銀行データ（検索項目）
        if($holder -> bankName != NO_STRING) {
            $rtn .= ' AND (withdraw.receipt_bank_name = (\')' . $holder -> bankName . '(\')'
                . ' OR withdraw.receipt_bank_swift = (\')' . $holder -> bankName . '(\')'
                . ' OR withdraw.intermediary_bank_name = (\')' . $holder -> bankName . '(\')'
                . ' OR withdraw.intermediary_bank_swift = (\')' . $holder -> bankName . '(\')'
                . ')';
        }
        
        // 送金先口座番号（検索項目）
        if($holder -> remittanceAccount != NO_STRING) {
            $rtn .= ' AND withdraw.account_number = (\')' . $holder -> remittanceAccount . '(\')';
        }
        
        // 銀行注文番号
        if($holder -> bankSlipNumber  != NO_STRING) {
            $rtn .= ' AND withdraw.order_number = (\')' . $holder -> bankSlipNumber . '(\')';
        }
        
        // ステータス（検索項目）
        if($holder -> withdrawalStatus != NO_STRING) {
            $rtn .= ' AND withdraw.status = (\')' . $holder -> withdrawalStatus . '(\')';
        }
        if($holder -> tier != NO_STRING) {
            $rtn .= ' AND users.tier_tag = (\')' . $holder -> tier . '(\')';
        }
        
        // 通貨
        if($holder -> currency != NO_STRING) {
            $rtn .= ' AND withdraw.currency = (\')' . $holder -> currency . '(\')';
        }
        
        // 口座番号
        if($holder -> userAccount != NO_STRING) {
            $rtn .= ' AND withdraw.user_account = (\')' . $holder -> userAccount . '(\')';
        }
        
        // 送金額（最少）（検索項目）
        if($holder -> minAmount != NO_STRING) {
            if($holder -> currency == NO_STRING) {	// 通貨未指定
                $rtn .= ' AND withdraw.amount >= (\')' . $holder -> minAmount . '(\')';
            } else {								// 通貨指定
                $rtn .= ' AND withdraw.amount >= (\')' . $sys -> currencyToInt($holder -> minAmount, $holder -> currency) . '(\')';
            }
        }
        
        // 送金額（最大）（検索項目）
        if($holder -> maxAmount != NO_STRING) {
            if($holder -> currency == NO_STRING) {	// 通貨未指定
                $rtn .= ' AND withdraw.amount <= (\')' . $holder -> maxAmount . '(\')';
            } else {								// 通貨指定
                $rtn .= ' AND withdraw.amount <= (\')' . $sys -> currencyToInt($holder -> maxAmount, $holder -> currency) . '(\')';
            }
        }
        
        if($holder -> withdrawalFee != NO_STRING && $holder -> withdrawalFee == 'All' ){
             $rtn .= ' AND (LEFT(withdraw.transaction_number, 1) = (\')F(\')
		          OR LEFT(withdraw.transaction_number, 1) = (\')M(\'))';
        }
        
        if($holder -> withdrawalFee != NO_STRING && $holder -> withdrawalFee != 'All' && $holder -> withdrawalFee != 'Select') {
            $rtn .= ' AND LEFT(withdraw.transaction_number, 1) = (\')'. $holder -> withdrawalFee .'(\')';
        }
        
        if($holder -> searchByAppDate != NO_STRING){
            // 登録時刻（開始日）（検索項目）
            if($holder -> applicationDateFrom != NO_STRING) {
                $rtn .= ' AND withdraw.create_time >= (\')' . $holder -> applicationDateFrom . '(\')';
            }
            
            // 登録時刻（終了）（検索項目）
            if($holder -> applicationDateTo != NO_STRING) {
                $rtn .= ' AND withdraw.create_time < DATE_ADD((\')' . $holder -> applicationDateTo . '(\'), INTERVAL 1 DAY)';
            }
        }
        
        if($holder -> searchByProcessDate != NO_STRING){
            // 登録時刻（開始日）（検索項目）
            if($holder -> processDateFrom != NO_STRING) {
                $rtn .= ' AND withdraw.process_time >= (\')' . $holder -> processDateFrom . '(\')';
            }
            
            // 登録時刻（終了）（検索項目）
            if($holder -> processDateTo != NO_STRING) {
                $rtn .= ' AND withdraw.process_time < DATE_ADD((\')' . $holder -> processDateTo . '(\'), INTERVAL 1 DAY)';
            }
        }
        
        if($holder -> withdrawalSolution != NO_STRING && $holder -> withdrawalSolution != 'All' &&  $holder -> withdrawalSolution != 'Select') {
            $rtn .= ' AND withdraw.withdraw_solution = (\')' . $holder -> withdrawalSolution . '(\')';
        }
        
        if($holder -> withdrawalSolution != NO_STRING && $holder -> withdrawalSolution == 'All' ){
            $rtn .= 'AND LEFT(withdraw.transaction_number, 1) = (\')W(\')';
        }
        
        if($holder -> testAccountFlag != NO_STRING) {
            $rtn .= 'AND users.test_account_flg = (\')' . $holder -> testAccountFlag . '(\')';
        }
        
        return $rtn;
    }
}