<?php
require_once(SYSTEM_LOGICS . 'exchange_rate/model.php');

class LogicExchangeRate extends ExchangeRateModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			$this -> init();

			if($this -> getType() == TYPE_EXPORT_COMMON) {	// エラーファイルの取得

				$this -> lists();
				$this -> exportData();

			}else{
				$this -> lists();
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$res = $this -> accessSelect('SELECT_EXCHANGE_RATE_DISPLAY', $this -> getWhere());
		$this -> setResult($res);
		$this -> setTotal(count($res));
	}


    function makeExportData(){
        $rtn  = NO_STRING;

        $rtn = (
        		$this -> getLangage() == "en" ?
        		"From currency,To Currency,Rate,Original Rate,Create Time\n" :
        		"通貨から,通貨へ,レート,オリジナルレート,時間作成" . "\n"
        		);

        $rtn .= $this -> getExportDetails();
        return $rtn;
    }

    /*-------------------------------------------------------------------------
    * @function_name: exportData
    * @parameter	:
    * @return		:
    -------------------------------------------------------------------------*/
    function exportData(){
        $fileName = 'Exchange_Rate_' . str_replace("/", "", 
            $this -> getDataPost(PARAM_S_FROM, true, true, true) . '-' 
            . $this -> getDataPost(PARAM_S_TO, true, true, true));

        header('Content-Encoding: UTF-8');
        header("Content-type: text/csv; charset=UTF-8");
        header('Content-Disposition: attachment; filename="' . $fileName . '.csv"');
        header('Content-Transfer-Encoding: binary');

        echo "\xEF\xBB\xBF";
        echo trim($this -> makeExportData());
        exit();
    }
}
?>
